/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.usage.NetworkStatsManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.INetworkStatsService;
import android.net.INetworkStatsSession;
import android.net.NetworkStats;
import android.net.connectivity.android.net.netstats.StatsResult;
import android.net.connectivity.android.net.netstats.TrafficStatsRateLimitCacheConfig;
import android.net.connectivity.com.android.net.module.util.BinderUtils;
import android.net.connectivity.com.android.net.module.util.LruCacheWithExpiry;
import android.os.Binder;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.function.LongSupplier;

public class TrafficStats {
    private static final String TAG;
    public static final int UNSUPPORTED = -1;
    @Deprecated
    public static final long KB_IN_BYTES = 1024L;
    @Deprecated
    public static final long MB_IN_BYTES = 0x100000L;
    @Deprecated
    public static final long GB_IN_BYTES = 0x40000000L;
    @Deprecated
    public static final long TB_IN_BYTES = 0x10000000000L;
    @Deprecated
    public static final long PB_IN_BYTES = 0x4000000000000L;
    public static final int UID_REMOVED = -4;
    public static final int UID_TETHERING = -5;
    @SystemApi
    public static final int TAG_NETWORK_STACK_RANGE_START = -768;
    @SystemApi
    public static final int TAG_NETWORK_STACK_RANGE_END = -257;
    @SystemApi
    public static final int TAG_SYSTEM_IMPERSONATION_RANGE_START = -256;
    @SystemApi
    public static final int TAG_SYSTEM_IMPERSONATION_RANGE_END = -241;
    @SystemApi
    public static final int TAG_NETWORK_STACK_IMPERSONATION_RANGE_START = -128;
    @SystemApi
    public static final int TAG_NETWORK_STACK_IMPERSONATION_RANGE_END = -113;
    public static final int TAG_SYSTEM_DOWNLOAD = -255;
    public static final int TAG_SYSTEM_MEDIA = -254;
    public static final int TAG_SYSTEM_BACKUP = -253;
    public static final int TAG_SYSTEM_RESTORE = -252;
    public static final int TAG_SYSTEM_APP = -251;
    public static final int TAG_SYSTEM_PROBE = -190;
    private static final StatsResult EMPTY_STATS;
    private static final Object sRateLimitCacheLock;
    @GuardedBy(value={"TrafficStats.class"})
    @Nullable
    private static INetworkStatsService sStatsService;
    @Nullable
    private static INetworkStatsService sStatsServiceForTest;
    @GuardedBy(value={"sRateLimitCacheLock"})
    @Nullable
    private static TrafficStatsRateLimitCacheConfig sRateLimitCacheConfig;
    @GuardedBy(value={"sRateLimitCacheLock"})
    @Nullable
    private static LruCacheWithExpiry<String, StatsResult> sRateLimitIfaceCache;
    @GuardedBy(value={"sRateLimitCacheLock"})
    @Nullable
    private static LruCacheWithExpiry<Integer, StatsResult> sRateLimitUidCache;
    @Nullable
    private static LongSupplier sTimeSupplierForTest;
    private static NetworkStats sActiveProfilingStart;
    private static Object sProfilingLock;
    private static final String LOOPBACK_IFACE = "lo";
    private static ThreadLocal<UidTag> sThreadUidTag;
    public static final int TYPE_RX_BYTES = 0;
    public static final int TYPE_RX_PACKETS = 1;
    public static final int TYPE_TX_BYTES = 2;
    public static final int TYPE_TX_PACKETS = 3;

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=130143562L)
    private static synchronized INetworkStatsService getStatsService() {
        if (sStatsServiceForTest != null) {
            return sStatsServiceForTest;
        }
        if (sStatsService == null) {
            throw new IllegalStateException("TrafficStats not initialized, uid=" + Binder.getCallingUid());
        }
        return sStatsService;
    }

    private static int getMyUid() {
        return Process.myUid();
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static void setServiceForTest(INetworkStatsService statsService) {
        sStatsServiceForTest = statsService;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static void setTimeSupplierForTest(LongSupplier timeSupplier) {
        sTimeSupplierForTest = timeSupplier;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static void reinitRateLimitCacheForTest() {
        TrafficStats.maybeGetConfigAndInitRateLimitCache(true);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @SuppressLint(value={"VisiblySynchronized"})
    public static synchronized void init(@NonNull Context context) {
        if (sStatsService != null) {
            throw new IllegalStateException("TrafficStats is already initialized, uid=" + Binder.getCallingUid());
        }
        NetworkStatsManager statsManager = context.getSystemService(NetworkStatsManager.class);
        if (statsManager == null) {
            Log.e(TAG, "TrafficStats not initialized, uid=" + Binder.getCallingUid());
            return;
        }
        sStatsService = statsManager.getBinder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static LruCacheWithExpiry<String, StatsResult> maybeGetRateLimitIfaceCache() {
        if (!TrafficStats.maybeGetConfigAndInitRateLimitCache(false)) {
            return null;
        }
        Object object = sRateLimitCacheLock;
        synchronized (object) {
            return sRateLimitIfaceCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static LruCacheWithExpiry<Integer, StatsResult> maybeGetRateLimitUidCache() {
        if (!TrafficStats.maybeGetConfigAndInitRateLimitCache(false)) {
            return null;
        }
        Object object = sRateLimitCacheLock;
        synchronized (object) {
            return sRateLimitUidCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean maybeGetConfigAndInitRateLimitCache(boolean forceReinit) {
        TrafficStatsRateLimitCacheConfig config;
        Object object = sRateLimitCacheLock;
        synchronized (object) {
            if (sRateLimitCacheConfig != null && !forceReinit) {
                return TrafficStats.sRateLimitCacheConfig.isCacheEnabled;
            }
        }
        try {
            config = TrafficStats.getStatsService().getRateLimitCacheConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        Object object2 = sRateLimitCacheLock;
        synchronized (object2) {
            if (sRateLimitCacheConfig == null || forceReinit) {
                sRateLimitCacheConfig = config;
                TrafficStats.initRateLimitCacheLocked();
            }
        }
        return config.isCacheEnabled;
    }

    @GuardedBy(value={"sRateLimitCacheLock"})
    private static void initRateLimitCacheLocked() {
        if (TrafficStats.sRateLimitCacheConfig.isCacheEnabled) {
            LongSupplier realtimeSupplier = sTimeSupplierForTest != null ? sTimeSupplierForTest : () -> SystemClock.elapsedRealtime();
            sRateLimitIfaceCache = new LruCacheWithExpiry(realtimeSupplier, TrafficStats.sRateLimitCacheConfig.expiryDurationMs, TrafficStats.sRateLimitCacheConfig.maxEntries, statsResult -> !TrafficStats.isEmpty(statsResult));
            sRateLimitUidCache = new LruCacheWithExpiry(realtimeSupplier, TrafficStats.sRateLimitCacheConfig.expiryDurationMs, TrafficStats.sRateLimitCacheConfig.maxEntries, statsResult -> !TrafficStats.isEmpty(statsResult));
        } else {
            sRateLimitIfaceCache = null;
            sRateLimitUidCache = null;
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void attachSocketTagger() {
        dalvik.system.SocketTagger.set(new SocketTagger());
    }

    private static int native_tagSocketFd(FileDescriptor fileDescriptor, int n, int n2) {
        return OverrideMethod.invokeI("android.net.TrafficStats#native_tagSocketFd(Ljava/io/FileDescriptor;II)I", true, null);
    }

    private static int native_untagSocketFd(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("android.net.TrafficStats#native_untagSocketFd(Ljava/io/FileDescriptor;)I", true, null);
    }

    public static void setThreadStatsTag(int tag) {
        TrafficStats.getAndSetThreadStatsTag(tag);
    }

    public static int getAndSetThreadStatsTag(int tag) {
        int old = TrafficStats.sThreadUidTag.get().tag;
        TrafficStats.sThreadUidTag.get().tag = tag;
        return old;
    }

    @SystemApi
    public static void setThreadStatsTagBackup() {
        TrafficStats.setThreadStatsTag(-253);
    }

    @SystemApi
    public static void setThreadStatsTagRestore() {
        TrafficStats.setThreadStatsTag(-252);
    }

    @SystemApi
    public static void setThreadStatsTagApp() {
        TrafficStats.setThreadStatsTag(-251);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setThreadStatsTagDownload() {
        TrafficStats.setThreadStatsTag(-255);
    }

    public static int getThreadStatsTag() {
        return TrafficStats.sThreadUidTag.get().tag;
    }

    public static void clearThreadStatsTag() {
        TrafficStats.sThreadUidTag.get().tag = -1;
    }

    @SuppressLint(value={"RequiresPermission"})
    public static void setThreadStatsUid(int uid) {
        TrafficStats.sThreadUidTag.get().uid = uid;
    }

    public static int getThreadStatsUid() {
        return TrafficStats.sThreadUidTag.get().uid;
    }

    @Deprecated
    public static void setThreadStatsUidSelf() {
        TrafficStats.setThreadStatsUid(TrafficStats.getMyUid());
    }

    @SuppressLint(value={"RequiresPermission"})
    public static void clearThreadStatsUid() {
        TrafficStats.setThreadStatsUid(-1);
    }

    public static void tagSocket(@NonNull Socket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public static void untagSocket(@NonNull Socket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    public static void tagDatagramSocket(@NonNull DatagramSocket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public static void untagDatagramSocket(@NonNull DatagramSocket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    public static void tagFileDescriptor(@NonNull FileDescriptor fd) throws IOException {
        SocketTagger.get().tag(fd);
    }

    public static void untagFileDescriptor(@NonNull FileDescriptor fd) throws IOException {
        SocketTagger.get().untag(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart != null) {
                throw new IllegalStateException("already profiling data");
            }
            sActiveProfilingStart = TrafficStats.getDataLayerSnapshotForUid(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkStats stopDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart == null) {
                throw new IllegalStateException("not profiling data");
            }
            NetworkStats profilingStop = TrafficStats.getDataLayerSnapshotForUid(context);
            NetworkStats profilingDelta = NetworkStats.subtract(profilingStop, sActiveProfilingStart, null, null);
            sActiveProfilingStart = null;
            return profilingDelta;
        }
    }

    public static void incrementOperationCount(int operationCount) {
        int tag = TrafficStats.getThreadStatsTag();
        TrafficStats.incrementOperationCount(tag, operationCount);
    }

    public static void incrementOperationCount(int tag, int operationCount) {
        int uid = TrafficStats.getMyUid();
        try {
            TrafficStats.getStatsService().incrementOperationCount(uid, tag, operationCount);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void closeQuietly(INetworkStatsSession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static long addIfSupported(long stat) {
        return stat == -1L ? 0L : stat;
    }

    public static long getMobileTxPackets() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getTxPackets(iface));
        }
        return total;
    }

    public static long getMobileRxPackets() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getRxPackets(iface));
        }
        return total;
    }

    public static long getMobileTxBytes() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getTxBytes(iface));
        }
        return total;
    }

    public static long getMobileRxBytes() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getRxBytes(iface));
        }
        return total;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static long getMobileTcpRxPackets() {
        return -1L;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static long getMobileTcpTxPackets() {
        return -1L;
    }

    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK", "android.permission.NETWORK_SETTINGS"})
    public static void clearRateLimitCaches() {
        LruCacheWithExpiry<Integer, StatsResult> uidCache;
        LruCacheWithExpiry<String, StatsResult> ifaceCache = TrafficStats.maybeGetRateLimitIfaceCache();
        if (ifaceCache != null) {
            ifaceCache.clear();
        }
        if ((uidCache = TrafficStats.maybeGetRateLimitUidCache()) != null) {
            uidCache.clear();
        }
        try {
            TrafficStats.getStatsService().clearTrafficStatsRateLimitCaches();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTxPackets(@NonNull String iface) {
        return TrafficStats.getIfaceStats(iface, 3);
    }

    public static long getRxPackets(@NonNull String iface) {
        return TrafficStats.getIfaceStats(iface, 1);
    }

    public static long getTxBytes(@NonNull String iface) {
        return TrafficStats.getIfaceStats(iface, 2);
    }

    public static long getRxBytes(@NonNull String iface) {
        return TrafficStats.getIfaceStats(iface, 0);
    }

    public static long getLoopbackTxPackets() {
        return TrafficStats.getIfaceStats(LOOPBACK_IFACE, 3);
    }

    public static long getLoopbackRxPackets() {
        return TrafficStats.getIfaceStats(LOOPBACK_IFACE, 1);
    }

    public static long getLoopbackTxBytes() {
        return TrafficStats.getIfaceStats(LOOPBACK_IFACE, 2);
    }

    public static long getLoopbackRxBytes() {
        return TrafficStats.getIfaceStats(LOOPBACK_IFACE, 0);
    }

    public static long getTotalTxPackets() {
        return TrafficStats.getTotalStats(3);
    }

    public static long getTotalRxPackets() {
        return TrafficStats.getTotalStats(1);
    }

    public static long getTotalTxBytes() {
        return TrafficStats.getTotalStats(2);
    }

    public static long getTotalRxBytes() {
        return TrafficStats.getTotalStats(0);
    }

    public static long getUidTxBytes(int uid) {
        return TrafficStats.getUidStats(uid, 2);
    }

    public static long getUidRxBytes(int uid) {
        return TrafficStats.getUidStats(uid, 0);
    }

    public static long getUidTxPackets(int uid) {
        return TrafficStats.getUidStats(uid, 3);
    }

    public static long getUidRxPackets(int uid) {
        return TrafficStats.getUidStats(uid, 1);
    }

    public static long getUidStats(int uid, int type) {
        return TrafficStats.fetchStats(TrafficStats.maybeGetRateLimitUidCache(), uid, () -> TrafficStats.getStatsService().getUidStats(uid), type);
    }

    private static <K> long fetchStats(@Nullable LruCacheWithExpiry<K, StatsResult> cache, K key, BinderUtils.ThrowingSupplier<StatsResult, RemoteException> statsFetcher, int type) {
        try {
            StatsResult stats = cache != null ? TrafficStats.fetchStatsWithCache(cache, key, statsFetcher) : statsFetcher.get();
            return TrafficStats.getEntryValueForType(stats, type);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    private static <K> StatsResult fetchStatsWithCache(LruCacheWithExpiry<K, StatsResult> cache, K key, BinderUtils.ThrowingSupplier<StatsResult, RemoteException> statsFetcher) throws RemoteException {
        StatsResult cachedValue;
        StatsResult stats = cache.get(key);
        if (stats == null && (stats = statsFetcher.get()) != null && !TrafficStats.isEmpty(stats) && (cachedValue = cache.putIfAbsent(key, stats)) != null) {
            return cachedValue;
        }
        return stats;
    }

    private static boolean isEmpty(StatsResult stats) {
        return stats.equals(EMPTY_STATS);
    }

    public static long getTotalStats(int type) {
        return TrafficStats.fetchStats(TrafficStats.maybeGetRateLimitUidCache(), -1, () -> TrafficStats.getStatsService().getTotalStats(), type);
    }

    public static long getIfaceStats(String iface, int type) {
        return TrafficStats.fetchStats(TrafficStats.maybeGetRateLimitIfaceCache(), iface, () -> TrafficStats.getStatsService().getIfaceStats(iface), type);
    }

    @Deprecated
    public static long getUidTcpTxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpRxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpTxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpRxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpTxSegments(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpRxSegments(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpTxPackets(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpRxPackets(int uid) {
        return -1L;
    }

    private static NetworkStats getDataLayerSnapshotForUid(Context context) {
        int uid = TrafficStats.getMyUid();
        try {
            return TrafficStats.getStatsService().getDataLayerSnapshotForUid(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=130143562L)
    private static String[] getMobileIfaces() {
        try {
            return TrafficStats.getStatsService().getMobileIfaces();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static long getEntryValueForType(@Nullable StatsResult stats, int type) {
        if (stats == null) {
            return -1L;
        }
        if (!TrafficStats.isEntryValueTypeValid(type)) {
            return -1L;
        }
        switch (type) {
            case 0: {
                return stats.rxBytes;
            }
            case 1: {
                return stats.rxPackets;
            }
            case 2: {
                return stats.txBytes;
            }
            case 3: {
                return stats.txPackets;
            }
        }
        throw new IllegalStateException("Bug: Invalid type: " + type + " should not reach here.");
    }

    private static boolean isEntryValueTypeValid(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    static {
        System_Delegate.loadLibrary("framework-connectivity-tiramisu-jni");
        TAG = TrafficStats.class.getSimpleName();
        EMPTY_STATS = new StatsResult(0L, 0L, 0L, 0L);
        sRateLimitCacheLock = new Object();
        sStatsServiceForTest = null;
        sTimeSupplierForTest = null;
        sProfilingLock = new Object();
        sThreadUidTag = new ThreadLocal<UidTag>(){

            @Override
            protected UidTag initialValue() {
                return new UidTag();
            }
        };
    }

    private static class SocketTagger
    extends dalvik.system.SocketTagger {
        private static final boolean LOGD = Log.isLoggable(TAG, 3);

        SocketTagger() {
        }

        @Override
        public void tag(FileDescriptor fd) throws SocketException {
            UidTag tagInfo = sThreadUidTag.get();
            if (LOGD) {
                Log.d(TAG, "tagSocket(" + fd.getInt$() + ") with statsTag=0x" + Integer.toHexString(tagInfo.tag) + ", statsUid=" + tagInfo.uid);
            }
            if (tagInfo.tag == -1) {
                StrictMode.noteUntaggedSocket();
            }
            if (tagInfo.tag == -1 && tagInfo.uid == -1) {
                return;
            }
            int errno = TrafficStats.native_tagSocketFd(fd, tagInfo.tag, tagInfo.uid);
            if (errno < 0) {
                Log.i(TAG, "tagSocketFd(" + fd.getInt$() + ", " + tagInfo.tag + ", " + tagInfo.uid + ") failed with errno" + errno);
            }
        }

        @Override
        public void untag(FileDescriptor fd) throws SocketException {
            if (LOGD) {
                Log.i(TAG, "untagSocket(" + fd.getInt$() + ")");
            }
            UidTag tagInfo = sThreadUidTag.get();
            if (tagInfo.tag == -1 && tagInfo.uid == -1) {
                return;
            }
            int errno = TrafficStats.native_untagSocketFd(fd);
            if (errno < 0) {
                Log.w(TAG, "untagSocket(" + fd.getInt$() + ") failed with errno " + errno);
            }
        }
    }

    private static class UidTag {
        public int tag = -1;
        public int uid = -1;

        private UidTag() {
        }
    }
}

