/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.EventLogTags;
import android.net.Network;
import android.net.TrafficStats;
import android.net.sntp.Duration64;
import android.net.sntp.Timestamp64;
import android.os.SystemClock;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public class SntpClient {
    private static final String TAG = "SntpClient";
    private static final boolean DBG = true;
    private static final int REFERENCE_TIME_OFFSET = 16;
    private static final int ORIGINATE_TIME_OFFSET = 24;
    private static final int RECEIVE_TIME_OFFSET = 32;
    private static final int TRANSMIT_TIME_OFFSET = 40;
    private static final int NTP_PACKET_SIZE = 48;
    public static final int STANDARD_NTP_PORT = 123;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_MODE_SERVER = 4;
    private static final int NTP_MODE_BROADCAST = 5;
    private static final int NTP_VERSION = 3;
    private static final int NTP_LEAP_NOSYNC = 3;
    private static final int NTP_STRATUM_DEATH = 0;
    private static final int NTP_STRATUM_MAX = 15;
    private final Supplier<Instant> mSystemTimeSupplier;
    private final Random mRandom;
    private long mClockOffset;
    private long mNtpTime;
    private long mNtpTimeReference;
    private long mRoundTripTime;
    @Nullable
    private InetSocketAddress mServerSocketAddress;

    @UnsupportedAppUsage
    public SntpClient() {
        this(Instant::now, SntpClient.defaultRandom());
    }

    @VisibleForTesting
    public SntpClient(Supplier<Instant> systemTimeSupplier, Random random) {
        this.mSystemTimeSupplier = Objects.requireNonNull(systemTimeSupplier);
        this.mRandom = Objects.requireNonNull(random);
    }

    public boolean requestTime(String host, int port, int timeout, Network network) {
        Network networkForResolv = network.getPrivateDnsBypassingCopy();
        try {
            InetAddress[] addresses = networkForResolv.getAllByName(host);
            for (int i = 0; i < addresses.length; ++i) {
                if (!this.requestTime(addresses[i], port, timeout, networkForResolv)) continue;
                return true;
            }
        }
        catch (UnknownHostException e) {
            Log.w(TAG, "Unknown host: " + host);
            EventLogTags.writeNtpFailure(host, ((Object)e).toString());
        }
        Log.d(TAG, "request time failed");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestTime(InetAddress address, int port, int timeout, Network network) {
        DatagramSocket socket = null;
        int oldTag = TrafficStats.getAndSetThreadStatsTag(-191);
        try {
            socket = new DatagramSocket();
            network.bindSocket(socket);
            socket.setSoTimeout(timeout);
            byte[] buffer = new byte[48];
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, port);
            buffer[0] = 27;
            Instant requestTime = this.mSystemTimeSupplier.get();
            Timestamp64 requestTimestamp = Timestamp64.fromInstant(requestTime);
            Timestamp64 randomizedRequestTimestamp = requestTimestamp.randomizeSubMillis(this.mRandom);
            long requestTicks = SystemClock.elapsedRealtime();
            this.writeTimeStamp(buffer, 40, randomizedRequestTimestamp);
            socket.send(request);
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            socket.receive(response);
            long responseTicks = SystemClock.elapsedRealtime();
            Instant responseTime = requestTime.plusMillis(responseTicks - requestTicks);
            Timestamp64 responseTimestamp = Timestamp64.fromInstant(responseTime);
            byte leap = (byte)(buffer[0] >> 6 & 3);
            byte mode = (byte)(buffer[0] & 7);
            int stratum = buffer[1] & 0xFF;
            Timestamp64 referenceTimestamp = this.readTimeStamp(buffer, 16);
            Timestamp64 originateTimestamp = this.readTimeStamp(buffer, 24);
            Timestamp64 receiveTimestamp = this.readTimeStamp(buffer, 32);
            Timestamp64 transmitTimestamp = this.readTimeStamp(buffer, 40);
            SntpClient.checkValidServerReply(leap, mode, stratum, transmitTimestamp, referenceTimestamp, randomizedRequestTimestamp, originateTimestamp);
            long totalTransactionDurationMillis = responseTicks - requestTicks;
            long serverDurationMillis = Duration64.between(receiveTimestamp, transmitTimestamp).toDuration().toMillis();
            long roundTripTimeMillis = totalTransactionDurationMillis - serverDurationMillis;
            Duration clockOffsetDuration = SntpClient.calculateClockOffset(requestTimestamp, receiveTimestamp, transmitTimestamp, responseTimestamp);
            long clockOffsetMillis = clockOffsetDuration.toMillis();
            EventLogTags.writeNtpSuccess(((Object)address).toString(), roundTripTimeMillis, clockOffsetMillis);
            Log.d(TAG, "round trip: " + roundTripTimeMillis + "ms, clock offset: " + clockOffsetMillis + "ms");
            this.mClockOffset = clockOffsetMillis;
            this.mNtpTime = responseTime.plus(clockOffsetDuration).toEpochMilli();
            this.mNtpTimeReference = responseTicks;
            this.mRoundTripTime = roundTripTimeMillis;
            this.mServerSocketAddress = new InetSocketAddress(address, port);
        }
        catch (Exception e) {
            EventLogTags.writeNtpFailure(((Object)address).toString(), ((Object)e).toString());
            Log.d(TAG, "request time failed: " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
            TrafficStats.setThreadStatsTag(oldTag);
        }
        return true;
    }

    @VisibleForTesting
    public static Duration calculateClockOffset(Timestamp64 clientRequestTimestamp, Timestamp64 serverReceiveTimestamp, Timestamp64 serverTransmitTimestamp, Timestamp64 clientResponseTimestamp) {
        return Duration64.between(clientRequestTimestamp, serverReceiveTimestamp).plus(Duration64.between(clientResponseTimestamp, serverTransmitTimestamp)).dividedBy(2L);
    }

    @Deprecated
    @UnsupportedAppUsage
    public boolean requestTime(String host, int timeout) {
        Log.w(TAG, "Shame on you for calling the hidden API requestTime()!");
        return false;
    }

    @VisibleForTesting
    public long getClockOffset() {
        return this.mClockOffset;
    }

    @UnsupportedAppUsage
    public long getNtpTime() {
        return this.mNtpTime;
    }

    @UnsupportedAppUsage
    public long getNtpTimeReference() {
        return this.mNtpTimeReference;
    }

    @UnsupportedAppUsage
    public long getRoundTripTime() {
        return this.mRoundTripTime;
    }

    @Nullable
    public InetSocketAddress getServerSocketAddress() {
        return this.mServerSocketAddress;
    }

    private static void checkValidServerReply(byte leap, byte mode, int stratum, Timestamp64 transmitTimestamp, Timestamp64 referenceTimestamp, Timestamp64 randomizedRequestTimestamp, Timestamp64 originateTimestamp) throws InvalidServerReplyException {
        if (leap == 3) {
            throw new InvalidServerReplyException("unsynchronized server");
        }
        if (mode != 4 && mode != 5) {
            throw new InvalidServerReplyException("untrusted mode: " + mode);
        }
        if (stratum == 0 || stratum > 15) {
            throw new InvalidServerReplyException("untrusted stratum: " + stratum);
        }
        if (!randomizedRequestTimestamp.equals(originateTimestamp)) {
            throw new InvalidServerReplyException("originateTimestamp != randomizedRequestTimestamp");
        }
        if (transmitTimestamp.equals(Timestamp64.ZERO)) {
            throw new InvalidServerReplyException("zero transmitTimestamp");
        }
        if (referenceTimestamp.equals(Timestamp64.ZERO)) {
            throw new InvalidServerReplyException("zero referenceTimestamp");
        }
    }

    private long readUnsigned32(byte[] buffer, int offset) {
        int i0 = buffer[offset++] & 0xFF;
        int i1 = buffer[offset++] & 0xFF;
        int i2 = buffer[offset++] & 0xFF;
        int i3 = buffer[offset] & 0xFF;
        int bits = i0 << 24 | i1 << 16 | i2 << 8 | i3;
        return (long)bits & 0xFFFFFFFFL;
    }

    private Timestamp64 readTimeStamp(byte[] buffer, int offset) {
        long seconds = this.readUnsigned32(buffer, offset);
        int fractionBits = (int)this.readUnsigned32(buffer, offset + 4);
        return Timestamp64.fromComponents(seconds, fractionBits);
    }

    private void writeTimeStamp(byte[] buffer, int offset, Timestamp64 timestamp) {
        long seconds = timestamp.getEraSeconds();
        buffer[offset++] = (byte)(seconds >>> 24);
        buffer[offset++] = (byte)(seconds >>> 16);
        buffer[offset++] = (byte)(seconds >>> 8);
        buffer[offset++] = (byte)seconds;
        int fractionBits = timestamp.getFractionBits();
        buffer[offset++] = (byte)(fractionBits >>> 24);
        buffer[offset++] = (byte)(fractionBits >>> 16);
        buffer[offset++] = (byte)(fractionBits >>> 8);
        buffer[offset] = (byte)fractionBits;
    }

    private static Random defaultRandom() {
        Random random;
        try {
            random = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf(TAG, "Unable to access SecureRandom", e);
            random = new Random(System_Delegate.currentTimeMillis());
        }
        return random;
    }

    private static class InvalidServerReplyException
    extends Exception {
        public InvalidServerReplyException(String message) {
            super(message);
        }
    }
}

