/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.EthernetNetworkUpdateRequest;
import android.net.IEthernetServiceListener;
import android.net.IpConfiguration;
import android.net.connectivity.android.net.INetworkInterfaceOutcomeReceiver;
import android.net.connectivity.android.net.ITetheredInterfaceCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IEthernetManager
extends IInterface {
    public String[] getAvailableInterfaces() throws RemoteException;

    public IpConfiguration getConfiguration(String var1) throws RemoteException;

    public void setConfiguration(String var1, IpConfiguration var2) throws RemoteException;

    public boolean isAvailable(String var1) throws RemoteException;

    public void addListener(IEthernetServiceListener var1) throws RemoteException;

    public void removeListener(IEthernetServiceListener var1) throws RemoteException;

    public void setIncludeTestInterfaces(boolean var1) throws RemoteException;

    public void requestTetheredInterface(ITetheredInterfaceCallback var1) throws RemoteException;

    public void releaseTetheredInterface(ITetheredInterfaceCallback var1) throws RemoteException;

    public void updateConfiguration(String var1, EthernetNetworkUpdateRequest var2, INetworkInterfaceOutcomeReceiver var3) throws RemoteException;

    public void enableInterface(String var1, INetworkInterfaceOutcomeReceiver var2) throws RemoteException;

    public void disableInterface(String var1, INetworkInterfaceOutcomeReceiver var2) throws RemoteException;

    public void setEthernetEnabled(boolean var1) throws RemoteException;

    public List<String> getInterfaceList() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IEthernetManager {
        public static final String DESCRIPTOR = "android.net.IEthernetManager";
        static final int TRANSACTION_getAvailableInterfaces = 1;
        static final int TRANSACTION_getConfiguration = 2;
        static final int TRANSACTION_setConfiguration = 3;
        static final int TRANSACTION_isAvailable = 4;
        static final int TRANSACTION_addListener = 5;
        static final int TRANSACTION_removeListener = 6;
        static final int TRANSACTION_setIncludeTestInterfaces = 7;
        static final int TRANSACTION_requestTetheredInterface = 8;
        static final int TRANSACTION_releaseTetheredInterface = 9;
        static final int TRANSACTION_updateConfiguration = 10;
        static final int TRANSACTION_enableInterface = 11;
        static final int TRANSACTION_disableInterface = 12;
        static final int TRANSACTION_setEthernetEnabled = 13;
        static final int TRANSACTION_getInterfaceList = 14;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IEthernetManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IEthernetManager) {
                return (IEthernetManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAvailableInterfaces";
                }
                case 2: {
                    return "getConfiguration";
                }
                case 3: {
                    return "setConfiguration";
                }
                case 4: {
                    return "isAvailable";
                }
                case 5: {
                    return "addListener";
                }
                case 6: {
                    return "removeListener";
                }
                case 7: {
                    return "setIncludeTestInterfaces";
                }
                case 8: {
                    return "requestTetheredInterface";
                }
                case 9: {
                    return "releaseTetheredInterface";
                }
                case 10: {
                    return "updateConfiguration";
                }
                case 11: {
                    return "enableInterface";
                }
                case 12: {
                    return "disableInterface";
                }
                case 13: {
                    return "setEthernetEnabled";
                }
                case 14: {
                    return "getInterfaceList";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String[] _result = this.getAvailableInterfaces();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    IpConfiguration _result = this.getConfiguration(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    IpConfiguration _arg1 = data.readTypedObject(IpConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    this.setConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAvailable(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    IEthernetServiceListener _arg0 = IEthernetServiceListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IEthernetServiceListener _arg0 = IEthernetServiceListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setIncludeTestInterfaces(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    ITetheredInterfaceCallback _arg0 = ITetheredInterfaceCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestTetheredInterface(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    ITetheredInterfaceCallback _arg0 = ITetheredInterfaceCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.releaseTetheredInterface(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    EthernetNetworkUpdateRequest _arg1 = data.readTypedObject(EthernetNetworkUpdateRequest.CREATOR);
                    INetworkInterfaceOutcomeReceiver _arg2 = INetworkInterfaceOutcomeReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updateConfiguration(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    INetworkInterfaceOutcomeReceiver _arg1 = INetworkInterfaceOutcomeReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.enableInterface(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    INetworkInterfaceOutcomeReceiver _arg1 = INetworkInterfaceOutcomeReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.disableInterface(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setEthernetEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    List<String> _result = this.getInterfaceList();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 13;
        }

        private static class Proxy
        implements IEthernetManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getAvailableInterfaces() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IpConfiguration getConfiguration(String iface) throws RemoteException {
                IpConfiguration _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IpConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConfiguration(String iface, IpConfiguration config) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAvailable(String iface) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addListener(IEthernetServiceListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeListener(IEthernetServiceListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIncludeTestInterfaces(boolean include) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(include);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestTetheredInterface(ITetheredInterfaceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseTetheredInterface(ITetheredInterfaceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateConfiguration(String iface, EthernetNetworkUpdateRequest request, INetworkInterfaceOutcomeReceiver listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableInterface(String iface, INetworkInterfaceOutcomeReceiver listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableInterface(String iface, INetworkInterfaceOutcomeReceiver listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEthernetEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getInterfaceList() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IEthernetManager {
        @Override
        public String[] getAvailableInterfaces() throws RemoteException {
            return null;
        }

        @Override
        public IpConfiguration getConfiguration(String iface) throws RemoteException {
            return null;
        }

        @Override
        public void setConfiguration(String iface, IpConfiguration config) throws RemoteException {
        }

        @Override
        public boolean isAvailable(String iface) throws RemoteException {
            return false;
        }

        @Override
        public void addListener(IEthernetServiceListener listener) throws RemoteException {
        }

        @Override
        public void removeListener(IEthernetServiceListener listener) throws RemoteException {
        }

        @Override
        public void setIncludeTestInterfaces(boolean include) throws RemoteException {
        }

        @Override
        public void requestTetheredInterface(ITetheredInterfaceCallback callback) throws RemoteException {
        }

        @Override
        public void releaseTetheredInterface(ITetheredInterfaceCallback callback) throws RemoteException {
        }

        @Override
        public void updateConfiguration(String iface, EthernetNetworkUpdateRequest request, INetworkInterfaceOutcomeReceiver listener) throws RemoteException {
        }

        @Override
        public void enableInterface(String iface, INetworkInterfaceOutcomeReceiver listener) throws RemoteException {
        }

        @Override
        public void disableInterface(String iface, INetworkInterfaceOutcomeReceiver listener) throws RemoteException {
        }

        @Override
        public void setEthernetEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public List<String> getInterfaceList() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

