/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.MacAddress;
import android.net.NetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

public class EthernetNetworkSpecifier
extends NetworkSpecifier
implements Parcelable {
    @Nullable
    private final String mInterfaceName;
    @Nullable
    private final MacAddress mMacAddress;
    @NonNull
    public static final Parcelable.Creator<EthernetNetworkSpecifier> CREATOR = new Parcelable.Creator<EthernetNetworkSpecifier>(){

        @Override
        public EthernetNetworkSpecifier createFromParcel(Parcel in) {
            String ifname = in.readString();
            MacAddress addr = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
            return new EthernetNetworkSpecifier(ifname, addr);
        }

        public EthernetNetworkSpecifier[] newArray(int size) {
            return new EthernetNetworkSpecifier[size];
        }
    };

    public EthernetNetworkSpecifier(@NonNull String interfaceName) {
        if (TextUtils.isEmpty(interfaceName)) {
            throw new IllegalArgumentException("Interface name cannot be null");
        }
        this.mInterfaceName = interfaceName;
        this.mMacAddress = null;
    }

    public EthernetNetworkSpecifier(@Nullable String interfaceName, @Nullable MacAddress macAddress) {
        if (TextUtils.isEmpty(interfaceName) && macAddress == null) {
            throw new IllegalArgumentException("Either interface name or MAC address needs to be valid.");
        }
        this.mInterfaceName = interfaceName;
        this.mMacAddress = macAddress;
    }

    @Nullable
    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    @Nullable
    public MacAddress getMacAddress() {
        return this.mMacAddress;
    }

    @Override
    public boolean canBeSatisfiedBy(@Nullable NetworkSpecifier other) {
        if (!(other instanceof EthernetNetworkSpecifier)) {
            return false;
        }
        EthernetNetworkSpecifier rhs = (EthernetNetworkSpecifier)other;
        if (this.mInterfaceName != null && !this.mInterfaceName.equals(rhs.mInterfaceName)) {
            return false;
        }
        return this.mMacAddress == null || this.mMacAddress.equals(rhs.mMacAddress);
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof EthernetNetworkSpecifier)) {
            return false;
        }
        EthernetNetworkSpecifier rhs = (EthernetNetworkSpecifier)o;
        return TextUtils.equals(this.mInterfaceName, rhs.mInterfaceName) && Objects.equals(this.mMacAddress, rhs.mMacAddress);
    }

    public int hashCode() {
        return Objects.hash(this.mMacAddress, this.mInterfaceName);
    }

    public String toString() {
        return "EthernetNetworkSpecifier ( interface name: " + this.mInterfaceName + ", MAC address: " + Objects.toString(this.mMacAddress) + ")";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mInterfaceName);
        dest.writeParcelable(this.mMacAddress, flags);
    }
}

