/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.app.usage.NetworkStatsManager;
import android.net.EthernetManager;
import android.net.IEthernetManager;
import android.net.IIpSecService;
import android.net.INetworkStatsService;
import android.net.IpSecManager;
import android.net.connectivity.android.net.mdns.aidl.IMDns;
import android.net.connectivity.android.net.nsd.MDnsManager;
import android.net.connectivity.android.net.thread.IThreadNetworkManager;
import android.net.connectivity.com.android.modules.utils.build.SdkLevel;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdManager;
import android.net.thread.ThreadNetworkManager;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class ConnectivityFrameworkInitializerTiramisu {
    private ConnectivityFrameworkInitializerTiramisu() {
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("servicediscovery", NsdManager.class, (context, serviceBinder) -> {
            INsdManager service = INsdManager.Stub.asInterface(serviceBinder);
            return new NsdManager(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("ipsec", IpSecManager.class, (context, serviceBinder) -> {
            IIpSecService service = IIpSecService.Stub.asInterface(serviceBinder);
            return new IpSecManager(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("netstats", NetworkStatsManager.class, (context, serviceBinder) -> {
            INetworkStatsService service = INetworkStatsService.Stub.asInterface(serviceBinder);
            return new NetworkStatsManager(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("ethernet", EthernetManager.class, (context, serviceBinder) -> {
            IEthernetManager service = IEthernetManager.Stub.asInterface(serviceBinder);
            return new EthernetManager(context, service);
        });
        if (!SdkLevel.isAtLeastV()) {
            SystemServiceRegistry.registerStaticService("mdns", MDnsManager.class, serviceBinder -> {
                IMDns service = IMDns.Stub.asInterface(serviceBinder);
                return new MDnsManager(service);
            });
        }
        SystemServiceRegistry.registerContextAwareService("thread_network", ThreadNetworkManager.class, (context, serviceBinder) -> {
            IThreadNetworkManager managerService = IThreadNetworkManager.Stub.asInterface(serviceBinder);
            return new ThreadNetworkManager(context, managerService);
        });
    }
}

