/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;

@SystemApi
public abstract class NearbyDevice {
    @Nullable
    private final String mName;
    private final List<Integer> mMediums;
    private final int mRssi;

    public NearbyDevice(@Nullable String name, List<Integer> mediums, int rssi) {
        for (int medium : mediums) {
            Preconditions.checkState(NearbyDevice.isValidMedium(medium), "Not supported medium: " + medium + ", scan medium must be one of NearbyDevice#Medium.");
        }
        this.mName = name;
        this.mMediums = mediums;
        this.mRssi = rssi;
    }

    static String mediumToString(int medium) {
        switch (medium) {
            case 1: {
                return "BLE";
            }
            case 2: {
                return "Bluetooth Classic";
            }
        }
        return "Unknown";
    }

    public static boolean isValidMedium(int medium) {
        return medium == 1 || medium == 2;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @NonNull
    public List<Integer> getMediums() {
        return this.mMediums;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NearbyDevice [");
        if (this.mName != null && !this.mName.isEmpty()) {
            stringBuilder.append("name=").append(this.mName).append(", ");
        }
        stringBuilder.append("medium={");
        for (int medium : this.mMediums) {
            stringBuilder.append(NearbyDevice.mediumToString(medium));
        }
        stringBuilder.append("} rssi=").append(this.mRssi);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof NearbyDevice)) {
            return false;
        }
        NearbyDevice otherDevice = (NearbyDevice)other;
        ArraySet<Integer> mediumSet = new ArraySet<Integer>(this.mMediums);
        ArraySet<Integer> otherMediumSet = new ArraySet<Integer>(otherDevice.mMediums);
        if (!mediumSet.equals(otherMediumSet)) {
            return false;
        }
        return Objects.equals(this.mName, otherDevice.mName) && this.mRssi == otherDevice.mRssi;
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mMediums, this.mRssi);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Medium {
        public static final int BLE = 1;
        public static final int BLUETOOTH = 2;
    }
}

