/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class DataElement
implements Parcelable {
    private final int mKey;
    private final byte[] mValue;
    @NonNull
    public static final Parcelable.Creator<DataElement> CREATOR = new Parcelable.Creator<DataElement>(){

        @Override
        public DataElement createFromParcel(Parcel in) {
            int key = in.readInt();
            byte[] value = new byte[in.readInt()];
            in.readByteArray(value);
            return new DataElement(key, value);
        }

        public DataElement[] newArray(int size) {
            return new DataElement[size];
        }
    };

    public boolean isIdentityDataType() {
        return this.mKey == 1 || this.mKey == 2 || this.mKey == 3 || this.mKey == 4;
    }

    public static boolean isTestDeType(int type) {
        return type >= 2147483520 && type <= Integer.MAX_VALUE;
    }

    public DataElement(int key, @NonNull byte[] value) {
        Preconditions.checkArgument(value != null, "value cannot be null");
        this.mKey = key;
        this.mValue = value;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof DataElement) {
            return this.mKey == ((DataElement)obj).mKey && Arrays.equals(this.mValue, ((DataElement)obj).mValue);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mKey, Arrays.hashCode(this.mValue));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mKey);
        dest.writeInt(this.mValue.length);
        dest.writeByteArray(this.mValue);
    }

    public int getKey() {
        return this.mKey;
    }

    @NonNull
    public byte[] getValue() {
        return this.mValue;
    }

    public static @interface DataType {
        public static final int SALT = 0;
        public static final int PRIVATE_IDENTITY = 1;
        public static final int TRUSTED_IDENTITY = 2;
        public static final int PUBLIC_IDENTITY = 3;
        public static final int PROVISIONED_IDENTITY = 4;
        public static final int TX_POWER = 5;
        public static final int ACTION = 6;
        public static final int ACCOUNT_KEY_DATA = 9;
        public static final int CONNECTION_STATUS = 10;
        public static final int BATTERY = 11;
        public static final int ENCRYPTION_INFO = 16;
        public static final int BLE_SERVICE_DATA = 100;
        public static final int BLE_ADDRESS = 101;
        public static final int SCAN_MODE = 102;
        public static final int DEVICE_TYPE = 22;
        public static final int TEST_DE_BEGIN = 2147483520;
        public static final int TEST_DE_END = Integer.MAX_VALUE;
    }
}

