/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.ad;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Xml;
import com.android.internal.R;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

@FlaggedApi(value="android.media.tv.flags.enable_ad_service_fw")
public class TvAdServiceInfo
implements Parcelable {
    private static final boolean DEBUG = false;
    private static final String TAG = "TvAdServiceInfo";
    private static final String XML_START_TAG_NAME = "tv-ad-service";
    private final ResolveInfo mService;
    private final String mId;
    private final List<String> mTypes = new ArrayList<String>();
    @NonNull
    public static final Parcelable.Creator<TvAdServiceInfo> CREATOR = new Parcelable.Creator<TvAdServiceInfo>(){

        @Override
        public TvAdServiceInfo createFromParcel(Parcel in) {
            return new TvAdServiceInfo(in);
        }

        public TvAdServiceInfo[] newArray(int size) {
            return new TvAdServiceInfo[size];
        }
    };

    public TvAdServiceInfo(@NonNull Context context, @NonNull ComponentName component) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        Intent intent = new Intent("android.media.tv.ad.TvAdService").setComponent(component);
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 132);
        if (resolveInfo == null) {
            throw new IllegalArgumentException("Invalid component. Can't find the service.");
        }
        ComponentName componentName = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name);
        String id2 = TvAdServiceInfo.generateAdServiceId(componentName);
        ArrayList<String> types = new ArrayList<String>();
        TvAdServiceInfo.parseServiceMetadata(resolveInfo, context, types);
        this.mService = resolveInfo;
        this.mId = id2;
        this.mTypes.addAll(types);
    }

    private TvAdServiceInfo(ResolveInfo service, String id2, List<String> types) {
        this.mService = service;
        this.mId = id2;
        this.mTypes.addAll(types);
    }

    private TvAdServiceInfo(@NonNull Parcel in) {
        this.mService = ResolveInfo.CREATOR.createFromParcel(in);
        this.mId = in.readString();
        in.readStringList(this.mTypes);
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    @Nullable
    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    @NonNull
    public List<String> getSupportedTypes() {
        return this.mTypes;
    }

    private static String generateAdServiceId(ComponentName name) {
        return name.flattenToShortString();
    }

    private static void parseServiceMetadata(ResolveInfo resolveInfo, Context context, List<String> types) {
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        PackageManager pm = context.getPackageManager();
        try (XmlResourceParser parser = serviceInfo.loadXmlMetaData(pm, "android.media.tv.ad.service");){
            CharSequence[] textArr;
            int type;
            if (parser == null) {
                throw new IllegalStateException("No android.media.tv.ad.service meta-data found for " + serviceInfo.name);
            }
            Resources resources = pm.getResourcesForApplication(serviceInfo.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!XML_START_TAG_NAME.equals(nodeName)) {
                throw new IllegalStateException("Meta-data does not start with tv-ad-service tag for " + serviceInfo.name);
            }
            TypedArray sa = resources.obtainAttributes(attrs, R.styleable.TvAdService);
            for (CharSequence cs : textArr = sa.getTextArray(0)) {
                types.add(cs.toString().toLowerCase());
            }
            sa.recycle();
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException("Failed reading meta-data for " + serviceInfo.packageName, e);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalStateException("No resources found for " + serviceInfo.packageName, e);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mService.writeToParcel(dest, flags);
        dest.writeString(this.mId);
        dest.writeStringList(this.mTypes);
    }
}

