/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class AdRequest
implements Parcelable {
    public static final int REQUEST_TYPE_START = 1;
    public static final int REQUEST_TYPE_STOP = 2;
    @NonNull
    public static final Parcelable.Creator<AdRequest> CREATOR = new Parcelable.Creator<AdRequest>(){

        @Override
        public AdRequest createFromParcel(Parcel source) {
            return new AdRequest(source);
        }

        public AdRequest[] newArray(int size) {
            return new AdRequest[size];
        }
    };
    private final int mId;
    private final int mRequestType;
    private final ParcelFileDescriptor mFileDescriptor;
    private final long mStartTime;
    private final long mStopTime;
    private final long mEchoInterval;
    private final String mMediaFileType;
    private final Bundle mMetadata;
    private final Uri mUri;
    public static final String KEY_VIDEO_METADATA = "key_video_metadata";
    public static final String KEY_AUDIO_METADATA = "key_audio_metadata";

    public AdRequest(int id2, int requestType, @Nullable ParcelFileDescriptor fileDescriptor, long startTime, long stopTime, long echoInterval, @Nullable String mediaFileType, @NonNull Bundle metadata) {
        this(id2, requestType, fileDescriptor, null, startTime, stopTime, echoInterval, mediaFileType, metadata);
    }

    public AdRequest(int id2, int requestType, @Nullable Uri uri, long startTime, long stopTime, long echoInterval, @NonNull Bundle metadata) {
        this(id2, requestType, null, uri, startTime, stopTime, echoInterval, null, metadata);
    }

    private AdRequest(int id2, int requestType, @Nullable ParcelFileDescriptor fileDescriptor, @Nullable Uri uri, long startTime, long stopTime, long echoInterval, @Nullable String mediaFileType, @NonNull Bundle metadata) {
        this.mId = id2;
        this.mRequestType = requestType;
        this.mFileDescriptor = fileDescriptor;
        this.mStartTime = startTime;
        this.mStopTime = stopTime;
        this.mEchoInterval = echoInterval;
        this.mMediaFileType = mediaFileType;
        this.mMetadata = metadata;
        this.mUri = uri;
    }

    private AdRequest(Parcel source) {
        this.mId = source.readInt();
        this.mRequestType = source.readInt();
        int readInt = source.readInt();
        if (readInt == 1) {
            this.mFileDescriptor = ParcelFileDescriptor.CREATOR.createFromParcel(source);
            this.mUri = null;
        } else if (readInt == 2) {
            String stringUri = source.readString();
            this.mUri = stringUri == null ? null : Uri.parse(stringUri);
            this.mFileDescriptor = null;
        } else {
            this.mFileDescriptor = null;
            this.mUri = null;
        }
        this.mStartTime = source.readLong();
        this.mStopTime = source.readLong();
        this.mEchoInterval = source.readLong();
        this.mMediaFileType = source.readString();
        this.mMetadata = source.readBundle();
    }

    public int getId() {
        return this.mId;
    }

    public int getRequestType() {
        return this.mRequestType;
    }

    @Nullable
    public ParcelFileDescriptor getFileDescriptor() {
        return this.mFileDescriptor;
    }

    @Nullable
    public Uri getUri() {
        return this.mUri;
    }

    public long getStartTimeMillis() {
        return this.mStartTime;
    }

    public long getStopTimeMillis() {
        return this.mStopTime;
    }

    public long getEchoIntervalMillis() {
        return this.mEchoInterval;
    }

    @Nullable
    public String getMediaFileType() {
        return this.mMediaFileType;
    }

    @NonNull
    public Bundle getMetadata() {
        return this.mMetadata;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeInt(this.mRequestType);
        if (this.mFileDescriptor != null) {
            dest.writeInt(1);
            this.mFileDescriptor.writeToParcel(dest, flags);
        } else if (this.mUri != null) {
            dest.writeInt(2);
            String stringUri = this.mUri.toString();
            dest.writeString(stringUri);
        } else {
            dest.writeInt(0);
        }
        dest.writeLong(this.mStartTime);
        dest.writeLong(this.mStopTime);
        dest.writeLong(this.mEchoInterval);
        dest.writeString(this.mMediaFileType);
        dest.writeBundle(this.mMetadata);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestType {
    }
}

