/*
 * Decompiled with CFR 0.152.
 */
package android.media.soundtrigger_middleware;

import android.media.soundtrigger.Phrase;
import android.media.soundtrigger.RecognitionConfig;
import android.media.soundtrigger.SoundModel;
import android.media.soundtrigger_middleware.IInjectGlobalEvent;
import android.media.soundtrigger_middleware.IInjectModelEvent;
import android.media.soundtrigger_middleware.IInjectRecognitionEvent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISoundTriggerInjection
extends IInterface {
    public static final String DESCRIPTOR = "android.media.soundtrigger_middleware.ISoundTriggerInjection";
    public static final String FAKE_HAL_ARCH = "injection";

    public void registerGlobalEventInjection(IInjectGlobalEvent var1) throws RemoteException;

    public void onRestarted(IInjectGlobalEvent var1) throws RemoteException;

    public void onFrameworkDetached(IInjectGlobalEvent var1) throws RemoteException;

    public void onClientAttached(IBinder var1, IInjectGlobalEvent var2) throws RemoteException;

    public void onClientDetached(IBinder var1) throws RemoteException;

    public void onSoundModelLoaded(SoundModel var1, Phrase[] var2, IInjectModelEvent var3, IInjectGlobalEvent var4) throws RemoteException;

    public void onParamSet(int var1, int var2, IInjectModelEvent var3) throws RemoteException;

    public void onRecognitionStarted(int var1, RecognitionConfig var2, IInjectRecognitionEvent var3, IInjectModelEvent var4) throws RemoteException;

    public void onRecognitionStopped(IInjectRecognitionEvent var1) throws RemoteException;

    public void onSoundModelUnloaded(IInjectModelEvent var1) throws RemoteException;

    public void onPreempted() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISoundTriggerInjection {
        static final int TRANSACTION_registerGlobalEventInjection = 1;
        static final int TRANSACTION_onRestarted = 2;
        static final int TRANSACTION_onFrameworkDetached = 3;
        static final int TRANSACTION_onClientAttached = 4;
        static final int TRANSACTION_onClientDetached = 5;
        static final int TRANSACTION_onSoundModelLoaded = 6;
        static final int TRANSACTION_onParamSet = 7;
        static final int TRANSACTION_onRecognitionStarted = 8;
        static final int TRANSACTION_onRecognitionStopped = 9;
        static final int TRANSACTION_onSoundModelUnloaded = 10;
        static final int TRANSACTION_onPreempted = 11;

        public Stub() {
            this.attachInterface(this, ISoundTriggerInjection.DESCRIPTOR);
        }

        public static ISoundTriggerInjection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISoundTriggerInjection.DESCRIPTOR);
            if (iin != null && iin instanceof ISoundTriggerInjection) {
                return (ISoundTriggerInjection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISoundTriggerInjection.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IInjectGlobalEvent _arg0 = IInjectGlobalEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerGlobalEventInjection(_arg0);
                    break;
                }
                case 2: {
                    IInjectGlobalEvent _arg0 = IInjectGlobalEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onRestarted(_arg0);
                    break;
                }
                case 3: {
                    IInjectGlobalEvent _arg0 = IInjectGlobalEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onFrameworkDetached(_arg0);
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    IInjectGlobalEvent _arg1 = IInjectGlobalEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onClientAttached(_arg0, _arg1);
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.onClientDetached(_arg0);
                    break;
                }
                case 6: {
                    SoundModel _arg0 = data.readTypedObject(SoundModel.CREATOR);
                    Phrase[] _arg1 = data.createTypedArray(Phrase.CREATOR);
                    IInjectModelEvent _arg2 = IInjectModelEvent.Stub.asInterface(data.readStrongBinder());
                    IInjectGlobalEvent _arg3 = IInjectGlobalEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onSoundModelLoaded(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IInjectModelEvent _arg2 = IInjectModelEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onParamSet(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    RecognitionConfig _arg1 = data.readTypedObject(RecognitionConfig.CREATOR);
                    IInjectRecognitionEvent _arg2 = IInjectRecognitionEvent.Stub.asInterface(data.readStrongBinder());
                    IInjectModelEvent _arg3 = IInjectModelEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onRecognitionStarted(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 9: {
                    IInjectRecognitionEvent _arg0 = IInjectRecognitionEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onRecognitionStopped(_arg0);
                    break;
                }
                case 10: {
                    IInjectModelEvent _arg0 = IInjectModelEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onSoundModelUnloaded(_arg0);
                    break;
                }
                case 11: {
                    this.onPreempted();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ISoundTriggerInjection {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISoundTriggerInjection.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerGlobalEventInjection(IInjectGlobalEvent globalInjection) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    _data.writeStrongInterface(globalInjection);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRestarted(IInjectGlobalEvent globalSession) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    _data.writeStrongInterface(globalSession);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFrameworkDetached(IInjectGlobalEvent globalSession) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    _data.writeStrongInterface(globalSession);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClientAttached(IBinder token, IInjectGlobalEvent globalSession) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(globalSession);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClientDetached(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoundModelLoaded(SoundModel model, Phrase[] phrases, IInjectModelEvent modelInjection, IInjectGlobalEvent globalSession) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    _data.writeTypedObject(model, 0);
                    _data.writeTypedArray(phrases, 0);
                    _data.writeStrongInterface(modelInjection);
                    _data.writeStrongInterface(globalSession);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onParamSet(int modelParam, int value, IInjectModelEvent modelSession) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    _data.writeInt(modelParam);
                    _data.writeInt(value);
                    _data.writeStrongInterface(modelSession);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecognitionStarted(int audioSessionToken, RecognitionConfig config, IInjectRecognitionEvent recognitionInjection, IInjectModelEvent modelSession) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    _data.writeInt(audioSessionToken);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongInterface(recognitionInjection);
                    _data.writeStrongInterface(modelSession);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecognitionStopped(IInjectRecognitionEvent recognitionSession) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    _data.writeStrongInterface(recognitionSession);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoundModelUnloaded(IInjectModelEvent modelSession) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    _data.writeStrongInterface(modelSession);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onPreempted() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundTriggerInjection.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISoundTriggerInjection {
        @Override
        public void registerGlobalEventInjection(IInjectGlobalEvent globalInjection) throws RemoteException {
        }

        @Override
        public void onRestarted(IInjectGlobalEvent globalSession) throws RemoteException {
        }

        @Override
        public void onFrameworkDetached(IInjectGlobalEvent globalSession) throws RemoteException {
        }

        @Override
        public void onClientAttached(IBinder token, IInjectGlobalEvent globalSession) throws RemoteException {
        }

        @Override
        public void onClientDetached(IBinder token) throws RemoteException {
        }

        @Override
        public void onSoundModelLoaded(SoundModel model, Phrase[] phrases, IInjectModelEvent modelInjection, IInjectGlobalEvent globalSession) throws RemoteException {
        }

        @Override
        public void onParamSet(int modelParam, int value, IInjectModelEvent modelSession) throws RemoteException {
        }

        @Override
        public void onRecognitionStarted(int audioSessionToken, RecognitionConfig config, IInjectRecognitionEvent recognitionInjection, IInjectModelEvent modelSession) throws RemoteException {
        }

        @Override
        public void onRecognitionStopped(IInjectRecognitionEvent recognitionSession) throws RemoteException {
        }

        @Override
        public void onSoundModelUnloaded(IInjectModelEvent modelSession) throws RemoteException {
        }

        @Override
        public void onPreempted() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

