/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.ActivityOptions;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionManager;
import android.media.projection.IMediaProjectionWatcherCallback;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionConfig;
import android.media.projection.MediaProjectionEvent;
import android.media.projection.MediaProjectionInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import android.view.ContentRecordingSession;
import com.android.internal.hidden_from_bootclasspath.com.android.media.projection.flags.Flags;
import java.util.Map;

public class MediaProjectionManager {
    private static final String TAG = "MediaProjectionManager";
    public static final long OVERRIDE_DISABLE_MEDIA_PROJECTION_SINGLE_APP_OPTION = 316897322L;
    public static final String EXTRA_MEDIA_PROJECTION_CONFIG = "android.media.projection.extra.EXTRA_MEDIA_PROJECTION_CONFIG";
    public static final String EXTRA_APP_TOKEN = "android.media.projection.extra.EXTRA_APP_TOKEN";
    public static final String EXTRA_MEDIA_PROJECTION = "android.media.projection.extra.EXTRA_MEDIA_PROJECTION";
    public static final String EXTRA_LAUNCH_COOKIE = "android.media.projection.extra.EXTRA_LAUNCH_COOKIE";
    public static final int TYPE_SCREEN_CAPTURE = 0;
    public static final int TYPE_MIRRORING = 1;
    public static final int TYPE_PRESENTATION = 2;
    private Context mContext;
    private Map<Callback, CallbackDelegate> mCallbacks;
    private IMediaProjectionManager mService;

    public MediaProjectionManager(Context context) {
        this.mContext = context;
        IBinder b = ServiceManager.getService("media_projection");
        this.mService = IMediaProjectionManager.Stub.asInterface(b);
        this.mCallbacks = new ArrayMap<Callback, CallbackDelegate>();
    }

    @NonNull
    public Intent createScreenCaptureIntent() {
        Intent i = new Intent();
        ComponentName mediaProjectionPermissionDialogComponent = ComponentName.unflattenFromString(this.mContext.getResources().getString(17040028));
        i.setComponent(mediaProjectionPermissionDialogComponent);
        return i;
    }

    @NonNull
    public Intent createScreenCaptureIntent(@NonNull MediaProjectionConfig config) {
        if (Flags.appContentSharing() && config.isOwnAppContentProvided()) {
            this.checkAppContentPrerequisites();
        }
        Intent i = this.createScreenCaptureIntent();
        i.putExtra(EXTRA_MEDIA_PROJECTION_CONFIG, config);
        return i;
    }

    private void checkAppContentPrerequisites() {
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent serviceIntent = new Intent("android.media.projection.AppContentProjectionService").setPackage(this.mContext.getPackageName());
        ResolveInfo resolveInfo = packageManager.resolveService(serviceIntent, 131072);
        Log.d(TAG, "ResolveInfo:" + (resolveInfo == null ? "null" : resolveInfo.toString()));
        if (resolveInfo == null) {
            Log.w(TAG, "Could not resolve service declaring an intent-filter with android.media.projection.AppContentProjectionService");
            throw new IllegalArgumentException("Could not resolve service declaring an intent-filter with android.media.projection.AppContentProjectionService");
        }
        if (resolveInfo != null && !"android.permission.MANAGE_MEDIA_PROJECTION".equals(resolveInfo.serviceInfo.permission)) {
            Log.w(TAG, "Service declaring action %s must check %s".formatted("android.media.projection.AppContentProjectionService", "android.permission.MANAGE_MEDIA_PROJECTION"));
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public Intent createScreenCaptureIntent(@NonNull ActivityOptions.LaunchCookie launchCookie) {
        Intent i = this.createScreenCaptureIntent();
        i.putExtra(EXTRA_LAUNCH_COOKIE, launchCookie);
        return i;
    }

    @Nullable
    public MediaProjection getMediaProjection(int resultCode, @NonNull Intent resultData) {
        if (resultCode != -1 || resultData == null) {
            return null;
        }
        IBinder projection = resultData.getIBinderExtra(EXTRA_MEDIA_PROJECTION);
        if (projection == null) {
            return null;
        }
        return new MediaProjection(this.mContext, IMediaProjection.Stub.asInterface(projection));
    }

    public MediaProjectionInfo getActiveProjectionInfo() {
        try {
            return this.mService.getActiveProjectionInfo();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to get the active projection info", e);
            return null;
        }
    }

    public void stopActiveProjection(int stopReason) {
        try {
            Log.d(TAG, "Content Recording: stopping active projection");
            this.mService.stopActiveProjection(stopReason);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to stop the currently active media projection", e);
        }
    }

    public void addCallback(@NonNull Callback callback, @Nullable Handler handler) {
        if (callback == null) {
            Log.w(TAG, "Content Recording: cannot add null callback");
            throw new IllegalArgumentException("callback must not be null");
        }
        CallbackDelegate delegate = new CallbackDelegate(callback, handler);
        this.mCallbacks.put(callback, delegate);
        try {
            this.mService.addCallback(delegate);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to add callbacks to MediaProjection service", e);
        }
    }

    public void removeCallback(@NonNull Callback callback) {
        if (callback == null) {
            Log.w(TAG, "ContentRecording: cannot remove null callback");
            throw new IllegalArgumentException("callback must not be null");
        }
        CallbackDelegate delegate = this.mCallbacks.remove(callback);
        try {
            if (delegate != null) {
                this.mService.removeCallback(delegate);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to add callbacks to MediaProjection service", e);
        }
    }

    private static class CallbackDelegate
    extends IMediaProjectionWatcherCallback.Stub {
        private Callback mCallback;
        private Handler mHandler;

        public CallbackDelegate(Callback callback, Handler handler) {
            this.mCallback = callback;
            if (handler == null) {
                handler = new Handler();
            }
            this.mHandler = handler;
        }

        @Override
        public void onStart(final MediaProjectionInfo info) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onStart(info);
                }
            });
        }

        @Override
        public void onStop(final MediaProjectionInfo info) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onStop(info);
                }
            });
        }

        @Override
        public void onRecordingSessionSet(@NonNull MediaProjectionInfo info, @Nullable ContentRecordingSession session) {
            this.mHandler.post(() -> this.mCallback.onRecordingSessionSet(info, session));
        }

        @Override
        public void onMediaProjectionEvent(MediaProjectionEvent event, @Nullable MediaProjectionInfo info, @Nullable ContentRecordingSession session) {
            this.mHandler.post(() -> this.mCallback.onMediaProjectionEvent(event, info, session));
        }
    }

    public static abstract class Callback {
        public abstract void onStart(MediaProjectionInfo var1);

        public abstract void onStop(MediaProjectionInfo var1);

        public void onRecordingSessionSet(@NonNull MediaProjectionInfo info, @Nullable ContentRecordingSession session) {
        }

        public void onMediaProjectionEvent(MediaProjectionEvent event, @Nullable MediaProjectionInfo info, @Nullable ContentRecordingSession session) {
        }
    }
}

