/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Size;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@FlaggedApi(value="com.android.media.editing.flags.add_media_metrics_editing")
public class MediaItemInfo
implements Parcelable {
    public static final int SOURCE_TYPE_UNSPECIFIED = 0;
    public static final int SOURCE_TYPE_GALLERY = 1;
    public static final int SOURCE_TYPE_CAMERA = 2;
    public static final int SOURCE_TYPE_EDITING_SESSION = 3;
    public static final int SOURCE_TYPE_LOCAL_FILE = 4;
    public static final int SOURCE_TYPE_REMOTE_FILE = 5;
    public static final int SOURCE_TYPE_REMOTE_LIVE_STREAM = 6;
    public static final int SOURCE_TYPE_GENERATED = 7;
    public static final long DATA_TYPE_IMAGE = 1L;
    public static final long DATA_TYPE_VIDEO = 2L;
    public static final long DATA_TYPE_AUDIO = 4L;
    public static final long DATA_TYPE_METADATA = 8L;
    public static final long DATA_TYPE_DEPTH = 16L;
    public static final long DATA_TYPE_GAIN_MAP = 32L;
    public static final long DATA_TYPE_HIGH_FRAME_RATE = 64L;
    public static final long DATA_TYPE_SPEED_SETTING_CUE_POINTS = 128L;
    public static final long DATA_TYPE_GAPLESS = 256L;
    public static final long DATA_TYPE_SPATIAL_AUDIO = 512L;
    public static final long DATA_TYPE_HIGH_DYNAMIC_RANGE_VIDEO = 1024L;
    public static final int VALUE_UNSPECIFIED = -1;
    private final int mSourceType;
    private final long mDataTypes;
    private final long mDurationMillis;
    private final long mClipDurationMillis;
    @Nullable
    private final String mContainerMimeType;
    private final List<String> mSampleMimeTypes;
    private final List<String> mCodecNames;
    private final int mAudioSampleRateHz;
    private final int mAudioChannelCount;
    private final long mAudioSampleCount;
    private final Size mVideoSize;
    private final int mVideoDataSpace;
    private final float mVideoFrameRate;
    private final long mVideoSampleCount;
    @NonNull
    public static final Parcelable.Creator<MediaItemInfo> CREATOR = new Parcelable.Creator<MediaItemInfo>(){

        public MediaItemInfo[] newArray(int size) {
            return new MediaItemInfo[size];
        }

        @Override
        public MediaItemInfo createFromParcel(@NonNull Parcel in) {
            return new MediaItemInfo(in);
        }
    };

    private MediaItemInfo(int sourceType, long dataTypes, long durationMillis, long clipDurationMillis, @Nullable String containerMimeType, List<String> sampleMimeTypes, List<String> codecNames, int audioSampleRateHz, int audioChannelCount, long audioSampleCount, Size videoSize, int videoDataSpace, float videoFrameRate, long videoSampleCount) {
        this.mSourceType = sourceType;
        this.mDataTypes = dataTypes;
        this.mDurationMillis = durationMillis;
        this.mClipDurationMillis = clipDurationMillis;
        this.mContainerMimeType = containerMimeType;
        this.mSampleMimeTypes = sampleMimeTypes;
        this.mCodecNames = codecNames;
        this.mAudioSampleRateHz = audioSampleRateHz;
        this.mAudioChannelCount = audioChannelCount;
        this.mAudioSampleCount = audioSampleCount;
        this.mVideoSize = videoSize;
        this.mVideoDataSpace = videoDataSpace;
        this.mVideoFrameRate = videoFrameRate;
        this.mVideoSampleCount = videoSampleCount;
    }

    public int getSourceType() {
        return this.mSourceType;
    }

    public long getDataTypes() {
        return this.mDataTypes;
    }

    public long getDurationMillis() {
        return this.mDurationMillis;
    }

    public long getClipDurationMillis() {
        return this.mClipDurationMillis;
    }

    @Nullable
    public String getContainerMimeType() {
        return this.mContainerMimeType;
    }

    @NonNull
    public List<String> getSampleMimeTypes() {
        return new ArrayList<String>(this.mSampleMimeTypes);
    }

    @NonNull
    public List<String> getCodecNames() {
        return new ArrayList<String>(this.mCodecNames);
    }

    public int getAudioSampleRateHz() {
        return this.mAudioSampleRateHz;
    }

    public int getAudioChannelCount() {
        return this.mAudioChannelCount;
    }

    public long getAudioSampleCount() {
        return this.mAudioSampleCount;
    }

    @NonNull
    public Size getVideoSize() {
        return this.mVideoSize;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getVideoDataSpace() {
        return this.mVideoDataSpace;
    }

    public float getVideoFrameRate() {
        return this.mVideoFrameRate;
    }

    public long getVideoSampleCount() {
        return this.mVideoSampleCount;
    }

    @NonNull
    public String toString() {
        return "MediaItemInfo { sourceType = " + this.mSourceType + ", dataTypes = " + this.mDataTypes + ", durationMillis = " + this.mDurationMillis + ", clipDurationMillis = " + this.mClipDurationMillis + ", containerMimeType = " + this.mContainerMimeType + ", sampleMimeTypes = " + this.mSampleMimeTypes + ", codecNames = " + this.mCodecNames + ", audioSampleRateHz = " + this.mAudioSampleRateHz + ", audioChannelCount = " + this.mAudioChannelCount + ", audioSampleCount = " + this.mAudioSampleCount + ", videoSize = " + this.mVideoSize + ", videoDataSpace = " + this.mVideoDataSpace + ", videoFrameRate = " + this.mVideoFrameRate + ", videoSampleCount = " + this.mVideoSampleCount + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaItemInfo that = (MediaItemInfo)o;
        return this.mSourceType == that.mSourceType && this.mDataTypes == that.mDataTypes && this.mDurationMillis == that.mDurationMillis && this.mClipDurationMillis == that.mClipDurationMillis && Objects.equals(this.mContainerMimeType, that.mContainerMimeType) && this.mSampleMimeTypes.equals(that.mSampleMimeTypes) && this.mCodecNames.equals(that.mCodecNames) && this.mAudioSampleRateHz == that.mAudioSampleRateHz && this.mAudioChannelCount == that.mAudioChannelCount && this.mAudioSampleCount == that.mAudioSampleCount && Objects.equals(this.mVideoSize, that.mVideoSize) && Objects.equals(this.mVideoDataSpace, that.mVideoDataSpace) && this.mVideoFrameRate == that.mVideoFrameRate && this.mVideoSampleCount == that.mVideoSampleCount;
    }

    public int hashCode() {
        return Objects.hash(this.mSourceType, this.mDataTypes);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mSourceType);
        dest.writeLong(this.mDataTypes);
        dest.writeLong(this.mDurationMillis);
        dest.writeLong(this.mClipDurationMillis);
        dest.writeString(this.mContainerMimeType);
        dest.writeStringList(this.mSampleMimeTypes);
        dest.writeStringList(this.mCodecNames);
        dest.writeInt(this.mAudioSampleRateHz);
        dest.writeInt(this.mAudioChannelCount);
        dest.writeLong(this.mAudioSampleCount);
        dest.writeInt(this.mVideoSize.getWidth());
        dest.writeInt(this.mVideoSize.getHeight());
        dest.writeInt(this.mVideoDataSpace);
        dest.writeFloat(this.mVideoFrameRate);
        dest.writeLong(this.mVideoSampleCount);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private MediaItemInfo(@NonNull Parcel in) {
        this.mSourceType = in.readInt();
        this.mDataTypes = in.readLong();
        this.mDurationMillis = in.readLong();
        this.mClipDurationMillis = in.readLong();
        this.mContainerMimeType = in.readString();
        this.mSampleMimeTypes = new ArrayList<String>();
        in.readStringList(this.mSampleMimeTypes);
        this.mCodecNames = new ArrayList<String>();
        in.readStringList(this.mCodecNames);
        this.mAudioSampleRateHz = in.readInt();
        this.mAudioChannelCount = in.readInt();
        this.mAudioSampleCount = in.readLong();
        int videoSizeWidth = in.readInt();
        int videoSizeHeight = in.readInt();
        this.mVideoSize = new Size(videoSizeWidth, videoSizeHeight);
        this.mVideoDataSpace = in.readInt();
        this.mVideoFrameRate = in.readFloat();
        this.mVideoSampleCount = in.readLong();
    }

    @FlaggedApi(value="com.android.media.editing.flags.add_media_metrics_editing")
    public static class Builder {
        private int mSourceType = 0;
        private long mDataTypes;
        private long mDurationMillis = -1L;
        private long mClipDurationMillis = -1L;
        @Nullable
        private String mContainerMimeType;
        private final ArrayList<String> mSampleMimeTypes = new ArrayList();
        private final ArrayList<String> mCodecNames = new ArrayList();
        private int mAudioSampleRateHz = -1;
        private int mAudioChannelCount = -1;
        private long mAudioSampleCount = -1L;
        @Nullable
        private Size mVideoSize = new Size(-1, -1);
        private int mVideoDataSpace;
        private float mVideoFrameRate = -1.0f;
        private long mVideoSampleCount = -1L;

        @NonNull
        public Builder setSourceType(int sourceType) {
            this.mSourceType = sourceType;
            return this;
        }

        @NonNull
        public Builder addDataType(long dataType) {
            this.mDataTypes |= dataType;
            return this;
        }

        @NonNull
        public Builder setDurationMillis(long durationMillis) {
            this.mDurationMillis = durationMillis;
            return this;
        }

        @NonNull
        public Builder setClipDurationMillis(long clipDurationMillis) {
            this.mClipDurationMillis = clipDurationMillis;
            return this;
        }

        @NonNull
        public Builder setContainerMimeType(@NonNull String containerMimeType) {
            this.mContainerMimeType = Objects.requireNonNull(containerMimeType);
            return this;
        }

        @NonNull
        public Builder addSampleMimeType(@NonNull String mimeType) {
            this.mSampleMimeTypes.add(Objects.requireNonNull(mimeType));
            return this;
        }

        @NonNull
        public Builder addCodecName(@NonNull String codecName) {
            this.mCodecNames.add(Objects.requireNonNull(codecName));
            return this;
        }

        @NonNull
        public Builder setAudioSampleRateHz(int audioSampleRateHz) {
            this.mAudioSampleRateHz = audioSampleRateHz;
            return this;
        }

        @NonNull
        public Builder setAudioChannelCount(int audioChannelCount) {
            this.mAudioChannelCount = audioChannelCount;
            return this;
        }

        @NonNull
        public Builder setAudioSampleCount(long audioSampleCount) {
            this.mAudioSampleCount = audioSampleCount;
            return this;
        }

        @NonNull
        public Builder setVideoSize(@NonNull Size videoSize) {
            this.mVideoSize = Objects.requireNonNull(videoSize);
            return this;
        }

        @NonNull
        public Builder setVideoDataSpace(int videoDataSpace) {
            this.mVideoDataSpace = videoDataSpace;
            return this;
        }

        @NonNull
        public Builder setVideoFrameRate(float videoFrameRate) {
            this.mVideoFrameRate = videoFrameRate;
            return this;
        }

        @NonNull
        public Builder setVideoSampleCount(long videoSampleCount) {
            this.mVideoSampleCount = videoSampleCount;
            return this;
        }

        @NonNull
        public MediaItemInfo build() {
            return new MediaItemInfo(this.mSourceType, this.mDataTypes, this.mDurationMillis, this.mClipDurationMillis, this.mContainerMimeType, this.mSampleMimeTypes, this.mCodecNames, this.mAudioSampleRateHz, this.mAudioChannelCount, this.mAudioSampleCount, this.mVideoSize, this.mVideoDataSpace, this.mVideoFrameRate, this.mVideoSampleCount);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceType {
    }
}

