/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.metrics.Event;
import android.media.metrics.MediaItemInfo;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@FlaggedApi(value="com.android.media.editing.flags.add_media_metrics_editing")
public class EditingEndedEvent
extends Event
implements Parcelable {
    public static final int FINAL_STATE_SUCCEEDED = 1;
    public static final int FINAL_STATE_CANCELED = 2;
    public static final int FINAL_STATE_ERROR = 3;
    private final int mFinalState;
    private final float mFinalProgressPercent;
    public static final int ERROR_CODE_NONE = 1;
    public static final int ERROR_CODE_FAILED_RUNTIME_CHECK = 2;
    public static final int ERROR_CODE_IO_UNSPECIFIED = 3;
    public static final int ERROR_CODE_IO_NETWORK_CONNECTION_FAILED = 4;
    public static final int ERROR_CODE_IO_NETWORK_CONNECTION_TIMEOUT = 5;
    public static final int ERROR_CODE_IO_BAD_HTTP_STATUS = 6;
    public static final int ERROR_CODE_IO_FILE_NOT_FOUND = 7;
    public static final int ERROR_CODE_IO_NO_PERMISSION = 8;
    public static final int ERROR_CODE_IO_CLEARTEXT_NOT_PERMITTED = 9;
    public static final int ERROR_CODE_IO_READ_POSITION_OUT_OF_RANGE = 10;
    public static final int ERROR_CODE_DECODER_INIT_FAILED = 11;
    public static final int ERROR_CODE_DECODING_FAILED = 12;
    public static final int ERROR_CODE_DECODING_FORMAT_UNSUPPORTED = 13;
    public static final int ERROR_CODE_ENCODER_INIT_FAILED = 14;
    public static final int ERROR_CODE_ENCODING_FAILED = 15;
    public static final int ERROR_CODE_ENCODING_FORMAT_UNSUPPORTED = 16;
    public static final int ERROR_CODE_VIDEO_FRAME_PROCESSING_FAILED = 17;
    public static final int ERROR_CODE_AUDIO_PROCESSING_FAILED = 18;
    public static final int ERROR_CODE_MUXING_FAILED = 19;
    public static final int TIME_SINCE_CREATED_UNKNOWN = -1;
    public static final int PROGRESS_PERCENT_UNKNOWN = -1;
    private final int mErrorCode;
    private final long mTimeSinceCreatedMillis;
    @Nullable
    private final String mExporterName;
    @Nullable
    private final String mMuxerName;
    private final ArrayList<MediaItemInfo> mInputMediaItemInfos;
    @Nullable
    private final MediaItemInfo mOutputMediaItemInfo;
    public static final long OPERATION_TYPE_VIDEO_TRANSCODE = 1L;
    public static final long OPERATION_TYPE_AUDIO_TRANSCODE = 2L;
    public static final long OPERATION_TYPE_VIDEO_EDIT = 4L;
    public static final long OPERATION_TYPE_AUDIO_EDIT = 8L;
    public static final long OPERATION_TYPE_VIDEO_TRANSMUX = 16L;
    public static final long OPERATION_TYPE_AUDIO_TRANSMUX = 32L;
    public static final long OPERATION_TYPE_PAUSED = 64L;
    public static final long OPERATION_TYPE_RESUMED = 128L;
    private final long mOperationTypes;
    @NonNull
    public static final Parcelable.Creator<EditingEndedEvent> CREATOR = new Parcelable.Creator<EditingEndedEvent>(){

        public EditingEndedEvent[] newArray(int size) {
            return new EditingEndedEvent[size];
        }

        @Override
        public EditingEndedEvent createFromParcel(@NonNull Parcel in) {
            return new EditingEndedEvent(in);
        }
    };

    private EditingEndedEvent(int finalState, float finalProgressPercent, int errorCode, long timeSinceCreatedMillis, @Nullable String exporterName, @Nullable String muxerName, ArrayList<MediaItemInfo> inputMediaItemInfos, @Nullable MediaItemInfo outputMediaItemInfo, long operationTypes, @NonNull Bundle extras) {
        this.mFinalState = finalState;
        this.mFinalProgressPercent = finalProgressPercent;
        this.mErrorCode = errorCode;
        this.mTimeSinceCreatedMillis = timeSinceCreatedMillis;
        this.mExporterName = exporterName;
        this.mMuxerName = muxerName;
        this.mInputMediaItemInfos = inputMediaItemInfos;
        this.mOutputMediaItemInfo = outputMediaItemInfo;
        this.mOperationTypes = operationTypes;
        this.mMetricsBundle = extras.deepCopy();
    }

    public int getFinalState() {
        return this.mFinalState;
    }

    public float getFinalProgressPercent() {
        return this.mFinalProgressPercent;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Override
    public long getTimeSinceCreatedMillis() {
        return this.mTimeSinceCreatedMillis;
    }

    @Nullable
    public String getExporterName() {
        return this.mExporterName;
    }

    @Nullable
    public String getMuxerName() {
        return this.mMuxerName;
    }

    @NonNull
    public List<MediaItemInfo> getInputMediaItemInfos() {
        return new ArrayList<MediaItemInfo>(this.mInputMediaItemInfos);
    }

    @Nullable
    public MediaItemInfo getOutputMediaItemInfo() {
        return this.mOutputMediaItemInfo;
    }

    public long getOperationTypes() {
        return this.mOperationTypes;
    }

    @Override
    @NonNull
    public Bundle getMetricsBundle() {
        return this.mMetricsBundle;
    }

    @NonNull
    public String toString() {
        return "EditingEndedEvent { finalState = " + this.mFinalState + ", finalProgressPercent = " + this.mFinalProgressPercent + ", errorCode = " + this.mErrorCode + ", timeSinceCreatedMillis = " + this.mTimeSinceCreatedMillis + ", exporterName = " + this.mExporterName + ", muxerName = " + this.mMuxerName + ", inputMediaItemInfos = " + this.mInputMediaItemInfos + ", outputMediaItemInfo = " + this.mOutputMediaItemInfo + ", operationTypes = " + this.mOperationTypes + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditingEndedEvent that = (EditingEndedEvent)o;
        return this.mFinalState == that.mFinalState && this.mFinalProgressPercent == that.mFinalProgressPercent && this.mErrorCode == that.mErrorCode && Objects.equals(this.mInputMediaItemInfos, that.mInputMediaItemInfos) && Objects.equals(this.mOutputMediaItemInfo, that.mOutputMediaItemInfo) && this.mOperationTypes == that.mOperationTypes && this.mTimeSinceCreatedMillis == that.mTimeSinceCreatedMillis && Objects.equals(this.mExporterName, that.mExporterName) && Objects.equals(this.mMuxerName, that.mMuxerName);
    }

    public int hashCode() {
        return Objects.hash(this.mFinalState, Float.valueOf(this.mFinalProgressPercent), this.mErrorCode, this.mInputMediaItemInfos, this.mOutputMediaItemInfo, this.mOperationTypes, this.mTimeSinceCreatedMillis, this.mExporterName, this.mMuxerName);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mFinalState);
        dest.writeFloat(this.mFinalProgressPercent);
        dest.writeInt(this.mErrorCode);
        dest.writeLong(this.mTimeSinceCreatedMillis);
        dest.writeString(this.mExporterName);
        dest.writeString(this.mMuxerName);
        dest.writeTypedList(this.mInputMediaItemInfos);
        dest.writeTypedObject(this.mOutputMediaItemInfo, 0);
        dest.writeLong(this.mOperationTypes);
        dest.writeBundle(this.mMetricsBundle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private EditingEndedEvent(@NonNull Parcel in) {
        this.mFinalState = in.readInt();
        this.mFinalProgressPercent = in.readFloat();
        this.mErrorCode = in.readInt();
        this.mTimeSinceCreatedMillis = in.readLong();
        this.mExporterName = in.readString();
        this.mMuxerName = in.readString();
        this.mInputMediaItemInfos = new ArrayList();
        in.readTypedList(this.mInputMediaItemInfos, MediaItemInfo.CREATOR);
        this.mOutputMediaItemInfo = in.readTypedObject(MediaItemInfo.CREATOR);
        this.mOperationTypes = in.readLong();
        this.mMetricsBundle = in.readBundle();
    }

    @FlaggedApi(value="com.android.media.editing.flags.add_media_metrics_editing")
    public static class Builder {
        private final int mFinalState;
        private final ArrayList<MediaItemInfo> mInputMediaItemInfos;
        private float mFinalProgressPercent;
        private int mErrorCode;
        private long mTimeSinceCreatedMillis;
        @Nullable
        private String mExporterName;
        @Nullable
        private String mMuxerName;
        @Nullable
        private MediaItemInfo mOutputMediaItemInfo;
        private long mOperationTypes;
        private Bundle mMetricsBundle;

        public Builder(int finalState) {
            this.mFinalState = finalState;
            this.mFinalProgressPercent = -1.0f;
            this.mErrorCode = 1;
            this.mTimeSinceCreatedMillis = -1L;
            this.mInputMediaItemInfos = new ArrayList();
            this.mMetricsBundle = new Bundle();
        }

        @NonNull
        public Builder setFinalProgressPercent(float finalProgressPercent) {
            this.mFinalProgressPercent = finalProgressPercent;
            return this;
        }

        @NonNull
        public Builder setTimeSinceCreatedMillis(long timeSinceCreatedMillis) {
            this.mTimeSinceCreatedMillis = timeSinceCreatedMillis;
            return this;
        }

        @NonNull
        public Builder setExporterName(@NonNull String exporterName) {
            this.mExporterName = Objects.requireNonNull(exporterName);
            return this;
        }

        @NonNull
        public Builder setMuxerName(@NonNull String muxerName) {
            this.mMuxerName = Objects.requireNonNull(muxerName);
            return this;
        }

        @NonNull
        public Builder setErrorCode(int value) {
            this.mErrorCode = value;
            return this;
        }

        @NonNull
        public Builder addInputMediaItemInfo(@NonNull MediaItemInfo mediaItemInfo) {
            this.mInputMediaItemInfos.add(Objects.requireNonNull(mediaItemInfo));
            return this;
        }

        @NonNull
        public Builder setOutputMediaItemInfo(@NonNull MediaItemInfo mediaItemInfo) {
            this.mOutputMediaItemInfo = Objects.requireNonNull(mediaItemInfo);
            return this;
        }

        @NonNull
        public Builder addOperationType(long operationType) {
            this.mOperationTypes |= operationType;
            return this;
        }

        @NonNull
        public Builder setMetricsBundle(@NonNull Bundle metricsBundle) {
            this.mMetricsBundle = Objects.requireNonNull(metricsBundle);
            return this;
        }

        @NonNull
        public EditingEndedEvent build() {
            return new EditingEndedEvent(this.mFinalState, this.mFinalProgressPercent, this.mErrorCode, this.mTimeSinceCreatedMillis, this.mExporterName, this.mMuxerName, this.mInputMediaItemInfos, this.mOutputMediaItemInfo, this.mOperationTypes, this.mMetricsBundle);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OperationType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FinalState {
    }
}

