/*
 * Decompiled with CFR 0.152.
 */
package android.media.audio.common;

import android.media.audio.common.AudioChannelLayout;
import android.media.audio.common.AudioFormatDescription;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class AudioConfigBase
implements Parcelable {
    public int sampleRate = 0;
    public AudioChannelLayout channelMask;
    public AudioFormatDescription format;
    public static final Parcelable.Creator<AudioConfigBase> CREATOR = new Parcelable.Creator<AudioConfigBase>(){

        @Override
        public AudioConfigBase createFromParcel(Parcel _aidl_source) {
            AudioConfigBase _aidl_out = new AudioConfigBase();
            _aidl_out.readFromParcel(_aidl_source);
            return _aidl_out;
        }

        public AudioConfigBase[] newArray(int _aidl_size) {
            return new AudioConfigBase[_aidl_size];
        }
    };

    @Override
    public int getStability() {
        return 1;
    }

    @Override
    public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
        int _aidl_start_pos = _aidl_parcel.dataPosition();
        _aidl_parcel.writeInt(0);
        _aidl_parcel.writeInt(this.sampleRate);
        _aidl_parcel.writeTypedObject(this.channelMask, _aidl_flag);
        _aidl_parcel.writeTypedObject(this.format, _aidl_flag);
        int _aidl_end_pos = _aidl_parcel.dataPosition();
        _aidl_parcel.setDataPosition(_aidl_start_pos);
        _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
        _aidl_parcel.setDataPosition(_aidl_end_pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromParcel(Parcel _aidl_parcel) {
        int _aidl_start_pos = _aidl_parcel.dataPosition();
        int _aidl_parcelable_size = _aidl_parcel.readInt();
        try {
            if (_aidl_parcelable_size < 4) {
                throw new BadParcelableException("Parcelable too small");
            }
            if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                return;
            }
            this.sampleRate = _aidl_parcel.readInt();
            if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                return;
            }
            this.channelMask = _aidl_parcel.readTypedObject(AudioChannelLayout.CREATOR);
            if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                return;
            }
            this.format = _aidl_parcel.readTypedObject(AudioFormatDescription.CREATOR);
        }
        finally {
            if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                throw new BadParcelableException("Overflow in the size of parcelable");
            }
            _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
        }
    }

    public String toString() {
        StringJoiner _aidl_sj = new StringJoiner(", ", "{", "}");
        _aidl_sj.add("sampleRate: " + this.sampleRate);
        _aidl_sj.add("channelMask: " + Objects.toString(this.channelMask));
        _aidl_sj.add("format: " + Objects.toString(this.format));
        return "AudioConfigBase" + ((Object)_aidl_sj).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof AudioConfigBase)) {
            return false;
        }
        AudioConfigBase that = (AudioConfigBase)other;
        if (!Objects.deepEquals(this.sampleRate, that.sampleRate)) {
            return false;
        }
        if (!Objects.deepEquals(this.channelMask, that.channelMask)) {
            return false;
        }
        return Objects.deepEquals(this.format, that.format);
    }

    public int hashCode() {
        return Arrays.deepHashCode(Arrays.asList(this.sampleRate, this.channelMask, this.format).toArray());
    }

    @Override
    public int describeContents() {
        int _mask = 0;
        _mask |= this.describeContents(this.channelMask);
        return _mask |= this.describeContents(this.format);
    }

    private int describeContents(Object _v) {
        if (_v == null) {
            return 0;
        }
        if (_v instanceof Parcelable) {
            return ((Parcelable)_v).describeContents();
        }
        return 0;
    }
}

