/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.MediaRoute2Info;
import android.media.MediaRouter2Utils;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RoutingSessionInfo
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<RoutingSessionInfo> CREATOR = new Parcelable.Creator<RoutingSessionInfo>(){

        @Override
        public RoutingSessionInfo createFromParcel(Parcel in) {
            return new RoutingSessionInfo(in);
        }

        public RoutingSessionInfo[] newArray(int size) {
            return new RoutingSessionInfo[size];
        }
    };
    private static final String KEY_GROUP_ROUTE = "com.android.layoutlib.androidx.mediarouter.media.KEY_GROUP_ROUTE";
    private static final String KEY_VOLUME_HANDLING = "volumeHandling";
    @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
    public static final int TRANSFER_REASON_FALLBACK = 0;
    @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
    public static final int TRANSFER_REASON_SYSTEM_REQUEST = 1;
    @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
    public static final int TRANSFER_REASON_APP = 2;
    public static final int RELEASE_UNSUPPORTED = 0;
    public static final int RELEASE_TYPE_CASTING = 1;
    public static final int RELEASE_TYPE_SHARING = 2;
    @NonNull
    final String mOriginalId;
    @Nullable
    final CharSequence mName;
    @Nullable
    final String mOwnerPackageName;
    @NonNull
    final String mClientPackageName;
    @Nullable
    final String mProviderId;
    @NonNull
    final List<String> mSelectedRoutes;
    @NonNull
    final List<String> mSelectableRoutes;
    @NonNull
    final List<String> mDeselectableRoutes;
    @NonNull
    final List<String> mTransferableRoutes;
    final int mVolumeHandling;
    final int mVolumeMax;
    final int mVolume;
    @Nullable
    final Bundle mControlHints;
    final boolean mIsSystemSession;
    final int mTransferReason;
    @Nullable
    final UserHandle mTransferInitiatorUserHandle;
    @Nullable
    final String mTransferInitiatorPackageName;
    private final int mReleaseType;

    RoutingSessionInfo(@NonNull Builder builder) {
        Objects.requireNonNull(builder, "builder must not be null.");
        this.mOriginalId = builder.mOriginalId;
        this.mName = builder.mName;
        this.mOwnerPackageName = builder.mOwnerPackageName;
        this.mClientPackageName = builder.mClientPackageName;
        this.mProviderId = builder.mProviderId;
        this.mSelectedRoutes = Collections.unmodifiableList(this.convertToUniqueRouteIds(builder.mSelectedRoutes));
        this.mSelectableRoutes = Collections.unmodifiableList(this.convertToUniqueRouteIds(builder.mSelectableRoutes));
        this.mDeselectableRoutes = Collections.unmodifiableList(this.convertToUniqueRouteIds(builder.mDeselectableRoutes));
        this.mTransferableRoutes = Collections.unmodifiableList(this.convertToUniqueRouteIds(builder.mTransferableRoutes));
        this.mVolumeMax = builder.mVolumeMax;
        this.mVolume = builder.mVolume;
        this.mIsSystemSession = builder.mIsSystemSession;
        this.mVolumeHandling = builder.mVolumeHandling;
        this.mControlHints = RoutingSessionInfo.updateVolumeHandlingInHints(builder.mControlHints, this.mVolumeHandling);
        this.mTransferReason = builder.mTransferReason;
        this.mTransferInitiatorUserHandle = builder.mTransferInitiatorUserHandle;
        this.mTransferInitiatorPackageName = builder.mTransferInitiatorPackageName;
        this.mReleaseType = builder.mReleaseType;
    }

    RoutingSessionInfo(@NonNull Parcel src) {
        this.mOriginalId = src.readString();
        Preconditions.checkArgument(!TextUtils.isEmpty(this.mOriginalId));
        this.mName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(src);
        this.mOwnerPackageName = src.readString();
        this.mClientPackageName = RoutingSessionInfo.ensureString(src.readString());
        this.mProviderId = src.readString();
        this.mSelectedRoutes = RoutingSessionInfo.ensureList(src.createStringArrayList());
        Preconditions.checkArgument(!this.mSelectedRoutes.isEmpty());
        this.mSelectableRoutes = RoutingSessionInfo.ensureList(src.createStringArrayList());
        this.mDeselectableRoutes = RoutingSessionInfo.ensureList(src.createStringArrayList());
        this.mTransferableRoutes = RoutingSessionInfo.ensureList(src.createStringArrayList());
        this.mVolumeHandling = src.readInt();
        this.mVolumeMax = src.readInt();
        this.mVolume = src.readInt();
        this.mControlHints = src.readBundle();
        this.mIsSystemSession = src.readBoolean();
        this.mTransferReason = src.readInt();
        this.mTransferInitiatorUserHandle = UserHandle.readFromParcel(src);
        this.mTransferInitiatorPackageName = src.readString();
        this.mReleaseType = src.readInt();
    }

    @Nullable
    private static Bundle updateVolumeHandlingInHints(@Nullable Bundle controlHints, int volumeHandling) {
        Bundle groupRoute;
        if (controlHints != null && controlHints.containsKey(KEY_GROUP_ROUTE) && (groupRoute = controlHints.getBundle(KEY_GROUP_ROUTE)) != null && groupRoute.containsKey(KEY_VOLUME_HANDLING) && volumeHandling != groupRoute.getInt(KEY_VOLUME_HANDLING)) {
            Bundle newGroupRoute = new Bundle(groupRoute);
            newGroupRoute.putInt(KEY_VOLUME_HANDLING, volumeHandling);
            Bundle newControlHints = new Bundle(controlHints);
            newControlHints.putBundle(KEY_GROUP_ROUTE, newGroupRoute);
            return newControlHints;
        }
        return controlHints;
    }

    @NonNull
    private static String ensureString(@Nullable String str) {
        return str != null ? str : "";
    }

    @NonNull
    private static <T> List<T> ensureList(@Nullable List<? extends T> list) {
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @NonNull
    public String getId() {
        if (!TextUtils.isEmpty(this.mProviderId)) {
            return MediaRouter2Utils.toUniqueId(this.mProviderId, this.mOriginalId);
        }
        return this.mOriginalId;
    }

    @Nullable
    public CharSequence getName() {
        return this.mName;
    }

    @NonNull
    public String getOriginalId() {
        return this.mOriginalId;
    }

    @Nullable
    public String getOwnerPackageName() {
        return this.mOwnerPackageName;
    }

    @NonNull
    public String getClientPackageName() {
        return this.mClientPackageName;
    }

    @Nullable
    public String getProviderId() {
        return this.mProviderId;
    }

    @NonNull
    public List<String> getSelectedRoutes() {
        return this.mSelectedRoutes;
    }

    @NonNull
    public List<String> getSelectableRoutes() {
        return this.mSelectableRoutes;
    }

    @NonNull
    public List<String> getDeselectableRoutes() {
        return this.mDeselectableRoutes;
    }

    @NonNull
    public List<String> getTransferableRoutes() {
        return this.mTransferableRoutes;
    }

    public int getVolumeHandling() {
        return this.mVolumeHandling;
    }

    public int getVolumeMax() {
        return this.mVolumeMax;
    }

    public int getVolume() {
        return this.mVolume;
    }

    @Nullable
    public Bundle getControlHints() {
        return this.mControlHints;
    }

    @Nullable
    public boolean isSystemSession() {
        return this.mIsSystemSession;
    }

    @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
    public int getTransferReason() {
        return this.mTransferReason;
    }

    @Nullable
    public UserHandle getTransferInitiatorUserHandle() {
        return this.mTransferInitiatorUserHandle;
    }

    @Nullable
    public String getTransferInitiatorPackageName() {
        return this.mTransferInitiatorPackageName;
    }

    public int getReleaseType() {
        return this.mReleaseType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mOriginalId);
        dest.writeCharSequence(this.mName);
        dest.writeString(this.mOwnerPackageName);
        dest.writeString(this.mClientPackageName);
        dest.writeString(this.mProviderId);
        dest.writeStringList(this.mSelectedRoutes);
        dest.writeStringList(this.mSelectableRoutes);
        dest.writeStringList(this.mDeselectableRoutes);
        dest.writeStringList(this.mTransferableRoutes);
        dest.writeInt(this.mVolumeHandling);
        dest.writeInt(this.mVolumeMax);
        dest.writeInt(this.mVolume);
        dest.writeBundle(this.mControlHints);
        dest.writeBoolean(this.mIsSystemSession);
        dest.writeInt(this.mTransferReason);
        UserHandle.writeToParcel(this.mTransferInitiatorUserHandle, dest);
        dest.writeString(this.mTransferInitiatorPackageName);
        dest.writeInt(this.mReleaseType);
    }

    public void dump(@NonNull PrintWriter pw, @NonNull String prefix) {
        pw.println(prefix + "RoutingSessionInfo");
        String indent = prefix + "  ";
        pw.println(indent + "mOriginalId=" + this.mOriginalId);
        pw.println(indent + "mName=" + this.mName);
        pw.println(indent + "mOwnerPackageName=" + this.mOwnerPackageName);
        pw.println(indent + "mClientPackageName=" + this.mClientPackageName);
        pw.println(indent + "mProviderId=" + this.mProviderId);
        pw.println(indent + "mSelectedRoutes=" + this.mSelectedRoutes);
        pw.println(indent + "mSelectableRoutes=" + this.mSelectableRoutes);
        pw.println(indent + "mDeselectableRoutes=" + this.mDeselectableRoutes);
        pw.println(indent + "mTransferableRoutes=" + this.mTransferableRoutes);
        pw.println(indent + MediaRoute2Info.getVolumeString(this.mVolume, this.mVolumeMax, this.mVolumeHandling));
        pw.println(indent + "mControlHints=" + this.mControlHints);
        pw.println(indent + "mIsSystemSession=" + this.mIsSystemSession);
        pw.println(indent + "mTransferReason=" + this.mTransferReason);
        pw.println(indent + "mtransferInitiatorUserHandle=" + this.mTransferInitiatorUserHandle);
        pw.println(indent + "mtransferInitiatorPackageName=" + this.mTransferInitiatorPackageName);
        pw.println(indent + "mReleaseType=" + RoutingSessionInfo.getHumanReadableReleaseType(this.mReleaseType));
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoutingSessionInfo other = (RoutingSessionInfo)obj;
        return Objects.equals(this.mOriginalId, other.mOriginalId) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mOwnerPackageName, other.mOwnerPackageName) && Objects.equals(this.mClientPackageName, other.mClientPackageName) && Objects.equals(this.mProviderId, other.mProviderId) && Objects.equals(this.mSelectedRoutes, other.mSelectedRoutes) && Objects.equals(this.mSelectableRoutes, other.mSelectableRoutes) && Objects.equals(this.mDeselectableRoutes, other.mDeselectableRoutes) && Objects.equals(this.mTransferableRoutes, other.mTransferableRoutes) && this.mVolumeHandling == other.mVolumeHandling && this.mVolumeMax == other.mVolumeMax && this.mVolume == other.mVolume && this.mTransferReason == other.mTransferReason && Objects.equals(this.mTransferInitiatorUserHandle, other.mTransferInitiatorUserHandle) && Objects.equals(this.mTransferInitiatorPackageName, other.mTransferInitiatorPackageName) && this.mReleaseType == other.mReleaseType;
    }

    public int hashCode() {
        return Objects.hash(this.mOriginalId, this.mName, this.mOwnerPackageName, this.mClientPackageName, this.mProviderId, this.mSelectedRoutes, this.mSelectableRoutes, this.mDeselectableRoutes, this.mTransferableRoutes, this.mVolumeMax, this.mVolumeHandling, this.mVolume, this.mTransferReason, this.mTransferInitiatorUserHandle, this.mTransferInitiatorPackageName, this.mReleaseType);
    }

    public String toString() {
        return "RoutingSessionInfo{ " + "sessionId=" + this.getId() + ", name=" + this.getName() + ", clientPackageName=" + this.getClientPackageName() + ", selectedRoutes={" + String.join((CharSequence)",", this.getSelectedRoutes()) + "}" + ", selectableRoutes={" + String.join((CharSequence)",", this.getSelectableRoutes()) + "}" + ", deselectableRoutes={" + String.join((CharSequence)",", this.getDeselectableRoutes()) + "}" + ", transferableRoutes={" + String.join((CharSequence)",", this.getTransferableRoutes()) + "}" + ", " + MediaRoute2Info.getVolumeString(this.mVolume, this.mVolumeMax, this.mVolumeHandling) + ", transferReason=" + this.getTransferReason() + ", transferInitiatorUserHandle=" + this.getTransferInitiatorUserHandle() + ", transferInitiatorPackageName=" + this.getTransferInitiatorPackageName() + ", releaseType=" + RoutingSessionInfo.getHumanReadableReleaseType(this.getReleaseType()) + " }";
    }

    @NonNull
    private static String getHumanReadableReleaseType(int releaseType) {
        String string2;
        switch (releaseType) {
            case 2: {
                string2 = "RELEASE_TYPE_SHARING";
                break;
            }
            case 1: {
                string2 = "RELEASE_TYPE_CASTING";
                break;
            }
            case 0: {
                string2 = "RELEASE_UNSUPPORTED";
                break;
            }
            default: {
                string2 = "";
            }
        }
        return string2;
    }

    @NonNull
    private List<String> convertToUniqueRouteIds(@NonNull List<String> routeIds) {
        Objects.requireNonNull(routeIds, "RouteIds cannot be null.");
        if (TextUtils.isEmpty(this.mProviderId)) {
            return new ArrayList<String>(routeIds);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String routeId : routeIds) {
            result.add(MediaRouter2Utils.toUniqueId(this.mProviderId, routeId));
        }
        return result;
    }

    public static class Builder {
        @NonNull
        private final String mOriginalId;
        @Nullable
        private CharSequence mName;
        @Nullable
        private String mOwnerPackageName;
        @NonNull
        private String mClientPackageName;
        @Nullable
        private String mProviderId;
        @NonNull
        private final List<String> mSelectedRoutes;
        @NonNull
        private final List<String> mSelectableRoutes;
        @NonNull
        private final List<String> mDeselectableRoutes;
        @NonNull
        private final List<String> mTransferableRoutes;
        private int mVolumeHandling = 0;
        private int mVolumeMax;
        private int mVolume;
        @Nullable
        private Bundle mControlHints;
        private boolean mIsSystemSession;
        private int mTransferReason = 0;
        @Nullable
        private UserHandle mTransferInitiatorUserHandle;
        @Nullable
        private String mTransferInitiatorPackageName;
        private int mReleaseType = 1;

        public Builder(@NonNull String originalId, @NonNull String clientPackageName) {
            if (TextUtils.isEmpty(originalId)) {
                throw new IllegalArgumentException("id must not be empty");
            }
            this.mOriginalId = originalId;
            this.mClientPackageName = Objects.requireNonNull(clientPackageName, "clientPackageName must not be null");
            this.mSelectedRoutes = new ArrayList<String>();
            this.mSelectableRoutes = new ArrayList<String>();
            this.mDeselectableRoutes = new ArrayList<String>();
            this.mTransferableRoutes = new ArrayList<String>();
        }

        public Builder(@NonNull RoutingSessionInfo sessionInfo) {
            this(sessionInfo, sessionInfo.getOriginalId());
        }

        public Builder(@NonNull RoutingSessionInfo sessionInfo, String originalId) {
            Objects.requireNonNull(sessionInfo, "sessionInfo must not be null");
            this.mOriginalId = originalId;
            this.mName = sessionInfo.mName;
            this.mClientPackageName = sessionInfo.mClientPackageName;
            this.mProviderId = sessionInfo.mProviderId;
            this.mSelectedRoutes = new ArrayList<String>(sessionInfo.mSelectedRoutes);
            this.mSelectableRoutes = new ArrayList<String>(sessionInfo.mSelectableRoutes);
            this.mDeselectableRoutes = new ArrayList<String>(sessionInfo.mDeselectableRoutes);
            this.mTransferableRoutes = new ArrayList<String>(sessionInfo.mTransferableRoutes);
            if (this.mProviderId != null) {
                this.mSelectedRoutes.replaceAll(MediaRouter2Utils::getOriginalId);
                this.mSelectableRoutes.replaceAll(MediaRouter2Utils::getOriginalId);
                this.mDeselectableRoutes.replaceAll(MediaRouter2Utils::getOriginalId);
                this.mTransferableRoutes.replaceAll(MediaRouter2Utils::getOriginalId);
            }
            this.mVolumeHandling = sessionInfo.mVolumeHandling;
            this.mVolumeMax = sessionInfo.mVolumeMax;
            this.mVolume = sessionInfo.mVolume;
            this.mControlHints = sessionInfo.mControlHints;
            this.mIsSystemSession = sessionInfo.mIsSystemSession;
            this.mTransferReason = sessionInfo.mTransferReason;
            this.mTransferInitiatorUserHandle = sessionInfo.mTransferInitiatorUserHandle;
            this.mTransferInitiatorPackageName = sessionInfo.mTransferInitiatorPackageName;
            this.mReleaseType = sessionInfo.mReleaseType;
        }

        @NonNull
        public Builder setName(@Nullable CharSequence name) {
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setOwnerPackageName(@Nullable String packageName) {
            this.mOwnerPackageName = packageName;
            return this;
        }

        @NonNull
        public Builder setClientPackageName(@Nullable String packageName) {
            this.mClientPackageName = packageName;
            return this;
        }

        @NonNull
        public Builder setProviderId(@NonNull String providerId) {
            if (TextUtils.isEmpty(providerId)) {
                throw new IllegalArgumentException("providerId must not be empty");
            }
            this.mProviderId = providerId;
            return this;
        }

        @NonNull
        public Builder clearSelectedRoutes() {
            this.mSelectedRoutes.clear();
            return this;
        }

        @NonNull
        public Builder addSelectedRoute(@NonNull String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mSelectedRoutes.add(routeId);
            return this;
        }

        @NonNull
        public Builder removeSelectedRoute(@NonNull String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mSelectedRoutes.remove(routeId);
            return this;
        }

        @NonNull
        public Builder clearSelectableRoutes() {
            this.mSelectableRoutes.clear();
            return this;
        }

        @NonNull
        public Builder addSelectableRoute(@NonNull String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mSelectableRoutes.add(routeId);
            return this;
        }

        @NonNull
        public Builder removeSelectableRoute(@NonNull String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mSelectableRoutes.remove(routeId);
            return this;
        }

        @NonNull
        public Builder clearDeselectableRoutes() {
            this.mDeselectableRoutes.clear();
            return this;
        }

        @NonNull
        public Builder addDeselectableRoute(@NonNull String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mDeselectableRoutes.add(routeId);
            return this;
        }

        @NonNull
        public Builder removeDeselectableRoute(@NonNull String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mDeselectableRoutes.remove(routeId);
            return this;
        }

        @NonNull
        public Builder clearTransferableRoutes() {
            this.mTransferableRoutes.clear();
            return this;
        }

        @NonNull
        public Builder addTransferableRoute(@NonNull String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mTransferableRoutes.add(routeId);
            return this;
        }

        @NonNull
        public Builder removeTransferableRoute(@NonNull String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mTransferableRoutes.remove(routeId);
            return this;
        }

        @NonNull
        public Builder setVolumeHandling(int volumeHandling) {
            this.mVolumeHandling = volumeHandling;
            return this;
        }

        @NonNull
        public Builder setVolumeMax(int volumeMax) {
            this.mVolumeMax = volumeMax;
            return this;
        }

        @NonNull
        public Builder setVolume(int volume) {
            this.mVolume = volume;
            return this;
        }

        @NonNull
        public Builder setControlHints(@Nullable Bundle controlHints) {
            this.mControlHints = controlHints;
            return this;
        }

        @NonNull
        public Builder setSystemSession(boolean isSystemSession) {
            this.mIsSystemSession = isSystemSession;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
        public Builder setTransferReason(int transferReason) {
            this.mTransferReason = transferReason;
            return this;
        }

        @NonNull
        public Builder setReleaseType(int releaseType) {
            this.mReleaseType = releaseType;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
        public Builder setTransferInitiator(@Nullable UserHandle transferInitiatorUserHandle, @Nullable String transferInitiatorPackageName) {
            this.mTransferInitiatorUserHandle = transferInitiatorUserHandle;
            this.mTransferInitiatorPackageName = transferInitiatorPackageName;
            return this;
        }

        @NonNull
        public RoutingSessionInfo build() {
            if (this.mSelectedRoutes.isEmpty()) {
                throw new IllegalArgumentException("selectedRoutes must not be empty");
            }
            return new RoutingSessionInfo(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReleaseType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransferReason {
    }
}

