/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class RouteListingPreference
implements Parcelable {
    public static final String ACTION_TRANSFER_MEDIA = "android.media.action.TRANSFER_MEDIA";
    public static final String EXTRA_ROUTE_ID = "android.media.extra.ROUTE_ID";
    @NonNull
    public static final Parcelable.Creator<RouteListingPreference> CREATOR = new Parcelable.Creator<RouteListingPreference>(){

        @Override
        public RouteListingPreference createFromParcel(Parcel in) {
            return new RouteListingPreference(in);
        }

        public RouteListingPreference[] newArray(int size) {
            return new RouteListingPreference[size];
        }
    };
    @NonNull
    private final List<Item> mItems;
    private final boolean mUseSystemOrdering;
    @Nullable
    private final ComponentName mLinkedItemComponentName;

    private RouteListingPreference(Builder builder) {
        this.mItems = builder.mItems;
        this.mUseSystemOrdering = builder.mUseSystemOrdering;
        this.mLinkedItemComponentName = builder.mLinkedItemComponentName;
    }

    private RouteListingPreference(Parcel in) {
        List<Item> items = in.readParcelableList(new ArrayList(), Item.class.getClassLoader(), Item.class);
        this.mItems = List.copyOf(items);
        this.mUseSystemOrdering = in.readBoolean();
        this.mLinkedItemComponentName = ComponentName.readFromParcel(in);
    }

    @NonNull
    public List<Item> getItems() {
        return this.mItems;
    }

    public boolean getUseSystemOrdering() {
        return this.mUseSystemOrdering;
    }

    @Nullable
    public ComponentName getLinkedItemComponentName() {
        return this.mLinkedItemComponentName;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelableList(this.mItems, flags);
        dest.writeBoolean(this.mUseSystemOrdering);
        ComponentName.writeToParcel(this.mLinkedItemComponentName, dest);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RouteListingPreference)) {
            return false;
        }
        RouteListingPreference that = (RouteListingPreference)other;
        return this.mItems.equals(that.mItems) && this.mUseSystemOrdering == that.mUseSystemOrdering && Objects.equals(this.mLinkedItemComponentName, that.mLinkedItemComponentName);
    }

    public int hashCode() {
        return Objects.hash(this.mItems, this.mUseSystemOrdering, this.mLinkedItemComponentName);
    }

    public static class Builder {
        private List<Item> mItems = List.of();
        private boolean mUseSystemOrdering = true;
        private ComponentName mLinkedItemComponentName;

        @NonNull
        public Builder setItems(@NonNull List<Item> items) {
            this.mItems = List.copyOf((Collection)Objects.requireNonNull(items));
            return this;
        }

        @NonNull
        public Builder setUseSystemOrdering(boolean useSystemOrdering) {
            this.mUseSystemOrdering = useSystemOrdering;
            return this;
        }

        @NonNull
        public Builder setLinkedItemComponentName(@Nullable ComponentName linkedItemComponentName) {
            this.mLinkedItemComponentName = linkedItemComponentName;
            return this;
        }

        @NonNull
        public RouteListingPreference build() {
            return new RouteListingPreference(this);
        }
    }

    public static class Item
    implements Parcelable {
        public static final int SELECTION_BEHAVIOR_NONE = 0;
        public static final int SELECTION_BEHAVIOR_TRANSFER = 1;
        public static final int SELECTION_BEHAVIOR_GO_TO_APP = 2;
        public static final int FLAG_ONGOING_SESSION = 1;
        public static final int FLAG_ONGOING_SESSION_MANAGED = 2;
        public static final int FLAG_SUGGESTED = 4;
        public static final int SUBTEXT_NONE = 0;
        public static final int SUBTEXT_ERROR_UNKNOWN = 1;
        public static final int SUBTEXT_SUBSCRIPTION_REQUIRED = 2;
        public static final int SUBTEXT_DOWNLOADED_CONTENT_ROUTING_DISALLOWED = 3;
        public static final int SUBTEXT_AD_ROUTING_DISALLOWED = 4;
        public static final int SUBTEXT_DEVICE_LOW_POWER = 5;
        public static final int SUBTEXT_UNAUTHORIZED = 6;
        public static final int SUBTEXT_TRACK_UNSUPPORTED = 7;
        public static final int SUBTEXT_CUSTOM = 10000;
        @NonNull
        public static final Parcelable.Creator<Item> CREATOR = new Parcelable.Creator<Item>(){

            @Override
            public Item createFromParcel(Parcel in) {
                return new Item(in);
            }

            public Item[] newArray(int size) {
                return new Item[size];
            }
        };
        @NonNull
        private final String mRouteId;
        private final int mSelectionBehavior;
        private final int mFlags;
        private final int mSubText;
        @Nullable
        private final CharSequence mCustomSubtextMessage;

        private Item(@NonNull Builder builder) {
            this.mRouteId = builder.mRouteId;
            this.mSelectionBehavior = builder.mSelectionBehavior;
            this.mFlags = builder.mFlags;
            this.mSubText = builder.mSubText;
            this.mCustomSubtextMessage = builder.mCustomSubtextMessage;
            this.validateCustomMessageSubtext();
        }

        private Item(Parcel in) {
            this.mRouteId = in.readString();
            Preconditions.checkArgument(!TextUtils.isEmpty(this.mRouteId));
            this.mSelectionBehavior = in.readInt();
            this.mFlags = in.readInt();
            this.mSubText = in.readInt();
            this.mCustomSubtextMessage = in.readCharSequence();
            this.validateCustomMessageSubtext();
        }

        @NonNull
        public String getRouteId() {
            return this.mRouteId;
        }

        public int getSelectionBehavior() {
            return this.mSelectionBehavior;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public int getSubText() {
            return this.mSubText;
        }

        @Nullable
        public CharSequence getCustomSubtextMessage() {
            return this.mCustomSubtextMessage;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString(this.mRouteId);
            dest.writeInt(this.mSelectionBehavior);
            dest.writeInt(this.mFlags);
            dest.writeInt(this.mSubText);
            dest.writeCharSequence(this.mCustomSubtextMessage);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Item)) {
                return false;
            }
            Item item = (Item)other;
            return this.mRouteId.equals(item.mRouteId) && this.mSelectionBehavior == item.mSelectionBehavior && this.mFlags == item.mFlags && this.mSubText == item.mSubText && TextUtils.equals(this.mCustomSubtextMessage, item.mCustomSubtextMessage);
        }

        public int hashCode() {
            return Objects.hash(this.mRouteId, this.mSelectionBehavior, this.mFlags, this.mSubText, this.mCustomSubtextMessage);
        }

        private void validateCustomMessageSubtext() {
            Preconditions.checkArgument(this.mSubText != 10000 || this.mCustomSubtextMessage != null, "The custom subtext message cannot be null if subtext is SUBTEXT_CUSTOM.");
        }

        public static class Builder {
            private final String mRouteId;
            private int mSelectionBehavior;
            private int mFlags;
            private int mSubText;
            private CharSequence mCustomSubtextMessage;

            public Builder(@NonNull String routeId) {
                Preconditions.checkArgument(!TextUtils.isEmpty(routeId));
                this.mRouteId = routeId;
                this.mSelectionBehavior = 1;
                this.mSubText = 0;
            }

            @NonNull
            public Builder setSelectionBehavior(int selectionBehavior) {
                this.mSelectionBehavior = selectionBehavior;
                return this;
            }

            @NonNull
            public Builder setFlags(int flags) {
                this.mFlags = flags;
                return this;
            }

            @NonNull
            public Builder setSubText(int subText) {
                this.mSubText = subText;
                return this;
            }

            @NonNull
            public Builder setCustomSubtextMessage(@Nullable CharSequence customSubtextMessage) {
                this.mCustomSubtextMessage = customSubtextMessage;
                return this;
            }

            @NonNull
            public Item build() {
                return new Item(this);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SubText {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Flags {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SelectionBehavior {
        }
    }
}

