/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.database.Cursor;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.IRingtonePlayer;
import android.media.MediaPlayer;
import android.media.PlayerBase;
import android.media.RingtoneManager;
import android.media.Utils;
import android.media.VolumeShaper;
import android.media.audiofx.HapticGenerator;
import android.net.Uri;
import android.os.Binder;
import android.os.RemoteException;
import android.os.Trace;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.media.audio.Flags;
import java.io.IOException;
import java.util.ArrayList;

public class Ringtone {
    private static final String TAG = "Ringtone";
    private static final boolean LOGD = true;
    private static final String[] MEDIA_COLUMNS = new String[]{"_id", "title"};
    private static final String MEDIA_SELECTION = "mime_type LIKE 'audio/%' OR mime_type IN ('application/ogg', 'application/x-flac')";
    private static final ArrayList<Ringtone> sActiveRingtones = new ArrayList();
    private static final VibrationAttributes VIBRATION_ATTRIBUTES = new VibrationAttributes.Builder().setUsage(33).build();
    private static final int VIBRATION_LOOP_DELAY_MS = 200;
    private final Context mContext;
    private final AudioManager mAudioManager;
    private VolumeShaper.Configuration mVolumeShaperConfig;
    private VolumeShaper mVolumeShaper;
    private final boolean mAllowRemote;
    private final IRingtonePlayer mRemotePlayer;
    private final Binder mRemoteToken;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private MediaPlayer mLocalPlayer;
    private final MyOnCompletionListener mCompletionListener = new MyOnCompletionListener();
    private HapticGenerator mHapticGenerator;
    @UnsupportedAppUsage
    private Uri mUri;
    private String mTitle;
    private AudioAttributes mAudioAttributes = new AudioAttributes.Builder().setUsage(6).setContentType(4).build();
    private boolean mPreferBuiltinDevice;
    private boolean mIsLooping = false;
    private float mVolume = 1.0f;
    private boolean mHapticGeneratorEnabled = false;
    private final Object mPlaybackSettingsLock = new Object();
    private final Vibrator mVibrator;
    private final boolean mRingtoneVibrationSupported;
    private VibrationEffect mVibrationEffect;
    private boolean mIsVibrating;

    @UnsupportedAppUsage
    public Ringtone(Context context, boolean allowRemote) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mAllowRemote = allowRemote;
        this.mRemotePlayer = allowRemote ? this.mAudioManager.getRingtonePlayer() : null;
        this.mRemoteToken = allowRemote ? new Binder() : null;
        this.mVibrator = this.mContext.getSystemService(Vibrator.class);
        this.mRingtoneVibrationSupported = Utils.isRingtoneVibrationSettingsSupported(this.mContext);
    }

    @Deprecated
    public void setStreamType(int streamType) {
        PlayerBase.deprecateStreamTypeForPlayback(streamType, TAG, "setStreamType()");
        this.setAudioAttributes(new AudioAttributes.Builder().setInternalLegacyStreamType(streamType).build());
    }

    @Deprecated
    public int getStreamType() {
        return AudioAttributes.toLegacyStreamType(this.mAudioAttributes);
    }

    public void setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
        this.setAudioAttributesField(attributes);
        this.setUri(this.mUri, this.mVolumeShaperConfig);
        this.createLocalMediaPlayer();
    }

    public void setAudioAttributesField(@Nullable AudioAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Invalid null AudioAttributes for Ringtone");
        }
        this.mAudioAttributes = attributes;
    }

    private AudioDeviceInfo getBuiltinDevice(AudioManager audioManager) {
        AudioDeviceInfo[] deviceList;
        for (AudioDeviceInfo device : deviceList = audioManager.getDevices(2)) {
            if (device.getType() != 2) continue;
            return device;
        }
        return null;
    }

    public boolean preferBuiltinDevice(boolean enable) {
        this.mPreferBuiltinDevice = enable;
        if (this.mLocalPlayer == null) {
            return true;
        }
        return this.mLocalPlayer.setPreferredDevice(this.getBuiltinDevice(this.mAudioManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createLocalMediaPlayer() {
        block9: {
            Trace.beginSection("createLocalMediaPlayer");
            if (this.mUri == null) {
                Log.e(TAG, "Could not create media player as no URI was provided.");
                return this.mAllowRemote && this.mRemotePlayer != null;
            }
            this.destroyLocalPlayer();
            this.mLocalPlayer = new MediaPlayer();
            try {
                this.mLocalPlayer.setDataSource(this.mContext, this.mUri);
                this.mLocalPlayer.setAudioAttributes(this.mAudioAttributes);
                this.mLocalPlayer.setPreferredDevice(this.mPreferBuiltinDevice ? this.getBuiltinDevice(this.mAudioManager) : null);
                Object object = this.mPlaybackSettingsLock;
                synchronized (object) {
                    this.applyPlaybackProperties_sync();
                }
                if (this.mVolumeShaperConfig != null) {
                    this.mVolumeShaper = this.mLocalPlayer.createVolumeShaper(this.mVolumeShaperConfig);
                }
                this.mLocalPlayer.prepare();
            }
            catch (IOException | SecurityException e) {
                this.destroyLocalPlayer();
                if (this.mAllowRemote) break block9;
                Log.w(TAG, "Remote playback not allowed: " + e);
            }
        }
        if (this.mLocalPlayer != null) {
            Log.d(TAG, "Successfully created local player");
        } else {
            Log.d(TAG, "Problem opening; delegating to remote player");
        }
        Trace.endSection();
        return this.mLocalPlayer != null || this.mAllowRemote && this.mRemotePlayer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHapticChannels() {
        try {
            Trace.beginSection("Ringtone.hasHapticChannels");
            if (this.mLocalPlayer != null) {
                for (MediaPlayer.TrackInfo trackInfo : this.mLocalPlayer.getTrackInfo()) {
                    if (!trackInfo.hasHapticChannels()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            Trace.endSection();
        }
        return false;
    }

    @VisibleForTesting
    public boolean hasLocalPlayer() {
        return this.mLocalPlayer != null;
    }

    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLooping(boolean looping) {
        Object object = this.mPlaybackSettingsLock;
        synchronized (object) {
            this.mIsLooping = looping;
            this.applyPlaybackProperties_sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLooping() {
        Object object = this.mPlaybackSettingsLock;
        synchronized (object) {
            return this.mIsLooping;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVolume(float volume) {
        Object object = this.mPlaybackSettingsLock;
        synchronized (object) {
            if (volume < 0.0f) {
                volume = 0.0f;
            }
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            this.mVolume = volume;
            this.applyPlaybackProperties_sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getVolume() {
        Object object = this.mPlaybackSettingsLock;
        synchronized (object) {
            return this.mVolume;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setHapticGeneratorEnabled(boolean enabled) {
        if (!HapticGenerator.isAvailable()) {
            return false;
        }
        Object object = this.mPlaybackSettingsLock;
        synchronized (object) {
            this.mHapticGeneratorEnabled = enabled;
            this.applyPlaybackProperties_sync();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHapticGeneratorEnabled() {
        Object object = this.mPlaybackSettingsLock;
        synchronized (object) {
            return this.mHapticGeneratorEnabled;
        }
    }

    private void applyPlaybackProperties_sync() {
        if (this.mLocalPlayer != null) {
            this.mLocalPlayer.setVolume(this.mVolume);
            this.mLocalPlayer.setLooping(this.mIsLooping);
            if (this.mHapticGenerator == null && this.mHapticGeneratorEnabled) {
                this.mHapticGenerator = HapticGenerator.create(this.mLocalPlayer.getAudioSessionId());
            }
            if (this.mHapticGenerator != null) {
                this.mHapticGenerator.setEnabled(this.mHapticGeneratorEnabled);
            }
        } else if (this.mAllowRemote && this.mRemotePlayer != null) {
            try {
                this.mRemotePlayer.setPlaybackProperties(this.mRemoteToken, this.mVolume, this.mIsLooping, this.mHapticGeneratorEnabled);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Problem setting playback properties: ", e);
            }
        } else {
            Log.w(TAG, "Neither local nor remote player available when applying playback properties");
        }
    }

    public String getTitle(Context context) {
        if (this.mTitle != null) {
            return this.mTitle;
        }
        this.mTitle = Ringtone.getTitle(context, this.mUri, true, this.mAllowRemote);
        return this.mTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTitle(Context context, Uri uri, boolean followSettingsUri, boolean allowRemote) {
        ContentResolver res = context.getContentResolver();
        String title = null;
        if (uri != null) {
            String authority = ContentProvider.getAuthorityWithoutUserId(uri.getAuthority());
            if ("settings".equals(authority)) {
                if (followSettingsUri) {
                    Uri actualUri = RingtoneManager.getActualDefaultRingtoneUri(context, RingtoneManager.getDefaultType(uri));
                    String actualTitle = Ringtone.getTitle(context, actualUri, false, allowRemote);
                    title = context.getString(17041728, actualTitle);
                }
            } else {
                Cursor cursor = null;
                try {
                    String mediaSelection;
                    if ("media".equals(authority) && (cursor = res.query(uri, MEDIA_COLUMNS, mediaSelection = allowRemote ? null : MEDIA_SELECTION, null, null)) != null && cursor.getCount() == 1) {
                        cursor.moveToFirst();
                        String string2 = cursor.getString(1);
                        return string2;
                    }
                }
                catch (SecurityException e) {
                    IRingtonePlayer mRemotePlayer = null;
                    if (allowRemote) {
                        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
                        mRemotePlayer = audioManager.getRingtonePlayer();
                    }
                    if (mRemotePlayer != null) {
                        try {
                            title = mRemotePlayer.getTitle(uri);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    cursor = null;
                }
                if (title == null) {
                    title = uri.getLastPathSegment();
                }
            }
        } else {
            title = context.getString(17041732);
        }
        if (title == null && (title = context.getString(17041733)) == null) {
            title = "";
        }
        return title;
    }

    @UnsupportedAppUsage
    public void setUri(Uri uri) {
        this.setUri(uri, null);
    }

    public void setVolumeShaperConfig(@Nullable VolumeShaper.Configuration volumeShaperConfig) {
        this.mVolumeShaperConfig = volumeShaperConfig;
    }

    public void setUri(Uri uri, @Nullable VolumeShaper.Configuration volumeShaperConfig) {
        this.mVolumeShaperConfig = volumeShaperConfig;
        this.mUri = uri;
        if (this.mUri == null) {
            this.destroyLocalPlayer();
        }
        if (Flags.enableRingtoneHapticsCustomization() && this.mRingtoneVibrationSupported && this.mUri != null) {
            this.mVibrationEffect = Utils.parseVibrationEffect(this.mVibrator, Utils.getVibrationUri(this.mUri));
            if (this.mVibrationEffect != null) {
                this.mVibrationEffect = this.mVibrationEffect.applyRepeatingIndefinitely(true, 200);
            }
        }
    }

    @VisibleForTesting
    public VibrationEffect getVibrationEffect() {
        return this.mVibrationEffect;
    }

    @UnsupportedAppUsage
    public Uri getUri() {
        return this.mUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        block14: {
            if (this.mLocalPlayer != null) {
                if (this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(this.mAudioAttributes)) != 0) {
                    this.startLocalPlayer();
                } else if (!this.mAudioAttributes.areHapticChannelsMuted() && this.hasHapticChannels()) {
                    this.startLocalPlayer();
                }
            } else {
                if (this.mAllowRemote && this.mRemotePlayer != null && this.mUri != null) {
                    float volume;
                    boolean looping;
                    Uri canonicalUri = this.mUri.getCanonicalUri();
                    Object object = this.mPlaybackSettingsLock;
                    synchronized (object) {
                        looping = this.mIsLooping;
                        volume = this.mVolume;
                    }
                    try {
                        this.mRemotePlayer.playWithVolumeShaping(this.mRemoteToken, canonicalUri, this.mAudioAttributes, volume, looping, this.mVolumeShaperConfig);
                    }
                    catch (RemoteException e) {
                        if (!this.playFallbackRingtone()) {
                            Log.w(TAG, "Problem playing ringtone: " + e);
                        }
                        break block14;
                    }
                }
                if (!this.playFallbackRingtone()) {
                    Log.w(TAG, "Neither local nor remote playback available");
                }
            }
        }
        if (Flags.enableRingtoneHapticsCustomization() && this.mRingtoneVibrationSupported) {
            this.playVibration();
        }
    }

    private void playVibration() {
        if (this.mVibrationEffect == null) {
            return;
        }
        this.mIsVibrating = true;
        this.mVibrator.vibrate(this.mVibrationEffect, VIBRATION_ATTRIBUTES);
    }

    public void stop() {
        if (this.mLocalPlayer != null) {
            this.destroyLocalPlayer();
        } else if (this.mAllowRemote && this.mRemotePlayer != null) {
            try {
                this.mRemotePlayer.stop(this.mRemoteToken);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Problem stopping ringtone: " + e);
            }
        }
        if (Flags.enableRingtoneHapticsCustomization() && this.mRingtoneVibrationSupported && this.mIsVibrating) {
            this.mVibrator.cancel();
            this.mIsVibrating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyLocalPlayer() {
        if (this.mLocalPlayer != null) {
            if (this.mHapticGenerator != null) {
                this.mHapticGenerator.release();
                this.mHapticGenerator = null;
            }
            this.mLocalPlayer.setOnCompletionListener(null);
            this.mLocalPlayer.reset();
            this.mLocalPlayer.release();
            this.mLocalPlayer = null;
            this.mVolumeShaper = null;
            ArrayList<Ringtone> arrayList = sActiveRingtones;
            synchronized (arrayList) {
                sActiveRingtones.remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLocalPlayer() {
        if (this.mLocalPlayer == null) {
            return;
        }
        ArrayList<Ringtone> arrayList = sActiveRingtones;
        synchronized (arrayList) {
            sActiveRingtones.add(this);
        }
        this.mLocalPlayer.setOnCompletionListener(this.mCompletionListener);
        this.mLocalPlayer.start();
        if (this.mVolumeShaper != null) {
            this.mVolumeShaper.apply(VolumeShaper.Operation.PLAY);
        }
    }

    public boolean isPlaying() {
        if (this.mLocalPlayer != null) {
            return this.mLocalPlayer.isPlaying();
        }
        if (this.mAllowRemote && this.mRemotePlayer != null) {
            try {
                return this.mRemotePlayer.isPlaying(this.mRemoteToken);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Problem checking ringtone: " + e);
                return false;
            }
        }
        Log.w(TAG, "Neither local nor remote playback available");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean playFallbackRingtone() {
        int streamType = AudioAttributes.toLegacyStreamType(this.mAudioAttributes);
        if (this.mAudioManager.getStreamVolume(streamType) == 0) {
            return false;
        }
        int ringtoneType = RingtoneManager.getDefaultType(this.mUri);
        if (ringtoneType != -1 && RingtoneManager.getActualDefaultRingtoneUri(this.mContext, ringtoneType) == null) {
            Log.w(TAG, "not playing fallback for " + this.mUri);
            return false;
        }
        try {
            AssetFileDescriptor afd = this.mContext.getResources().openRawResourceFd(0x1100006);
            if (afd == null) {
                Log.e(TAG, "Could not load fallback ringtone");
                return false;
            }
            this.mLocalPlayer = new MediaPlayer();
            if (afd.getDeclaredLength() < 0L) {
                this.mLocalPlayer.setDataSource(afd.getFileDescriptor());
            } else {
                this.mLocalPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
            }
            this.mLocalPlayer.setAudioAttributes(this.mAudioAttributes);
            Object object = this.mPlaybackSettingsLock;
            synchronized (object) {
                this.applyPlaybackProperties_sync();
            }
            if (this.mVolumeShaperConfig != null) {
                this.mVolumeShaper = this.mLocalPlayer.createVolumeShaper(this.mVolumeShaperConfig);
            }
            this.mLocalPlayer.prepare();
            this.startLocalPlayer();
            afd.close();
        }
        catch (IOException ioe) {
            this.destroyLocalPlayer();
            Log.e(TAG, "Failed to open fallback ringtone");
            return false;
        }
        catch (Resources.NotFoundException nfe) {
            Log.e(TAG, "Fallback ringtone does not exist");
            return false;
        }
        return true;
    }

    void setTitle(String title) {
        this.mTitle = title;
    }

    protected void finalize() {
        if (this.mLocalPlayer != null) {
            this.mLocalPlayer.release();
        }
    }

    class MyOnCompletionListener
    implements MediaPlayer.OnCompletionListener {
        MyOnCompletionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(MediaPlayer mp) {
            ArrayList<Ringtone> arrayList = sActiveRingtones;
            synchronized (arrayList) {
                sActiveRingtones.remove(Ringtone.this);
            }
            mp.setOnCompletionListener(null);
        }
    }
}

