/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class MediaSyncEvent
implements Parcelable {
    public static final int SYNC_EVENT_NONE = 0;
    public static final int SYNC_EVENT_PRESENTATION_COMPLETE = 1;
    @SystemApi
    public static final int SYNC_EVENT_SHARE_AUDIO_HISTORY = 100;
    private final int mType;
    private int mAudioSession = 0;
    @NonNull
    public static final Parcelable.Creator<MediaSyncEvent> CREATOR = new Parcelable.Creator<MediaSyncEvent>(){

        @Override
        public MediaSyncEvent createFromParcel(Parcel p) {
            return new MediaSyncEvent(p);
        }

        public MediaSyncEvent[] newArray(int size) {
            return new MediaSyncEvent[size];
        }
    };

    public static MediaSyncEvent createEvent(int eventType) throws IllegalArgumentException {
        if (!MediaSyncEvent.isValidType(eventType)) {
            throw new IllegalArgumentException(eventType + "is not a valid MediaSyncEvent type.");
        }
        return new MediaSyncEvent(eventType);
    }

    private MediaSyncEvent(int eventType) {
        this.mType = eventType;
    }

    public MediaSyncEvent setAudioSessionId(int audioSessionId) throws IllegalArgumentException {
        if (audioSessionId <= 0) {
            throw new IllegalArgumentException(audioSessionId + " is not a valid session ID.");
        }
        this.mAudioSession = audioSessionId;
        return this;
    }

    public int getType() {
        return this.mType;
    }

    public int getAudioSessionId() {
        return this.mAudioSession;
    }

    private static boolean isValidType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.mType);
        dest.writeInt(this.mAudioSession);
    }

    private MediaSyncEvent(Parcel in) {
        this.mType = in.readInt();
        this.mAudioSession = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaSyncEvent that = (MediaSyncEvent)o;
        return this.mType == that.mType && this.mAudioSession == that.mAudioSession;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mAudioSession);
    }

    public String toString() {
        return new String("MediaSyncEvent: type=" + MediaSyncEvent.typeToString(this.mType) + " session=" + this.mAudioSession);
    }

    @NonNull
    public static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "SYNC_EVENT_NONE";
            }
            case 1: {
                return "SYNC_EVENT_PRESENTATION_COMPLETE";
            }
            case 100: {
                return "SYNC_EVENT_SHARE_AUDIO_HISTORY";
            }
        }
        return "unknown event type " + type;
    }
}

