/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRouting;
import android.media.DeniedByServerException;
import android.media.MediaDataSource;
import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.MediaFormat;
import android.media.MediaHTTPService;
import android.media.MediaTimeProvider;
import android.media.MediaTimestamp;
import android.media.Metadata;
import android.media.NativeRoutingEventHandlerDelegate;
import android.media.NotProvisionedException;
import android.media.PlaybackParams;
import android.media.PlayerBase;
import android.media.ResourceBusyException;
import android.media.RingtoneManager;
import android.media.SRTRenderer;
import android.media.SubtitleController;
import android.media.SubtitleData;
import android.media.SubtitleTrack;
import android.media.SyncParams;
import android.media.TimedMetaData;
import android.media.TimedText;
import android.media.UnsupportedSchemeException;
import android.media.VolumeAutomation;
import android.media.VolumeShaper;
import android.net.Uri;
import android.os.Bundle;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.Executor;
import libcore.io.IoBridge;
import libcore.io.Streams;

public class MediaPlayer
extends PlayerBase
implements SubtitleController.Listener,
VolumeAutomation,
AudioRouting {
    public static final boolean METADATA_UPDATE_ONLY = true;
    @UnsupportedAppUsage
    public static final boolean METADATA_ALL = false;
    public static final boolean APPLY_METADATA_FILTER = true;
    @UnsupportedAppUsage
    public static final boolean BYPASS_METADATA_FILTER = false;
    private static final String TAG = "MediaPlayer";
    private static final String IMEDIA_PLAYER = "android.media.IMediaPlayer";
    private long mNativeContext;
    private long mNativeSurfaceTexture;
    private int mListenerContext;
    private SurfaceHolder mSurfaceHolder;
    @UnsupportedAppUsage
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private int mStreamType = Integer.MIN_VALUE;
    private UUID mDrmUUID;
    private final Object mDrmLock = new Object();
    private DrmInfo mDrmInfo;
    private MediaDrm mDrmObj;
    private byte[] mDrmSessionId;
    private boolean mDrmInfoResolved;
    private boolean mActiveDrmScheme;
    private boolean mDrmConfigAllowed;
    private boolean mDrmProvisioningInProgress;
    private boolean mPrepareDrmInProgress;
    private ProvisioningThread mDrmProvisioningThread;
    private static final int INVOKE_ID_GET_TRACK_INFO = 1;
    private static final int INVOKE_ID_ADD_EXTERNAL_SOURCE = 2;
    private static final int INVOKE_ID_ADD_EXTERNAL_SOURCE_FD = 3;
    private static final int INVOKE_ID_SELECT_TRACK = 4;
    private static final int INVOKE_ID_DESELECT_TRACK = 5;
    private static final int INVOKE_ID_SET_VIDEO_SCALE_MODE = 6;
    private static final int INVOKE_ID_GET_SELECTED_TRACK = 7;
    private static final int INVOKE_ID_SET_PLAYER_IID = 8;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    private AudioDeviceInfo mPreferredDevice = null;
    @GuardedBy(value={"mRoutingChangeListeners"})
    private ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners = new ArrayMap();
    @GuardedBy(value={"mRoutingChangeListeners"})
    private boolean mEnableSelfRoutingMonitor;
    public static final int PLAYBACK_RATE_AUDIO_MODE_RESAMPLE = 2;
    public static final int PLAYBACK_RATE_AUDIO_MODE_STRETCH = 1;
    public static final int PLAYBACK_RATE_AUDIO_MODE_DEFAULT = 0;
    public static final int SEEK_PREVIOUS_SYNC = 0;
    public static final int SEEK_NEXT_SYNC = 1;
    public static final int SEEK_CLOSEST_SYNC = 2;
    public static final int SEEK_CLOSEST = 3;
    private static final int KEY_PARAMETER_AUDIO_ATTRIBUTES = 1400;
    private Vector<Pair<Integer, SubtitleTrack>> mIndexTrackPairs = new Vector();
    private BitSet mInbandTrackIndices = new BitSet();
    public static final String MEDIA_MIMETYPE_TEXT_SUBRIP = "application/x-subrip";
    public static final String MEDIA_MIMETYPE_TEXT_VTT = "text/vtt";
    public static final String MEDIA_MIMETYPE_TEXT_CEA_608 = "text/cea-608";
    public static final String MEDIA_MIMETYPE_TEXT_CEA_708 = "text/cea-708";
    private SubtitleController mSubtitleController;
    private int mSelectedSubtitleTrackIndex = -1;
    private Vector<InputStream> mOpenSubtitleSources;
    private final OnSubtitleDataListener mIntSubtitleDataListener = new OnSubtitleDataListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubtitleData(MediaPlayer mp, SubtitleData data) {
            int index = data.getTrackIndex();
            Vector<Pair<Integer, SubtitleTrack>> vector = MediaPlayer.this.mIndexTrackPairs;
            synchronized (vector) {
                for (Pair<Integer, SubtitleTrack> p : MediaPlayer.this.mIndexTrackPairs) {
                    if (p.first == null || (Integer)p.first != index || p.second == null) continue;
                    SubtitleTrack track = (SubtitleTrack)p.second;
                    track.onData(data);
                }
            }
        }
    };
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_STARTED = 6;
    private static final int MEDIA_PAUSED = 7;
    private static final int MEDIA_STOPPED = 8;
    private static final int MEDIA_SKIPPED = 9;
    private static final int MEDIA_NOTIFY_TIME = 98;
    private static final int MEDIA_TIMED_TEXT = 99;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    private static final int MEDIA_SUBTITLE_DATA = 201;
    private static final int MEDIA_META_DATA = 202;
    private static final int MEDIA_DRM_INFO = 210;
    private static final int MEDIA_TIME_DISCONTINUITY = 211;
    private static final int MEDIA_RTP_RX_NOTICE = 300;
    private static final int MEDIA_AUDIO_ROUTING_CHANGED = 10000;
    private TimeProvider mTimeProvider;
    private final Object mTimeProviderLock = new Object();
    @UnsupportedAppUsage
    private OnPreparedListener mOnPreparedListener;
    @UnsupportedAppUsage
    private OnCompletionListener mOnCompletionListener;
    private final OnCompletionListener mOnCompletionInternalListener = new OnCompletionListener(){

        @Override
        public void onCompletion(MediaPlayer mp) {
            MediaPlayer.this.tryToDisableNativeRoutingCallback();
            MediaPlayer.this.baseStop();
        }
    };
    private OnBufferingUpdateListener mOnBufferingUpdateListener;
    @UnsupportedAppUsage
    private OnSeekCompleteListener mOnSeekCompleteListener;
    private OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    @UnsupportedAppUsage
    private OnTimedTextListener mOnTimedTextListener;
    private boolean mSubtitleDataListenerDisabled;
    private OnSubtitleDataListener mExtSubtitleDataListener;
    private Handler mExtSubtitleDataHandler;
    private OnMediaTimeDiscontinuityListener mOnMediaTimeDiscontinuityListener;
    private Handler mOnMediaTimeDiscontinuityHandler;
    private OnRtpRxNoticeListener mOnRtpRxNoticeListener;
    private Executor mOnRtpRxNoticeExecutor;
    private OnTimedMetaDataAvailableListener mOnTimedMetaDataAvailableListener;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public static final int MEDIA_ERROR_IO = -1004;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_UNSUPPORTED = -1010;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    public static final int MEDIA_ERROR_SYSTEM = Integer.MIN_VALUE;
    @UnsupportedAppUsage
    private OnErrorListener mOnErrorListener;
    public static final int MEDIA_INFO_UNKNOWN = 1;
    public static final int MEDIA_INFO_STARTED_AS_NEXT = 2;
    public static final int MEDIA_INFO_VIDEO_RENDERING_START = 3;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_NETWORK_BANDWIDTH = 703;
    public static final int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static final int MEDIA_INFO_METADATA_UPDATE = 802;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int MEDIA_INFO_EXTERNAL_METADATA_UPDATE = 803;
    public static final int MEDIA_INFO_AUDIO_NOT_PLAYING = 804;
    public static final int MEDIA_INFO_VIDEO_NOT_PLAYING = 805;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int MEDIA_INFO_TIMED_TEXT_ERROR = 900;
    public static final int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901;
    public static final int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902;
    @UnsupportedAppUsage
    private OnInfoListener mOnInfoListener;
    private OnDrmConfigHelper mOnDrmConfigHelper;
    private OnDrmInfoHandlerDelegate mOnDrmInfoHandlerDelegate;
    public static final int PREPARE_DRM_STATUS_SUCCESS = 0;
    public static final int PREPARE_DRM_STATUS_PROVISIONING_NETWORK_ERROR = 1;
    public static final int PREPARE_DRM_STATUS_PROVISIONING_SERVER_ERROR = 2;
    public static final int PREPARE_DRM_STATUS_PREPARATION_ERROR = 3;
    private OnDrmPreparedHandlerDelegate mOnDrmPreparedHandlerDelegate;

    public MediaPlayer() {
        this((Context)null, 0);
    }

    public MediaPlayer(@NonNull Context context) {
        this(Objects.requireNonNull(context), 0);
    }

    private MediaPlayer(Context context, int sessionId) {
        super(new AudioAttributes.Builder().build(), 2);
        AttributionSource attributionSource;
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mTimeProvider = new TimeProvider(this);
        this.mOpenSubtitleSources = new Vector();
        AttributionSource attributionSource2 = attributionSource = context == null ? AttributionSource.myAttributionSource() : context.getAttributionSource();
        if (attributionSource.getPackageName() == null) {
            attributionSource = attributionSource.withPackageName("");
        }
        try (AttributionSource.ScopedParcelState attributionSourceState = attributionSource.asScopedParcelState();){
            this.native_setup(new WeakReference<MediaPlayer>(this), attributionSourceState.getParcel(), MediaPlayer.resolvePlaybackSessionId(context, sessionId));
        }
        this.baseRegisterPlayer(this.getAudioSessionId());
    }

    private Parcel createPlayerIIdParcel() {
        Parcel parcel = this.newRequest();
        parcel.writeInt(8);
        parcel.writeInt(this.mPlayerIId);
        return parcel;
    }

    private void _setVideoSurface(Surface surface) {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setVideoSurface(Landroid/view/Surface;)V", true, this);
    }

    @UnsupportedAppUsage
    public Parcel newRequest() {
        Parcel parcel = Parcel.obtain();
        parcel.writeInterfaceToken(IMEDIA_PLAYER);
        return parcel;
    }

    @UnsupportedAppUsage
    public void invoke(Parcel request, Parcel reply) {
        int retcode = this.native_invoke(request, reply);
        reply.setDataPosition(0);
        if (retcode != 0) {
            throw new RuntimeException("failure code: " + retcode);
        }
    }

    public void setDisplay(SurfaceHolder sh) {
        this.mSurfaceHolder = sh;
        Surface surface = sh != null ? sh.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoScalingMode(int mode) {
        if (!this.isVideoScalingModeSupported(mode)) {
            String msg = "Scaling mode " + mode + " is not supported";
            throw new IllegalArgumentException(msg);
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(6);
            request.writeInt(mode);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public static MediaPlayer create(Context context, Uri uri) {
        return MediaPlayer.create(context, uri, null);
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder) {
        return MediaPlayer.create(context, uri, holder, null, 0);
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder, AudioAttributes audioAttributes, int audioSessionId) {
        try {
            MediaPlayer mp = new MediaPlayer(context, audioSessionId);
            AudioAttributes aa = audioAttributes != null ? audioAttributes : new AudioAttributes.Builder().build();
            mp.setAudioAttributes(aa);
            mp.setDataSource(context, uri);
            if (holder != null) {
                mp.setDisplay(holder);
            }
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        return null;
    }

    public static MediaPlayer create(Context context, int resid) {
        return MediaPlayer.create(context, resid, null, 0);
    }

    public static MediaPlayer create(Context context, int resid, AudioAttributes audioAttributes, int audioSessionId) {
        try {
            AssetFileDescriptor afd = context.getResources().openRawResourceFd(resid);
            if (afd == null) {
                return null;
            }
            MediaPlayer mp = new MediaPlayer(context, audioSessionId);
            AudioAttributes aa = audioAttributes != null ? audioAttributes : new AudioAttributes.Builder().build();
            mp.setAudioAttributes(aa);
            mp.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        return null;
    }

    public void setDataSource(@NonNull Context context, @NonNull Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null, null);
    }

    public void setDataSource(@NonNull Context context, @NonNull Uri uri, @Nullable Map<String, String> headers, @Nullable List<HttpCookie> cookies) throws IOException {
        CookieHandler cookieHandler;
        if (context == null) {
            throw new NullPointerException("context param can not be null.");
        }
        if (uri == null) {
            throw new NullPointerException("uri param can not be null.");
        }
        if (cookies != null && (cookieHandler = CookieHandler.getDefault()) != null && !(cookieHandler instanceof CookieManager)) {
            throw new IllegalArgumentException("The cookie handler has to be of CookieManager type when cookies are provided.");
        }
        ContentResolver resolver = context.getContentResolver();
        String scheme = uri.getScheme();
        String authority = ContentProvider.getAuthorityWithoutUserId(uri.getAuthority());
        if ("file".equals(scheme)) {
            this.setDataSource(uri.getPath());
            return;
        }
        if ("content".equals(scheme) && "settings".equals(authority)) {
            int type = RingtoneManager.getDefaultType(uri);
            Uri cacheUri = RingtoneManager.getCacheForType(type, context.getUserId());
            Uri actualUri = RingtoneManager.getActualDefaultRingtoneUri(context, type);
            if (this.attemptDataSource(resolver, cacheUri)) {
                return;
            }
            if (this.attemptDataSource(resolver, actualUri)) {
                return;
            }
            this.setDataSource(uri.toString(), headers, cookies);
        } else {
            if (this.attemptDataSource(resolver, uri)) {
                return;
            }
            this.setDataSource(uri.toString(), headers, cookies);
        }
    }

    public void setDataSource(@NonNull Context context, @NonNull Uri uri, @Nullable Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, headers, null);
    }

    private boolean attemptDataSource(ContentResolver resolver, Uri uri) {
        boolean bl;
        block8: {
            boolean optimize = SystemProperties.getBoolean("fuse.sys.transcode_player_optimize", false);
            Bundle opts = new Bundle();
            opts.putBoolean("android.provider.extra.ACCEPT_ORIGINAL_MEDIA_FORMAT", true);
            AssetFileDescriptor afd = optimize ? resolver.openTypedAssetFileDescriptor(uri, "*/*", opts) : resolver.openAssetFileDescriptor(uri, "r");
            try {
                this.setDataSource(afd);
                bl = true;
                if (afd == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (afd != null) {
                        try {
                            afd.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException | SecurityException ex) {
                    Log.w(TAG, "Error setting data source via ContentResolver", ex);
                    return false;
                }
            }
            afd.close();
        }
        return bl;
    }

    public void setDataSource(String path) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(path, null, null);
    }

    @UnsupportedAppUsage
    public void setDataSource(String path, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(path, headers, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void setDataSource(String path, Map<String, String> headers, List<HttpCookie> cookies) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.setDataSource(path, keys, values, cookies);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void setDataSource(String path, String[] keys, String[] values, List<HttpCookie> cookies) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        Uri uri = Uri.parse(path);
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            path = uri.getPath();
        } else if (scheme != null) {
            this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path, cookies), path, keys, values);
            return;
        }
        File file = new File(path);
        try (FileInputStream is = new FileInputStream(file);){
            this.setDataSource(is.getFD());
        }
    }

    private void nativeSetDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#nativeSetDataSource(Landroid/os/IBinder;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    public void setDataSource(@NonNull AssetFileDescriptor afd) throws IOException, IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull(afd);
        if (afd.getDeclaredLength() < 0L) {
            this.setDataSource(afd.getFileDescriptor());
        } else {
            this.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
        }
    }

    public void setDataSource(FileDescriptor fd) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public void setDataSource(FileDescriptor fd, long offset, long length) throws IOException, IllegalArgumentException, IllegalStateException {
        try (ParcelFileDescriptor modernFd = FileUtils.convertToModernFd(fd);){
            if (modernFd == null) {
                this._setDataSource(fd, offset, length);
            } else {
                this._setDataSource(modernFd.getFileDescriptor(), offset, length);
            }
        }
        catch (IOException e) {
            Log.w(TAG, "Ignoring IO error while setting data source", e);
        }
    }

    private void _setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException, IllegalArgumentException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setDataSource(Ljava/io/FileDescriptor;JJ)V", true, this);
    }

    public void setDataSource(MediaDataSource dataSource) throws IllegalArgumentException, IllegalStateException {
        this._setDataSource(dataSource);
    }

    private void _setDataSource(MediaDataSource mediaDataSource) throws IllegalArgumentException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setDataSource(Landroid/media/MediaDataSource;)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws IOException, IllegalStateException {
        Parcel piidParcel = this.createPlayerIIdParcel();
        try {
            int retCode = this._prepare(piidParcel);
            if (retCode != 0) {
                Log.w(TAG, "prepare(): could not set piid " + this.mPlayerIId);
            }
        }
        finally {
            piidParcel.recycle();
        }
        this.scanInternalSubtitleTracks();
        Object object = this.mDrmLock;
        synchronized (object) {
            this.mDrmInfoResolved = true;
        }
    }

    private int _prepare(Parcel parcel) throws IOException, IllegalStateException {
        return OverrideMethod.invokeI("android.media.MediaPlayer#_prepare(Landroid/os/Parcel;)I", true, this);
    }

    public void prepareAsync() throws IllegalStateException {
        Parcel piidParcel = this.createPlayerIIdParcel();
        try {
            int retCode = this._prepareAsync(piidParcel);
            if (retCode != 0) {
                Log.w(TAG, "prepareAsync(): could not set piid " + this.mPlayerIId);
            }
        }
        finally {
            piidParcel.recycle();
        }
    }

    private int _prepareAsync(Parcel parcel) throws IllegalStateException {
        return OverrideMethod.invokeI("android.media.MediaPlayer#_prepareAsync(Landroid/os/Parcel;)I", true, this);
    }

    public void start() throws IllegalStateException {
        final int delay = this.getStartDelayMs();
        if (delay == 0) {
            this.startImpl();
        } else {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    MediaPlayer.this.baseSetStartDelayMs(0);
                    try {
                        MediaPlayer.this.startImpl();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    private void startImpl() {
        this.baseStart(new int[0]);
        this.stayAwake(true);
        this.tryToEnableNativeRoutingCallback();
        this._start();
    }

    private void _start() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_start()V", true, this);
    }

    private int getAudioStreamType() {
        if (this.mStreamType == Integer.MIN_VALUE) {
            this.mStreamType = this._getAudioStreamType();
        }
        return this.mStreamType;
    }

    private int _getAudioStreamType() throws IllegalStateException {
        return OverrideMethod.invokeI("android.media.MediaPlayer#_getAudioStreamType()I", true, this);
    }

    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
        this.baseStop();
        this.tryToDisableNativeRoutingCallback();
    }

    private void _stop() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_stop()V", true, this);
    }

    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
        this.basePause();
    }

    private void _pause() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_pause()V", true, this);
    }

    @Override
    void playerStart() {
        this.start();
    }

    @Override
    void playerPause() {
        this.pause();
    }

    @Override
    void playerStop() {
        this.stop();
    }

    @Override
    int playerApplyVolumeShaper(@NonNull VolumeShaper.Configuration configuration, @NonNull VolumeShaper.Operation operation) {
        return this.native_applyVolumeShaper(configuration, operation);
    }

    @Override
    @Nullable
    VolumeShaper.State playerGetVolumeShaperState(int id2) {
        return this.native_getVolumeShaperState(id2);
    }

    @Override
    @NonNull
    public VolumeShaper createVolumeShaper(@NonNull VolumeShaper.Configuration configuration) {
        return new VolumeShaper(configuration, this);
    }

    private int native_applyVolumeShaper(@NonNull VolumeShaper.Configuration configuration, @NonNull VolumeShaper.Operation operation) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_applyVolumeShaper(Landroid/media/VolumeShaper$Configuration;Landroid/media/VolumeShaper$Operation;)I", true, this);
    }

    @Nullable
    private VolumeShaper.State native_getVolumeShaperState(int n) {
        return (VolumeShaper.State)OverrideMethod.invokeA("android.media.MediaPlayer#native_getVolumeShaperState(I)Landroid/media/VolumeShaper$State;", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSink()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setOutputDevice(preferredDeviceId);
        if (status) {
            MediaPlayer mediaPlayer = this;
            synchronized (mediaPlayer) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioDeviceInfo getPreferredDevice() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            return this.mPreferredDevice;
        }
    }

    @NonNull
    private List<AudioDeviceInfo> getRoutedDevicesInternal() {
        ArrayList<AudioDeviceInfo> audioDeviceInfos = new ArrayList<AudioDeviceInfo>();
        int[] deviceIds = this.native_getRoutedDeviceIds();
        if (deviceIds == null || deviceIds.length == 0) {
            return audioDeviceInfos;
        }
        for (int i = 0; i < deviceIds.length; ++i) {
            AudioDeviceInfo audioDeviceInfo = AudioManager.getDeviceForPortId((int)deviceIds[i], (int)2);
            if (audioDeviceInfo == null) continue;
            audioDeviceInfos.add(audioDeviceInfo);
        }
        return audioDeviceInfos;
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        List<AudioDeviceInfo> audioDeviceInfos = this.getRoutedDevicesInternal();
        if (audioDeviceInfos.isEmpty()) {
            return null;
        }
        return audioDeviceInfos.get(0);
    }

    @Override
    @FlaggedApi(value="android.media.audio.routed_device_ids")
    @NonNull
    public List<AudioDeviceInfo> getRoutedDevices() {
        return this.getRoutedDevicesInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastRoutingChange() {
        AudioManager.resetAudioPortGeneration();
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mEnableSelfRoutingMonitor) {
                this.baseUpdateDeviceIds(this.getRoutedDevicesInternal());
            }
            for (NativeRoutingEventHandlerDelegate delegate : this.mRoutingChangeListeners.values()) {
                delegate.notifyClient();
            }
        }
    }

    @GuardedBy(value={"mRoutingChangeListeners"})
    private boolean testEnableNativeRoutingCallbacksLocked() {
        block3: {
            if (this.mRoutingChangeListeners.size() == 0 && !this.mEnableSelfRoutingMonitor) {
                try {
                    this.native_enableDeviceCallback(true);
                    return true;
                }
                catch (IllegalStateException e) {
                    if (!Log.isLoggable(TAG, 3)) break block3;
                    Log.d(TAG, "testEnableNativeRoutingCallbacks failed", e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToEnableNativeRoutingCallback() {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (!this.mEnableSelfRoutingMonitor) {
                this.mEnableSelfRoutingMonitor = this.testEnableNativeRoutingCallbacksLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToDisableNativeRoutingCallback() {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mEnableSelfRoutingMonitor) {
                this.mEnableSelfRoutingMonitor = false;
                this.testDisableNativeRoutingCallbacksLocked();
            }
        }
    }

    @GuardedBy(value={"mRoutingChangeListeners"})
    private void testDisableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0 && !this.mEnableSelfRoutingMonitor) {
            try {
                this.native_enableDeviceCallback(false);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (listener != null && !this.mRoutingChangeListeners.containsKey(listener)) {
                this.mEnableSelfRoutingMonitor = this.testEnableNativeRoutingCallbacksLocked();
                this.mRoutingChangeListeners.put(listener, new NativeRoutingEventHandlerDelegate(this, listener, handler != null ? handler : this.mEventHandler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener)) {
                this.mRoutingChangeListeners.remove(listener);
            }
            this.testDisableNativeRoutingCallbacksLocked();
        }
    }

    private boolean native_setOutputDevice(int n) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_setOutputDevice(I)Z", true, this) != 0;
    }

    private int[] native_getRoutedDeviceIds() {
        return (int[])OverrideMethod.invokeA("android.media.MediaPlayer#native_getRoutedDeviceIds()[I", true, this);
    }

    private void native_enableDeviceCallback(boolean bl) {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_enableDeviceCallback(Z)V", true, this);
    }

    public void setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (SystemProperties.getBoolean("audio.offload.ignore_setawake", false)) {
            Log.w(TAG, "IGNORING setWakeMode " + mode);
            return;
        }
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, MediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            if (screenOn && this.mSurfaceHolder == null) {
                Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    private void stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    public int getVideoWidth() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getVideoWidth()I", true, this);
    }

    public int getVideoHeight() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getVideoHeight()I", true, this);
    }

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private PersistableBundle native_getMetrics() {
        return (PersistableBundle)OverrideMethod.invokeA("android.media.MediaPlayer#native_getMetrics()Landroid/os/PersistableBundle;", true, this);
    }

    public boolean isPlaying() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#isPlaying()Z", true, this) != 0;
    }

    @NonNull
    public PlaybackParams easyPlaybackParams(float rate, int audioMode) {
        PlaybackParams params = new PlaybackParams();
        params.allowDefaults();
        switch (audioMode) {
            case 0: {
                params.setSpeed(rate).setPitch(1.0f);
                break;
            }
            case 1: {
                params.setSpeed(rate).setPitch(1.0f).setAudioFallbackMode(2);
                break;
            }
            case 2: {
                params.setSpeed(rate).setPitch(rate);
                break;
            }
            default: {
                String msg = "Audio playback mode " + audioMode + " is not supported";
                throw new IllegalArgumentException(msg);
            }
        }
        return params;
    }

    public void setPlaybackParams(@NonNull PlaybackParams playbackParams) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setPlaybackParams(Landroid/media/PlaybackParams;)V", true, this);
    }

    @NonNull
    public PlaybackParams getPlaybackParams() {
        return (PlaybackParams)OverrideMethod.invokeA("android.media.MediaPlayer#getPlaybackParams()Landroid/media/PlaybackParams;", true, this);
    }

    public void setSyncParams(@NonNull SyncParams syncParams) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setSyncParams(Landroid/media/SyncParams;)V", true, this);
    }

    @NonNull
    public SyncParams getSyncParams() {
        return (SyncParams)OverrideMethod.invokeA("android.media.MediaPlayer#getSyncParams()Landroid/media/SyncParams;", true, this);
    }

    private void _seekTo(long l, int n) {
        OverrideMethod.invokeV("android.media.MediaPlayer#_seekTo(JI)V", true, this);
    }

    public void seekTo(long msec, int mode) {
        if (mode < 0 || mode > 3) {
            String msg = "Illegal seek mode: " + mode;
            throw new IllegalArgumentException(msg);
        }
        if (msec > Integer.MAX_VALUE) {
            Log.w(TAG, "seekTo offset " + msec + " is too large, cap to " + Integer.MAX_VALUE);
            msec = Integer.MAX_VALUE;
        } else if (msec < Integer.MIN_VALUE) {
            Log.w(TAG, "seekTo offset " + msec + " is too small, cap to " + Integer.MIN_VALUE);
            msec = Integer.MIN_VALUE;
        }
        this._seekTo(msec, mode);
    }

    public void seekTo(int msec) throws IllegalStateException {
        this.seekTo(msec, 0);
    }

    @Nullable
    public MediaTimestamp getTimestamp() {
        try {
            return new MediaTimestamp((long)this.getCurrentPosition() * 1000L, System_Delegate.nanoTime(), this.isPlaying() ? this.getPlaybackParams().getSpeed() : 0.0f);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public int getCurrentPosition() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getCurrentPosition()I", true, this);
    }

    public int getDuration() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getDuration()I", true, this);
    }

    @UnsupportedAppUsage
    public Metadata getMetadata(boolean update_only, boolean apply_filter) {
        Parcel reply = Parcel.obtain();
        Metadata data = new Metadata();
        if (!this.native_getMetadata(update_only, apply_filter, reply)) {
            reply.recycle();
            return null;
        }
        if (!data.parse(reply)) {
            reply.recycle();
            return null;
        }
        return data;
    }

    public int setMetadataFilter(Set<Integer> allow, Set<Integer> block) {
        Parcel request = this.newRequest();
        int capacity = request.dataSize() + 4 * (1 + allow.size() + 1 + block.size());
        if (request.dataCapacity() < capacity) {
            request.setDataCapacity(capacity);
        }
        request.writeInt(allow.size());
        for (Integer t : allow) {
            request.writeInt(t);
        }
        request.writeInt(block.size());
        for (Integer t : block) {
            request.writeInt(t);
        }
        return this.native_setMetadataFilter(request);
    }

    public void setNextMediaPlayer(MediaPlayer mediaPlayer) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setNextMediaPlayer(Landroid/media/MediaPlayer;)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.baseRelease();
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.mOnPreparedListener = null;
        this.mOnBufferingUpdateListener = null;
        this.mOnCompletionListener = null;
        this.mOnSeekCompleteListener = null;
        this.mOnErrorListener = null;
        this.mOnInfoListener = null;
        this.mOnVideoSizeChangedListener = null;
        this.mOnTimedTextListener = null;
        this.mOnRtpRxNoticeListener = null;
        this.mOnRtpRxNoticeExecutor = null;
        Object object = this.mTimeProviderLock;
        synchronized (object) {
            if (this.mTimeProvider != null) {
                this.mTimeProvider.close();
                this.mTimeProvider = null;
            }
        }
        object = this;
        synchronized (object) {
            this.mSubtitleDataListenerDisabled = false;
            this.mExtSubtitleDataListener = null;
            this.mExtSubtitleDataHandler = null;
            this.mOnMediaTimeDiscontinuityListener = null;
            this.mOnMediaTimeDiscontinuityHandler = null;
        }
        this.mOnDrmConfigHelper = null;
        this.mOnDrmInfoHandlerDelegate = null;
        this.mOnDrmPreparedHandlerDelegate = null;
        this.resetDrmState();
        this._release();
    }

    private void _release() {
        OverrideMethod.invokeV("android.media.MediaPlayer#_release()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.mSelectedSubtitleTrackIndex = -1;
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mOpenSubtitleSources;
        synchronized (vector) {
            for (InputStream is : this.mOpenSubtitleSources) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            this.mOpenSubtitleSources.clear();
        }
        if (this.mSubtitleController != null) {
            this.mSubtitleController.reset();
        }
        vector = this.mTimeProviderLock;
        synchronized (vector) {
            if (this.mTimeProvider != null) {
                this.mTimeProvider.close();
                this.mTimeProvider = null;
            }
        }
        this.stayAwake(false);
        this._reset();
        if (this.mEventHandler != null) {
            this.mEventHandler.removeCallbacksAndMessages(null);
        }
        vector = this.mIndexTrackPairs;
        synchronized (vector) {
            this.mIndexTrackPairs.clear();
            this.mInbandTrackIndices.clear();
        }
        this.resetDrmState();
    }

    private void _reset() {
        OverrideMethod.invokeV("android.media.MediaPlayer#_reset()V", true, this);
    }

    public void notifyAt(long mediaTimeUs) {
        this._notifyAt(mediaTimeUs);
    }

    private void _notifyAt(long l) {
        OverrideMethod.invokeV("android.media.MediaPlayer#_notifyAt(J)V", true, this);
    }

    public void setAudioStreamType(int streamtype) {
        MediaPlayer.deprecateStreamTypeForPlayback(streamtype, TAG, "setAudioStreamType()");
        this.baseUpdateAudioAttributes(new AudioAttributes.Builder().setInternalLegacyStreamType(streamtype).build());
        this._setAudioStreamType(streamtype);
        this.mStreamType = streamtype;
    }

    private void _setAudioStreamType(int n) {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setAudioStreamType(I)V", true, this);
    }

    @UnsupportedAppUsage
    private boolean setParameter(int n, Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#setParameter(ILandroid/os/Parcel;)Z", true, this) != 0;
    }

    public void setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
        if (attributes == null) {
            String msg = "Cannot set AudioAttributes to null";
            throw new IllegalArgumentException("Cannot set AudioAttributes to null");
        }
        this.baseUpdateAudioAttributes(attributes);
        Parcel pattributes = Parcel.obtain();
        attributes.writeToParcel(pattributes, 1);
        this.setParameter(1400, pattributes);
        pattributes.recycle();
    }

    public void setLooping(boolean bl) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setLooping(Z)V", true, this);
    }

    public boolean isLooping() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#isLooping()Z", true, this) != 0;
    }

    public void setVolume(float leftVolume, float rightVolume) {
        this.baseSetVolume(leftVolume, rightVolume);
    }

    @Override
    void playerSetVolume(boolean muting, float leftVolume, float rightVolume) {
        this._setVolume(muting ? 0.0f : leftVolume, muting ? 0.0f : rightVolume);
    }

    private void _setVolume(float f, float f2) {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setVolume(FF)V", true, this);
    }

    public void setVolume(float volume) {
        this.setVolume(volume, volume);
    }

    public void setAudioSessionId(int sessionId) throws IllegalArgumentException, IllegalStateException {
        this.native_setAudioSessionId(sessionId);
        this.baseUpdateSessionId(sessionId);
    }

    private void native_setAudioSessionId(int n) {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_setAudioSessionId(I)V", true, this);
    }

    public int getAudioSessionId() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getAudioSessionId()I", true, this);
    }

    public void attachAuxEffect(int n) {
        OverrideMethod.invokeV("android.media.MediaPlayer#attachAuxEffect(I)V", true, this);
    }

    public void setAuxEffectSendLevel(float level) {
        this.baseSetAuxEffectSendLevel(level);
    }

    @Override
    int playerSetAuxEffectSendLevel(boolean muting, float level) {
        this._setAuxEffectSendLevel(muting ? 0.0f : level);
        return 0;
    }

    private void _setAuxEffectSendLevel(float f) {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setAuxEffectSendLevel(F)V", true, this);
    }

    private int native_invoke(Parcel parcel, Parcel parcel2) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_invoke(Landroid/os/Parcel;Landroid/os/Parcel;)I", true, this);
    }

    private boolean native_getMetadata(boolean bl, boolean bl2, Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_getMetadata(ZZLandroid/os/Parcel;)Z", true, this) != 0;
    }

    private int native_setMetadataFilter(Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_setMetadataFilter(Landroid/os/Parcel;)I", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_init()V", true, null);
    }

    private void native_setup(Object object, @NonNull Parcel parcel, int n) {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_setup(Ljava/lang/Object;Landroid/os/Parcel;I)V", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_finalize()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackInfo[] getTrackInfo() throws IllegalStateException {
        TrackInfo[] trackInfo = this.getInbandTrackInfo();
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            TrackInfo[] allTrackInfo = new TrackInfo[this.mIndexTrackPairs.size()];
            for (int i = 0; i < allTrackInfo.length; ++i) {
                Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                if (p.first != null) {
                    allTrackInfo[i] = trackInfo[(Integer)p.first];
                    continue;
                }
                SubtitleTrack track = (SubtitleTrack)p.second;
                allTrackInfo[i] = new TrackInfo(track.getTrackType(), track.getFormat());
            }
            return allTrackInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackInfo[] getInbandTrackInfo() throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            TrackInfo[] trackInfo;
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(1);
            this.invoke(request, reply);
            TrackInfo[] trackInfoArray = trackInfo = reply.createTypedArray(TrackInfo.CREATOR);
            return trackInfoArray;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private static boolean availableMimeTypeForExternalSource(String mimeType) {
        return MEDIA_MIMETYPE_TEXT_SUBRIP.equals(mimeType);
    }

    @UnsupportedAppUsage
    public void setSubtitleAnchor(SubtitleController controller, SubtitleController.Anchor anchor) {
        this.mSubtitleController = controller;
        this.mSubtitleController.setAnchor(anchor);
    }

    private synchronized void setSubtitleAnchor() {
        if (this.mSubtitleController == null && ActivityThread.currentApplication() != null) {
            final TimeProvider timeProvider = (TimeProvider)this.getMediaTimeProvider();
            final HandlerThread thread = new HandlerThread("SetSubtitleAnchorThread");
            thread.start();
            Handler handler = new Handler(thread.getLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Application context = ActivityThread.currentApplication();
                    MediaPlayer.this.mSubtitleController = new SubtitleController(context, timeProvider, MediaPlayer.this);
                    MediaPlayer.this.mSubtitleController.setAnchor(new SubtitleController.Anchor(){

                        @Override
                        public void setSubtitleWidget(SubtitleTrack.RenderingWidget subtitleWidget) {
                        }

                        @Override
                        public Looper getSubtitleLooper() {
                            return timeProvider.mEventHandler.getLooper();
                        }
                    });
                    thread.getLooper().quitSafely();
                }
            });
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.w(TAG, "failed to join SetSubtitleAnchorThread");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubtitleTrackSelected(SubtitleTrack track) {
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, false);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.mSelectedSubtitleTrackIndex = -1;
        }
        Object object = this;
        synchronized (object) {
            this.mSubtitleDataListenerDisabled = true;
        }
        if (track == null) {
            return;
        }
        object = this.mIndexTrackPairs;
        synchronized (object) {
            for (Pair<Integer, SubtitleTrack> p : this.mIndexTrackPairs) {
                if (p.first == null || p.second != track) continue;
                this.mSelectedSubtitleTrackIndex = (Integer)p.first;
                break;
            }
        }
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, true);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            object = this;
            synchronized (object) {
                this.mSubtitleDataListenerDisabled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void addSubtitleSource(InputStream is, MediaFormat format) throws IllegalStateException {
        final InputStream fIs = is;
        final MediaFormat fFormat = format;
        if (is != null) {
            Vector<InputStream> vector = this.mOpenSubtitleSources;
            synchronized (vector) {
                this.mOpenSubtitleSources.add(is);
            }
        } else {
            Log.w(TAG, "addSubtitleSource called with null InputStream");
        }
        this.getMediaTimeProvider();
        final HandlerThread thread = new HandlerThread("SubtitleReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int addTrack() {
                if (fIs == null || MediaPlayer.this.mSubtitleController == null) {
                    return 901;
                }
                SubtitleTrack track = MediaPlayer.this.mSubtitleController.addTrack(fFormat);
                if (track == null) {
                    return 901;
                }
                Scanner scanner = new Scanner(fIs, "UTF-8");
                String contents = scanner.useDelimiter("\\A").next();
                Object object = MediaPlayer.this.mOpenSubtitleSources;
                synchronized (object) {
                    MediaPlayer.this.mOpenSubtitleSources.remove(fIs);
                }
                scanner.close();
                object = MediaPlayer.this.mIndexTrackPairs;
                synchronized (object) {
                    MediaPlayer.this.mIndexTrackPairs.add(Pair.create(null, track));
                }
                object = MediaPlayer.this.mTimeProviderLock;
                synchronized (object) {
                    if (MediaPlayer.this.mTimeProvider != null) {
                        Handler h = MediaPlayer.this.mTimeProvider.mEventHandler;
                        int what = 1;
                        int arg1 = 4;
                        Pair<SubtitleTrack, byte[]> trackData = Pair.create(track, contents.getBytes());
                        Message m = h.obtainMessage(what, arg1, 0, trackData);
                        h.sendMessage(m);
                    }
                }
                return 803;
            }

            @Override
            public void run() {
                int res = this.addTrack();
                if (MediaPlayer.this.mEventHandler != null) {
                    Message m = MediaPlayer.this.mEventHandler.obtainMessage(200, res, 0, null);
                    MediaPlayer.this.mEventHandler.sendMessage(m);
                }
                thread.getLooper().quitSafely();
            }
        });
    }

    private void scanInternalSubtitleTracks() {
        this.setSubtitleAnchor();
        this.populateInbandTracks();
        if (this.mSubtitleController != null) {
            this.mSubtitleController.selectDefaultTrack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateInbandTracks() {
        TrackInfo[] tracks = this.getInbandTrackInfo();
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            for (int i = 0; i < tracks.length; ++i) {
                if (this.mInbandTrackIndices.get(i)) continue;
                this.mInbandTrackIndices.set(i);
                if (tracks[i] == null) {
                    Log.w(TAG, "unexpected NULL track at index " + i);
                }
                if (tracks[i] != null && tracks[i].getTrackType() == 4) {
                    SubtitleTrack track = this.mSubtitleController.addTrack(tracks[i].getFormat());
                    this.mIndexTrackPairs.add(Pair.create(i, track));
                    continue;
                }
                this.mIndexTrackPairs.add(Pair.create(i, null));
            }
        }
    }

    public void addTimedTextSource(String path, String mimeType) throws IOException, IllegalArgumentException, IllegalStateException {
        if (!MediaPlayer.availableMimeTypeForExternalSource(mimeType)) {
            String msg = "Illegal mimeType for timed text source: " + mimeType;
            throw new IllegalArgumentException(msg);
        }
        File file = new File(path);
        try (FileInputStream is = new FileInputStream(file);){
            this.addTimedTextSource(is.getFD(), mimeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimedTextSource(Context context, Uri uri, String mimeType) throws IOException, IllegalArgumentException, IllegalStateException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.addTimedTextSource(uri.getPath(), mimeType);
            return;
        }
        try (AssetFileDescriptor fd = null;){
            boolean optimize = SystemProperties.getBoolean("fuse.sys.transcode_player_optimize", false);
            ContentResolver resolver = context.getContentResolver();
            Bundle opts = new Bundle();
            opts.putBoolean("android.provider.extra.ACCEPT_ORIGINAL_MEDIA_FORMAT", true);
            AssetFileDescriptor assetFileDescriptor = fd = optimize ? resolver.openTypedAssetFileDescriptor(uri, "*/*", opts) : resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            this.addTimedTextSource(fd.getFileDescriptor(), mimeType);
            return;
        }
    }

    public void addTimedTextSource(FileDescriptor fd, String mimeType) throws IllegalArgumentException, IllegalStateException {
        this.addTimedTextSource(fd, 0L, 0x7FFFFFFFFFFFFFFL, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimedTextSource(FileDescriptor fd, long offset, long length, String mime) throws IllegalArgumentException, IllegalStateException {
        FileDescriptor dupedFd;
        if (!MediaPlayer.availableMimeTypeForExternalSource(mime)) {
            throw new IllegalArgumentException("Illegal mimeType for timed text source: " + mime);
        }
        try {
            dupedFd = Os.dup(fd);
        }
        catch (ErrnoException ex) {
            Log.e(TAG, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        MediaFormat fFormat = new MediaFormat();
        fFormat.setString("mime", mime);
        fFormat.setInteger("is-timed-text", 1);
        if (this.mSubtitleController == null) {
            this.setSubtitleAnchor();
        }
        if (!this.mSubtitleController.hasRendererFor(fFormat)) {
            Application context = ActivityThread.currentApplication();
            this.mSubtitleController.registerRenderer(new SRTRenderer(context, this.mEventHandler));
        }
        final SubtitleTrack track = this.mSubtitleController.addTrack(fFormat);
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            this.mIndexTrackPairs.add(Pair.create(null, track));
        }
        this.getMediaTimeProvider();
        final long offset2 = offset;
        final long length2 = length;
        final HandlerThread thread = new HandlerThread("TimedTextReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int addTrack() {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    int bytesToRead;
                    int bytes;
                    Os.lseek(dupedFd, offset2, OsConstants.SEEK_SET);
                    byte[] buffer = new byte[4096];
                    for (long total = 0L; total < length2 && (bytes = IoBridge.read(dupedFd, buffer, 0, bytesToRead = (int)Math.min((long)buffer.length, length2 - total))) >= 0; total += (long)bytes) {
                        bos.write(buffer, 0, bytes);
                    }
                    Object object = MediaPlayer.this.mTimeProviderLock;
                    synchronized (object) {
                        if (MediaPlayer.this.mTimeProvider != null) {
                            Handler h = MediaPlayer.this.mTimeProvider.mEventHandler;
                            int what = 1;
                            int arg1 = 4;
                            Pair<SubtitleTrack, byte[]> trackData = Pair.create(track, bos.toByteArray());
                            Message m = h.obtainMessage(what, arg1, 0, trackData);
                            h.sendMessage(m);
                        }
                    }
                    int n = 803;
                    return n;
                }
                catch (Exception e) {
                    Log.e(MediaPlayer.TAG, e.getMessage(), e);
                    int n = 900;
                    return n;
                }
                finally {
                    try {
                        Os.close(dupedFd);
                    }
                    catch (ErrnoException e) {
                        Log.e(MediaPlayer.TAG, e.getMessage(), e);
                    }
                }
            }

            @Override
            public void run() {
                int res = this.addTrack();
                if (MediaPlayer.this.mEventHandler != null) {
                    Message m = MediaPlayer.this.mEventHandler.obtainMessage(200, res, 0, null);
                    MediaPlayer.this.mEventHandler.sendMessage(m);
                }
                thread.getLooper().quitSafely();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSelectedTrack(int trackType) throws IllegalStateException {
        SubtitleTrack subtitleTrack;
        if (this.mSubtitleController != null && (trackType == 4 || trackType == 3) && (subtitleTrack = this.mSubtitleController.getSelectedTrack()) != null) {
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                for (int i = 0; i < this.mIndexTrackPairs.size(); ++i) {
                    Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                    if (p.second != subtitleTrack || subtitleTrack.getTrackType() != trackType) continue;
                    return i;
                }
            }
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(7);
            request.writeInt(trackType);
            this.invoke(request, reply);
            int inbandTrackIndex = reply.readInt();
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                for (int i = 0; i < this.mIndexTrackPairs.size(); ++i) {
                    Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                    if (p.first == null || (Integer)p.first != inbandTrackIndex) continue;
                    int n = i;
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public void selectTrack(int index) throws IllegalStateException {
        this.selectOrDeselectTrack(index, true);
    }

    public void deselectTrack(int index) throws IllegalStateException {
        this.selectOrDeselectTrack(index, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectOrDeselectTrack(int index, boolean select) throws IllegalStateException {
        this.populateInbandTracks();
        Pair<Integer, SubtitleTrack> p = null;
        try {
            p = this.mIndexTrackPairs.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        SubtitleTrack track = (SubtitleTrack)p.second;
        if (track == null) {
            this.selectOrDeselectInbandTrack((Integer)p.first, select);
            return;
        }
        if (this.mSubtitleController == null) {
            return;
        }
        if (!select) {
            if (this.mSubtitleController.getSelectedTrack() == track) {
                this.mSubtitleController.selectTrack(null);
            } else {
                Log.w(TAG, "trying to deselect track that was not selected");
            }
            return;
        }
        if (track.getTrackType() == 3) {
            int ttIndex = this.getSelectedTrack(3);
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                if (ttIndex >= 0 && ttIndex < this.mIndexTrackPairs.size()) {
                    Pair<Integer, SubtitleTrack> p2 = this.mIndexTrackPairs.get(ttIndex);
                    if (p2.first != null && p2.second == null) {
                        this.selectOrDeselectInbandTrack((Integer)p2.first, false);
                    }
                }
            }
        }
        this.mSubtitleController.selectTrack(track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectOrDeselectInbandTrack(int index, boolean select) throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(select ? 4 : 5);
            request.writeInt(index);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public static int native_pullBatteryData(Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_pullBatteryData(Landroid/os/Parcel;)I", true, null);
    }

    @UnsupportedAppUsage
    public void setRetransmitEndpoint(InetSocketAddress endpoint) throws IllegalStateException, IllegalArgumentException {
        int ret;
        String addrString = null;
        int port = 0;
        if (null != endpoint) {
            addrString = endpoint.getAddress().getHostAddress();
            port = endpoint.getPort();
        }
        if ((ret = this.native_setRetransmitEndpoint(addrString, port)) != 0) {
            throw new IllegalArgumentException("Illegal re-transmit endpoint; native ret " + ret);
        }
    }

    private int native_setRetransmitEndpoint(String string2, int n) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_setRetransmitEndpoint(Ljava/lang/String;I)I", true, this);
    }

    protected void finalize() {
        this.tryToDisableNativeRoutingCallback();
        this.baseRelease();
        this.native_finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public MediaTimeProvider getMediaTimeProvider() {
        Object object = this.mTimeProviderLock;
        synchronized (object) {
            if (this.mTimeProvider == null) {
                this.mTimeProvider = new TimeProvider(this);
            }
            return this.mTimeProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postEventFromNative(Object mediaplayer_ref, int what, int arg1, int arg2, Object obj) {
        final MediaPlayer mp = (MediaPlayer)((WeakReference)mediaplayer_ref).get();
        if (mp == null) {
            return;
        }
        switch (what) {
            case 200: {
                if (arg1 != 2) break;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        mp.start();
                    }
                }).start();
                Thread.yield();
                break;
            }
            case 210: {
                Object parcel;
                Log.v(TAG, "postEventFromNative MEDIA_DRM_INFO");
                if (obj instanceof Parcel) {
                    parcel = (Parcel)obj;
                    DrmInfo drmInfo = new DrmInfo((Parcel)parcel);
                    Object object = mp.mDrmLock;
                    synchronized (object) {
                        mp.mDrmInfo = drmInfo;
                        break;
                    }
                }
                Log.w(TAG, "MEDIA_DRM_INFO msg.obj of unexpected type " + obj);
                break;
            }
            case 1: {
                Object parcel = mp.mDrmLock;
                synchronized (parcel) {
                    mp.mDrmInfoResolved = true;
                    break;
                }
            }
        }
        if (mp.mEventHandler != null) {
            Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mp.mEventHandler.sendMessage(m);
        }
    }

    public void setOnPreparedListener(OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
    }

    public void setOnCompletionListener(OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
    }

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
    }

    public void setOnSeekCompleteListener(OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
    }

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
    }

    public void setOnTimedTextListener(OnTimedTextListener listener) {
        this.mOnTimedTextListener = listener;
    }

    public void setOnSubtitleDataListener(@NonNull OnSubtitleDataListener listener, @NonNull Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("Illegal null listener");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Illegal null handler");
        }
        this.setOnSubtitleDataListenerInt(listener, handler);
    }

    public void setOnSubtitleDataListener(@NonNull OnSubtitleDataListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Illegal null listener");
        }
        this.setOnSubtitleDataListenerInt(listener, null);
    }

    public void clearOnSubtitleDataListener() {
        this.setOnSubtitleDataListenerInt(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOnSubtitleDataListenerInt(@Nullable OnSubtitleDataListener listener, @Nullable Handler handler) {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            this.mExtSubtitleDataListener = listener;
            this.mExtSubtitleDataHandler = handler;
        }
    }

    public void setOnMediaTimeDiscontinuityListener(@NonNull OnMediaTimeDiscontinuityListener listener, @NonNull Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("Illegal null listener");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Illegal null handler");
        }
        this.setOnMediaTimeDiscontinuityListenerInt(listener, handler);
    }

    public void setOnMediaTimeDiscontinuityListener(@NonNull OnMediaTimeDiscontinuityListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Illegal null listener");
        }
        this.setOnMediaTimeDiscontinuityListenerInt(listener, null);
    }

    public void clearOnMediaTimeDiscontinuityListener() {
        this.setOnMediaTimeDiscontinuityListenerInt(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOnMediaTimeDiscontinuityListenerInt(@Nullable OnMediaTimeDiscontinuityListener listener, @Nullable Handler handler) {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            this.mOnMediaTimeDiscontinuityListener = listener;
            this.mOnMediaTimeDiscontinuityHandler = handler;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BIND_IMS_SERVICE")
    public void setOnRtpRxNoticeListener(@NonNull Context context, @NonNull Executor executor, @NonNull OnRtpRxNoticeListener listener) {
        Objects.requireNonNull(context);
        Preconditions.checkArgument(context.checkSelfPermission("android.permission.BIND_IMS_SERVICE") == 0, "android.permission.BIND_IMS_SERVICE permission not granted.");
        this.mOnRtpRxNoticeListener = Objects.requireNonNull(listener);
        this.mOnRtpRxNoticeExecutor = Objects.requireNonNull(executor);
    }

    public void setOnTimedMetaDataAvailableListener(OnTimedMetaDataAvailableListener listener) {
        this.mOnTimedMetaDataAvailableListener = listener;
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    public void setOnInfoListener(OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnDrmConfigHelper(OnDrmConfigHelper listener) {
        Object object = this.mDrmLock;
        synchronized (object) {
            this.mOnDrmConfigHelper = listener;
        }
    }

    public void setOnDrmInfoListener(OnDrmInfoListener listener) {
        this.setOnDrmInfoListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnDrmInfoListener(OnDrmInfoListener listener, Handler handler) {
        Object object = this.mDrmLock;
        synchronized (object) {
            this.mOnDrmInfoHandlerDelegate = listener != null ? new OnDrmInfoHandlerDelegate(this, this, listener, handler) : null;
        }
    }

    public void setOnDrmPreparedListener(OnDrmPreparedListener listener) {
        this.setOnDrmPreparedListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnDrmPreparedListener(OnDrmPreparedListener listener, Handler handler) {
        Object object = this.mDrmLock;
        synchronized (object) {
            this.mOnDrmPreparedHandlerDelegate = listener != null ? new OnDrmPreparedHandlerDelegate(this, this, listener, handler) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrmInfo getDrmInfo() {
        DrmInfo drmInfo = null;
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mDrmInfoResolved && this.mDrmInfo == null) {
                String msg = "The Player has not been prepared yet";
                Log.v(TAG, "The Player has not been prepared yet");
                throw new IllegalStateException("The Player has not been prepared yet");
            }
            if (this.mDrmInfo != null) {
                drmInfo = this.mDrmInfo.makeCopy();
            }
        }
        return drmInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDrm(@NonNull UUID uuid) throws UnsupportedSchemeException, ResourceBusyException, ProvisioningNetworkErrorException, ProvisioningServerErrorException {
        Log.v(TAG, "prepareDrm: uuid: " + uuid + " mOnDrmConfigHelper: " + this.mOnDrmConfigHelper);
        boolean allDoneWithoutProvisioning = false;
        OnDrmPreparedHandlerDelegate onDrmPreparedHandlerDelegate = null;
        Object object = this.mDrmLock;
        synchronized (object) {
            if (this.mDrmInfo == null) {
                String msg = "prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.";
                Log.e(TAG, "prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.");
                throw new IllegalStateException("prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.");
            }
            if (this.mActiveDrmScheme) {
                String msg = "prepareDrm(): Wrong usage: There is already an active DRM scheme with " + this.mDrmUUID;
                Log.e(TAG, msg);
                throw new IllegalStateException(msg);
            }
            if (this.mPrepareDrmInProgress) {
                String msg = "prepareDrm(): Wrong usage: There is already a pending prepareDrm call.";
                Log.e(TAG, "prepareDrm(): Wrong usage: There is already a pending prepareDrm call.");
                throw new IllegalStateException("prepareDrm(): Wrong usage: There is already a pending prepareDrm call.");
            }
            if (this.mDrmProvisioningInProgress) {
                String msg = "prepareDrm(): Unexpectd: Provisioning is already in progress.";
                Log.e(TAG, "prepareDrm(): Unexpectd: Provisioning is already in progress.");
                throw new IllegalStateException("prepareDrm(): Unexpectd: Provisioning is already in progress.");
            }
            this.cleanDrmObj();
            this.mPrepareDrmInProgress = true;
            onDrmPreparedHandlerDelegate = this.mOnDrmPreparedHandlerDelegate;
            try {
                this.prepareDrm_createDrmStep(uuid);
            }
            catch (Exception e) {
                Log.w(TAG, "prepareDrm(): Exception ", e);
                this.mPrepareDrmInProgress = false;
                throw e;
            }
            this.mDrmConfigAllowed = true;
        }
        if (this.mOnDrmConfigHelper != null) {
            this.mOnDrmConfigHelper.onDrmConfig(this);
        }
        object = this.mDrmLock;
        synchronized (object) {
            this.mDrmConfigAllowed = false;
            boolean earlyExit = false;
            try {
                this.prepareDrm_openSessionStep(uuid);
                this.mDrmUUID = uuid;
                this.mActiveDrmScheme = true;
                allDoneWithoutProvisioning = true;
            }
            catch (IllegalStateException e) {
                String msg = "prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().";
                Log.e(TAG, "prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().");
                earlyExit = true;
                throw new IllegalStateException("prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().");
            }
            catch (NotProvisionedException e) {
                Log.w(TAG, "prepareDrm: NotProvisionedException");
                int result = this.HandleProvisioninig(uuid);
                if (result != 0) {
                    earlyExit = true;
                    switch (result) {
                        case 1: {
                            String msg = "prepareDrm: Provisioning was required but failed due to a network error.";
                            Log.e(TAG, msg);
                            throw new ProvisioningNetworkErrorException(msg);
                        }
                        case 2: {
                            String msg = "prepareDrm: Provisioning was required but the request was denied by the server.";
                            Log.e(TAG, msg);
                            throw new ProvisioningServerErrorException(msg);
                        }
                    }
                    String msg = "prepareDrm: Post-provisioning preparation failed.";
                    Log.e(TAG, msg);
                    throw new IllegalStateException(msg);
                }
            }
            catch (Exception e) {
                Log.e(TAG, "prepareDrm Exception", e);
                earlyExit = true;
                throw e;
            }
            finally {
                if (!this.mDrmProvisioningInProgress) {
                    this.mPrepareDrmInProgress = false;
                }
                if (earlyExit) {
                    this.cleanDrmObj();
                }
            }
        }
        if (allDoneWithoutProvisioning && onDrmPreparedHandlerDelegate != null) {
            onDrmPreparedHandlerDelegate.notifyClient(0);
        }
    }

    private void _releaseDrm() {
        OverrideMethod.invokeV("android.media.MediaPlayer#_releaseDrm()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDrm() throws NoDrmSchemeException {
        Log.v(TAG, "releaseDrm:");
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e(TAG, "releaseDrm(): No active DRM scheme to release.");
                throw new NoDrmSchemeException("releaseDrm: No active DRM scheme to release.");
            }
            try {
                this._releaseDrm();
                this.cleanDrmObj();
                this.mActiveDrmScheme = false;
            }
            catch (IllegalStateException e) {
                Log.w(TAG, "releaseDrm: Exception ", e);
                throw new IllegalStateException("releaseDrm: The player is not in a valid state.");
            }
            catch (Exception e) {
                Log.e(TAG, "releaseDrm: Exception ", e);
            }
        }
    }

    @NonNull
    public MediaDrm.KeyRequest getKeyRequest(@Nullable byte[] keySetId, @Nullable byte[] initData, @Nullable String mimeType, int keyType, @Nullable Map<String, String> optionalParameters) throws NoDrmSchemeException {
        Log.v(TAG, "getKeyRequest:  keySetId: " + Arrays.toString(keySetId) + " initData:" + Arrays.toString(initData) + " mimeType: " + mimeType + " keyType: " + keyType + " optionalParameters: " + optionalParameters);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e(TAG, "getKeyRequest NoDrmSchemeException");
                throw new NoDrmSchemeException("getKeyRequest: Has to set a DRM scheme first.");
            }
            try {
                byte[] scope = keyType != 3 ? this.mDrmSessionId : keySetId;
                HashMap<String, String> hmapOptionalParameters = optionalParameters != null ? new HashMap<String, String>(optionalParameters) : null;
                MediaDrm.KeyRequest request = this.mDrmObj.getKeyRequest(scope, initData, mimeType, keyType, hmapOptionalParameters);
                Log.v(TAG, "getKeyRequest:   --> request: " + request);
                return request;
            }
            catch (NotProvisionedException e) {
                Log.w(TAG, "getKeyRequest NotProvisionedException: Unexpected. Shouldn't have reached here.");
                throw new IllegalStateException("getKeyRequest: Unexpected provisioning error.");
            }
            catch (Exception e) {
                Log.w(TAG, "getKeyRequest Exception", e);
                throw e;
            }
        }
    }

    public byte[] provideKeyResponse(@Nullable byte[] keySetId, @NonNull byte[] response) throws NoDrmSchemeException, DeniedByServerException {
        Log.v(TAG, "provideKeyResponse: keySetId: " + Arrays.toString(keySetId) + " response: " + Arrays.toString(response));
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e(TAG, "getKeyRequest NoDrmSchemeException");
                throw new NoDrmSchemeException("getKeyRequest: Has to set a DRM scheme first.");
            }
            try {
                byte[] scope = keySetId == null ? this.mDrmSessionId : keySetId;
                byte[] keySetResult = this.mDrmObj.provideKeyResponse(scope, response);
                Log.v(TAG, "provideKeyResponse: keySetId: " + Arrays.toString(keySetId) + " response: " + Arrays.toString(response) + " --> " + Arrays.toString(keySetResult));
                return keySetResult;
            }
            catch (NotProvisionedException e) {
                Log.w(TAG, "provideKeyResponse NotProvisionedException: Unexpected. Shouldn't have reached here.");
                throw new IllegalStateException("provideKeyResponse: Unexpected provisioning error.");
            }
            catch (Exception e) {
                Log.w(TAG, "provideKeyResponse Exception", e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreKeys(@NonNull byte[] keySetId) throws NoDrmSchemeException {
        Log.v(TAG, "restoreKeys: keySetId: " + Arrays.toString(keySetId));
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.w(TAG, "restoreKeys NoDrmSchemeException");
                throw new NoDrmSchemeException("restoreKeys: Has to set a DRM scheme first.");
            }
            try {
                this.mDrmObj.restoreKeys(this.mDrmSessionId, keySetId);
            }
            catch (Exception e) {
                Log.w(TAG, "restoreKeys Exception", e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public String getDrmPropertyString(@NonNull String propertyName) throws NoDrmSchemeException {
        String value;
        Log.v(TAG, "getDrmPropertyString: propertyName: " + propertyName);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme && !this.mDrmConfigAllowed) {
                Log.w(TAG, "getDrmPropertyString NoDrmSchemeException");
                throw new NoDrmSchemeException("getDrmPropertyString: Has to prepareDrm() first.");
            }
            try {
                value = this.mDrmObj.getPropertyString(propertyName);
            }
            catch (Exception e) {
                Log.w(TAG, "getDrmPropertyString Exception", e);
                throw e;
            }
        }
        Log.v(TAG, "getDrmPropertyString: propertyName: " + propertyName + " --> value: " + value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDrmPropertyString(@NonNull String propertyName, @NonNull String value) throws NoDrmSchemeException {
        Log.v(TAG, "setDrmPropertyString: propertyName: " + propertyName + " value: " + value);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme && !this.mDrmConfigAllowed) {
                Log.w(TAG, "setDrmPropertyString NoDrmSchemeException");
                throw new NoDrmSchemeException("setDrmPropertyString: Has to prepareDrm() first.");
            }
            try {
                this.mDrmObj.setPropertyString(propertyName, value);
            }
            catch (Exception e) {
                Log.w(TAG, "setDrmPropertyString Exception", e);
                throw e;
            }
        }
    }

    private void _prepareDrm(@NonNull byte[] byArray, @NonNull byte[] byArray2) {
        OverrideMethod.invokeV("android.media.MediaPlayer#_prepareDrm([B[B)V", true, this);
    }

    private void prepareDrm_createDrmStep(@NonNull UUID uuid) throws UnsupportedSchemeException {
        Log.v(TAG, "prepareDrm_createDrmStep: UUID: " + uuid);
        try {
            this.mDrmObj = new MediaDrm(uuid);
            Log.v(TAG, "prepareDrm_createDrmStep: Created mDrmObj=" + this.mDrmObj);
        }
        catch (Exception e) {
            Log.e(TAG, "prepareDrm_createDrmStep: MediaDrm failed", e);
            throw e;
        }
    }

    private void prepareDrm_openSessionStep(@NonNull UUID uuid) throws NotProvisionedException, ResourceBusyException {
        Log.v(TAG, "prepareDrm_openSessionStep: uuid: " + uuid);
        try {
            this.mDrmSessionId = this.mDrmObj.openSession();
            Log.v(TAG, "prepareDrm_openSessionStep: mDrmSessionId=" + Arrays.toString(this.mDrmSessionId));
            this._prepareDrm(MediaPlayer.getByteArrayFromUUID(uuid), this.mDrmSessionId);
            Log.v(TAG, "prepareDrm_openSessionStep: _prepareDrm/Crypto succeeded");
        }
        catch (Exception e) {
            Log.e(TAG, "prepareDrm_openSessionStep: open/crypto failed", e);
            throw e;
        }
    }

    private int HandleProvisioninig(UUID uuid) {
        int result;
        if (this.mDrmProvisioningInProgress) {
            Log.e(TAG, "HandleProvisioninig: Unexpected mDrmProvisioningInProgress");
            return 3;
        }
        MediaDrm.ProvisionRequest provReq = this.mDrmObj.getProvisionRequest();
        if (provReq == null) {
            Log.e(TAG, "HandleProvisioninig: getProvisionRequest returned null.");
            return 3;
        }
        Log.v(TAG, "HandleProvisioninig provReq  data: " + Arrays.toString(provReq.getData()) + " url: " + provReq.getDefaultUrl());
        this.mDrmProvisioningInProgress = true;
        this.mDrmProvisioningThread = new ProvisioningThread().initialize(provReq, uuid, this);
        this.mDrmProvisioningThread.start();
        if (this.mOnDrmPreparedHandlerDelegate != null) {
            result = 0;
        } else {
            try {
                this.mDrmProvisioningThread.join();
            }
            catch (Exception e) {
                Log.w(TAG, "HandleProvisioninig: Thread.join Exception", e);
            }
            result = this.mDrmProvisioningThread.status();
            this.mDrmProvisioningThread = null;
        }
        return result;
    }

    private boolean resumePrepareDrm(UUID uuid) {
        Log.v(TAG, "resumePrepareDrm: uuid: " + uuid);
        boolean success = false;
        try {
            this.prepareDrm_openSessionStep(uuid);
            this.mDrmUUID = uuid;
            this.mActiveDrmScheme = true;
            success = true;
        }
        catch (Exception e) {
            Log.w(TAG, "HandleProvisioninig: Thread run _prepareDrm resume failed", e);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDrmState() {
        Object object = this.mDrmLock;
        synchronized (object) {
            Log.v(TAG, "resetDrmState:  mDrmInfo=" + this.mDrmInfo + " mDrmProvisioningThread=" + this.mDrmProvisioningThread + " mPrepareDrmInProgress=" + this.mPrepareDrmInProgress + " mActiveDrmScheme=" + this.mActiveDrmScheme);
            this.mDrmInfoResolved = false;
            this.mDrmInfo = null;
            if (this.mDrmProvisioningThread != null) {
                try {
                    this.mDrmProvisioningThread.join();
                }
                catch (InterruptedException e) {
                    Log.w(TAG, "resetDrmState: ProvThread.join Exception", e);
                }
                this.mDrmProvisioningThread = null;
            }
            this.mPrepareDrmInProgress = false;
            this.mActiveDrmScheme = false;
            this.cleanDrmObj();
        }
    }

    private void cleanDrmObj() {
        Log.v(TAG, "cleanDrmObj: mDrmObj=" + this.mDrmObj + " mDrmSessionId=" + Arrays.toString(this.mDrmSessionId));
        if (this.mDrmSessionId != null) {
            this.mDrmObj.closeSession(this.mDrmSessionId);
            this.mDrmSessionId = null;
        }
        if (this.mDrmObj != null) {
            this.mDrmObj.release();
            this.mDrmObj = null;
        }
    }

    private static byte[] getByteArrayFromUUID(@NonNull UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private boolean isVideoScalingModeSupported(int mode) {
        return mode == 1 || mode == 2;
    }

    static {
        System_Delegate.loadLibrary("media_jni");
        MediaPlayer.native_init();
    }

    public static interface OnSubtitleDataListener {
        public void onSubtitleData(@NonNull MediaPlayer var1, @NonNull SubtitleData var2);
    }

    public static interface OnCompletionListener {
        public void onCompletion(MediaPlayer var1);
    }

    private class EventHandler
    extends Handler {
        private MediaPlayer mMediaPlayer;

        public EventHandler(MediaPlayer mp, Looper looper) {
            super(looper);
            this.mMediaPlayer = mp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message msg) {
            if (this.mMediaPlayer.mNativeContext == 0L) {
                Log.w(MediaPlayer.TAG, "mediaplayer went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 1: {
                    try {
                        MediaPlayer.this.scanInternalSubtitleTracks();
                    }
                    catch (RuntimeException e) {
                        Message msg2 = this.obtainMessage(100, 1, -1010, null);
                        this.sendMessage(msg2);
                    }
                    OnPreparedListener onPreparedListener = MediaPlayer.this.mOnPreparedListener;
                    if (onPreparedListener == null) return;
                    onPreparedListener.onPrepared(this.mMediaPlayer);
                    return;
                }
                case 210: {
                    Log.v(MediaPlayer.TAG, "MEDIA_DRM_INFO " + MediaPlayer.this.mOnDrmInfoHandlerDelegate);
                    if (msg.obj == null) {
                        Log.w(MediaPlayer.TAG, "MEDIA_DRM_INFO msg.obj=NULL");
                        return;
                    }
                    if (msg.obj instanceof Parcel) {
                        OnDrmInfoHandlerDelegate onDrmInfoHandlerDelegate;
                        DrmInfo drmInfo = null;
                        Object object = MediaPlayer.this.mDrmLock;
                        synchronized (object) {
                            if (MediaPlayer.this.mOnDrmInfoHandlerDelegate != null && MediaPlayer.this.mDrmInfo != null) {
                                drmInfo = MediaPlayer.this.mDrmInfo.makeCopy();
                            }
                            onDrmInfoHandlerDelegate = MediaPlayer.this.mOnDrmInfoHandlerDelegate;
                        }
                        if (onDrmInfoHandlerDelegate == null) return;
                        onDrmInfoHandlerDelegate.notifyClient(drmInfo);
                        return;
                    }
                    Log.w(MediaPlayer.TAG, "MEDIA_DRM_INFO msg.obj of unexpected type " + msg.obj);
                    return;
                }
                case 2: {
                    MediaPlayer.this.mOnCompletionInternalListener.onCompletion(this.mMediaPlayer);
                    OnCompletionListener onCompletionListener = MediaPlayer.this.mOnCompletionListener;
                    if (onCompletionListener != null) {
                        onCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 8: {
                    TimeProvider timeProvider = MediaPlayer.this.mTimeProvider;
                    if (timeProvider == null) return;
                    timeProvider.onStopped();
                    return;
                }
                case 6: 
                case 7: {
                    TimeProvider timeProvider = MediaPlayer.this.mTimeProvider;
                    if (timeProvider == null) return;
                    timeProvider.onPaused(msg.what == 7);
                    return;
                }
                case 3: {
                    OnBufferingUpdateListener onBufferingUpdateListener = MediaPlayer.this.mOnBufferingUpdateListener;
                    if (onBufferingUpdateListener == null) return;
                    onBufferingUpdateListener.onBufferingUpdate(this.mMediaPlayer, msg.arg1);
                    return;
                }
                case 4: {
                    OnSeekCompleteListener onSeekCompleteListener = MediaPlayer.this.mOnSeekCompleteListener;
                    if (onSeekCompleteListener != null) {
                        onSeekCompleteListener.onSeekComplete(this.mMediaPlayer);
                    }
                }
                case 9: {
                    TimeProvider timeProvider = MediaPlayer.this.mTimeProvider;
                    if (timeProvider == null) return;
                    timeProvider.onSeekComplete(this.mMediaPlayer);
                    return;
                }
                case 5: {
                    OnVideoSizeChangedListener onVideoSizeChangedListener = MediaPlayer.this.mOnVideoSizeChangedListener;
                    if (onVideoSizeChangedListener == null) return;
                    onVideoSizeChangedListener.onVideoSizeChanged(this.mMediaPlayer, msg.arg1, msg.arg2);
                    return;
                }
                case 100: {
                    Log.e(MediaPlayer.TAG, "Error (" + msg.arg1 + "," + msg.arg2 + ")");
                    boolean error_was_handled = false;
                    OnErrorListener onErrorListener = MediaPlayer.this.mOnErrorListener;
                    if (onErrorListener != null) {
                        error_was_handled = onErrorListener.onError(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    MediaPlayer.this.mOnCompletionInternalListener.onCompletion(this.mMediaPlayer);
                    OnCompletionListener onCompletionListener = MediaPlayer.this.mOnCompletionListener;
                    if (onCompletionListener != null && !error_was_handled) {
                        onCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 200: {
                    switch (msg.arg1) {
                        case 700: {
                            Log.i(MediaPlayer.TAG, "Info (" + msg.arg1 + "," + msg.arg2 + ")");
                            break;
                        }
                        case 802: {
                            try {
                                MediaPlayer.this.scanInternalSubtitleTracks();
                            }
                            catch (RuntimeException e) {
                                Message msg2 = this.obtainMessage(100, 1, -1010, null);
                                this.sendMessage(msg2);
                            }
                        }
                        case 803: {
                            msg.arg1 = 802;
                            if (MediaPlayer.this.mSubtitleController == null) break;
                            MediaPlayer.this.mSubtitleController.selectDefaultTrack();
                            break;
                        }
                        case 701: 
                        case 702: {
                            TimeProvider timeProvider = MediaPlayer.this.mTimeProvider;
                            if (timeProvider == null) break;
                            timeProvider.onBuffering(msg.arg1 == 701);
                        }
                    }
                    OnInfoListener onInfoListener = MediaPlayer.this.mOnInfoListener;
                    if (onInfoListener == null) return;
                    onInfoListener.onInfo(this.mMediaPlayer, msg.arg1, msg.arg2);
                    return;
                }
                case 98: {
                    TimeProvider timeProvider = MediaPlayer.this.mTimeProvider;
                    if (timeProvider == null) return;
                    timeProvider.onNotifyTime();
                    return;
                }
                case 99: {
                    OnTimedTextListener onTimedTextListener = MediaPlayer.this.mOnTimedTextListener;
                    if (onTimedTextListener == null) {
                        return;
                    }
                    if (msg.obj == null) {
                        onTimedTextListener.onTimedText(this.mMediaPlayer, null);
                        return;
                    } else {
                        if (!(msg.obj instanceof Parcel)) return;
                        Parcel parcel = (Parcel)msg.obj;
                        TimedText text = new TimedText(parcel);
                        parcel.recycle();
                        onTimedTextListener.onTimedText(this.mMediaPlayer, text);
                    }
                    return;
                }
                case 201: {
                    Handler extSubtitleHandler;
                    OnSubtitleDataListener extSubtitleListener;
                    EventHandler eventHandler = this;
                    synchronized (eventHandler) {
                        if (MediaPlayer.this.mSubtitleDataListenerDisabled) {
                            return;
                        }
                        extSubtitleListener = MediaPlayer.this.mExtSubtitleDataListener;
                        extSubtitleHandler = MediaPlayer.this.mExtSubtitleDataHandler;
                    }
                    if (!(msg.obj instanceof Parcel)) return;
                    Parcel parcel = (Parcel)msg.obj;
                    final SubtitleData data = new SubtitleData(parcel);
                    parcel.recycle();
                    MediaPlayer.this.mIntSubtitleDataListener.onSubtitleData(this.mMediaPlayer, data);
                    if (extSubtitleListener == null) return;
                    if (extSubtitleHandler == null) {
                        extSubtitleListener.onSubtitleData(this.mMediaPlayer, data);
                        return;
                    } else {
                        extSubtitleHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                extSubtitleListener.onSubtitleData(EventHandler.this.mMediaPlayer, data);
                            }
                        });
                    }
                    return;
                }
                case 202: {
                    OnTimedMetaDataAvailableListener onTimedMetaDataAvailableListener = MediaPlayer.this.mOnTimedMetaDataAvailableListener;
                    if (onTimedMetaDataAvailableListener == null) {
                        return;
                    }
                    if (!(msg.obj instanceof Parcel)) return;
                    Parcel parcel = (Parcel)msg.obj;
                    TimedMetaData data = TimedMetaData.createTimedMetaDataFromParcel(parcel);
                    parcel.recycle();
                    onTimedMetaDataAvailableListener.onTimedMetaDataAvailable(this.mMediaPlayer, data);
                    return;
                }
                case 0: {
                    return;
                }
                case 10000: {
                    MediaPlayer.this.broadcastRoutingChange();
                    return;
                }
                case 211: {
                    Handler mediaTimeHandler;
                    OnMediaTimeDiscontinuityListener mediaTimeListener;
                    EventHandler eventHandler = this;
                    synchronized (eventHandler) {
                        mediaTimeListener = MediaPlayer.this.mOnMediaTimeDiscontinuityListener;
                        mediaTimeHandler = MediaPlayer.this.mOnMediaTimeDiscontinuityHandler;
                    }
                    if (mediaTimeListener == null) {
                        return;
                    }
                    if (!(msg.obj instanceof Parcel)) return;
                    Parcel parcel = (Parcel)msg.obj;
                    parcel.setDataPosition(0);
                    long anchorMediaUs = parcel.readLong();
                    long anchorRealUs = parcel.readLong();
                    float playbackRate = parcel.readFloat();
                    parcel.recycle();
                    final MediaTimestamp timestamp = anchorMediaUs != -1L && anchorRealUs != -1L ? new MediaTimestamp(anchorMediaUs, anchorRealUs * 1000L, playbackRate) : MediaTimestamp.TIMESTAMP_UNKNOWN;
                    if (mediaTimeHandler == null) {
                        mediaTimeListener.onMediaTimeDiscontinuity(this.mMediaPlayer, timestamp);
                        return;
                    } else {
                        mediaTimeHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                mediaTimeListener.onMediaTimeDiscontinuity(EventHandler.this.mMediaPlayer, timestamp);
                            }
                        });
                    }
                    return;
                }
                case 300: {
                    int[] data;
                    int noticeType;
                    OnRtpRxNoticeListener rtpRxNoticeListener = MediaPlayer.this.mOnRtpRxNoticeListener;
                    if (rtpRxNoticeListener == null) {
                        return;
                    }
                    if (!(msg.obj instanceof Parcel)) return;
                    Parcel parcel = (Parcel)msg.obj;
                    parcel.setDataPosition(0);
                    try {
                        noticeType = parcel.readInt();
                        int numOfArgs = parcel.dataAvail() / 4;
                        data = new int[numOfArgs];
                        for (int i = 0; i < numOfArgs; ++i) {
                            data[i] = parcel.readInt();
                        }
                    }
                    finally {
                        parcel.recycle();
                    }
                    MediaPlayer.this.mOnRtpRxNoticeExecutor.execute(() -> rtpRxNoticeListener.onRtpRxNotice(this.mMediaPlayer, noticeType, data));
                    return;
                }
                default: {
                    Log.e(MediaPlayer.TAG, "Unknown message type " + msg.what);
                    return;
                }
            }
        }
    }

    static class TimeProvider
    implements OnSeekCompleteListener,
    MediaTimeProvider {
        private static final String TAG = "MTP";
        private static final long MAX_NS_WITHOUT_POSITION_CHECK = 5000000000L;
        private static final long MAX_EARLY_CALLBACK_US = 1000L;
        private static final long TIME_ADJUSTMENT_RATE = 2L;
        private long mLastTimeUs = 0L;
        private MediaPlayer mPlayer;
        private boolean mPaused = true;
        private boolean mStopped = true;
        private boolean mBuffering;
        private long mLastReportedTime;
        private MediaTimeProvider.OnMediaTimeListener[] mListeners;
        private long[] mTimes;
        private Handler mEventHandler;
        private boolean mRefresh = false;
        private boolean mPausing = false;
        private boolean mSeeking = false;
        private static final int NOTIFY = 1;
        private static final int NOTIFY_TIME = 0;
        private static final int NOTIFY_STOP = 2;
        private static final int NOTIFY_SEEK = 3;
        private static final int NOTIFY_TRACK_DATA = 4;
        private HandlerThread mHandlerThread;
        public boolean DEBUG = false;

        public TimeProvider(MediaPlayer mp) {
            this.mPlayer = mp;
            try {
                this.getCurrentTimeUs(true, false);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
            }
            Looper looper = Looper.myLooper();
            if (looper == null && (looper = Looper.getMainLooper()) == null) {
                this.mHandlerThread = new HandlerThread("MediaPlayerMTPEventThread", -2);
                this.mHandlerThread.start();
                looper = this.mHandlerThread.getLooper();
            }
            this.mEventHandler = new EventHandler(looper);
            this.mListeners = new MediaTimeProvider.OnMediaTimeListener[0];
            this.mTimes = new long[0];
            this.mLastTimeUs = 0L;
        }

        private void scheduleNotification(int type, long delayUs) {
            if (this.mSeeking && type == 0) {
                return;
            }
            if (this.DEBUG) {
                Log.v(TAG, "scheduleNotification " + type + " in " + delayUs);
            }
            this.mEventHandler.removeMessages(1);
            Message msg = this.mEventHandler.obtainMessage(1, type, 0);
            this.mEventHandler.sendMessageDelayed(msg, (int)(delayUs / 1000L));
        }

        public void close() {
            this.mEventHandler.removeMessages(1);
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread = null;
            }
        }

        protected void finalize() {
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNotifyTime() {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onNotifyTime: ");
                }
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPaused(boolean paused) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onPaused: " + paused);
                }
                if (this.mStopped) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.scheduleNotification(3, 0L);
                } else {
                    this.mPausing = paused;
                    this.mSeeking = false;
                    this.scheduleNotification(0, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBuffering(boolean buffering) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onBuffering: " + buffering);
                }
                this.mBuffering = buffering;
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStopped() {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onStopped");
                }
                this.mPaused = true;
                this.mStopped = true;
                this.mSeeking = false;
                this.mBuffering = false;
                this.scheduleNotification(2, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSeekComplete(MediaPlayer mp) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                this.mStopped = false;
                this.mSeeking = true;
                this.scheduleNotification(3, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNewPlayer() {
            if (this.mRefresh) {
                TimeProvider timeProvider = this;
                synchronized (timeProvider) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.mBuffering = false;
                    this.scheduleNotification(3, 0L);
                }
            }
        }

        private synchronized void notifySeek() {
            this.mSeeking = false;
            try {
                long timeUs = this.getCurrentTimeUs(true, false);
                if (this.DEBUG) {
                    Log.d(TAG, "onSeekComplete at " + timeUs);
                }
                for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                    if (listener == null) break;
                    listener.onSeek(timeUs);
                }
            }
            catch (IllegalStateException e) {
                if (this.DEBUG) {
                    Log.d(TAG, "onSeekComplete but no player");
                }
                this.mPausing = true;
                this.notifyTimedEvent(false);
            }
        }

        private synchronized void notifyTrackData(Pair<SubtitleTrack, byte[]> trackData) {
            SubtitleTrack track = (SubtitleTrack)trackData.first;
            byte[] data = (byte[])trackData.second;
            track.onData(data, true, -1L);
        }

        private synchronized void notifyStop() {
            for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                if (listener == null) break;
                listener.onStop();
            }
        }

        private int registerListener(MediaTimeProvider.OnMediaTimeListener listener) {
            int i;
            for (i = 0; i < this.mListeners.length && this.mListeners[i] != listener && this.mListeners[i] != null; ++i) {
            }
            if (i >= this.mListeners.length) {
                MediaTimeProvider.OnMediaTimeListener[] newListeners = new MediaTimeProvider.OnMediaTimeListener[i + 1];
                long[] newTimes = new long[i + 1];
                System.arraycopy(this.mListeners, 0, newListeners, 0, this.mListeners.length);
                System.arraycopy(this.mTimes, 0, newTimes, 0, this.mTimes.length);
                this.mListeners = newListeners;
                this.mTimes = newTimes;
            }
            if (this.mListeners[i] == null) {
                this.mListeners[i] = listener;
                this.mTimes[i] = -1L;
            }
            return i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyAt(long timeUs, MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "notifyAt " + timeUs);
                }
                this.mTimes[this.registerListener((MediaTimeProvider.OnMediaTimeListener)listener)] = timeUs;
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleUpdate(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "scheduleUpdate");
                }
                int i = this.registerListener(listener);
                if (!this.mStopped) {
                    this.mTimes[i] = 0L;
                    this.scheduleNotification(0, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelNotifications(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                for (int i = 0; i < this.mListeners.length; ++i) {
                    if (this.mListeners[i] == listener) {
                        System.arraycopy(this.mListeners, i + 1, this.mListeners, i, this.mListeners.length - i - 1);
                        System.arraycopy(this.mTimes, i + 1, this.mTimes, i, this.mTimes.length - i - 1);
                        this.mListeners[this.mListeners.length - 1] = null;
                        this.mTimes[this.mTimes.length - 1] = -1L;
                        break;
                    }
                    if (this.mListeners[i] == null) break;
                }
                this.scheduleNotification(0, 0L);
            }
        }

        private synchronized void notifyTimedEvent(boolean refreshTime) {
            long nowUs;
            try {
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
                this.mPausing = true;
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            long nextTimeUs = nowUs;
            if (this.mSeeking) {
                return;
            }
            if (this.DEBUG) {
                StringBuilder sb = new StringBuilder();
                sb.append("notifyTimedEvent(").append(this.mLastTimeUs).append(" -> ").append(nowUs).append(") from {");
                boolean first = true;
                for (long time : this.mTimes) {
                    if (time == -1L) continue;
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(time);
                    first = false;
                }
                sb.append("}");
                Log.d(TAG, sb.toString());
            }
            Vector<MediaTimeProvider.OnMediaTimeListener> activatedListeners = new Vector<MediaTimeProvider.OnMediaTimeListener>();
            for (int ix = 0; ix < this.mTimes.length && this.mListeners[ix] != null; ++ix) {
                if (this.mTimes[ix] <= -1L) continue;
                if (this.mTimes[ix] <= nowUs + 1000L) {
                    activatedListeners.add(this.mListeners[ix]);
                    if (this.DEBUG) {
                        Log.d(TAG, "removed");
                    }
                    this.mTimes[ix] = -1L;
                    continue;
                }
                if (nextTimeUs != nowUs && this.mTimes[ix] >= nextTimeUs) continue;
                nextTimeUs = this.mTimes[ix];
            }
            if (nextTimeUs > nowUs && !this.mPaused) {
                if (this.DEBUG) {
                    Log.d(TAG, "scheduling for " + nextTimeUs + " and " + nowUs);
                }
                this.mPlayer.notifyAt(nextTimeUs);
            } else {
                this.mEventHandler.removeMessages(1);
            }
            for (MediaTimeProvider.OnMediaTimeListener listener : activatedListeners) {
                listener.onTimedEvent(nowUs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCurrentTimeUs(boolean refreshTime, boolean monotonic) throws IllegalStateException {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.mPaused && !refreshTime) {
                    return this.mLastReportedTime;
                }
                try {
                    this.mLastTimeUs = (long)this.mPlayer.getCurrentPosition() * 1000L;
                    boolean bl = this.mPaused = !this.mPlayer.isPlaying() || this.mBuffering;
                    if (this.DEBUG) {
                        Log.v(TAG, (this.mPaused ? "paused" : "playing") + " at " + this.mLastTimeUs);
                    }
                }
                catch (IllegalStateException e) {
                    if (this.mPausing) {
                        this.mPausing = false;
                        if (!monotonic || this.mLastReportedTime < this.mLastTimeUs) {
                            this.mLastReportedTime = this.mLastTimeUs;
                        }
                        this.mPaused = true;
                        if (this.DEBUG) {
                            Log.d(TAG, "illegal state, but pausing: estimating at " + this.mLastReportedTime);
                        }
                        return this.mLastReportedTime;
                    }
                    throw e;
                }
                if (monotonic && this.mLastTimeUs < this.mLastReportedTime) {
                    if (this.mLastReportedTime - this.mLastTimeUs > 1000000L) {
                        this.mStopped = false;
                        this.mSeeking = true;
                        this.scheduleNotification(3, 0L);
                    }
                } else {
                    this.mLastReportedTime = this.mLastTimeUs;
                }
                return this.mLastReportedTime;
            }
        }

        private class EventHandler
        extends Handler {
            public EventHandler(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message msg) {
                if (msg.what == 1) {
                    switch (msg.arg1) {
                        case 0: {
                            TimeProvider.this.notifyTimedEvent(true);
                            break;
                        }
                        case 2: {
                            TimeProvider.this.notifyStop();
                            break;
                        }
                        case 3: {
                            TimeProvider.this.notifySeek();
                            break;
                        }
                        case 4: {
                            TimeProvider.this.notifyTrackData((Pair)msg.obj);
                        }
                    }
                }
            }
        }
    }

    public static interface OnPreparedListener {
        public void onPrepared(MediaPlayer var1);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(MediaPlayer var1, int var2);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(MediaPlayer var1);
    }

    public static interface OnErrorListener {
        public boolean onError(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnInfoListener {
        public boolean onInfo(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnTimedTextListener {
        public void onTimedText(MediaPlayer var1, TimedText var2);
    }

    @SystemApi
    public static interface OnRtpRxNoticeListener {
        public void onRtpRxNotice(@NonNull MediaPlayer var1, int var2, @NonNull int[] var3);
    }

    public static interface OnMediaTimeDiscontinuityListener {
        public void onMediaTimeDiscontinuity(@NonNull MediaPlayer var1, @NonNull MediaTimestamp var2);
    }

    public static interface OnDrmConfigHelper {
        public void onDrmConfig(MediaPlayer var1);
    }

    private class OnDrmInfoHandlerDelegate {
        private MediaPlayer mMediaPlayer;
        private OnDrmInfoListener mOnDrmInfoListener;
        private Handler mHandler;

        OnDrmInfoHandlerDelegate(MediaPlayer mediaPlayer, MediaPlayer mp, OnDrmInfoListener listener, Handler handler) {
            this.mMediaPlayer = mp;
            this.mOnDrmInfoListener = listener;
            if (handler != null) {
                this.mHandler = handler;
            }
        }

        void notifyClient(final DrmInfo drmInfo) {
            if (this.mHandler != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        OnDrmInfoHandlerDelegate.this.mOnDrmInfoListener.onDrmInfo(OnDrmInfoHandlerDelegate.this.mMediaPlayer, drmInfo);
                    }
                });
            } else {
                this.mOnDrmInfoListener.onDrmInfo(this.mMediaPlayer, drmInfo);
            }
        }
    }

    private class OnDrmPreparedHandlerDelegate {
        private MediaPlayer mMediaPlayer;
        private OnDrmPreparedListener mOnDrmPreparedListener;
        private Handler mHandler;

        OnDrmPreparedHandlerDelegate(MediaPlayer mediaPlayer, MediaPlayer mp, OnDrmPreparedListener listener, Handler handler) {
            this.mMediaPlayer = mp;
            this.mOnDrmPreparedListener = listener;
            if (handler != null) {
                this.mHandler = handler;
            } else if (mediaPlayer.mEventHandler != null) {
                this.mHandler = mediaPlayer.mEventHandler;
            } else {
                Log.e(MediaPlayer.TAG, "OnDrmPreparedHandlerDelegate: Unexpected null mEventHandler");
            }
        }

        void notifyClient(final int status) {
            if (this.mHandler != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        OnDrmPreparedHandlerDelegate.this.mOnDrmPreparedListener.onDrmPrepared(OnDrmPreparedHandlerDelegate.this.mMediaPlayer, status);
                    }
                });
            } else {
                Log.e(MediaPlayer.TAG, "OnDrmPreparedHandlerDelegate:notifyClient: Unexpected null mHandler");
            }
        }
    }

    public static class TrackInfo
    implements Parcelable {
        public static final int MEDIA_TRACK_TYPE_UNKNOWN = 0;
        public static final int MEDIA_TRACK_TYPE_VIDEO = 1;
        public static final int MEDIA_TRACK_TYPE_AUDIO = 2;
        public static final int MEDIA_TRACK_TYPE_TIMEDTEXT = 3;
        public static final int MEDIA_TRACK_TYPE_SUBTITLE = 4;
        public static final int MEDIA_TRACK_TYPE_METADATA = 5;
        final int mTrackType;
        final MediaFormat mFormat;
        @UnsupportedAppUsage
        @NonNull
        static final Parcelable.Creator<TrackInfo> CREATOR = new Parcelable.Creator<TrackInfo>(){

            @Override
            public TrackInfo createFromParcel(Parcel in) {
                return new TrackInfo(in);
            }

            public TrackInfo[] newArray(int size) {
                return new TrackInfo[size];
            }
        };

        public int getTrackType() {
            return this.mTrackType;
        }

        public String getLanguage() {
            String language = this.mFormat.getString("language");
            return language == null ? "und" : language;
        }

        public boolean hasHapticChannels() {
            return this.mFormat != null && this.mFormat.containsKey("haptic-channel-count") && this.mFormat.getInteger("haptic-channel-count") > 0;
        }

        public MediaFormat getFormat() {
            if (this.mTrackType == 3 || this.mTrackType == 4) {
                return this.mFormat;
            }
            return null;
        }

        TrackInfo(Parcel in) {
            boolean hasHapticChannels;
            this.mTrackType = in.readInt();
            String mime = in.readString();
            String language = in.readString();
            this.mFormat = MediaFormat.createSubtitleFormat(mime, language);
            if (this.mTrackType == 4) {
                this.mFormat.setInteger("is-autoselect", in.readInt());
                this.mFormat.setInteger("is-default", in.readInt());
                this.mFormat.setInteger("is-forced-subtitle", in.readInt());
            } else if (this.mTrackType == 2 && (hasHapticChannels = in.readBoolean())) {
                this.mFormat.setInteger("haptic-channel-count", in.readInt());
            }
        }

        TrackInfo(int type, MediaFormat format) {
            this.mTrackType = type;
            this.mFormat = format;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mTrackType);
            dest.writeString(this.mFormat.getString("mime"));
            dest.writeString(this.getLanguage());
            if (this.mTrackType == 4) {
                dest.writeInt(this.mFormat.getInteger("is-autoselect"));
                dest.writeInt(this.mFormat.getInteger("is-default"));
                dest.writeInt(this.mFormat.getInteger("is-forced-subtitle"));
            } else if (this.mTrackType == 2) {
                boolean hasHapticChannels = this.mFormat.containsKey("haptic-channel-count");
                dest.writeBoolean(hasHapticChannels);
                if (hasHapticChannels) {
                    dest.writeInt(this.mFormat.getInteger("haptic-channel-count"));
                }
            }
        }

        public String toString() {
            StringBuilder out = new StringBuilder(128);
            out.append(this.getClass().getName());
            out.append('{');
            switch (this.mTrackType) {
                case 1: {
                    out.append("VIDEO");
                    break;
                }
                case 2: {
                    out.append("AUDIO");
                    break;
                }
                case 3: {
                    out.append("TIMEDTEXT");
                    break;
                }
                case 4: {
                    out.append("SUBTITLE");
                    break;
                }
                default: {
                    out.append("UNKNOWN");
                }
            }
            out.append(", " + this.mFormat.toString());
            out.append("}");
            return out.toString();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface TrackType {
        }
    }

    public static class DrmInfo {
        private Map<UUID, byte[]> mapPssh;
        private UUID[] supportedSchemes;

        public Map<UUID, byte[]> getPssh() {
            return this.mapPssh;
        }

        public UUID[] getSupportedSchemes() {
            return this.supportedSchemes;
        }

        private DrmInfo(Map<UUID, byte[]> Pssh, UUID[] SupportedSchemes) {
            this.mapPssh = Pssh;
            this.supportedSchemes = SupportedSchemes;
        }

        private DrmInfo(Parcel parcel) {
            Log.v(MediaPlayer.TAG, "DrmInfo(" + parcel + ") size " + parcel.dataSize());
            int psshsize = parcel.readInt();
            byte[] pssh = new byte[psshsize];
            parcel.readByteArray(pssh);
            Log.v(MediaPlayer.TAG, "DrmInfo() PSSH: " + this.arrToHex(pssh));
            this.mapPssh = this.parsePSSH(pssh, psshsize);
            Log.v(MediaPlayer.TAG, "DrmInfo() PSSH: " + this.mapPssh);
            int supportedDRMsCount = parcel.readInt();
            this.supportedSchemes = new UUID[supportedDRMsCount];
            for (int i = 0; i < supportedDRMsCount; ++i) {
                byte[] uuid = new byte[16];
                parcel.readByteArray(uuid);
                this.supportedSchemes[i] = this.bytesToUUID(uuid);
                Log.v(MediaPlayer.TAG, "DrmInfo() supportedScheme[" + i + "]: " + this.supportedSchemes[i]);
            }
            Log.v(MediaPlayer.TAG, "DrmInfo() Parcel psshsize: " + psshsize + " supportedDRMsCount: " + supportedDRMsCount);
        }

        private DrmInfo makeCopy() {
            return new DrmInfo(this.mapPssh, this.supportedSchemes);
        }

        private String arrToHex(byte[] bytes) {
            String out = "0x";
            for (int i = 0; i < bytes.length; ++i) {
                out = out + String.format("%02x", bytes[i]);
            }
            return out;
        }

        private UUID bytesToUUID(byte[] uuid) {
            long msb = 0L;
            long lsb = 0L;
            for (int i = 0; i < 8; ++i) {
                msb |= ((long)uuid[i] & 0xFFL) << 8 * (7 - i);
                lsb |= ((long)uuid[i + 8] & 0xFFL) << 8 * (7 - i);
            }
            return new UUID(msb, lsb);
        }

        private Map<UUID, byte[]> parsePSSH(byte[] pssh, int psshsize) {
            HashMap<UUID, byte[]> result = new HashMap<UUID, byte[]>();
            int UUID_SIZE = 16;
            int DATALEN_SIZE = 4;
            int len = psshsize;
            int numentries = 0;
            int i = 0;
            while (len > 0) {
                if (len < 16) {
                    Log.w(MediaPlayer.TAG, String.format("parsePSSH: len is too short to parse UUID: (%d < 16) pssh: %d", len, psshsize));
                    return null;
                }
                byte[] subset = Arrays.copyOfRange(pssh, i, i + 16);
                UUID uuid = this.bytesToUUID(subset);
                i += 16;
                if ((len -= 16) < 4) {
                    Log.w(MediaPlayer.TAG, String.format("parsePSSH: len is too short to parse datalen: (%d < 4) pssh: %d", len, psshsize));
                    return null;
                }
                subset = Arrays.copyOfRange(pssh, i, i + 4);
                int datalen = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (subset[3] & 0xFF) << 24 | (subset[2] & 0xFF) << 16 | (subset[1] & 0xFF) << 8 | subset[0] & 0xFF : (subset[0] & 0xFF) << 24 | (subset[1] & 0xFF) << 16 | (subset[2] & 0xFF) << 8 | subset[3] & 0xFF;
                i += 4;
                if ((len -= 4) < datalen) {
                    Log.w(MediaPlayer.TAG, String.format("parsePSSH: len is too short to parse data: (%d < %d) pssh: %d", len, datalen, psshsize));
                    return null;
                }
                byte[] data = Arrays.copyOfRange(pssh, i, i + datalen);
                i += datalen;
                len -= datalen;
                Log.v(MediaPlayer.TAG, String.format("parsePSSH[%d]: <%s, %s> pssh: %d", numentries, uuid, this.arrToHex(data), psshsize));
                ++numentries;
                result.put(uuid, data);
            }
            return result;
        }
    }

    public static interface OnTimedMetaDataAvailableListener {
        public void onTimedMetaDataAvailable(MediaPlayer var1, TimedMetaData var2);
    }

    public static interface OnDrmInfoListener {
        public void onDrmInfo(MediaPlayer var1, DrmInfo var2);
    }

    public static interface OnDrmPreparedListener {
        public void onDrmPrepared(MediaPlayer var1, int var2);
    }

    public static class ProvisioningNetworkErrorException
    extends MediaDrmException {
        public ProvisioningNetworkErrorException(String detailMessage) {
            super(detailMessage);
        }
    }

    public static class ProvisioningServerErrorException
    extends MediaDrmException {
        public ProvisioningServerErrorException(String detailMessage) {
            super(detailMessage);
        }
    }

    public static class NoDrmSchemeException
    extends MediaDrmException {
        public NoDrmSchemeException(String detailMessage) {
            super(detailMessage);
        }
    }

    private class ProvisioningThread
    extends Thread {
        public static final int TIMEOUT_MS = 60000;
        private UUID uuid;
        private String urlStr;
        private Object drmLock;
        private OnDrmPreparedHandlerDelegate onDrmPreparedHandlerDelegate;
        private MediaPlayer mediaPlayer;
        private int status;
        private boolean finished;

        private ProvisioningThread() {
        }

        public int status() {
            return this.status;
        }

        public ProvisioningThread initialize(MediaDrm.ProvisionRequest request, UUID uuid, MediaPlayer mediaPlayer) {
            this.drmLock = mediaPlayer.mDrmLock;
            this.onDrmPreparedHandlerDelegate = mediaPlayer.mOnDrmPreparedHandlerDelegate;
            this.mediaPlayer = mediaPlayer;
            this.urlStr = request.getDefaultUrl() + "&signedRequest=" + new String(request.getData());
            this.uuid = uuid;
            this.status = 3;
            Log.v(MediaPlayer.TAG, "HandleProvisioninig: Thread is initialised url: " + this.urlStr);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] response = null;
            boolean provisioningSucceeded = false;
            try {
                URL url = new URL(this.urlStr);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                try {
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(false);
                    connection.setDoInput(true);
                    connection.setConnectTimeout(60000);
                    connection.setReadTimeout(60000);
                    connection.connect();
                    response = Streams.readFully(connection.getInputStream());
                    Log.v(MediaPlayer.TAG, "HandleProvisioninig: Thread run: response " + response.length + " " + Arrays.toString(response));
                }
                catch (Exception e) {
                    this.status = 1;
                    Log.w(MediaPlayer.TAG, "HandleProvisioninig: Thread run: connect url: " + url, e);
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                this.status = 1;
                Log.w(MediaPlayer.TAG, "HandleProvisioninig: Thread run: openConnection", e);
            }
            if (response != null) {
                try {
                    MediaPlayer.this.mDrmObj.provideProvisionResponse(response);
                    Log.v(MediaPlayer.TAG, "HandleProvisioninig: Thread run: provideProvisionResponse SUCCEEDED!");
                    provisioningSucceeded = true;
                }
                catch (Exception e) {
                    this.status = 2;
                    Log.w(MediaPlayer.TAG, "HandleProvisioninig: Thread run: provideProvisionResponse", e);
                }
            }
            boolean succeeded = false;
            if (this.onDrmPreparedHandlerDelegate != null) {
                Object object = this.drmLock;
                synchronized (object) {
                    if (provisioningSucceeded) {
                        succeeded = this.mediaPlayer.resumePrepareDrm(this.uuid);
                        this.status = succeeded ? 0 : 3;
                    }
                    this.mediaPlayer.mDrmProvisioningInProgress = false;
                    this.mediaPlayer.mPrepareDrmInProgress = false;
                    if (!succeeded) {
                        MediaPlayer.this.cleanDrmObj();
                    }
                }
                this.onDrmPreparedHandlerDelegate.notifyClient(this.status);
            } else {
                if (provisioningSucceeded) {
                    succeeded = this.mediaPlayer.resumePrepareDrm(this.uuid);
                    this.status = succeeded ? 0 : 3;
                }
                this.mediaPlayer.mDrmProvisioningInProgress = false;
                this.mediaPlayer.mPrepareDrmInProgress = false;
                if (!succeeded) {
                    MediaPlayer.this.cleanDrmObj();
                }
            }
            this.finished = true;
        }
    }

    public static class MetricsConstants {
        public static final String MIME_TYPE_VIDEO = "android.media.mediaplayer.video.mime";
        public static final String CODEC_VIDEO = "android.media.mediaplayer.video.codec";
        public static final String WIDTH = "android.media.mediaplayer.width";
        public static final String HEIGHT = "android.media.mediaplayer.height";
        public static final String FRAMES = "android.media.mediaplayer.frames";
        public static final String FRAMES_DROPPED = "android.media.mediaplayer.dropped";
        public static final String MIME_TYPE_AUDIO = "android.media.mediaplayer.audio.mime";
        public static final String CODEC_AUDIO = "android.media.mediaplayer.audio.codec";
        public static final String DURATION = "android.media.mediaplayer.durationMs";
        public static final String PLAYING = "android.media.mediaplayer.playingMs";
        public static final String ERRORS = "android.media.mediaplayer.err";
        public static final String ERROR_CODE = "android.media.mediaplayer.errcode";

        private MetricsConstants() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrepareDrmStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeekMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlaybackRateAudioMode {
    }
}

