/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.media.AudioPresentation;
import android.media.AudioSystem;
import android.media.Image;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaDescrambler;
import android.media.MediaDrmThrowable;
import android.media.MediaFormat;
import android.media.Utils;
import android.media.quality.PictureProfile;
import android.media.quality.PictureProfileHandle;
import android.os.Bundle;
import android.os.Handler;
import android.os.IHwBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Trace;
import android.util.Log;
import android.view.Surface;
import com.android.internal.hidden_from_bootclasspath.android.media.codec.Flags;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.NioUtils_Delegate;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class MediaCodec {
    private static final String TAG = "MediaCodec";
    public static final int BUFFER_FLAG_SYNC_FRAME = 1;
    public static final int BUFFER_FLAG_KEY_FRAME = 1;
    public static final int BUFFER_FLAG_CODEC_CONFIG = 2;
    public static final int BUFFER_FLAG_END_OF_STREAM = 4;
    public static final int BUFFER_FLAG_PARTIAL_FRAME = 8;
    public static final int BUFFER_FLAG_MUXER_DATA = 16;
    public static final int BUFFER_FLAG_DECODE_ONLY = 32;
    private EventHandler mEventHandler;
    private EventHandler mOnFirstTunnelFrameReadyHandler;
    private EventHandler mOnFrameRenderedHandler;
    private EventHandler mCallbackHandler;
    private Callback mCallback;
    private OnFirstTunnelFrameReadyListener mOnFirstTunnelFrameReadyListener;
    private OnFrameRenderedListener mOnFrameRenderedListener;
    private final Object mListenerLock = new Object();
    private MediaCodecInfo mCodecInfo;
    private final Object mCodecInfoLock = new Object();
    private MediaCrypto mCrypto;
    private static final int EVENT_CALLBACK = 1;
    private static final int EVENT_SET_CALLBACK = 2;
    private static final int EVENT_FRAME_RENDERED = 3;
    private static final int EVENT_FIRST_TUNNEL_FRAME_READY = 4;
    private static final int CB_INPUT_AVAILABLE = 1;
    private static final int CB_OUTPUT_AVAILABLE = 2;
    private static final int CB_ERROR = 3;
    private static final int CB_OUTPUT_FORMAT_CHANGE = 4;
    private static final String EOS_AND_DECODE_ONLY_ERROR_MESSAGE = "An input buffer cannot have both BUFFER_FLAG_END_OF_STREAM and BUFFER_FLAG_DECODE_ONLY flags";
    private static final int CB_CRYPTO_ERROR = 6;
    private static final int CB_LARGE_FRAME_OUTPUT_AVAILABLE = 7;
    private static final int CB_METRICS_FLUSHED = 8;
    private static final int CB_REQUIRED_RESOURCES_CHANGE = 9;
    private boolean mHasSurface = false;
    private String mNameAtCreation;
    public static final int CONFIGURE_FLAG_ENCODE = 1;
    public static final int CONFIGURE_FLAG_USE_BLOCK_MODEL = 2;
    public static final int CONFIGURE_FLAG_USE_CRYPTO_ASYNC = 4;
    @FlaggedApi(value="android.media.codec.null_output_surface")
    public static final int CONFIGURE_FLAG_DETACHED_SURFACE = 8;
    private static final int BUFFER_MODE_INVALID = -1;
    private static final int BUFFER_MODE_LEGACY = 0;
    private static final int BUFFER_MODE_BLOCK = 1;
    private int mBufferMode = -1;
    public static final int CRYPTO_MODE_UNENCRYPTED = 0;
    public static final int CRYPTO_MODE_AES_CTR = 1;
    public static final int CRYPTO_MODE_AES_CBC = 2;
    private final ArrayList<QueueRequest> mQueueRequests = new ArrayList();
    public static final int INFO_TRY_AGAIN_LATER = -1;
    public static final int INFO_OUTPUT_FORMAT_CHANGED = -2;
    public static final int INFO_OUTPUT_BUFFERS_CHANGED = -3;
    private ByteBuffer[] mCachedInputBuffers;
    private ByteBuffer[] mCachedOutputBuffers;
    private BitSet mValidInputIndices = new BitSet();
    private BitSet mValidOutputIndices = new BitSet();
    private final BufferMap mDequeuedInputBuffers = new BufferMap();
    private final BufferMap mDequeuedOutputBuffers = new BufferMap();
    private final Map<Integer, BufferInfo> mDequeuedOutputInfos = new HashMap<Integer, BufferInfo>();
    private final Object mBufferLock;
    private final ArrayList<OutputFrame> mOutputFrames = new ArrayList();
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static final String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";
    public static final String PARAMETER_KEY_SUSPEND = "drop-input-frames";
    public static final String PARAMETER_KEY_SUSPEND_TIME = "drop-start-time-us";
    public static final String PARAMETER_KEY_OFFSET_TIME = "time-offset-us";
    public static final String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";
    public static final String PARAMETER_KEY_HDR10_PLUS_INFO = "hdr10-plus-info";
    public static final String PARAMETER_KEY_LOW_LATENCY = "low-latency";
    public static final String PARAMETER_KEY_TUNNEL_PEEK = "tunnel-peek";
    @FlaggedApi(value="android.media.codec.region_of_interest")
    public static final String PARAMETER_KEY_QP_OFFSET_MAP = "qp-offset-map";
    @FlaggedApi(value="android.media.codec.region_of_interest")
    public static final String PARAMETER_KEY_QP_OFFSET_RECTS = "qp-offset-rects";
    private static final String PARAMETER_KEY_PICTURE_PROFILE_HANDLE = "picture-profile-handle";
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private long mNativeContext = 0L;
    private final Lock mNativeContextLock = new ReentrantLock();

    static boolean GetFlag(Supplier<Boolean> flagValueSupplier) {
        return MediaCodec.GetFlag(flagValueSupplier, false);
    }

    static boolean GetFlag(Supplier<Boolean> flagValueSupplier, boolean defaultValue) {
        try {
            return flagValueSupplier.get();
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    @NonNull
    public static MediaCodec createDecoderByType(@NonNull String type) throws IOException {
        return new MediaCodec(type, true, false);
    }

    @NonNull
    public static MediaCodec createEncoderByType(@NonNull String type) throws IOException {
        return new MediaCodec(type, true, true);
    }

    @NonNull
    public static MediaCodec createByCodecName(@NonNull String name) throws IOException {
        return new MediaCodec(name, false, false);
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.MEDIA_RESOURCE_OVERRIDE_PID")
    public static MediaCodec createByCodecNameForClient(@NonNull String name, int clientPid, int clientUid) throws IOException {
        return new MediaCodec(name, false, false, clientPid, clientUid);
    }

    private MediaCodec(@NonNull String name, boolean nameIsType, boolean encoder) {
        this(name, nameIsType, encoder, -1, -1);
    }

    private MediaCodec(@NonNull String name, boolean nameIsType, boolean encoder, int pid, int uid) {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mCallbackHandler = this.mEventHandler;
        this.mOnFirstTunnelFrameReadyHandler = this.mEventHandler;
        this.mOnFrameRenderedHandler = this.mEventHandler;
        this.mBufferLock = new Object();
        this.mNameAtCreation = nameIsType ? null : name;
        this.native_setup(name, nameIsType, encoder, pid, uid);
    }

    protected void finalize() {
        this.native_finalize();
        this.mCrypto = null;
    }

    public void reset() {
        this.freeAllTrackedBuffers();
        this.native_reset();
        this.mCrypto = null;
    }

    private void native_reset() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_reset()V", true, this);
    }

    public void release() {
        this.freeAllTrackedBuffers();
        this.native_release();
        this.mCrypto = null;
    }

    private void native_release() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_release()V", true, this);
    }

    @FlaggedApi(value="android.media.codec.codec_availability")
    @NonNull
    public static List<GlobalResourceInfo> getGloballyAvailableResources() {
        return MediaCodec.native_getGloballyAvailableResources();
    }

    @NonNull
    private static List<GlobalResourceInfo> native_getGloballyAvailableResources() {
        return (List)OverrideMethod.invokeA("android.media.MediaCodec#native_getGloballyAvailableResources()Ljava/util/List;", true, null);
    }

    public void configure(@Nullable MediaFormat format, @Nullable Surface surface, @Nullable MediaCrypto crypto, int flags) {
        this.configure(format, surface, crypto, null, flags);
    }

    public void configure(@Nullable MediaFormat format, @Nullable Surface surface, int flags, @Nullable MediaDescrambler descrambler) {
        this.configure(format, surface, null, descrambler != null ? descrambler.getBinder() : null, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(@Nullable MediaFormat format, @Nullable Surface surface, @Nullable MediaCrypto crypto, @Nullable IHwBinder descramblerBinder, int flags) {
        if (crypto != null && descramblerBinder != null) {
            throw new IllegalArgumentException("Can't use crypto and descrambler together!");
        }
        boolean canDetach = MediaCodec.GetFlag(() -> Flags.nullOutputSurfaceSupport());
        if (MediaCodec.GetFlag(() -> Flags.nullOutputSurface())) {
            if (surface == null && (flags & 8) != 0 && !canDetach) {
                throw new IllegalArgumentException("Codec does not support detached surface");
            }
        } else {
            canDetach = false;
        }
        String[] keys = null;
        Object[] values = null;
        if (format != null) {
            Map<String, Object> formatMap = format.getMap();
            keys = new String[formatMap.size()];
            values = new Object[formatMap.size()];
            int i = 0;
            for (Map.Entry<String, Object> entry : formatMap.entrySet()) {
                if (entry.getKey().equals("audio-session-id")) {
                    int sessionId = 0;
                    try {
                        sessionId = (Integer)entry.getValue();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Wrong Session ID Parameter!");
                    }
                    keys[i] = "audio-hw-sync";
                    values[i] = AudioSystem.getAudioHwSyncForSession(sessionId);
                } else if (com.android.internal.hidden_from_bootclasspath.android.media.tv.flags.Flags.applyPictureProfiles() && com.android.internal.hidden_from_bootclasspath.android.media.tv.flags.Flags.mediaQualityFw() && entry.getKey().equals("picture-profile-instance")) {
                    PictureProfile pictureProfile = null;
                    try {
                        pictureProfile = (PictureProfile)entry.getValue();
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("Cannot cast the instance parameter to PictureProfile!");
                    }
                    catch (Exception e) {
                        Log.e(TAG, Log.getStackTraceString(e));
                        throw new IllegalArgumentException("Unexpected exception when casting the instance parameter to PictureProfile!");
                    }
                    if (pictureProfile == null) {
                        throw new IllegalArgumentException("Picture profile instance parameter is null!");
                    }
                    PictureProfileHandle handle = pictureProfile.getHandle();
                    if (handle != PictureProfileHandle.NONE) {
                        keys[i] = PARAMETER_KEY_PICTURE_PROFILE_HANDLE;
                        values[i] = handle.getId();
                    }
                } else if (com.android.internal.hidden_from_bootclasspath.android.media.tv.flags.Flags.applyPictureProfiles() && com.android.internal.hidden_from_bootclasspath.android.media.tv.flags.Flags.mediaQualityFw() && entry.getKey().equals("picture-profile-id")) {
                    String pictureProfileId = null;
                    try {
                        pictureProfileId = (String)entry.getValue();
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("Cannot cast the KEY_PICTURE_PROFILE_ID parameter to String!");
                    }
                    catch (Exception e) {
                        Log.e(TAG, Log.getStackTraceString(e));
                        throw new IllegalArgumentException("Unexpected exception when casting the KEY_PICTURE_PROFILE_ID parameter!");
                    }
                    if (pictureProfileId == null) {
                        throw new IllegalArgumentException("KEY_PICTURE_PROFILE_ID parameter is null!");
                    }
                    if (!pictureProfileId.isEmpty()) {
                        keys[i] = "picture-profile-id";
                        values[i] = pictureProfileId;
                    }
                } else {
                    keys[i] = entry.getKey();
                    values[i] = entry.getValue();
                }
                ++i;
            }
        }
        this.mHasSurface = surface != null;
        this.mCrypto = crypto;
        Object object = this.mBufferLock;
        synchronized (object) {
            this.mBufferMode = (flags & 2) != 0 ? 1 : 0;
        }
        this.native_configure(keys, values, surface, crypto, descramblerBinder, flags);
        if (canDetach && surface == null && (flags & 8) != 0) {
            this.mHasSurface = true;
        }
    }

    @FlaggedApi(value="android.media.codec.codec_availability")
    @NonNull
    public List<InstanceResourceInfo> getRequiredResources() {
        return this.native_getRequiredResources();
    }

    @NonNull
    private List<InstanceResourceInfo> native_getRequiredResources() {
        return (List)OverrideMethod.invokeA("android.media.MediaCodec#native_getRequiredResources()Ljava/util/List;", true, this);
    }

    public void setOutputSurface(@NonNull Surface surface) {
        if (!this.mHasSurface) {
            throw new IllegalStateException("codec was not configured for an output surface");
        }
        this.native_setSurface(surface);
    }

    private void native_setSurface(@NonNull Surface surface) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setSurface(Landroid/view/Surface;)V", true, this);
    }

    @FlaggedApi(value="android.media.codec.null_output_surface")
    public void detachOutputSurface() {
        if (!this.mHasSurface) {
            throw new IllegalStateException("codec was not configured for an output surface");
        }
        if (!MediaCodec.GetFlag(() -> Flags.nullOutputSurfaceSupport())) {
            throw new IllegalStateException("codec does not support detaching output surface");
        }
        this.native_detachOutputSurface();
    }

    private void native_detachOutputSurface() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_detachOutputSurface()V", true, this);
    }

    @NonNull
    public static Surface createPersistentInputSurface() {
        return MediaCodec.native_createPersistentInputSurface();
    }

    public void setInputSurface(@NonNull Surface surface) {
        if (!(surface instanceof PersistentSurface)) {
            throw new IllegalArgumentException("not a PersistentSurface");
        }
        this.native_setInputSurface(surface);
    }

    @NonNull
    private static PersistentSurface native_createPersistentInputSurface() {
        return (PersistentSurface)OverrideMethod.invokeA("android.media.MediaCodec#native_createPersistentInputSurface()Landroid/media/MediaCodec$PersistentSurface;", true, null);
    }

    private static void native_releasePersistentInputSurface(@NonNull Surface surface) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_releasePersistentInputSurface(Landroid/view/Surface;)V", true, null);
    }

    private void native_setInputSurface(@NonNull Surface surface) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setInputSurface(Landroid/view/Surface;)V", true, this);
    }

    private void native_setCallback(@Nullable Callback callback) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setCallback(Landroid/media/MediaCodec$Callback;)V", true, this);
    }

    private void native_configure(@Nullable String[] stringArray, @Nullable Object[] objectArray, @Nullable Surface surface, @Nullable MediaCrypto mediaCrypto, @Nullable IHwBinder iHwBinder, int n) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_configure([Ljava/lang/String;[Ljava/lang/Object;Landroid/view/Surface;Landroid/media/MediaCrypto;Landroid/os/IHwBinder;I)V", true, this);
    }

    @NonNull
    public Surface createInputSurface() {
        return (Surface)OverrideMethod.invokeA("android.media.MediaCodec#createInputSurface()Landroid/view/Surface;", true, this);
    }

    public void start() {
        this.native_start();
    }

    private void native_start() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_start()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.native_stop();
        this.freeAllTrackedBuffers();
        Object object = this.mListenerLock;
        synchronized (object) {
            if (this.mCallbackHandler != null) {
                this.mCallbackHandler.removeMessages(2);
                this.mCallbackHandler.removeMessages(1);
            }
            if (this.mOnFirstTunnelFrameReadyHandler != null) {
                this.mOnFirstTunnelFrameReadyHandler.removeMessages(4);
            }
            if (this.mOnFrameRenderedHandler != null) {
                this.mOnFrameRenderedHandler.removeMessages(3);
            }
        }
    }

    private void native_stop() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_stop()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffersLocked(this.mCachedInputBuffers);
            this.invalidateByteBuffersLocked(this.mCachedOutputBuffers);
            this.mValidInputIndices.clear();
            this.mValidOutputIndices.clear();
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
        }
        this.native_flush();
    }

    private void native_flush() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_flush()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) throws CryptoException {
        Trace.traceBegin(512L, "MediaCodec::queueInputBuffer#java");
        if ((flags & 0x20) != 0 && (flags & 4) != 0) {
            throw new InvalidBufferFlagsException(EOS_AND_DECODE_ONLY_ERROR_MESSAGE);
        }
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("queueInputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getQueueRequest() to queue buffers");
            }
            this.invalidateByteBufferLocked(this.mCachedInputBuffers, index, true);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueInputBuffer(index, offset, size, presentationTimeUs, flags);
        }
        catch (CryptoException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index, true);
            throw e;
        }
        finally {
            Trace.traceEnd(512L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.media.codec.flags.large_audio_frame")
    public void queueInputBuffers(int index, @NonNull ArrayDeque<BufferInfo> bufferInfos) {
        Trace.traceBegin(512L, "MediaCodec::queueInputBuffers#java");
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("queueInputBuffers() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getQueueRequest() to queue buffers");
            }
            this.invalidateByteBufferLocked(this.mCachedInputBuffers, index, true);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueInputBuffers(index, bufferInfos.toArray());
        }
        catch (CryptoException | IllegalArgumentException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index, true);
            throw e;
        }
        finally {
            Trace.traceEnd(512L);
        }
    }

    private void native_queueInputBuffer(int n, int n2, int n3, long l, int n4) throws CryptoException {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueInputBuffer(IIIJI)V", true, this);
    }

    private void native_queueInputBuffers(int n, @NonNull Object[] objectArray) throws CryptoException, CodecException {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueInputBuffers(I[Ljava/lang/Object;)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSecureInputBuffer(int index, int offset, @NonNull CryptoInfo info, long presentationTimeUs, int flags) throws CryptoException {
        Trace.traceBegin(512L, "MediaCodec::queueSecureInputBuffer#java");
        if ((flags & 0x20) != 0 && (flags & 4) != 0) {
            throw new InvalidBufferFlagsException(EOS_AND_DECODE_ONLY_ERROR_MESSAGE);
        }
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("queueSecureInputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getQueueRequest() to queue buffers");
            }
            this.invalidateByteBufferLocked(this.mCachedInputBuffers, index, true);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueSecureInputBuffer(index, offset, info, presentationTimeUs, flags);
        }
        catch (CryptoException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index, true);
            throw e;
        }
        finally {
            Trace.traceEnd(512L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.media.codec.flags.large_audio_frame")
    public void queueSecureInputBuffers(int index, @NonNull ArrayDeque<BufferInfo> bufferInfos, @NonNull ArrayDeque<CryptoInfo> cryptoInfos) {
        Trace.traceBegin(512L, "MediaCodec::queueSecureInputBuffers#java");
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("queueSecureInputBuffers() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getQueueRequest() to queue buffers");
            }
            this.invalidateByteBufferLocked(this.mCachedInputBuffers, index, true);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueSecureInputBuffers(index, bufferInfos.toArray(), cryptoInfos.toArray());
        }
        catch (CryptoException | IllegalArgumentException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index, true);
            throw e;
        }
        finally {
            Trace.traceEnd(512L);
        }
    }

    private void native_queueSecureInputBuffer(int n, int n2, @NonNull CryptoInfo cryptoInfo, long l, int n3) throws CryptoException {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueSecureInputBuffer(IILandroid/media/MediaCodec$CryptoInfo;JI)V", true, this);
    }

    private void native_queueSecureInputBuffers(int n, @NonNull Object[] objectArray, @NonNull Object[] objectArray2) throws CryptoException, CodecException {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueSecureInputBuffers(I[Ljava/lang/Object;[Ljava/lang/Object;)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dequeueInputBuffer(long timeoutUs) {
        Trace.traceBegin(512L, "MediaCodec::dequeueInputBuffer#java");
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("dequeueInputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use MediaCodec.Callback objectes to get input buffer slots.");
            }
        }
        int res = this.native_dequeueInputBuffer(timeoutUs);
        if (res >= 0) {
            Object object2 = this.mBufferLock;
            synchronized (object2) {
                this.validateInputByteBufferLocked(this.mCachedInputBuffers, res);
            }
        }
        Trace.traceEnd(512L);
        return res;
    }

    private int native_dequeueInputBuffer(long l) {
        return OverrideMethod.invokeI("android.media.MediaCodec#native_dequeueInputBuffer(J)I", true, this);
    }

    @Nullable
    public static Image mapHardwareBuffer(@NonNull HardwareBuffer hardwareBuffer) {
        return MediaCodec.native_mapHardwareBuffer(hardwareBuffer);
    }

    @Nullable
    private static Image native_mapHardwareBuffer(@NonNull HardwareBuffer hardwareBuffer) {
        return (Image)OverrideMethod.invokeA("android.media.MediaCodec#native_mapHardwareBuffer(Landroid/hardware/HardwareBuffer;)Landroid/media/Image;", true, null);
    }

    private static void native_closeMediaImage(long l) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_closeMediaImage(J)V", true, null);
    }

    private void native_queueLinearBlock(int n, @NonNull LinearBlock linearBlock, @Nullable Object[] objectArray, @NonNull Object[] objectArray2, @NonNull ArrayList<String> arrayList, @NonNull ArrayList<Object> arrayList2) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueLinearBlock(ILandroid/media/MediaCodec$LinearBlock;[Ljava/lang/Object;[Ljava/lang/Object;Ljava/util/ArrayList;Ljava/util/ArrayList;)V", true, this);
    }

    private void native_queueHardwareBuffer(int n, @NonNull HardwareBuffer hardwareBuffer, long l, int n2, @NonNull ArrayList<String> arrayList, @NonNull ArrayList<Object> arrayList2) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueHardwareBuffer(ILandroid/hardware/HardwareBuffer;JILjava/util/ArrayList;Ljava/util/ArrayList;)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public QueueRequest getQueueRequest(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode != 1) {
                throw new IllegalStateException("The codec is not configured for block model");
            }
            if (index < 0 || index >= this.mQueueRequests.size()) {
                throw new IndexOutOfBoundsException("Expected range of index: [0," + (this.mQueueRequests.size() - 1) + "]; actual: " + index);
            }
            QueueRequest request = this.mQueueRequests.get(index);
            if (request == null) {
                throw new IllegalArgumentException("Unavailable index: " + index);
            }
            if (!request.isAccessible()) {
                throw new IllegalArgumentException("The request is stale at index " + index);
            }
            return request.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dequeueOutputBuffer(@NonNull BufferInfo info, long timeoutUs) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("dequeueOutputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use MediaCodec.Callback objects to get output buffer slots.");
            }
        }
        int res = this.native_dequeueOutputBuffer(info, timeoutUs);
        Object object2 = this.mBufferLock;
        synchronized (object2) {
            if (res == -3) {
                this.cacheBuffersLocked(false);
            } else if (res >= 0) {
                this.validateOutputByteBufferLocked(this.mCachedOutputBuffers, res, info);
                if (this.mHasSurface || this.mCachedOutputBuffers == null) {
                    this.mDequeuedOutputInfos.put(res, info.dup());
                }
            }
        }
        return res;
    }

    private int native_dequeueOutputBuffer(@NonNull BufferInfo bufferInfo, long l) {
        return OverrideMethod.invokeI("android.media.MediaCodec#native_dequeueOutputBuffer(Landroid/media/MediaCodec$BufferInfo;J)I", true, this);
    }

    public void releaseOutputBuffer(int index, boolean render) {
        this.releaseOutputBufferInternal(index, render, false, 0L);
    }

    public void releaseOutputBuffer(int index, long renderTimestampNs) {
        this.releaseOutputBufferInternal(index, true, true, renderTimestampNs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseOutputBufferInternal(int index, boolean render, boolean updatePts, long renderTimestampNs) {
        BufferInfo info = null;
        Object object = this.mBufferLock;
        synchronized (object) {
            switch (this.mBufferMode) {
                case 0: {
                    this.invalidateByteBufferLocked(this.mCachedOutputBuffers, index, false);
                    this.mDequeuedOutputBuffers.remove(index);
                    if (!this.mHasSurface && this.mCachedOutputBuffers != null) break;
                    info = this.mDequeuedOutputInfos.remove(index);
                    break;
                }
                case 1: {
                    OutputFrame frame = this.mOutputFrames.get(index);
                    frame.setAccessible(false);
                    frame.clear();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized buffer mode: " + this.mBufferMode);
                }
            }
        }
        this.releaseOutputBuffer(index, render, updatePts, renderTimestampNs);
    }

    @UnsupportedAppUsage
    private void releaseOutputBuffer(int n, boolean bl, boolean bl2, long l) {
        OverrideMethod.invokeV("android.media.MediaCodec#releaseOutputBuffer(IZZJ)V", true, this);
    }

    public void signalEndOfInputStream() {
        OverrideMethod.invokeV("android.media.MediaCodec#signalEndOfInputStream()V", true, this);
    }

    @NonNull
    public MediaFormat getOutputFormat() {
        return new MediaFormat(this.getFormatNative(false));
    }

    @NonNull
    public MediaFormat getInputFormat() {
        return new MediaFormat(this.getFormatNative(true));
    }

    @NonNull
    public MediaFormat getOutputFormat(int index) {
        return new MediaFormat(this.getOutputFormatNative(index));
    }

    @NonNull
    private Map<String, Object> getFormatNative(boolean bl) {
        return (Map)OverrideMethod.invokeA("android.media.MediaCodec#getFormatNative(Z)Ljava/util/Map;", true, this);
    }

    @NonNull
    private Map<String, Object> getOutputFormatNative(int n) {
        return (Map)OverrideMethod.invokeA("android.media.MediaCodec#getOutputFormatNative(I)Ljava/util/Map;", true, this);
    }

    private void invalidateByteBufferLocked(@Nullable ByteBuffer[] buffers, int index, boolean input) {
        ByteBuffer buffer;
        if (buffers == null) {
            if (index >= 0) {
                BitSet indices = input ? this.mValidInputIndices : this.mValidOutputIndices;
                indices.clear(index);
            }
        } else if (index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(false);
        }
    }

    private void validateInputByteBufferLocked(@Nullable ByteBuffer[] buffers, int index) {
        ByteBuffer buffer;
        if (buffers == null) {
            if (index >= 0) {
                this.mValidInputIndices.set(index);
            }
        } else if (index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(true);
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revalidateByteBuffer(@Nullable ByteBuffer[] buffers, int index, boolean input) {
        Object object = this.mBufferLock;
        synchronized (object) {
            ByteBuffer buffer;
            if (buffers == null) {
                if (index >= 0) {
                    BitSet indices = input ? this.mValidInputIndices : this.mValidOutputIndices;
                    indices.set(index);
                }
            } else if (index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
                buffer.setAccessible(true);
            }
        }
    }

    private void validateOutputByteBuffersLocked(@Nullable ByteBuffer[] buffers, int index, @NonNull ArrayDeque<BufferInfo> infoDeque) {
        ByteBuffer buffer;
        Optional minInfo = infoDeque.stream().min((info1, info2) -> Integer.compare(info1.offset, info2.offset));
        Optional maxInfo = infoDeque.stream().max((info1, info2) -> Integer.compare(info1.offset, info2.offset));
        if (buffers == null) {
            if (index >= 0) {
                this.mValidOutputIndices.set(index);
            }
        } else if (index >= 0 && index < buffers.length && (buffer = buffers[index]) != null && minInfo.isPresent() && maxInfo.isPresent()) {
            buffer.setAccessible(true);
            buffer.limit(((BufferInfo)maxInfo.get()).offset + ((BufferInfo)maxInfo.get()).size);
            buffer.position(((BufferInfo)minInfo.get()).offset);
        }
    }

    private void validateOutputByteBufferLocked(@Nullable ByteBuffer[] buffers, int index, @NonNull BufferInfo info) {
        ByteBuffer buffer;
        if (buffers == null) {
            if (index >= 0) {
                this.mValidOutputIndices.set(index);
            }
        } else if (index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(true);
            buffer.limit(info.offset + info.size).position(info.offset);
        }
    }

    private void invalidateByteBuffersLocked(@Nullable ByteBuffer[] buffers) {
        if (buffers != null) {
            for (ByteBuffer buffer : buffers) {
                if (buffer == null) continue;
                buffer.setAccessible(false);
            }
        }
    }

    private void freeByteBufferLocked(@Nullable ByteBuffer buffer) {
        if (buffer != null) {
            NioUtils_Delegate.freeDirectBuffer(buffer);
        }
    }

    private void freeByteBuffersLocked(@Nullable ByteBuffer[] buffers) {
        if (buffers != null) {
            for (ByteBuffer buffer : buffers) {
                this.freeByteBufferLocked(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeAllTrackedBuffers() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.freeByteBuffersLocked(this.mCachedInputBuffers);
            this.freeByteBuffersLocked(this.mCachedOutputBuffers);
            this.mCachedInputBuffers = null;
            this.mCachedOutputBuffers = null;
            this.mValidInputIndices.clear();
            this.mValidOutputIndices.clear();
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
            this.mQueueRequests.clear();
            this.mOutputFrames.clear();
        }
    }

    private void cacheBuffersLocked(boolean input) {
        ByteBuffer[] buffers = null;
        try {
            buffers = this.getBuffers(input);
            this.invalidateByteBuffersLocked(buffers);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (buffers != null) {
            BitSet indices = input ? this.mValidInputIndices : this.mValidOutputIndices;
            for (int i = 0; i < buffers.length; ++i) {
                BufferInfo info;
                ByteBuffer buffer = buffers[i];
                if (buffer == null || !indices.get(i)) continue;
                buffer.setAccessible(true);
                if (input || (info = this.mDequeuedOutputInfos.get(i)) == null) continue;
                buffer.limit(info.offset + info.size).position(info.offset);
            }
            indices.clear();
        }
        if (input) {
            this.mCachedInputBuffers = buffers;
        } else {
            this.mCachedOutputBuffers = buffers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ByteBuffer[] getInputBuffers() {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getInputBuffers() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please obtain MediaCodec.LinearBlock or HardwareBuffer objects and attach to QueueRequest objects.");
            }
            if (this.mCachedInputBuffers == null) {
                this.cacheBuffersLocked(true);
            }
            if (this.mCachedInputBuffers == null) {
                throw new IllegalStateException();
            }
            return this.mCachedInputBuffers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ByteBuffer[] getOutputBuffers() {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getOutputBuffers() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getOutputFrame to get output frames.");
            }
            if (this.mCachedOutputBuffers == null) {
                this.cacheBuffersLocked(false);
            }
            if (this.mCachedOutputBuffers == null) {
                throw new IllegalStateException();
            }
            return this.mCachedOutputBuffers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ByteBuffer getInputBuffer(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getInputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please obtain MediaCodec.LinearBlock or HardwareBuffer objects and attach to QueueRequest objects.");
            }
        }
        ByteBuffer newBuffer = this.getBuffer(true, index);
        Object object2 = this.mBufferLock;
        synchronized (object2) {
            this.invalidateByteBufferLocked(this.mCachedInputBuffers, index, true);
            this.mDequeuedInputBuffers.put(index, newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Image getInputImage(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getInputImage() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please obtain MediaCodec.LinearBlock or HardwareBuffer objects and attach to QueueRequest objects.");
            }
        }
        Image newImage = this.getImage(true, index);
        Object object2 = this.mBufferLock;
        synchronized (object2) {
            this.invalidateByteBufferLocked(this.mCachedInputBuffers, index, true);
            this.mDequeuedInputBuffers.put(index, newImage);
        }
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ByteBuffer getOutputBuffer(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getOutputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getOutputFrame() to get output frames.");
            }
        }
        ByteBuffer newBuffer = this.getBuffer(false, index);
        Object object2 = this.mBufferLock;
        synchronized (object2) {
            this.invalidateByteBufferLocked(this.mCachedOutputBuffers, index, false);
            this.mDequeuedOutputBuffers.put(index, newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Image getOutputImage(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getOutputImage() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getOutputFrame() to get output frames.");
            }
        }
        Image newImage = this.getImage(false, index);
        Object object2 = this.mBufferLock;
        synchronized (object2) {
            this.invalidateByteBufferLocked(this.mCachedOutputBuffers, index, false);
            this.mDequeuedOutputBuffers.put(index, newImage);
        }
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public OutputFrame getOutputFrame(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode != 1) {
                throw new IllegalStateException("The codec is not configured for block model");
            }
            if (index < 0 || index >= this.mOutputFrames.size()) {
                throw new IndexOutOfBoundsException("Expected range of index: [0," + (this.mQueueRequests.size() - 1) + "]; actual: " + index);
            }
            OutputFrame frame = this.mOutputFrames.get(index);
            if (frame == null) {
                throw new IllegalArgumentException("Unavailable index: " + index);
            }
            if (!frame.isAccessible()) {
                throw new IllegalArgumentException("The output frame is stale at index " + index);
            }
            if (!frame.isLoaded()) {
                this.native_getOutputFrame(frame, index);
                frame.setLoaded(true);
            }
            return frame;
        }
    }

    private void native_getOutputFrame(OutputFrame outputFrame, int n) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_getOutputFrame(Landroid/media/MediaCodec$OutputFrame;I)V", true, this);
    }

    public void setVideoScalingMode(int n) {
        OverrideMethod.invokeV("android.media.MediaCodec#setVideoScalingMode(I)V", true, this);
    }

    public void setAudioPresentation(@NonNull AudioPresentation presentation) {
        if (presentation == null) {
            throw new NullPointerException("audio presentation is null");
        }
        this.native_setAudioPresentation(presentation.getPresentationId(), presentation.getProgramId());
    }

    private void native_setAudioPresentation(int n, int n2) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setAudioPresentation(II)V", true, this);
    }

    @NonNull
    public String getName() {
        String canonicalName = this.getCanonicalName();
        return this.mNameAtCreation != null ? this.mNameAtCreation : canonicalName;
    }

    @NonNull
    public String getCanonicalName() {
        return (String)OverrideMethod.invokeA("android.media.MediaCodec#getCanonicalName()Ljava/lang/String;", true, this);
    }

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private PersistableBundle native_getMetrics() {
        return (PersistableBundle)OverrideMethod.invokeA("android.media.MediaCodec#native_getMetrics()Landroid/os/PersistableBundle;", true, this);
    }

    public void setParameters(@Nullable Bundle params) {
        if (params == null) {
            return;
        }
        String[] keys = new String[params.size()];
        Object[] values = new Object[params.size()];
        int i = 0;
        for (String key : params.keySet()) {
            if (key.equals("audio-session-id")) {
                int sessionId = 0;
                try {
                    sessionId = (Integer)params.get(key);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Wrong Session ID Parameter!");
                }
                keys[i] = "audio-hw-sync";
                values[i] = AudioSystem.getAudioHwSyncForSession(sessionId);
            } else if (com.android.internal.hidden_from_bootclasspath.android.media.tv.flags.Flags.applyPictureProfiles() && com.android.internal.hidden_from_bootclasspath.android.media.tv.flags.Flags.mediaQualityFw() && key.equals("picture-profile-instance")) {
                PictureProfile pictureProfile = null;
                try {
                    pictureProfile = (PictureProfile)params.get(key);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Cannot cast the instance parameter to PictureProfile!");
                }
                catch (Exception e) {
                    Log.e(TAG, Log.getStackTraceString(e));
                    throw new IllegalArgumentException("Unexpected exception when casting the instance parameter to PictureProfile!");
                }
                if (pictureProfile == null) {
                    throw new IllegalArgumentException("Picture profile instance parameter is null!");
                }
                PictureProfileHandle handle = pictureProfile.getHandle();
                if (handle != PictureProfileHandle.NONE) {
                    keys[i] = PARAMETER_KEY_PICTURE_PROFILE_HANDLE;
                    values[i] = handle.getId();
                }
            } else if (com.android.internal.hidden_from_bootclasspath.android.media.tv.flags.Flags.applyPictureProfiles() && com.android.internal.hidden_from_bootclasspath.android.media.tv.flags.Flags.mediaQualityFw() && key.equals("picture-profile-id")) {
                String pictureProfileId = null;
                try {
                    pictureProfileId = (String)params.get(key);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Cannot cast the KEY_PICTURE_PROFILE_ID parameter to String!");
                }
                catch (Exception e) {
                    Log.e(TAG, Log.getStackTraceString(e));
                    throw new IllegalArgumentException("Unexpected exception when casting the KEY_PICTURE_PROFILE_ID parameter!");
                }
                if (pictureProfileId == null) {
                    throw new IllegalArgumentException("KEY_PICTURE_PROFILE_ID parameter is null!");
                }
                if (!pictureProfileId.isEmpty()) {
                    keys[i] = "picture-profile-id";
                    values[i] = pictureProfileId;
                }
            } else {
                keys[i] = key;
                Object value = params.get(key);
                values[i] = value instanceof byte[] ? ByteBuffer.wrap((byte[])value) : value;
            }
            ++i;
        }
        this.setParameters(keys, values);
    }

    private void logAndRun(String message, Runnable r) {
        Log.d(TAG, "enter: " + message);
        r.run();
        Log.d(TAG, "exit : " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(@Nullable Callback cb, @Nullable Handler handler) {
        boolean setCallbackStallFlag = MediaCodec.GetFlag(() -> Flags.setCallbackStall());
        if (cb != null) {
            Object object = this.mListenerLock;
            synchronized (object) {
                EventHandler newHandler = this.getEventHandlerOn(handler, this.mCallbackHandler);
                if (newHandler != this.mCallbackHandler) {
                    if (setCallbackStallFlag) {
                        this.logAndRun("[new handler] removeMessages(SET_CALLBACK)", () -> this.mCallbackHandler.removeMessages(2));
                        this.logAndRun("[new handler] removeMessages(CALLBACK)", () -> this.mCallbackHandler.removeMessages(1));
                    } else {
                        this.mCallbackHandler.removeMessages(2);
                        this.mCallbackHandler.removeMessages(1);
                    }
                    this.mCallbackHandler = newHandler;
                }
            }
        } else if (this.mCallbackHandler != null) {
            if (setCallbackStallFlag) {
                this.logAndRun("[null handler] removeMessages(SET_CALLBACK)", () -> this.mCallbackHandler.removeMessages(2));
                this.logAndRun("[null handler] removeMessages(CALLBACK)", () -> this.mCallbackHandler.removeMessages(1));
            } else {
                this.mCallbackHandler.removeMessages(2);
                this.mCallbackHandler.removeMessages(1);
            }
        }
        if (this.mCallbackHandler != null) {
            Message msg = this.mCallbackHandler.obtainMessage(2, 0, 0, cb);
            this.mCallbackHandler.sendMessage(msg);
            this.native_setCallback(cb);
        }
    }

    public void setCallback(@Nullable Callback cb) {
        this.setCallback(cb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnFirstTunnelFrameReadyListener(@Nullable Handler handler, @Nullable OnFirstTunnelFrameReadyListener listener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mOnFirstTunnelFrameReadyListener = listener;
            if (listener != null) {
                EventHandler newHandler = this.getEventHandlerOn(handler, this.mOnFirstTunnelFrameReadyHandler);
                if (newHandler != this.mOnFirstTunnelFrameReadyHandler) {
                    this.mOnFirstTunnelFrameReadyHandler.removeMessages(4);
                }
                this.mOnFirstTunnelFrameReadyHandler = newHandler;
            } else if (this.mOnFirstTunnelFrameReadyHandler != null) {
                this.mOnFirstTunnelFrameReadyHandler.removeMessages(4);
            }
            this.native_enableOnFirstTunnelFrameReadyListener(listener != null);
        }
    }

    private void native_enableOnFirstTunnelFrameReadyListener(boolean bl) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_enableOnFirstTunnelFrameReadyListener(Z)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnFrameRenderedListener(@Nullable OnFrameRenderedListener listener, @Nullable Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mOnFrameRenderedListener = listener;
            if (listener != null) {
                EventHandler newHandler = this.getEventHandlerOn(handler, this.mOnFrameRenderedHandler);
                if (newHandler != this.mOnFrameRenderedHandler) {
                    this.mOnFrameRenderedHandler.removeMessages(3);
                }
                this.mOnFrameRenderedHandler = newHandler;
            } else if (this.mOnFrameRenderedHandler != null) {
                this.mOnFrameRenderedHandler.removeMessages(3);
            }
            this.native_enableOnFrameRenderedListener(listener != null);
        }
    }

    private void native_enableOnFrameRenderedListener(boolean bl) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_enableOnFrameRenderedListener(Z)V", true, this);
    }

    @NonNull
    public List<String> getSupportedVendorParameters() {
        return this.native_getSupportedVendorParameters();
    }

    @NonNull
    private List<String> native_getSupportedVendorParameters() {
        return (List)OverrideMethod.invokeA("android.media.MediaCodec#native_getSupportedVendorParameters()Ljava/util/List;", true, this);
    }

    @Nullable
    public ParameterDescriptor getParameterDescriptor(@NonNull String name) {
        return this.native_getParameterDescriptor(name);
    }

    @Nullable
    private ParameterDescriptor native_getParameterDescriptor(@NonNull String string2) {
        return (ParameterDescriptor)OverrideMethod.invokeA("android.media.MediaCodec#native_getParameterDescriptor(Ljava/lang/String;)Landroid/media/MediaCodec$ParameterDescriptor;", true, this);
    }

    public void subscribeToVendorParameters(@NonNull List<String> names) {
        this.native_subscribeToVendorParameters(names);
    }

    private void native_subscribeToVendorParameters(@NonNull List<String> list) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_subscribeToVendorParameters(Ljava/util/List;)V", true, this);
    }

    public void unsubscribeFromVendorParameters(@NonNull List<String> names) {
        this.native_unsubscribeFromVendorParameters(names);
    }

    private void native_unsubscribeFromVendorParameters(@NonNull List<String> list) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_unsubscribeFromVendorParameters(Ljava/util/List;)V", true, this);
    }

    private EventHandler getEventHandlerOn(@Nullable Handler handler, @NonNull EventHandler lastHandler) {
        if (handler == null) {
            return this.mEventHandler;
        }
        Looper looper = handler.getLooper();
        if (lastHandler.getLooper() == looper) {
            return lastHandler;
        }
        return new EventHandler(this, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEventFromNative(int what, int arg1, int arg2, @Nullable Object obj) {
        Object object = this.mListenerLock;
        synchronized (object) {
            EventHandler handler = this.mEventHandler;
            if (what == 1) {
                handler = this.mCallbackHandler;
            } else if (what == 4) {
                handler = this.mOnFirstTunnelFrameReadyHandler;
            } else if (what == 3) {
                handler = this.mOnFrameRenderedHandler;
            }
            if (handler != null) {
                Message msg = handler.obtainMessage(what, arg1, arg2, obj);
                handler.sendMessage(msg);
            }
        }
    }

    @UnsupportedAppUsage
    private void setParameters(@NonNull String[] stringArray, @NonNull Object[] objectArray) {
        OverrideMethod.invokeV("android.media.MediaCodec#setParameters([Ljava/lang/String;[Ljava/lang/Object;)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MediaCodecInfo getCodecInfo() {
        String name = this.getName();
        Object object = this.mCodecInfoLock;
        synchronized (object) {
            if (this.mCodecInfo == null) {
                this.mCodecInfo = this.getOwnCodecInfo();
                if (this.mCodecInfo == null) {
                    this.mCodecInfo = MediaCodecList.getInfoFor(name);
                }
            }
            return this.mCodecInfo;
        }
    }

    @NonNull
    private MediaCodecInfo getOwnCodecInfo() {
        return (MediaCodecInfo)OverrideMethod.invokeA("android.media.MediaCodec#getOwnCodecInfo()Landroid/media/MediaCodecInfo;", true, this);
    }

    @NonNull
    @UnsupportedAppUsage
    private ByteBuffer[] getBuffers(boolean bl) {
        return (ByteBuffer[])OverrideMethod.invokeA("android.media.MediaCodec#getBuffers(Z)[Ljava/nio/ByteBuffer;", true, this);
    }

    @Nullable
    private ByteBuffer getBuffer(boolean bl, int n) {
        return (ByteBuffer)OverrideMethod.invokeA("android.media.MediaCodec#getBuffer(ZI)Ljava/nio/ByteBuffer;", true, this);
    }

    @Nullable
    private Image getImage(boolean bl, int n) {
        return (Image)OverrideMethod.invokeA("android.media.MediaCodec#getImage(ZI)Landroid/media/Image;", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_init()V", true, null);
    }

    private void native_setup(@NonNull String string2, boolean bl, boolean bl2, int n, int n2) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setup(Ljava/lang/String;ZZII)V", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_finalize()V", true, this);
    }

    private long lockAndGetContext() {
        this.mNativeContextLock.lock();
        return this.mNativeContext;
    }

    private void setAndUnlockContext(long context) {
        this.mNativeContext = context;
        this.mNativeContextLock.unlock();
    }

    static {
        System_Delegate.loadLibrary("media_jni");
        MediaCodec.native_init();
    }

    private static class BufferMap {
        private final Map<Integer, CodecBuffer> mMap = new HashMap<Integer, CodecBuffer>();

        private BufferMap() {
        }

        public void remove(int index) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer != null) {
                buffer.free();
                this.mMap.remove(index);
            }
        }

        public void put(int index, @Nullable ByteBuffer newBuffer) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer == null) {
                buffer = new CodecBuffer();
                this.mMap.put(index, buffer);
            }
            buffer.setByteBuffer(newBuffer);
        }

        public void put(int index, @Nullable Image newImage) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer == null) {
                buffer = new CodecBuffer();
                this.mMap.put(index, buffer);
            }
            buffer.setImage(newImage);
        }

        public void clear() {
            for (CodecBuffer buffer : this.mMap.values()) {
                buffer.free();
            }
            this.mMap.clear();
        }

        private static class CodecBuffer {
            private Image mImage;
            private ByteBuffer mByteBuffer;

            private CodecBuffer() {
            }

            public void free() {
                if (this.mByteBuffer != null) {
                    NioUtils_Delegate.freeDirectBuffer(this.mByteBuffer);
                    this.mByteBuffer = null;
                }
                if (this.mImage != null) {
                    this.mImage.close();
                    this.mImage = null;
                }
            }

            public void setImage(@Nullable Image image) {
                this.free();
                this.mImage = image;
            }

            public void setByteBuffer(@Nullable ByteBuffer buffer) {
                this.free();
                this.mByteBuffer = buffer;
            }
        }
    }

    private class EventHandler
    extends Handler {
        private MediaCodec mCodec;

        public EventHandler(@NonNull MediaCodec codec, Looper looper) {
            super(looper);
            this.mCodec = codec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(@NonNull Message msg) {
            block4 : switch (msg.what) {
                case 1: {
                    this.handleCallback(msg);
                    break;
                }
                case 2: {
                    MediaCodec.this.mCallback = (Callback)msg.obj;
                    break;
                }
                case 3: {
                    Map map = (Map)msg.obj;
                    int i = 0;
                    while (true) {
                        OnFrameRenderedListener onFrameRenderedListener;
                        Object mediaTimeUs = map.get(i + "-media-time-us");
                        Object systemNano = map.get(i + "-system-nano");
                        Object object = MediaCodec.this.mListenerLock;
                        synchronized (object) {
                            onFrameRenderedListener = MediaCodec.this.mOnFrameRenderedListener;
                        }
                        if (mediaTimeUs == null || systemNano == null || onFrameRenderedListener == null) break block4;
                        onFrameRenderedListener.onFrameRendered(this.mCodec, (Long)mediaTimeUs, (Long)systemNano);
                        ++i;
                    }
                }
                case 4: {
                    OnFirstTunnelFrameReadyListener onFirstTunnelFrameReadyListener;
                    Object object = MediaCodec.this.mListenerLock;
                    synchronized (object) {
                        onFirstTunnelFrameReadyListener = MediaCodec.this.mOnFirstTunnelFrameReadyListener;
                    }
                    if (onFirstTunnelFrameReadyListener == null) break;
                    onFirstTunnelFrameReadyListener.onFirstTunnelFrameReady(this.mCodec);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCallback(@NonNull Message msg) {
            if (MediaCodec.this.mCallback == null) {
                return;
            }
            switch (msg.arg1) {
                case 1: {
                    int index = msg.arg2;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        switch (MediaCodec.this.mBufferMode) {
                            case 0: {
                                MediaCodec.this.validateInputByteBufferLocked(MediaCodec.this.mCachedInputBuffers, index);
                                break;
                            }
                            case 1: {
                                while (MediaCodec.this.mQueueRequests.size() <= index) {
                                    MediaCodec.this.mQueueRequests.add(null);
                                }
                                QueueRequest request = MediaCodec.this.mQueueRequests.get(index);
                                if (request == null) {
                                    request = new QueueRequest(MediaCodec.this, this.mCodec, index);
                                    MediaCodec.this.mQueueRequests.set(index, request);
                                }
                                request.setAccessible(true);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unrecognized buffer mode: " + MediaCodec.this.mBufferMode);
                            }
                        }
                    }
                    MediaCodec.this.mCallback.onInputBufferAvailable(this.mCodec, index);
                    break;
                }
                case 2: {
                    int index = msg.arg2;
                    BufferInfo info = (BufferInfo)msg.obj;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        switch (MediaCodec.this.mBufferMode) {
                            case 0: {
                                MediaCodec.this.validateOutputByteBufferLocked(MediaCodec.this.mCachedOutputBuffers, index, info);
                                break;
                            }
                            case 1: {
                                while (MediaCodec.this.mOutputFrames.size() <= index) {
                                    MediaCodec.this.mOutputFrames.add(null);
                                }
                                OutputFrame frame = MediaCodec.this.mOutputFrames.get(index);
                                if (frame == null) {
                                    frame = new OutputFrame(index);
                                    MediaCodec.this.mOutputFrames.set(index, frame);
                                }
                                frame.setBufferInfo(info);
                                frame.setAccessible(true);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unrecognized buffer mode: " + MediaCodec.this.mBufferMode);
                            }
                        }
                    }
                    MediaCodec.this.mCallback.onOutputBufferAvailable(this.mCodec, index, info);
                    break;
                }
                case 7: {
                    int index = msg.arg2;
                    ArrayDeque infos = (ArrayDeque)msg.obj;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        switch (MediaCodec.this.mBufferMode) {
                            case 0: {
                                MediaCodec.this.validateOutputByteBuffersLocked(MediaCodec.this.mCachedOutputBuffers, index, infos);
                                break;
                            }
                            case 1: {
                                while (MediaCodec.this.mOutputFrames.size() <= index) {
                                    MediaCodec.this.mOutputFrames.add(null);
                                }
                                OutputFrame frame = MediaCodec.this.mOutputFrames.get(index);
                                if (frame == null) {
                                    frame = new OutputFrame(index);
                                    MediaCodec.this.mOutputFrames.set(index, frame);
                                }
                                frame.setBufferInfos(infos);
                                frame.setAccessible(true);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unrecognized buffer mode: for large frame output");
                            }
                        }
                    }
                    MediaCodec.this.mCallback.onOutputBuffersAvailable(this.mCodec, index, infos);
                    break;
                }
                case 3: {
                    MediaCodec.this.mCallback.onError(this.mCodec, (CodecException)msg.obj);
                    break;
                }
                case 6: {
                    MediaCodec.this.mCallback.onCryptoError(this.mCodec, (CryptoException)msg.obj);
                    break;
                }
                case 4: {
                    MediaCodec.this.mCallback.onOutputFormatChanged(this.mCodec, new MediaFormat((Map)msg.obj));
                    break;
                }
                case 8: {
                    if (!MediaCodec.GetFlag(() -> Flags.subsessionMetrics())) break;
                    MediaCodec.this.mCallback.onMetricsFlushed(this.mCodec, (PersistableBundle)msg.obj);
                    break;
                }
                case 9: {
                    if (!Flags.codecAvailability()) break;
                    MediaCodec.this.mCallback.onRequiredResourcesChanged(this.mCodec);
                    break;
                }
            }
        }
    }

    static class PersistentSurface
    extends Surface {
        private long mPersistentObject;

        PersistentSurface() {
        }

        @Override
        public void release() {
            MediaCodec.native_releasePersistentInputSurface(this);
            super.release();
        }
    }

    public class InvalidBufferFlagsException
    extends RuntimeException {
        InvalidBufferFlagsException(String message) {
            super(message);
        }
    }

    public class IncompatibleWithBlockModelException
    extends RuntimeException {
        IncompatibleWithBlockModelException() {
        }

        IncompatibleWithBlockModelException(String message) {
            super(message);
        }

        IncompatibleWithBlockModelException(String message, Throwable cause) {
            super(message, cause);
        }

        IncompatibleWithBlockModelException(Throwable cause) {
            super(cause);
        }
    }

    public static class CryptoException
    extends RuntimeException
    implements MediaDrmThrowable {
        public static final int ERROR_NO_KEY = 1;
        public static final int ERROR_KEY_EXPIRED = 2;
        public static final int ERROR_RESOURCE_BUSY = 3;
        public static final int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4;
        public static final int ERROR_SESSION_NOT_OPENED = 5;
        public static final int ERROR_UNSUPPORTED_OPERATION = 6;
        public static final int ERROR_INSUFFICIENT_SECURITY = 7;
        public static final int ERROR_FRAME_TOO_LARGE = 8;
        public static final int ERROR_LOST_STATE = 9;
        private final int mErrorCode;
        private final int mVendorError;
        private final int mOemError;
        private final int mErrorContext;
        private CryptoInfo mCryptoInfo;

        public CryptoException(int errorCode, @Nullable String detailMessage) {
            this(detailMessage, errorCode, 0, 0, 0, null);
        }

        public CryptoException(String message, int errorCode, int vendorError, int oemError, int errorContext, @Nullable CryptoInfo cryptoInfo) {
            super(message);
            this.mErrorCode = errorCode;
            this.mVendorError = vendorError;
            this.mOemError = oemError;
            this.mErrorContext = errorContext;
            this.mCryptoInfo = cryptoInfo;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        @Nullable
        public CryptoInfo getCryptoInfo() {
            return this.mCryptoInfo;
        }

        @Override
        public int getVendorError() {
            return this.mVendorError;
        }

        @Override
        public int getOemError() {
            return this.mOemError;
        }

        @Override
        public int getErrorContext() {
            return this.mErrorContext;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface CryptoErrorCode {
        }
    }

    public static class CryptoInfo {
        public int numSubSamples;
        public int[] numBytesOfClearData;
        public int[] numBytesOfEncryptedData;
        public byte[] key;
        public byte[] iv;
        public int mode;
        private static final Pattern ZERO_PATTERN = new Pattern(0, 0);
        private Pattern mPattern = ZERO_PATTERN;

        public void set(int newNumSubSamples, @NonNull int[] newNumBytesOfClearData, @NonNull int[] newNumBytesOfEncryptedData, @NonNull byte[] newKey, @NonNull byte[] newIV, int newMode) {
            this.numSubSamples = newNumSubSamples;
            this.numBytesOfClearData = newNumBytesOfClearData;
            this.numBytesOfEncryptedData = newNumBytesOfEncryptedData;
            this.key = newKey;
            this.iv = newIV;
            this.mode = newMode;
            this.mPattern = ZERO_PATTERN;
        }

        @NonNull
        public Pattern getPattern() {
            return new Pattern(this.mPattern.getEncryptBlocks(), this.mPattern.getSkipBlocks());
        }

        public void setPattern(Pattern newPattern) {
            if (newPattern == null) {
                newPattern = ZERO_PATTERN;
            }
            this.setPattern(newPattern.getEncryptBlocks(), newPattern.getSkipBlocks());
        }

        private void setPattern(int blocksToEncrypt, int blocksToSkip) {
            this.mPattern = new Pattern(blocksToEncrypt, blocksToSkip);
        }

        public String toString() {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append(this.numSubSamples + " subsamples, key [");
            String hexdigits = "0123456789abcdef";
            for (i = 0; i < this.key.length; ++i) {
                builder.append(hexdigits.charAt((this.key[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.key[i] & 0xF));
            }
            builder.append("], iv [");
            for (i = 0; i < this.iv.length; ++i) {
                builder.append(hexdigits.charAt((this.iv[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.iv[i] & 0xF));
            }
            builder.append("], clear ");
            builder.append(Arrays.toString(this.numBytesOfClearData));
            builder.append(", encrypted ");
            builder.append(Arrays.toString(this.numBytesOfEncryptedData));
            builder.append(", pattern (encrypt: ");
            builder.append(this.mPattern.mEncryptBlocks);
            builder.append(", skip: ");
            builder.append(this.mPattern.mSkipBlocks);
            builder.append(")");
            return builder.toString();
        }

        public static class Pattern {
            private int mEncryptBlocks;
            private int mSkipBlocks;

            public Pattern(int blocksToEncrypt, int blocksToSkip) {
                this.set(blocksToEncrypt, blocksToSkip);
            }

            public void set(int blocksToEncrypt, int blocksToSkip) {
                this.mEncryptBlocks = blocksToEncrypt;
                this.mSkipBlocks = blocksToSkip;
            }

            public int getSkipBlocks() {
                return this.mSkipBlocks;
            }

            public int getEncryptBlocks() {
                return this.mEncryptBlocks;
            }
        }
    }

    public class QueueRequest {
        private final MediaCodec mCodec;
        private final int mIndex;
        private LinearBlock mLinearBlock = null;
        private int mOffset = 0;
        private int mSize = 0;
        private HardwareBuffer mHardwareBuffer = null;
        private long mPresentationTimeUs = 0L;
        private int mFlags = 0;
        private final ArrayDeque<BufferInfo> mBufferInfos = new ArrayDeque();
        private final ArrayDeque<CryptoInfo> mCryptoInfos = new ArrayDeque();
        private final ArrayList<String> mTuningKeys = new ArrayList();
        private final ArrayList<Object> mTuningValues = new ArrayList();
        private boolean mAccessible = false;

        private QueueRequest(@NonNull MediaCodec this$0, MediaCodec codec, int index) {
            this.mCodec = codec;
            this.mIndex = index;
        }

        @NonNull
        public QueueRequest setLinearBlock(@NonNull LinearBlock block, int offset, int size) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            if (this.mLinearBlock != null || this.mHardwareBuffer != null) {
                throw new IllegalStateException("Cannot set block twice");
            }
            this.mLinearBlock = block;
            this.mOffset = offset;
            this.mSize = size;
            this.mCryptoInfos.clear();
            return this;
        }

        @FlaggedApi(value="com.android.media.codec.flags.large_audio_frame")
        @NonNull
        public QueueRequest setMultiFrameLinearBlock(@NonNull LinearBlock block, @NonNull ArrayDeque<BufferInfo> infos) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            if (this.mLinearBlock != null || this.mHardwareBuffer != null) {
                throw new IllegalStateException("Cannot set block twice");
            }
            this.mLinearBlock = block;
            this.mBufferInfos.clear();
            this.mBufferInfos.addAll(infos);
            this.mCryptoInfos.clear();
            return this;
        }

        @NonNull
        public QueueRequest setEncryptedLinearBlock(@NonNull LinearBlock block, int offset, int size, @NonNull CryptoInfo cryptoInfo) {
            Objects.requireNonNull(cryptoInfo);
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            if (this.mLinearBlock != null || this.mHardwareBuffer != null) {
                throw new IllegalStateException("Cannot set block twice");
            }
            this.mLinearBlock = block;
            this.mOffset = offset;
            this.mSize = size;
            this.mCryptoInfos.clear();
            this.mCryptoInfos.add(cryptoInfo);
            return this;
        }

        @FlaggedApi(value="com.android.media.codec.flags.large_audio_frame")
        @NonNull
        public QueueRequest setMultiFrameEncryptedLinearBlock(@NonNull LinearBlock block, @NonNull ArrayDeque<BufferInfo> bufferInfos, @NonNull ArrayDeque<CryptoInfo> cryptoInfos) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            if (this.mLinearBlock != null || this.mHardwareBuffer != null) {
                throw new IllegalStateException("Cannot set block twice");
            }
            this.mLinearBlock = block;
            this.mBufferInfos.clear();
            this.mBufferInfos.addAll(bufferInfos);
            this.mCryptoInfos.clear();
            this.mCryptoInfos.addAll(cryptoInfos);
            return this;
        }

        @NonNull
        public QueueRequest setHardwareBuffer(@NonNull HardwareBuffer buffer) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            if (this.mLinearBlock != null || this.mHardwareBuffer != null) {
                throw new IllegalStateException("Cannot set block twice");
            }
            this.mHardwareBuffer = buffer;
            return this;
        }

        @NonNull
        public QueueRequest setPresentationTimeUs(long presentationTimeUs) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mPresentationTimeUs = presentationTimeUs;
            return this;
        }

        @NonNull
        public QueueRequest setFlags(int flags) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mFlags = flags;
            return this;
        }

        @NonNull
        public QueueRequest setIntegerParameter(@NonNull String key, int value) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mTuningKeys.add(key);
            this.mTuningValues.add(value);
            return this;
        }

        @NonNull
        public QueueRequest setLongParameter(@NonNull String key, long value) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mTuningKeys.add(key);
            this.mTuningValues.add(value);
            return this;
        }

        @NonNull
        public QueueRequest setFloatParameter(@NonNull String key, float value) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mTuningKeys.add(key);
            this.mTuningValues.add(Float.valueOf(value));
            return this;
        }

        @NonNull
        public QueueRequest setByteBufferParameter(@NonNull String key, @NonNull ByteBuffer value) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mTuningKeys.add(key);
            this.mTuningValues.add(value);
            return this;
        }

        @NonNull
        public QueueRequest setStringParameter(@NonNull String key, @NonNull String value) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mTuningKeys.add(key);
            this.mTuningValues.add(value);
            return this;
        }

        public void queue() {
            Trace.traceBegin(512L, "MediaCodec::queueRequest-queue#java");
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            if (this.mLinearBlock == null && this.mHardwareBuffer == null) {
                throw new IllegalStateException("No block is set");
            }
            this.setAccessible(false);
            if (this.mBufferInfos.isEmpty()) {
                BufferInfo info = new BufferInfo();
                info.size = this.mSize;
                info.offset = this.mOffset;
                info.presentationTimeUs = this.mPresentationTimeUs;
                info.flags = this.mFlags;
                this.mBufferInfos.add(info);
            }
            if (this.mLinearBlock != null) {
                this.mCodec.native_queueLinearBlock(this.mIndex, this.mLinearBlock, this.mCryptoInfos.isEmpty() ? null : this.mCryptoInfos.toArray(), this.mBufferInfos.toArray(), this.mTuningKeys, this.mTuningValues);
            } else if (this.mHardwareBuffer != null) {
                this.mCodec.native_queueHardwareBuffer(this.mIndex, this.mHardwareBuffer, this.mPresentationTimeUs, this.mFlags, this.mTuningKeys, this.mTuningValues);
            }
            this.clear();
            Trace.traceEnd(512L);
        }

        @NonNull
        QueueRequest clear() {
            this.mLinearBlock = null;
            this.mOffset = 0;
            this.mSize = 0;
            this.mHardwareBuffer = null;
            this.mPresentationTimeUs = 0L;
            this.mFlags = 0;
            this.mBufferInfos.clear();
            this.mCryptoInfos.clear();
            this.mTuningKeys.clear();
            this.mTuningValues.clear();
            return this;
        }

        boolean isAccessible() {
            return this.mAccessible;
        }

        @NonNull
        QueueRequest setAccessible(boolean accessible) {
            this.mAccessible = accessible;
            return this;
        }
    }

    public static class BufferInfo {
        public int offset;
        public int size;
        public long presentationTimeUs;
        public int flags;

        public void set(int newOffset, int newSize, long newTimeUs, int newFlags) {
            this.offset = newOffset;
            this.size = newSize;
            this.presentationTimeUs = newTimeUs;
            this.flags = newFlags;
        }

        @NonNull
        public BufferInfo dup() {
            BufferInfo copy = new BufferInfo();
            copy.set(this.offset, this.size, this.presentationTimeUs, this.flags);
            return copy;
        }
    }

    public static class OutputFrame {
        private final int mIndex;
        private LinearBlock mLinearBlock = null;
        private HardwareBuffer mHardwareBuffer = null;
        private long mPresentationTimeUs = 0L;
        private int mFlags = 0;
        private MediaFormat mFormat = null;
        private final ArrayDeque<BufferInfo> mBufferInfos = new ArrayDeque();
        private final ArrayList<String> mChangedKeys = new ArrayList();
        private final Set<String> mKeySet = new HashSet<String>();
        private boolean mAccessible = false;
        private boolean mLoaded = false;

        OutputFrame(int index) {
            this.mIndex = index;
        }

        @Nullable
        public LinearBlock getLinearBlock() {
            if (this.mHardwareBuffer != null) {
                throw new IllegalStateException("This output frame is not linear");
            }
            return this.mLinearBlock;
        }

        @Nullable
        public HardwareBuffer getHardwareBuffer() {
            if (this.mLinearBlock != null) {
                throw new IllegalStateException("This output frame is not graphic");
            }
            return this.mHardwareBuffer;
        }

        public long getPresentationTimeUs() {
            return this.mPresentationTimeUs;
        }

        public int getFlags() {
            return this.mFlags;
        }

        @FlaggedApi(value="com.android.media.codec.flags.large_audio_frame")
        @NonNull
        public ArrayDeque<BufferInfo> getBufferInfos() {
            if (this.mBufferInfos.isEmpty()) {
                BufferInfo bufferInfo = new BufferInfo();
                bufferInfo.set(0, 0, this.mPresentationTimeUs, this.mFlags);
                this.mBufferInfos.add(bufferInfo);
            }
            return this.mBufferInfos;
        }

        @NonNull
        public MediaFormat getFormat() {
            return this.mFormat;
        }

        @NonNull
        public Set<String> getChangedKeys() {
            if (this.mKeySet.isEmpty() && !this.mChangedKeys.isEmpty()) {
                this.mKeySet.addAll(this.mChangedKeys);
            }
            return Collections.unmodifiableSet(this.mKeySet);
        }

        void clear() {
            this.mLinearBlock = null;
            this.mHardwareBuffer = null;
            this.mFormat = null;
            this.mBufferInfos.clear();
            this.mChangedKeys.clear();
            this.mKeySet.clear();
            this.mLoaded = false;
        }

        boolean isAccessible() {
            return this.mAccessible;
        }

        void setAccessible(boolean accessible) {
            this.mAccessible = accessible;
        }

        void setBufferInfo(BufferInfo info) {
            this.mBufferInfos.clear();
            this.mPresentationTimeUs = info.presentationTimeUs;
            this.mFlags = info.flags;
        }

        void setBufferInfos(ArrayDeque<BufferInfo> infos) {
            this.mBufferInfos.clear();
            this.mBufferInfos.addAll(infos);
        }

        boolean isLoaded() {
            return this.mLoaded;
        }

        void setLoaded(boolean loaded) {
            this.mLoaded = loaded;
        }
    }

    public static abstract class Callback {
        public abstract void onInputBufferAvailable(@NonNull MediaCodec var1, int var2);

        public abstract void onOutputBufferAvailable(@NonNull MediaCodec var1, int var2, @NonNull BufferInfo var3);

        @FlaggedApi(value="com.android.media.codec.flags.large_audio_frame")
        public void onOutputBuffersAvailable(@NonNull MediaCodec codec, int index, @NonNull ArrayDeque<BufferInfo> infos) {
            throw new IllegalStateException("Client must override onOutputBuffersAvailable when codec is configured to operate with multiple access units");
        }

        public abstract void onError(@NonNull MediaCodec var1, @NonNull CodecException var2);

        public void onCryptoError(@NonNull MediaCodec codec, @NonNull CryptoException e) {
            throw new IllegalStateException("Client must override onCryptoError when the codec is configured with CONFIGURE_FLAG_USE_CRYPTO_ASYNC.", e);
        }

        public abstract void onOutputFormatChanged(@NonNull MediaCodec var1, @NonNull MediaFormat var2);

        @FlaggedApi(value="android.media.codec.subsession_metrics")
        public void onMetricsFlushed(@NonNull MediaCodec codec, @NonNull PersistableBundle metrics) {
        }

        @FlaggedApi(value="android.media.codec.codec_availability")
        public void onRequiredResourcesChanged(@NonNull MediaCodec codec) {
        }
    }

    public static interface OnFirstTunnelFrameReadyListener {
        public void onFirstTunnelFrameReady(@NonNull MediaCodec var1);
    }

    public static interface OnFrameRenderedListener {
        public void onFrameRendered(@NonNull MediaCodec var1, long var2, long var4);
    }

    public static class ParameterDescriptor {
        private String mName;
        private int mType;

        private ParameterDescriptor() {
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        public int getType() {
            return this.mType;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ParameterDescriptor)) {
                return false;
            }
            ParameterDescriptor other = (ParameterDescriptor)o;
            return this.mName.equals(other.mName) && this.mType == other.mType;
        }

        public int hashCode() {
            return Arrays.asList(this.mName, this.mType).hashCode();
        }
    }

    public static class MetricsConstants {
        public static final String CODEC = "android.media.mediacodec.codec";
        public static final String MIME_TYPE = "android.media.mediacodec.mime";
        public static final String MODE = "android.media.mediacodec.mode";
        public static final String MODE_AUDIO = "audio";
        public static final String MODE_VIDEO = "video";
        public static final String ENCODER = "android.media.mediacodec.encoder";
        public static final String SECURE = "android.media.mediacodec.secure";
        public static final String WIDTH = "android.media.mediacodec.width";
        public static final String HEIGHT = "android.media.mediacodec.height";
        public static final String ROTATION = "android.media.mediacodec.rotation";

        private MetricsConstants() {
        }
    }

    public static class MediaImage
    extends Image {
        private final boolean mIsReadOnly;
        private final int mWidth;
        private final int mHeight;
        private final int mFormat;
        private long mTimestamp;
        private final Image.Plane[] mPlanes;
        private final ByteBuffer mBuffer;
        private final ByteBuffer mInfo;
        private final int mXOffset;
        private final int mYOffset;
        private final long mBufferContext;
        private static final int TYPE_YUV = 1;
        private final int mTransform = 0;
        private final int mScalingMode = 0;

        @Override
        public int getFormat() {
            this.throwISEIfImageIsInvalid();
            return this.mFormat;
        }

        @Override
        public int getHeight() {
            this.throwISEIfImageIsInvalid();
            return this.mHeight;
        }

        @Override
        public int getWidth() {
            this.throwISEIfImageIsInvalid();
            return this.mWidth;
        }

        @Override
        public int getTransform() {
            this.throwISEIfImageIsInvalid();
            return 0;
        }

        @Override
        public int getScalingMode() {
            this.throwISEIfImageIsInvalid();
            return 0;
        }

        @Override
        public long getTimestamp() {
            this.throwISEIfImageIsInvalid();
            return this.mTimestamp;
        }

        @Override
        @NonNull
        public Image.Plane[] getPlanes() {
            this.throwISEIfImageIsInvalid();
            return Arrays.copyOf(this.mPlanes, this.mPlanes.length);
        }

        @Override
        public void close() {
            if (this.mIsImageValid) {
                if (this.mBuffer != null) {
                    NioUtils_Delegate.freeDirectBuffer(this.mBuffer);
                }
                if (this.mBufferContext != 0L) {
                    MediaCodec.native_closeMediaImage(this.mBufferContext);
                }
                this.mIsImageValid = false;
            }
        }

        @Override
        public void setCropRect(@Nullable Rect cropRect) {
            if (this.mIsReadOnly) {
                throw new ReadOnlyBufferException();
            }
            super.setCropRect(cropRect);
        }

        public MediaImage(@NonNull ByteBuffer buffer, @NonNull ByteBuffer info, boolean readOnly, long timestamp, int xOffset, int yOffset, @Nullable Rect cropRect) {
            this.mTimestamp = timestamp;
            this.mIsImageValid = true;
            this.mIsReadOnly = buffer.isReadOnly();
            this.mBuffer = buffer.duplicate();
            this.mXOffset = xOffset;
            this.mYOffset = yOffset;
            this.mInfo = info;
            this.mBufferContext = 0L;
            int cbPlaneOffset = -1;
            int crPlaneOffset = -1;
            int planeOffsetInc = -1;
            int pixelStride = -1;
            if (info.remaining() == 104) {
                int type = info.getInt();
                if (type != 1) {
                    throw new UnsupportedOperationException("unsupported type: " + type);
                }
                int numPlanes = info.getInt();
                if (numPlanes != 3) {
                    throw new RuntimeException("unexpected number of planes: " + numPlanes);
                }
                this.mWidth = info.getInt();
                this.mHeight = info.getInt();
                if (this.mWidth < 1 || this.mHeight < 1) {
                    throw new UnsupportedOperationException("unsupported size: " + this.mWidth + "x" + this.mHeight);
                }
                int bitDepth = info.getInt();
                if (bitDepth != 8 && bitDepth != 10) {
                    throw new UnsupportedOperationException("unsupported bit depth: " + bitDepth);
                }
                int bitDepthAllocated = info.getInt();
                if (bitDepthAllocated != 8 && bitDepthAllocated != 16) {
                    throw new UnsupportedOperationException("unsupported allocated bit depth: " + bitDepthAllocated);
                }
                if (bitDepth == 8 && bitDepthAllocated == 8) {
                    this.mFormat = 35;
                    planeOffsetInc = 1;
                    pixelStride = 2;
                } else if (bitDepth == 10 && bitDepthAllocated == 16) {
                    this.mFormat = 54;
                    planeOffsetInc = 2;
                    pixelStride = 4;
                } else {
                    throw new UnsupportedOperationException("couldn't infer ImageFormat bitDepth: " + bitDepth + " bitDepthAllocated: " + bitDepthAllocated);
                }
                this.mPlanes = new MediaPlane[numPlanes];
                for (int ix = 0; ix < numPlanes; ++ix) {
                    int vert;
                    int planeOffset = info.getInt();
                    int colInc = info.getInt();
                    int rowInc = info.getInt();
                    int horiz = info.getInt();
                    if (horiz != (vert = info.getInt()) || horiz != (ix == 0 ? 1 : 2)) {
                        throw new UnsupportedOperationException("unexpected subsampling: " + horiz + "x" + vert + " on plane " + ix);
                    }
                    if (colInc < 1 || rowInc < 1) {
                        throw new UnsupportedOperationException("unexpected strides: " + colInc + " pixel, " + rowInc + " row on plane " + ix);
                    }
                    buffer.clear();
                    buffer.position(this.mBuffer.position() + planeOffset + xOffset / horiz * colInc + yOffset / vert * rowInc);
                    buffer.limit(buffer.position() + Utils.divUp(bitDepth, 8) + (this.mHeight / vert - 1) * rowInc + (this.mWidth / horiz - 1) * colInc);
                    this.mPlanes[ix] = new MediaPlane(buffer.slice(), rowInc, colInc);
                    if ((this.mFormat == 35 || this.mFormat == 54 || this.mFormat == 60) && ix == 1) {
                        cbPlaneOffset = planeOffset;
                        continue;
                    }
                    if (this.mFormat != 35 && this.mFormat != 54 && this.mFormat != 60 || ix != 2) continue;
                    crPlaneOffset = planeOffset;
                }
            } else {
                throw new UnsupportedOperationException("unsupported info length: " + info.remaining());
            }
            if (this.mFormat == 54 || this.mFormat == 60) {
                if (crPlaneOffset != cbPlaneOffset + planeOffsetInc) {
                    throw new UnsupportedOperationException("Invalid plane offsets cbPlaneOffset: " + cbPlaneOffset + " crPlaneOffset: " + crPlaneOffset);
                }
                if (this.mPlanes[1].getPixelStride() != pixelStride || this.mPlanes[2].getPixelStride() != pixelStride) {
                    throw new UnsupportedOperationException("Invalid pixelStride");
                }
            }
            if (cropRect == null) {
                cropRect = new Rect(0, 0, this.mWidth, this.mHeight);
            }
            cropRect.offset(-xOffset, -yOffset);
            super.setCropRect(cropRect);
        }

        public MediaImage(@NonNull ByteBuffer[] buffers, int[] rowStrides, int[] pixelStrides, int width, int height, int format, boolean readOnly, long timestamp, int xOffset, int yOffset, @Nullable Rect cropRect, long context) {
            if (buffers.length != rowStrides.length || buffers.length != pixelStrides.length) {
                throw new IllegalArgumentException("buffers, rowStrides and pixelStrides should have the same length");
            }
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
            this.mTimestamp = timestamp;
            this.mIsImageValid = true;
            this.mIsReadOnly = readOnly;
            this.mBuffer = null;
            this.mInfo = null;
            this.mPlanes = new MediaPlane[buffers.length];
            for (int i = 0; i < buffers.length; ++i) {
                this.mPlanes[i] = new MediaPlane(buffers[i], rowStrides[i], pixelStrides[i]);
            }
            this.mXOffset = xOffset;
            this.mYOffset = yOffset;
            if (cropRect == null) {
                cropRect = new Rect(0, 0, this.mWidth, this.mHeight);
            }
            cropRect.offset(-xOffset, -yOffset);
            super.setCropRect(cropRect);
            this.mBufferContext = context;
        }

        private class MediaPlane
        extends Image.Plane {
            private final int mRowInc;
            private final int mColInc;
            private final ByteBuffer mData;

            public MediaPlane(ByteBuffer buffer, int rowInc, int colInc) {
                this.mData = buffer;
                this.mRowInc = rowInc;
                this.mColInc = colInc;
            }

            @Override
            public int getRowStride() {
                MediaImage.this.throwISEIfImageIsInvalid();
                return this.mRowInc;
            }

            @Override
            public int getPixelStride() {
                MediaImage.this.throwISEIfImageIsInvalid();
                return this.mColInc;
            }

            @Override
            @NonNull
            public ByteBuffer getBuffer() {
                MediaImage.this.throwISEIfImageIsInvalid();
                return this.mData;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoScalingMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OutputBufferInfo {
    }

    public static class LinearBlock {
        private static final BlockingQueue<LinearBlock> sPool = new LinkedBlockingQueue<LinearBlock>();
        private final Object mLock = new Object();
        private boolean mValid = false;
        private boolean mMappable = false;
        private ByteBuffer mMapped = null;
        private long mNativeContext = 0L;
        private boolean mInternal = false;

        private LinearBlock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMappable() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mValid) {
                    throw new IllegalStateException("The linear block is invalid");
                }
                return this.mMappable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public ByteBuffer map() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mValid) {
                    throw new IllegalStateException("The linear block is invalid");
                }
                if (!this.mMappable) {
                    throw new IllegalStateException("The linear block is not mappable");
                }
                if (this.mMapped == null) {
                    this.mMapped = this.native_map();
                }
                return this.mMapped;
            }
        }

        private ByteBuffer native_map() {
            return (ByteBuffer)OverrideMethod.invokeA("android.media.MediaCodec$LinearBlock#native_map()Ljava/nio/ByteBuffer;", true, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mValid) {
                    throw new IllegalStateException("The linear block is invalid");
                }
                if (this.mMapped != null) {
                    this.mMapped.setAccessible(false);
                    this.mMapped = null;
                }
                this.native_recycle();
                this.mValid = false;
                this.mNativeContext = 0L;
            }
            if (!this.mInternal) {
                sPool.offer(this);
            }
        }

        private void native_recycle() {
            OverrideMethod.invokeV("android.media.MediaCodec$LinearBlock#native_recycle()V", true, this);
        }

        private void native_obtain(int n, String[] stringArray) {
            OverrideMethod.invokeV("android.media.MediaCodec$LinearBlock#native_obtain(I[Ljava/lang/String;)V", true, this);
        }

        protected void finalize() {
            this.native_recycle();
        }

        public static boolean isCodecCopyFreeCompatible(@NonNull String[] codecNames) {
            return LinearBlock.native_checkCompatible(codecNames);
        }

        private static boolean native_checkCompatible(@NonNull String[] stringArray) {
            return OverrideMethod.invokeI("android.media.MediaCodec$LinearBlock#native_checkCompatible([Ljava/lang/String;)Z", true, null) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public static LinearBlock obtain(int capacity, @NonNull String[] codecNames) {
            LinearBlock buffer = (LinearBlock)sPool.poll();
            if (buffer == null) {
                buffer = new LinearBlock();
            }
            Object object = buffer.mLock;
            synchronized (object) {
                buffer.native_obtain(capacity, codecNames);
            }
            return buffer;
        }

        private void setInternalStateLocked(long context, boolean isMappable) {
            this.mNativeContext = context;
            this.mMappable = isMappable;
            this.mValid = context != 0L;
            this.mInternal = true;
        }
    }

    public static class CodecException
    extends IllegalStateException {
        public static final int ERROR_INSUFFICIENT_RESOURCE = 1100;
        public static final int ERROR_RECLAIMED = 1101;
        private static final int ACTION_TRANSIENT = 1;
        private static final int ACTION_RECOVERABLE = 2;
        private final String mDiagnosticInfo;
        private final int mErrorCode;
        private final int mActionCode;

        @UnsupportedAppUsage
        CodecException(int errorCode, int actionCode, @Nullable String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
            this.mActionCode = actionCode;
            String sign = errorCode < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaCodec.error_" + sign + Math.abs(errorCode);
        }

        public boolean isTransient() {
            return this.mActionCode == 1;
        }

        public boolean isRecoverable() {
            return this.mActionCode == 2;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        @NonNull
        public String getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ReasonCode {
        }
    }

    @FlaggedApi(value="android.media.codec.codec_availability")
    public static class InstanceResourceInfo {
        String mName;
        long mStaticCount;
        long mPerFrameCount;

        @NonNull
        public String getName() {
            return this.mName;
        }

        public long getStaticCount() {
            return this.mStaticCount;
        }

        public long getPerFrameCount() {
            return this.mPerFrameCount;
        }
    }

    @FlaggedApi(value="android.media.codec.codec_availability")
    public static class GlobalResourceInfo {
        String mName;
        long mCapacity;
        long mAvailable;

        @NonNull
        public String getName() {
            return this.mName;
        }

        public long getCapacity() {
            return this.mCapacity;
        }

        public long getAvailable() {
            return this.mAvailable;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfigureFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BufferFlag {
    }
}

