/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.compat.annotation.UnsupportedAppUsage;
import android.media.AudioAttributes;
import android.media.VolumeShaper;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.UserHandle;

public interface IRingtonePlayer
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/IRingtonePlayer.aidl:30:1:30:25")
    public void play(IBinder var1, Uri var2, AudioAttributes var3, float var4, boolean var5) throws RemoteException;

    public void playWithVolumeShaping(IBinder var1, Uri var2, AudioAttributes var3, float var4, boolean var5, VolumeShaper.Configuration var6) throws RemoteException;

    public void stop(IBinder var1) throws RemoteException;

    public boolean isPlaying(IBinder var1) throws RemoteException;

    public void setPlaybackProperties(IBinder var1, float var2, boolean var3, boolean var4) throws RemoteException;

    public void playAsync(Uri var1, UserHandle var2, boolean var3, AudioAttributes var4, float var5) throws RemoteException;

    public void stopAsync() throws RemoteException;

    public String getTitle(Uri var1) throws RemoteException;

    public ParcelFileDescriptor openRingtone(Uri var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRingtonePlayer {
        public static final String DESCRIPTOR = "android.media.IRingtonePlayer";
        static final int TRANSACTION_play = 1;
        static final int TRANSACTION_playWithVolumeShaping = 2;
        static final int TRANSACTION_stop = 3;
        static final int TRANSACTION_isPlaying = 4;
        static final int TRANSACTION_setPlaybackProperties = 5;
        static final int TRANSACTION_playAsync = 6;
        static final int TRANSACTION_stopAsync = 7;
        static final int TRANSACTION_getTitle = 8;
        static final int TRANSACTION_openRingtone = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRingtonePlayer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRingtonePlayer) {
                return (IRingtonePlayer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "play";
                }
                case 2: {
                    return "playWithVolumeShaping";
                }
                case 3: {
                    return "stop";
                }
                case 4: {
                    return "isPlaying";
                }
                case 5: {
                    return "setPlaybackProperties";
                }
                case 6: {
                    return "playAsync";
                }
                case 7: {
                    return "stopAsync";
                }
                case 8: {
                    return "getTitle";
                }
                case 9: {
                    return "openRingtone";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    AudioAttributes _arg2 = data.readTypedObject(AudioAttributes.CREATOR);
                    float _arg3 = data.readFloat();
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.play(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    AudioAttributes _arg2 = data.readTypedObject(AudioAttributes.CREATOR);
                    float _arg3 = data.readFloat();
                    boolean _arg4 = data.readBoolean();
                    VolumeShaper.Configuration _arg5 = data.readTypedObject(VolumeShaper.Configuration.CREATOR);
                    data.enforceNoDataAvail();
                    this.playWithVolumeShaping(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.stop(_arg0);
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isPlaying(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    float _arg1 = data.readFloat();
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setPlaybackProperties(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 6: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    AudioAttributes _arg3 = data.readTypedObject(AudioAttributes.CREATOR);
                    float _arg4 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.playAsync(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 7: {
                    this.stopAsync();
                    break;
                }
                case 8: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getTitle(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 9: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.openRingtone(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IRingtonePlayer {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void play(IBinder token, Uri uri, AudioAttributes aa, float volume, boolean looping) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(uri, 0);
                    _data.writeTypedObject(aa, 0);
                    _data.writeFloat(volume);
                    _data.writeBoolean(looping);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playWithVolumeShaping(IBinder token, Uri uri, AudioAttributes aa, float volume, boolean looping, VolumeShaper.Configuration volumeShaperConfig) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(uri, 0);
                    _data.writeTypedObject(aa, 0);
                    _data.writeFloat(volume);
                    _data.writeBoolean(looping);
                    _data.writeTypedObject(volumeShaperConfig, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPlaying(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPlaybackProperties(IBinder token, float volume, boolean looping, boolean hapticGeneratorEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeFloat(volume);
                    _data.writeBoolean(looping);
                    _data.writeBoolean(hapticGeneratorEnabled);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playAsync(Uri uri, UserHandle user, boolean looping, AudioAttributes aa, float volume) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uri, 0);
                    _data.writeTypedObject(user, 0);
                    _data.writeBoolean(looping);
                    _data.writeTypedObject(aa, 0);
                    _data.writeFloat(volume);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void stopAsync() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getTitle(Uri uri) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uri, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openRingtone(Uri uri) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uri, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IRingtonePlayer {
        @Override
        public void play(IBinder token, Uri uri, AudioAttributes aa, float volume, boolean looping) throws RemoteException {
        }

        @Override
        public void playWithVolumeShaping(IBinder token, Uri uri, AudioAttributes aa, float volume, boolean looping, VolumeShaper.Configuration volumeShaperConfig) throws RemoteException {
        }

        @Override
        public void stop(IBinder token) throws RemoteException {
        }

        @Override
        public boolean isPlaying(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public void setPlaybackProperties(IBinder token, float volume, boolean looping, boolean hapticGeneratorEnabled) throws RemoteException {
        }

        @Override
        public void playAsync(Uri uri, UserHandle user, boolean looping, AudioAttributes aa, float volume) throws RemoteException {
        }

        @Override
        public void stopAsync() throws RemoteException {
        }

        @Override
        public String getTitle(Uri uri) throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor openRingtone(Uri uri) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

