/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.EnforcePermission;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.bluetooth.BluetoothDevice;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.media.AudioAttributes;
import android.media.AudioDeviceAttributes;
import android.media.AudioFocusInfo;
import android.media.AudioFormat;
import android.media.AudioHalVersionInfo;
import android.media.AudioMixerAttributes;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecordingConfiguration;
import android.media.AudioRoutesInfo;
import android.media.BluetoothProfileConnectionInfo;
import android.media.FadeManagerConfiguration;
import android.media.IAudioDeviceVolumeDispatcher;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioManagerNative;
import android.media.IAudioModeDispatcher;
import android.media.IAudioRoutesObserver;
import android.media.IAudioServerStateDispatcher;
import android.media.ICapturePresetDevicesRoleDispatcher;
import android.media.ICommunicationDeviceDispatcher;
import android.media.IDeviceVolumeBehaviorDispatcher;
import android.media.IDevicesForAttributesCallback;
import android.media.ILoudnessCodecUpdatesDispatcher;
import android.media.IMuteAwaitConnectionCallback;
import android.media.IPlaybackConfigDispatcher;
import android.media.IPreferredMixerAttributesDispatcher;
import android.media.IRecordingConfigDispatcher;
import android.media.IRingtonePlayer;
import android.media.ISpatializerCallback;
import android.media.ISpatializerHeadToSoundStagePoseCallback;
import android.media.ISpatializerHeadTrackerAvailableCallback;
import android.media.ISpatializerHeadTrackingModeCallback;
import android.media.ISpatializerOutputCallback;
import android.media.IStrategyNonDefaultDevicesDispatcher;
import android.media.IStrategyPreferredDevicesDispatcher;
import android.media.IStreamAliasingDispatcher;
import android.media.IVolumeController;
import android.media.LoudnessCodecInfo;
import android.media.PlayerBase;
import android.media.VolumeInfo;
import android.media.VolumePolicy;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioMixingRule;
import android.media.audiopolicy.AudioPolicyConfig;
import android.media.audiopolicy.AudioProductStrategy;
import android.media.audiopolicy.AudioVolumeGroup;
import android.media.audiopolicy.IAudioPolicyCallback;
import android.media.audiopolicy.IAudioVolumeChangeDispatcher;
import android.media.projection.IMediaProjection;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.view.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IAudioService
extends IInterface {
    public IAudioManagerNative getNativeInterface() throws RemoteException;

    public int trackPlayer(PlayerBase.PlayerIdCard var1) throws RemoteException;

    public void playerAttributes(int var1, AudioAttributes var2) throws RemoteException;

    public void playerEvent(int var1, int var2, int[] var3) throws RemoteException;

    public void releasePlayer(int var1) throws RemoteException;

    public int trackRecorder(IBinder var1) throws RemoteException;

    public void recorderEvent(int var1, int var2) throws RemoteException;

    public void releaseRecorder(int var1) throws RemoteException;

    public void playerSessionId(int var1, int var2) throws RemoteException;

    public void portEvent(int var1, int var2, PersistableBundle var3) throws RemoteException;

    public void permissionUpdateBarrier() throws RemoteException;

    public void adjustStreamVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    public void adjustStreamVolumeWithAttribution(int var1, int var2, int var3, String var4, String var5) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:115:1:115:69")
    public void setStreamVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    public void setStreamVolumeWithAttribution(int var1, int var2, int var3, String var4, String var5) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public void setDeviceVolume(VolumeInfo var1, AudioDeviceAttributes var2, String var3) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public void setVolumeForDevice(VolumeInfo var1, AudioDeviceAttributes var2, String var3) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public void adjustVolumeForDevice(VolumeInfo var1, int var2, AudioDeviceAttributes var3, String var4) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void notifyAbsoluteVolumeChanged(VolumeInfo var1, AudioDeviceAttributes var2, String var3) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public VolumeInfo getDeviceVolume(VolumeInfo var1, AudioDeviceAttributes var2, String var3) throws RemoteException;

    public void handleVolumeKey(KeyEvent var1, boolean var2, String var3, String var4) throws RemoteException;

    public boolean isStreamMute(int var1) throws RemoteException;

    public void forceRemoteSubmixFullVolume(boolean var1, IBinder var2) throws RemoteException;

    public boolean isMasterMute() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setMasterMute(boolean var1, int var2, String var3, int var4, String var5) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:154:1:154:25")
    public int getStreamVolume(int var1) throws RemoteException;

    public int getStreamMinVolume(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:159:1:159:25")
    public int getStreamMaxVolume(int var1) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"})
    public List<AudioVolumeGroup> getAudioVolumeGroups() throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"})
    public void setVolumeGroupVolumeIndex(int var1, int var2, int var3, String var4, String var5) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"})
    public int getVolumeGroupVolumeIndex(int var1) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"})
    public int getVolumeGroupMaxVolumeIndex(int var1) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"})
    public int getVolumeGroupMinVolumeIndex(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.QUERY_AUDIO_STATE")
    public int getLastAudibleVolumeForVolumeGroup(int var1) throws RemoteException;

    public boolean isVolumeGroupMuted(int var1) throws RemoteException;

    public void adjustVolumeGroupVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    @EnforcePermission(value="android.permission.QUERY_AUDIO_STATE")
    public int getLastAudibleStreamVolume(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setSupportedSystemUsages(int[] var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int[] getSupportedSystemUsages() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioProductStrategy> getAudioProductStrategies() throws RemoteException;

    public boolean isMicrophoneMuted() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_ULTRASOUND")
    public boolean isUltrasoundSupported() throws RemoteException;

    @EnforcePermission(value="android.permission.CAPTURE_AUDIO_HOTWORD")
    public boolean isHotwordStreamSupported(boolean var1) throws RemoteException;

    public void setMicrophoneMute(boolean var1, String var2, int var3, String var4) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setInputGainIndex(AudioDeviceAttributes var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int getInputGainIndex(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int getMaxInputGainIndex() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int getMinInputGainIndex() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean isInputGainFixed(AudioDeviceAttributes var1) throws RemoteException;

    public void setMicrophoneMuteFromSwitch(boolean var1) throws RemoteException;

    public void setRingerModeExternal(int var1, String var2) throws RemoteException;

    public void setRingerModeInternal(int var1, String var2) throws RemoteException;

    public int getRingerModeExternal() throws RemoteException;

    public int getRingerModeInternal() throws RemoteException;

    public boolean isValidRingerMode(int var1) throws RemoteException;

    public void setVibrateSetting(int var1, int var2) throws RemoteException;

    public int getVibrateSetting(int var1) throws RemoteException;

    public boolean shouldVibrate(int var1) throws RemoteException;

    public void setMode(int var1, IBinder var2, String var3) throws RemoteException;

    public int getMode() throws RemoteException;

    public void playSoundEffect(int var1, int var2) throws RemoteException;

    public void playSoundEffectVolume(int var1, float var2) throws RemoteException;

    public boolean loadSoundEffects() throws RemoteException;

    public void unloadSoundEffects() throws RemoteException;

    public void reloadAudioSettings() throws RemoteException;

    public Map getSurroundFormats() throws RemoteException;

    public List getReportedSurroundFormats() throws RemoteException;

    public boolean setSurroundFormatEnabled(int var1, boolean var2) throws RemoteException;

    public boolean isSurroundFormatEnabled(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.WRITE_SETTINGS")
    public boolean setEncodedSurroundMode(int var1) throws RemoteException;

    public int getEncodedSurroundMode(int var1) throws RemoteException;

    public void setSpeakerphoneOn(IBinder var1, boolean var2, AttributionSource var3) throws RemoteException;

    public boolean isSpeakerphoneOn() throws RemoteException;

    public void setBluetoothScoOn(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.BLUETOOTH_STACK")
    public void setA2dpSuspended(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.BLUETOOTH_STACK")
    public void setLeAudioSuspended(boolean var1) throws RemoteException;

    public boolean isBluetoothScoOn() throws RemoteException;

    public void setBluetoothA2dpOn(boolean var1) throws RemoteException;

    public boolean isBluetoothA2dpOn() throws RemoteException;

    public int requestAudioFocus(AudioAttributes var1, int var2, IBinder var3, IAudioFocusDispatcher var4, String var5, String var6, String var7, int var8, IAudioPolicyCallback var9, int var10) throws RemoteException;

    public int abandonAudioFocus(IAudioFocusDispatcher var1, String var2, AudioAttributes var3, String var4) throws RemoteException;

    public void unregisterAudioFocusClient(String var1) throws RemoteException;

    public int getCurrentAudioFocus() throws RemoteException;

    public void startBluetoothSco(IBinder var1, int var2, AttributionSource var3) throws RemoteException;

    public void startBluetoothScoVirtualCall(IBinder var1, AttributionSource var2) throws RemoteException;

    public void stopBluetoothSco(IBinder var1, AttributionSource var2) throws RemoteException;

    public void forceVolumeControlStream(int var1, IBinder var2) throws RemoteException;

    @EnforcePermission(value="android.permission.REMOTE_AUDIO_PLAYBACK")
    public void setRingtonePlayer(IRingtonePlayer var1) throws RemoteException;

    public IRingtonePlayer getRingtonePlayer() throws RemoteException;

    public int getUiSoundsStreamType() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public List getIndependentStreamTypes() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int getStreamTypeAlias(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean isVolumeControlUsingVolumeGroups() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void registerStreamAliasingDispatcher(IStreamAliasingDispatcher var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setNotifAliasRingForTest(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setWiredDeviceConnectionState(AudioDeviceAttributes var1, int var2, String var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:326:1:326:25")
    public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver var1) throws RemoteException;

    public boolean isCameraSoundForced() throws RemoteException;

    public void setVolumeController(IVolumeController var1) throws RemoteException;

    public IVolumeController getVolumeController() throws RemoteException;

    public void notifyVolumeControllerVisible(IVolumeController var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setVolumeControllerLongPressTimeoutEnabled(boolean var1) throws RemoteException;

    public boolean isStreamAffectedByRingerMode(int var1) throws RemoteException;

    public boolean isStreamAffectedByMute(int var1) throws RemoteException;

    public boolean isStreamMutableByUi(int var1) throws RemoteException;

    public void disableSafeMediaVolume(String var1) throws RemoteException;

    public void lowerVolumeToRs1(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public float getOutputRs2UpperBound() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setOutputRs2UpperBound(float var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public float getCsd() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setCsd(float var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void forceUseFrameworkMel(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void forceComputeCsdOnAllDevices(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean isCsdEnabled() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean isCsdAsAFeatureAvailable() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean isCsdAsAFeatureEnabled() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setCsdAsAFeatureEnabled(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean setBluetoothAudioDeviceCategory(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int getBluetoothAudioDeviceCategory(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean isBluetoothAudioDeviceCategoryFixed(String var1) throws RemoteException;

    public int setHdmiSystemAudioSupported(boolean var1) throws RemoteException;

    public boolean isHdmiSystemAudioSupported() throws RemoteException;

    public String registerAudioPolicy(AudioPolicyConfig var1, IAudioPolicyCallback var2, boolean var3, boolean var4, boolean var5, boolean var6, IMediaProjection var7, AttributionSource var8) throws RemoteException;

    public void unregisterAudioPolicyAsync(IAudioPolicyCallback var1) throws RemoteException;

    public List<AudioMix> getRegisteredPolicyMixes() throws RemoteException;

    public void unregisterAudioPolicy(IAudioPolicyCallback var1) throws RemoteException;

    public int addMixForPolicy(AudioPolicyConfig var1, IAudioPolicyCallback var2) throws RemoteException;

    public int removeMixForPolicy(AudioPolicyConfig var1, IAudioPolicyCallback var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int updateMixingRulesForPolicy(AudioMix[] var1, AudioMixingRule[] var2, IAudioPolicyCallback var3) throws RemoteException;

    public int setFocusPropertiesForPolicy(int var1, IAudioPolicyCallback var2) throws RemoteException;

    public void setVolumePolicy(VolumePolicy var1) throws RemoteException;

    public VolumePolicy getVolumePolicy() throws RemoteException;

    public boolean hasRegisteredDynamicPolicy() throws RemoteException;

    public void registerRecordingCallback(IRecordingConfigDispatcher var1) throws RemoteException;

    public void unregisterRecordingCallback(IRecordingConfigDispatcher var1) throws RemoteException;

    public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() throws RemoteException;

    public void registerPlaybackCallback(IPlaybackConfigDispatcher var1) throws RemoteException;

    public void unregisterPlaybackCallback(IPlaybackConfigDispatcher var1) throws RemoteException;

    public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() throws RemoteException;

    public int getFocusRampTimeMs(int var1, AudioAttributes var2) throws RemoteException;

    public int dispatchFocusChange(AudioFocusInfo var1, int var2, IAudioPolicyCallback var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int dispatchFocusChangeWithFade(AudioFocusInfo var1, int var2, IAudioPolicyCallback var3, List<AudioFocusInfo> var4, FadeManagerConfiguration var5) throws RemoteException;

    public void playerHasOpPlayAudio(int var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.BLUETOOTH_STACK")
    public void handleBluetoothActiveDeviceChanged(BluetoothDevice var1, BluetoothDevice var2, BluetoothProfileConnectionInfo var3) throws RemoteException;

    public void setFocusRequestResultFromExtPolicy(AudioFocusInfo var1, int var2, IAudioPolicyCallback var3) throws RemoteException;

    public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher var1) throws RemoteException;

    public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher var1) throws RemoteException;

    public boolean isAudioServerRunning() throws RemoteException;

    public void registerAudioVolumeCallback(IAudioVolumeChangeDispatcher var1) throws RemoteException;

    public void unregisterAudioVolumeCallback(IAudioVolumeChangeDispatcher var1) throws RemoteException;

    public int setUidDeviceAffinity(IAudioPolicyCallback var1, int var2, int[] var3, String[] var4) throws RemoteException;

    public int removeUidDeviceAffinity(IAudioPolicyCallback var1, int var2) throws RemoteException;

    public int setUserIdDeviceAffinity(IAudioPolicyCallback var1, int var2, int[] var3, String[] var4) throws RemoteException;

    public int removeUserIdDeviceAffinity(IAudioPolicyCallback var1, int var2) throws RemoteException;

    public boolean hasHapticChannels(Uri var1) throws RemoteException;

    public boolean isCallScreeningModeSupported() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int setPreferredDevicesForStrategy(int var1, List<AudioDeviceAttributes> var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int removePreferredDevicesForStrategy(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioDeviceAttributes> getPreferredDevicesForStrategy(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int setDeviceAsNonDefaultForStrategy(int var1, AudioDeviceAttributes var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int removeDeviceAsNonDefaultForStrategy(int var1, AudioDeviceAttributes var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioDeviceAttributes> getNonDefaultDevicesForStrategy(int var1) throws RemoteException;

    public List<AudioDeviceAttributes> getDevicesForAttributes(AudioAttributes var1) throws RemoteException;

    public List<AudioDeviceAttributes> getDevicesForAttributesUnprotected(AudioAttributes var1) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE"})
    public void addOnDevicesForAttributesChangedListener(AudioAttributes var1, IDevicesForAttributesCallback var2) throws RemoteException;

    public void removeOnDevicesForAttributesChangedListener(IDevicesForAttributesCallback var1) throws RemoteException;

    public int setAllowedCapturePolicy(int var1) throws RemoteException;

    public int getAllowedCapturePolicy() throws RemoteException;

    public void registerStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher var1) throws RemoteException;

    public void unregisterStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher var1) throws RemoteException;

    public void registerStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher var1) throws RemoteException;

    public void unregisterStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher var1) throws RemoteException;

    public void setRttEnabled(boolean var1) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public void setDeviceVolumeBehavior(AudioDeviceAttributes var1, int var2, String var3) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public int getDeviceVolumeBehavior(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setMultiAudioFocusEnabled(boolean var1) throws RemoteException;

    public int setPreferredDevicesForCapturePreset(int var1, List<AudioDeviceAttributes> var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int clearPreferredDevicesForCapturePreset(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioDeviceAttributes> getPreferredDevicesForCapturePreset(int var1) throws RemoteException;

    public void registerCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher var1) throws RemoteException;

    public void unregisterCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher var1) throws RemoteException;

    public void adjustStreamVolumeForUid(int var1, int var2, int var3, String var4, int var5, int var6, UserHandle var7, int var8) throws RemoteException;

    public void adjustSuggestedStreamVolumeForUid(int var1, int var2, int var3, String var4, int var5, int var6, UserHandle var7, int var8) throws RemoteException;

    public void setStreamVolumeForUid(int var1, int var2, int var3, String var4, int var5, int var6, UserHandle var7, int var8) throws RemoteException;

    public void adjustVolume(int var1, int var2) throws RemoteException;

    public void adjustSuggestedStreamVolume(int var1, int var2, int var3) throws RemoteException;

    public boolean isMusicActive(boolean var1) throws RemoteException;

    public int getDeviceMaskForStream(int var1) throws RemoteException;

    public int[] getAvailableCommunicationDeviceIds() throws RemoteException;

    public boolean setCommunicationDevice(IBinder var1, int var2, AttributionSource var3) throws RemoteException;

    public int getCommunicationDevice() throws RemoteException;

    public void registerCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher var1) throws RemoteException;

    public void unregisterCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher var1) throws RemoteException;

    public boolean areNavigationRepeatSoundEffectsEnabled() throws RemoteException;

    public void setNavigationRepeatSoundEffectsEnabled(boolean var1) throws RemoteException;

    public boolean isHomeSoundEffectEnabled() throws RemoteException;

    public void setHomeSoundEffectEnabled(boolean var1) throws RemoteException;

    public boolean setAdditionalOutputDeviceDelay(AudioDeviceAttributes var1, long var2) throws RemoteException;

    public long getAdditionalOutputDeviceDelay(AudioDeviceAttributes var1) throws RemoteException;

    public long getMaxAdditionalOutputDeviceDelay(AudioDeviceAttributes var1) throws RemoteException;

    public int requestAudioFocusForTest(AudioAttributes var1, int var2, IBinder var3, IAudioFocusDispatcher var4, String var5, String var6, int var7, int var8, int var9) throws RemoteException;

    public int abandonAudioFocusForTest(IAudioFocusDispatcher var1, String var2, AudioAttributes var3, String var4) throws RemoteException;

    public long getFadeOutDurationOnFocusLossMillis(AudioAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.QUERY_AUDIO_STATE")
    public List getFocusDuckedUidsForTest() throws RemoteException;

    @EnforcePermission(value="android.permission.QUERY_AUDIO_STATE")
    public long getFocusFadeOutDurationForTest() throws RemoteException;

    @EnforcePermission(value="android.permission.QUERY_AUDIO_STATE")
    public long getFocusUnmuteDelayAfterFadeOutForTest() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean enterAudioFocusFreezeForTest(IBinder var1, int[] var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean exitAudioFocusFreezeForTest(IBinder var1) throws RemoteException;

    public void registerModeDispatcher(IAudioModeDispatcher var1) throws RemoteException;

    public void unregisterModeDispatcher(IAudioModeDispatcher var1) throws RemoteException;

    public int getSpatializerImmersiveAudioLevel() throws RemoteException;

    public boolean isSpatializerEnabled() throws RemoteException;

    public boolean isSpatializerAvailable() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public boolean isSpatializerAvailableForDevice(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public boolean hasHeadTracker(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setHeadTrackerEnabled(boolean var1, AudioDeviceAttributes var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public boolean isHeadTrackerEnabled(AudioDeviceAttributes var1) throws RemoteException;

    public boolean isHeadTrackerAvailable() throws RemoteException;

    public void registerSpatializerHeadTrackerAvailableCallback(ISpatializerHeadTrackerAvailableCallback var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setSpatializerEnabled(boolean var1) throws RemoteException;

    public boolean canBeSpatialized(AudioAttributes var1, AudioFormat var2) throws RemoteException;

    public List getSpatializedChannelMasks() throws RemoteException;

    public void registerSpatializerCallback(ISpatializerCallback var1) throws RemoteException;

    public void unregisterSpatializerCallback(ISpatializerCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void registerSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void unregisterSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void registerHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void unregisterHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public List<AudioDeviceAttributes> getSpatializerCompatibleAudioDevices() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void addSpatializerCompatibleAudioDevice(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void removeSpatializerCompatibleAudioDevice(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setDesiredHeadTrackingMode(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public int getDesiredHeadTrackingMode() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public int[] getSupportedHeadTrackingModes() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public int getActualHeadTrackingMode() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setSpatializerGlobalTransform(float[] var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void recenterHeadTracker() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setSpatializerParameter(int var1, byte[] var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void getSpatializerParameter(int var1, byte[] var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public int getSpatializerOutput() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void registerSpatializerOutputCallback(ISpatializerOutputCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void unregisterSpatializerOutputCallback(ISpatializerOutputCallback var1) throws RemoteException;

    public boolean isVolumeFixed() throws RemoteException;

    public VolumeInfo getDefaultVolumeInfo() throws RemoteException;

    @EnforcePermission(value="android.permission.CALL_AUDIO_INTERCEPTION")
    public boolean isPstnCallAudioInterceptable() throws RemoteException;

    public void muteAwaitConnection(int[] var1, AudioDeviceAttributes var2, long var3) throws RemoteException;

    public void cancelMuteAwaitConnection(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public AudioDeviceAttributes getMutingExpectedDevice() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void registerMuteAwaitConnectionDispatcher(IMuteAwaitConnectionCallback var1, boolean var2) throws RemoteException;

    public void setTestDeviceConnectionState(AudioDeviceAttributes var1, boolean var2) throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE"})
    public void registerDeviceVolumeBehaviorDispatcher(boolean var1, IDeviceVolumeBehaviorDispatcher var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioFocusInfo> getFocusStack() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void sendFocusLossAndUpdate(AudioFocusInfo var1, IAudioPolicyCallback var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public boolean sendFocusLoss(AudioFocusInfo var1, IAudioPolicyCallback var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void addAssistantServicesUids(int[] var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void removeAssistantServicesUids(int[] var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setActiveAssistantServiceUids(int[] var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int[] getAssistantServicesUids() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int[] getActiveAssistantServiceUids() throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerDeviceVolumeDispatcherForAbsoluteVolume(boolean var1, IAudioDeviceVolumeDispatcher var2, String var3, AudioDeviceAttributes var4, List<VolumeInfo> var5, boolean var6, int var7) throws RemoteException;

    public AudioHalVersionInfo getHalVersion() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS")
    public int setPreferredMixerAttributes(AudioAttributes var1, int var2, AudioMixerAttributes var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS")
    public int clearPreferredMixerAttributes(AudioAttributes var1, int var2) throws RemoteException;

    public void registerPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher var1) throws RemoteException;

    public void unregisterPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public boolean supportsBluetoothVariableLatency() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setBluetoothVariableLatencyEnabled(boolean var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public boolean isBluetoothVariableLatencyEnabled() throws RemoteException;

    public void registerLoudnessCodecUpdatesDispatcher(ILoudnessCodecUpdatesDispatcher var1) throws RemoteException;

    public void unregisterLoudnessCodecUpdatesDispatcher(ILoudnessCodecUpdatesDispatcher var1) throws RemoteException;

    public void startLoudnessCodecUpdates(int var1) throws RemoteException;

    public void stopLoudnessCodecUpdates(int var1) throws RemoteException;

    public void addLoudnessCodecInfo(int var1, int var2, LoudnessCodecInfo var3) throws RemoteException;

    public void removeLoudnessCodecInfo(int var1, LoudnessCodecInfo var2) throws RemoteException;

    public PersistableBundle getLoudnessParams(LoudnessCodecInfo var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int setFadeManagerConfigurationForFocusLoss(FadeManagerConfiguration var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int clearFadeManagerConfigurationForFocusLoss() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public FadeManagerConfiguration getFadeManagerConfigurationForFocusLoss() throws RemoteException;

    @RequiresPermission(value="android.permission.QUERY_AUDIO_STATE")
    @EnforcePermission(value="android.permission.QUERY_AUDIO_STATE")
    public boolean shouldNotificationSoundPlay(AudioAttributes var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setEnableHardening(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAudioService {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.media.IAudioService";
        static final int TRANSACTION_getNativeInterface = 1;
        static final int TRANSACTION_trackPlayer = 2;
        static final int TRANSACTION_playerAttributes = 3;
        static final int TRANSACTION_playerEvent = 4;
        static final int TRANSACTION_releasePlayer = 5;
        static final int TRANSACTION_trackRecorder = 6;
        static final int TRANSACTION_recorderEvent = 7;
        static final int TRANSACTION_releaseRecorder = 8;
        static final int TRANSACTION_playerSessionId = 9;
        static final int TRANSACTION_portEvent = 10;
        static final int TRANSACTION_permissionUpdateBarrier = 11;
        static final int TRANSACTION_adjustStreamVolume = 12;
        static final int TRANSACTION_adjustStreamVolumeWithAttribution = 13;
        static final int TRANSACTION_setStreamVolume = 14;
        static final int TRANSACTION_setStreamVolumeWithAttribution = 15;
        static final int TRANSACTION_setDeviceVolume = 16;
        static final String[] PERMISSIONS_setDeviceVolume = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"};
        static final int TRANSACTION_setVolumeForDevice = 17;
        static final String[] PERMISSIONS_setVolumeForDevice = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"};
        static final int TRANSACTION_adjustVolumeForDevice = 18;
        static final String[] PERMISSIONS_adjustVolumeForDevice = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"};
        static final int TRANSACTION_notifyAbsoluteVolumeChanged = 19;
        static final String[] PERMISSIONS_notifyAbsoluteVolumeChanged = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.BLUETOOTH_PRIVILEGED"};
        static final int TRANSACTION_getDeviceVolume = 20;
        static final String[] PERMISSIONS_getDeviceVolume = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"};
        static final int TRANSACTION_handleVolumeKey = 21;
        static final int TRANSACTION_isStreamMute = 22;
        static final int TRANSACTION_forceRemoteSubmixFullVolume = 23;
        static final int TRANSACTION_isMasterMute = 24;
        static final int TRANSACTION_setMasterMute = 25;
        static final int TRANSACTION_getStreamVolume = 26;
        static final int TRANSACTION_getStreamMinVolume = 27;
        static final int TRANSACTION_getStreamMaxVolume = 28;
        static final int TRANSACTION_getAudioVolumeGroups = 29;
        static final String[] PERMISSIONS_getAudioVolumeGroups = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"};
        static final int TRANSACTION_setVolumeGroupVolumeIndex = 30;
        static final String[] PERMISSIONS_setVolumeGroupVolumeIndex = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"};
        static final int TRANSACTION_getVolumeGroupVolumeIndex = 31;
        static final String[] PERMISSIONS_getVolumeGroupVolumeIndex = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"};
        static final int TRANSACTION_getVolumeGroupMaxVolumeIndex = 32;
        static final String[] PERMISSIONS_getVolumeGroupMaxVolumeIndex = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"};
        static final int TRANSACTION_getVolumeGroupMinVolumeIndex = 33;
        static final String[] PERMISSIONS_getVolumeGroupMinVolumeIndex = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"};
        static final int TRANSACTION_getLastAudibleVolumeForVolumeGroup = 34;
        static final int TRANSACTION_isVolumeGroupMuted = 35;
        static final int TRANSACTION_adjustVolumeGroupVolume = 36;
        static final int TRANSACTION_getLastAudibleStreamVolume = 37;
        static final int TRANSACTION_setSupportedSystemUsages = 38;
        static final int TRANSACTION_getSupportedSystemUsages = 39;
        static final int TRANSACTION_getAudioProductStrategies = 40;
        static final int TRANSACTION_isMicrophoneMuted = 41;
        static final int TRANSACTION_isUltrasoundSupported = 42;
        static final int TRANSACTION_isHotwordStreamSupported = 43;
        static final int TRANSACTION_setMicrophoneMute = 44;
        static final int TRANSACTION_setInputGainIndex = 45;
        static final int TRANSACTION_getInputGainIndex = 46;
        static final int TRANSACTION_getMaxInputGainIndex = 47;
        static final int TRANSACTION_getMinInputGainIndex = 48;
        static final int TRANSACTION_isInputGainFixed = 49;
        static final int TRANSACTION_setMicrophoneMuteFromSwitch = 50;
        static final int TRANSACTION_setRingerModeExternal = 51;
        static final int TRANSACTION_setRingerModeInternal = 52;
        static final int TRANSACTION_getRingerModeExternal = 53;
        static final int TRANSACTION_getRingerModeInternal = 54;
        static final int TRANSACTION_isValidRingerMode = 55;
        static final int TRANSACTION_setVibrateSetting = 56;
        static final int TRANSACTION_getVibrateSetting = 57;
        static final int TRANSACTION_shouldVibrate = 58;
        static final int TRANSACTION_setMode = 59;
        static final int TRANSACTION_getMode = 60;
        static final int TRANSACTION_playSoundEffect = 61;
        static final int TRANSACTION_playSoundEffectVolume = 62;
        static final int TRANSACTION_loadSoundEffects = 63;
        static final int TRANSACTION_unloadSoundEffects = 64;
        static final int TRANSACTION_reloadAudioSettings = 65;
        static final int TRANSACTION_getSurroundFormats = 66;
        static final int TRANSACTION_getReportedSurroundFormats = 67;
        static final int TRANSACTION_setSurroundFormatEnabled = 68;
        static final int TRANSACTION_isSurroundFormatEnabled = 69;
        static final int TRANSACTION_setEncodedSurroundMode = 70;
        static final int TRANSACTION_getEncodedSurroundMode = 71;
        static final int TRANSACTION_setSpeakerphoneOn = 72;
        static final int TRANSACTION_isSpeakerphoneOn = 73;
        static final int TRANSACTION_setBluetoothScoOn = 74;
        static final int TRANSACTION_setA2dpSuspended = 75;
        static final int TRANSACTION_setLeAudioSuspended = 76;
        static final int TRANSACTION_isBluetoothScoOn = 77;
        static final int TRANSACTION_setBluetoothA2dpOn = 78;
        static final int TRANSACTION_isBluetoothA2dpOn = 79;
        static final int TRANSACTION_requestAudioFocus = 80;
        static final int TRANSACTION_abandonAudioFocus = 81;
        static final int TRANSACTION_unregisterAudioFocusClient = 82;
        static final int TRANSACTION_getCurrentAudioFocus = 83;
        static final int TRANSACTION_startBluetoothSco = 84;
        static final int TRANSACTION_startBluetoothScoVirtualCall = 85;
        static final int TRANSACTION_stopBluetoothSco = 86;
        static final int TRANSACTION_forceVolumeControlStream = 87;
        static final int TRANSACTION_setRingtonePlayer = 88;
        static final int TRANSACTION_getRingtonePlayer = 89;
        static final int TRANSACTION_getUiSoundsStreamType = 90;
        static final int TRANSACTION_getIndependentStreamTypes = 91;
        static final int TRANSACTION_getStreamTypeAlias = 92;
        static final int TRANSACTION_isVolumeControlUsingVolumeGroups = 93;
        static final int TRANSACTION_registerStreamAliasingDispatcher = 94;
        static final int TRANSACTION_setNotifAliasRingForTest = 95;
        static final int TRANSACTION_setWiredDeviceConnectionState = 96;
        static final int TRANSACTION_startWatchingRoutes = 97;
        static final int TRANSACTION_isCameraSoundForced = 98;
        static final int TRANSACTION_setVolumeController = 99;
        static final int TRANSACTION_getVolumeController = 100;
        static final int TRANSACTION_notifyVolumeControllerVisible = 101;
        static final int TRANSACTION_setVolumeControllerLongPressTimeoutEnabled = 102;
        static final int TRANSACTION_isStreamAffectedByRingerMode = 103;
        static final int TRANSACTION_isStreamAffectedByMute = 104;
        static final int TRANSACTION_isStreamMutableByUi = 105;
        static final int TRANSACTION_disableSafeMediaVolume = 106;
        static final int TRANSACTION_lowerVolumeToRs1 = 107;
        static final int TRANSACTION_getOutputRs2UpperBound = 108;
        static final int TRANSACTION_setOutputRs2UpperBound = 109;
        static final int TRANSACTION_getCsd = 110;
        static final int TRANSACTION_setCsd = 111;
        static final int TRANSACTION_forceUseFrameworkMel = 112;
        static final int TRANSACTION_forceComputeCsdOnAllDevices = 113;
        static final int TRANSACTION_isCsdEnabled = 114;
        static final int TRANSACTION_isCsdAsAFeatureAvailable = 115;
        static final int TRANSACTION_isCsdAsAFeatureEnabled = 116;
        static final int TRANSACTION_setCsdAsAFeatureEnabled = 117;
        static final int TRANSACTION_setBluetoothAudioDeviceCategory = 118;
        static final int TRANSACTION_getBluetoothAudioDeviceCategory = 119;
        static final int TRANSACTION_isBluetoothAudioDeviceCategoryFixed = 120;
        static final int TRANSACTION_setHdmiSystemAudioSupported = 121;
        static final int TRANSACTION_isHdmiSystemAudioSupported = 122;
        static final int TRANSACTION_registerAudioPolicy = 123;
        static final int TRANSACTION_unregisterAudioPolicyAsync = 124;
        static final int TRANSACTION_getRegisteredPolicyMixes = 125;
        static final int TRANSACTION_unregisterAudioPolicy = 126;
        static final int TRANSACTION_addMixForPolicy = 127;
        static final int TRANSACTION_removeMixForPolicy = 128;
        static final int TRANSACTION_updateMixingRulesForPolicy = 129;
        static final int TRANSACTION_setFocusPropertiesForPolicy = 130;
        static final int TRANSACTION_setVolumePolicy = 131;
        static final int TRANSACTION_getVolumePolicy = 132;
        static final int TRANSACTION_hasRegisteredDynamicPolicy = 133;
        static final int TRANSACTION_registerRecordingCallback = 134;
        static final int TRANSACTION_unregisterRecordingCallback = 135;
        static final int TRANSACTION_getActiveRecordingConfigurations = 136;
        static final int TRANSACTION_registerPlaybackCallback = 137;
        static final int TRANSACTION_unregisterPlaybackCallback = 138;
        static final int TRANSACTION_getActivePlaybackConfigurations = 139;
        static final int TRANSACTION_getFocusRampTimeMs = 140;
        static final int TRANSACTION_dispatchFocusChange = 141;
        static final int TRANSACTION_dispatchFocusChangeWithFade = 142;
        static final int TRANSACTION_playerHasOpPlayAudio = 143;
        static final int TRANSACTION_handleBluetoothActiveDeviceChanged = 144;
        static final int TRANSACTION_setFocusRequestResultFromExtPolicy = 145;
        static final int TRANSACTION_registerAudioServerStateDispatcher = 146;
        static final int TRANSACTION_unregisterAudioServerStateDispatcher = 147;
        static final int TRANSACTION_isAudioServerRunning = 148;
        static final int TRANSACTION_registerAudioVolumeCallback = 149;
        static final int TRANSACTION_unregisterAudioVolumeCallback = 150;
        static final int TRANSACTION_setUidDeviceAffinity = 151;
        static final int TRANSACTION_removeUidDeviceAffinity = 152;
        static final int TRANSACTION_setUserIdDeviceAffinity = 153;
        static final int TRANSACTION_removeUserIdDeviceAffinity = 154;
        static final int TRANSACTION_hasHapticChannels = 155;
        static final int TRANSACTION_isCallScreeningModeSupported = 156;
        static final int TRANSACTION_setPreferredDevicesForStrategy = 157;
        static final int TRANSACTION_removePreferredDevicesForStrategy = 158;
        static final int TRANSACTION_getPreferredDevicesForStrategy = 159;
        static final int TRANSACTION_setDeviceAsNonDefaultForStrategy = 160;
        static final int TRANSACTION_removeDeviceAsNonDefaultForStrategy = 161;
        static final int TRANSACTION_getNonDefaultDevicesForStrategy = 162;
        static final int TRANSACTION_getDevicesForAttributes = 163;
        static final int TRANSACTION_getDevicesForAttributesUnprotected = 164;
        static final int TRANSACTION_addOnDevicesForAttributesChangedListener = 165;
        static final String[] PERMISSIONS_addOnDevicesForAttributesChangedListener = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE"};
        static final int TRANSACTION_removeOnDevicesForAttributesChangedListener = 166;
        static final int TRANSACTION_setAllowedCapturePolicy = 167;
        static final int TRANSACTION_getAllowedCapturePolicy = 168;
        static final int TRANSACTION_registerStrategyPreferredDevicesDispatcher = 169;
        static final int TRANSACTION_unregisterStrategyPreferredDevicesDispatcher = 170;
        static final int TRANSACTION_registerStrategyNonDefaultDevicesDispatcher = 171;
        static final int TRANSACTION_unregisterStrategyNonDefaultDevicesDispatcher = 172;
        static final int TRANSACTION_setRttEnabled = 173;
        static final int TRANSACTION_setDeviceVolumeBehavior = 174;
        static final String[] PERMISSIONS_setDeviceVolumeBehavior = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"};
        static final int TRANSACTION_getDeviceVolumeBehavior = 175;
        static final String[] PERMISSIONS_getDeviceVolumeBehavior = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"};
        static final int TRANSACTION_setMultiAudioFocusEnabled = 176;
        static final int TRANSACTION_setPreferredDevicesForCapturePreset = 177;
        static final int TRANSACTION_clearPreferredDevicesForCapturePreset = 178;
        static final int TRANSACTION_getPreferredDevicesForCapturePreset = 179;
        static final int TRANSACTION_registerCapturePresetDevicesRoleDispatcher = 180;
        static final int TRANSACTION_unregisterCapturePresetDevicesRoleDispatcher = 181;
        static final int TRANSACTION_adjustStreamVolumeForUid = 182;
        static final int TRANSACTION_adjustSuggestedStreamVolumeForUid = 183;
        static final int TRANSACTION_setStreamVolumeForUid = 184;
        static final int TRANSACTION_adjustVolume = 185;
        static final int TRANSACTION_adjustSuggestedStreamVolume = 186;
        static final int TRANSACTION_isMusicActive = 187;
        static final int TRANSACTION_getDeviceMaskForStream = 188;
        static final int TRANSACTION_getAvailableCommunicationDeviceIds = 189;
        static final int TRANSACTION_setCommunicationDevice = 190;
        static final int TRANSACTION_getCommunicationDevice = 191;
        static final int TRANSACTION_registerCommunicationDeviceDispatcher = 192;
        static final int TRANSACTION_unregisterCommunicationDeviceDispatcher = 193;
        static final int TRANSACTION_areNavigationRepeatSoundEffectsEnabled = 194;
        static final int TRANSACTION_setNavigationRepeatSoundEffectsEnabled = 195;
        static final int TRANSACTION_isHomeSoundEffectEnabled = 196;
        static final int TRANSACTION_setHomeSoundEffectEnabled = 197;
        static final int TRANSACTION_setAdditionalOutputDeviceDelay = 198;
        static final int TRANSACTION_getAdditionalOutputDeviceDelay = 199;
        static final int TRANSACTION_getMaxAdditionalOutputDeviceDelay = 200;
        static final int TRANSACTION_requestAudioFocusForTest = 201;
        static final int TRANSACTION_abandonAudioFocusForTest = 202;
        static final int TRANSACTION_getFadeOutDurationOnFocusLossMillis = 203;
        static final int TRANSACTION_getFocusDuckedUidsForTest = 204;
        static final int TRANSACTION_getFocusFadeOutDurationForTest = 205;
        static final int TRANSACTION_getFocusUnmuteDelayAfterFadeOutForTest = 206;
        static final int TRANSACTION_enterAudioFocusFreezeForTest = 207;
        static final int TRANSACTION_exitAudioFocusFreezeForTest = 208;
        static final int TRANSACTION_registerModeDispatcher = 209;
        static final int TRANSACTION_unregisterModeDispatcher = 210;
        static final int TRANSACTION_getSpatializerImmersiveAudioLevel = 211;
        static final int TRANSACTION_isSpatializerEnabled = 212;
        static final int TRANSACTION_isSpatializerAvailable = 213;
        static final int TRANSACTION_isSpatializerAvailableForDevice = 214;
        static final int TRANSACTION_hasHeadTracker = 215;
        static final int TRANSACTION_setHeadTrackerEnabled = 216;
        static final int TRANSACTION_isHeadTrackerEnabled = 217;
        static final int TRANSACTION_isHeadTrackerAvailable = 218;
        static final int TRANSACTION_registerSpatializerHeadTrackerAvailableCallback = 219;
        static final int TRANSACTION_setSpatializerEnabled = 220;
        static final int TRANSACTION_canBeSpatialized = 221;
        static final int TRANSACTION_getSpatializedChannelMasks = 222;
        static final int TRANSACTION_registerSpatializerCallback = 223;
        static final int TRANSACTION_unregisterSpatializerCallback = 224;
        static final int TRANSACTION_registerSpatializerHeadTrackingCallback = 225;
        static final int TRANSACTION_unregisterSpatializerHeadTrackingCallback = 226;
        static final int TRANSACTION_registerHeadToSoundstagePoseCallback = 227;
        static final int TRANSACTION_unregisterHeadToSoundstagePoseCallback = 228;
        static final int TRANSACTION_getSpatializerCompatibleAudioDevices = 229;
        static final int TRANSACTION_addSpatializerCompatibleAudioDevice = 230;
        static final int TRANSACTION_removeSpatializerCompatibleAudioDevice = 231;
        static final int TRANSACTION_setDesiredHeadTrackingMode = 232;
        static final int TRANSACTION_getDesiredHeadTrackingMode = 233;
        static final int TRANSACTION_getSupportedHeadTrackingModes = 234;
        static final int TRANSACTION_getActualHeadTrackingMode = 235;
        static final int TRANSACTION_setSpatializerGlobalTransform = 236;
        static final int TRANSACTION_recenterHeadTracker = 237;
        static final int TRANSACTION_setSpatializerParameter = 238;
        static final int TRANSACTION_getSpatializerParameter = 239;
        static final int TRANSACTION_getSpatializerOutput = 240;
        static final int TRANSACTION_registerSpatializerOutputCallback = 241;
        static final int TRANSACTION_unregisterSpatializerOutputCallback = 242;
        static final int TRANSACTION_isVolumeFixed = 243;
        static final int TRANSACTION_getDefaultVolumeInfo = 244;
        static final int TRANSACTION_isPstnCallAudioInterceptable = 245;
        static final int TRANSACTION_muteAwaitConnection = 246;
        static final int TRANSACTION_cancelMuteAwaitConnection = 247;
        static final int TRANSACTION_getMutingExpectedDevice = 248;
        static final int TRANSACTION_registerMuteAwaitConnectionDispatcher = 249;
        static final int TRANSACTION_setTestDeviceConnectionState = 250;
        static final int TRANSACTION_registerDeviceVolumeBehaviorDispatcher = 251;
        static final int TRANSACTION_getFocusStack = 252;
        static final int TRANSACTION_sendFocusLossAndUpdate = 253;
        static final int TRANSACTION_sendFocusLoss = 254;
        static final int TRANSACTION_addAssistantServicesUids = 255;
        static final int TRANSACTION_removeAssistantServicesUids = 256;
        static final int TRANSACTION_setActiveAssistantServiceUids = 257;
        static final int TRANSACTION_getAssistantServicesUids = 258;
        static final int TRANSACTION_getActiveAssistantServiceUids = 259;
        static final int TRANSACTION_registerDeviceVolumeDispatcherForAbsoluteVolume = 260;
        static final int TRANSACTION_getHalVersion = 261;
        static final int TRANSACTION_setPreferredMixerAttributes = 262;
        static final int TRANSACTION_clearPreferredMixerAttributes = 263;
        static final int TRANSACTION_registerPreferredMixerAttributesDispatcher = 264;
        static final int TRANSACTION_unregisterPreferredMixerAttributesDispatcher = 265;
        static final int TRANSACTION_supportsBluetoothVariableLatency = 266;
        static final int TRANSACTION_setBluetoothVariableLatencyEnabled = 267;
        static final int TRANSACTION_isBluetoothVariableLatencyEnabled = 268;
        static final int TRANSACTION_registerLoudnessCodecUpdatesDispatcher = 269;
        static final int TRANSACTION_unregisterLoudnessCodecUpdatesDispatcher = 270;
        static final int TRANSACTION_startLoudnessCodecUpdates = 271;
        static final int TRANSACTION_stopLoudnessCodecUpdates = 272;
        static final int TRANSACTION_addLoudnessCodecInfo = 273;
        static final int TRANSACTION_removeLoudnessCodecInfo = 274;
        static final int TRANSACTION_getLoudnessParams = 275;
        static final int TRANSACTION_setFadeManagerConfigurationForFocusLoss = 276;
        static final int TRANSACTION_clearFadeManagerConfigurationForFocusLoss = 277;
        static final int TRANSACTION_getFadeManagerConfigurationForFocusLoss = 278;
        static final int TRANSACTION_shouldNotificationSoundPlay = 279;
        static final int TRANSACTION_setEnableHardening = 280;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IAudioService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAudioService) {
                return (IAudioService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getNativeInterface";
                }
                case 2: {
                    return "trackPlayer";
                }
                case 3: {
                    return "playerAttributes";
                }
                case 4: {
                    return "playerEvent";
                }
                case 5: {
                    return "releasePlayer";
                }
                case 6: {
                    return "trackRecorder";
                }
                case 7: {
                    return "recorderEvent";
                }
                case 8: {
                    return "releaseRecorder";
                }
                case 9: {
                    return "playerSessionId";
                }
                case 10: {
                    return "portEvent";
                }
                case 11: {
                    return "permissionUpdateBarrier";
                }
                case 12: {
                    return "adjustStreamVolume";
                }
                case 13: {
                    return "adjustStreamVolumeWithAttribution";
                }
                case 14: {
                    return "setStreamVolume";
                }
                case 15: {
                    return "setStreamVolumeWithAttribution";
                }
                case 16: {
                    return "setDeviceVolume";
                }
                case 17: {
                    return "setVolumeForDevice";
                }
                case 18: {
                    return "adjustVolumeForDevice";
                }
                case 19: {
                    return "notifyAbsoluteVolumeChanged";
                }
                case 20: {
                    return "getDeviceVolume";
                }
                case 21: {
                    return "handleVolumeKey";
                }
                case 22: {
                    return "isStreamMute";
                }
                case 23: {
                    return "forceRemoteSubmixFullVolume";
                }
                case 24: {
                    return "isMasterMute";
                }
                case 25: {
                    return "setMasterMute";
                }
                case 26: {
                    return "getStreamVolume";
                }
                case 27: {
                    return "getStreamMinVolume";
                }
                case 28: {
                    return "getStreamMaxVolume";
                }
                case 29: {
                    return "getAudioVolumeGroups";
                }
                case 30: {
                    return "setVolumeGroupVolumeIndex";
                }
                case 31: {
                    return "getVolumeGroupVolumeIndex";
                }
                case 32: {
                    return "getVolumeGroupMaxVolumeIndex";
                }
                case 33: {
                    return "getVolumeGroupMinVolumeIndex";
                }
                case 34: {
                    return "getLastAudibleVolumeForVolumeGroup";
                }
                case 35: {
                    return "isVolumeGroupMuted";
                }
                case 36: {
                    return "adjustVolumeGroupVolume";
                }
                case 37: {
                    return "getLastAudibleStreamVolume";
                }
                case 38: {
                    return "setSupportedSystemUsages";
                }
                case 39: {
                    return "getSupportedSystemUsages";
                }
                case 40: {
                    return "getAudioProductStrategies";
                }
                case 41: {
                    return "isMicrophoneMuted";
                }
                case 42: {
                    return "isUltrasoundSupported";
                }
                case 43: {
                    return "isHotwordStreamSupported";
                }
                case 44: {
                    return "setMicrophoneMute";
                }
                case 45: {
                    return "setInputGainIndex";
                }
                case 46: {
                    return "getInputGainIndex";
                }
                case 47: {
                    return "getMaxInputGainIndex";
                }
                case 48: {
                    return "getMinInputGainIndex";
                }
                case 49: {
                    return "isInputGainFixed";
                }
                case 50: {
                    return "setMicrophoneMuteFromSwitch";
                }
                case 51: {
                    return "setRingerModeExternal";
                }
                case 52: {
                    return "setRingerModeInternal";
                }
                case 53: {
                    return "getRingerModeExternal";
                }
                case 54: {
                    return "getRingerModeInternal";
                }
                case 55: {
                    return "isValidRingerMode";
                }
                case 56: {
                    return "setVibrateSetting";
                }
                case 57: {
                    return "getVibrateSetting";
                }
                case 58: {
                    return "shouldVibrate";
                }
                case 59: {
                    return "setMode";
                }
                case 60: {
                    return "getMode";
                }
                case 61: {
                    return "playSoundEffect";
                }
                case 62: {
                    return "playSoundEffectVolume";
                }
                case 63: {
                    return "loadSoundEffects";
                }
                case 64: {
                    return "unloadSoundEffects";
                }
                case 65: {
                    return "reloadAudioSettings";
                }
                case 66: {
                    return "getSurroundFormats";
                }
                case 67: {
                    return "getReportedSurroundFormats";
                }
                case 68: {
                    return "setSurroundFormatEnabled";
                }
                case 69: {
                    return "isSurroundFormatEnabled";
                }
                case 70: {
                    return "setEncodedSurroundMode";
                }
                case 71: {
                    return "getEncodedSurroundMode";
                }
                case 72: {
                    return "setSpeakerphoneOn";
                }
                case 73: {
                    return "isSpeakerphoneOn";
                }
                case 74: {
                    return "setBluetoothScoOn";
                }
                case 75: {
                    return "setA2dpSuspended";
                }
                case 76: {
                    return "setLeAudioSuspended";
                }
                case 77: {
                    return "isBluetoothScoOn";
                }
                case 78: {
                    return "setBluetoothA2dpOn";
                }
                case 79: {
                    return "isBluetoothA2dpOn";
                }
                case 80: {
                    return "requestAudioFocus";
                }
                case 81: {
                    return "abandonAudioFocus";
                }
                case 82: {
                    return "unregisterAudioFocusClient";
                }
                case 83: {
                    return "getCurrentAudioFocus";
                }
                case 84: {
                    return "startBluetoothSco";
                }
                case 85: {
                    return "startBluetoothScoVirtualCall";
                }
                case 86: {
                    return "stopBluetoothSco";
                }
                case 87: {
                    return "forceVolumeControlStream";
                }
                case 88: {
                    return "setRingtonePlayer";
                }
                case 89: {
                    return "getRingtonePlayer";
                }
                case 90: {
                    return "getUiSoundsStreamType";
                }
                case 91: {
                    return "getIndependentStreamTypes";
                }
                case 92: {
                    return "getStreamTypeAlias";
                }
                case 93: {
                    return "isVolumeControlUsingVolumeGroups";
                }
                case 94: {
                    return "registerStreamAliasingDispatcher";
                }
                case 95: {
                    return "setNotifAliasRingForTest";
                }
                case 96: {
                    return "setWiredDeviceConnectionState";
                }
                case 97: {
                    return "startWatchingRoutes";
                }
                case 98: {
                    return "isCameraSoundForced";
                }
                case 99: {
                    return "setVolumeController";
                }
                case 100: {
                    return "getVolumeController";
                }
                case 101: {
                    return "notifyVolumeControllerVisible";
                }
                case 102: {
                    return "setVolumeControllerLongPressTimeoutEnabled";
                }
                case 103: {
                    return "isStreamAffectedByRingerMode";
                }
                case 104: {
                    return "isStreamAffectedByMute";
                }
                case 105: {
                    return "isStreamMutableByUi";
                }
                case 106: {
                    return "disableSafeMediaVolume";
                }
                case 107: {
                    return "lowerVolumeToRs1";
                }
                case 108: {
                    return "getOutputRs2UpperBound";
                }
                case 109: {
                    return "setOutputRs2UpperBound";
                }
                case 110: {
                    return "getCsd";
                }
                case 111: {
                    return "setCsd";
                }
                case 112: {
                    return "forceUseFrameworkMel";
                }
                case 113: {
                    return "forceComputeCsdOnAllDevices";
                }
                case 114: {
                    return "isCsdEnabled";
                }
                case 115: {
                    return "isCsdAsAFeatureAvailable";
                }
                case 116: {
                    return "isCsdAsAFeatureEnabled";
                }
                case 117: {
                    return "setCsdAsAFeatureEnabled";
                }
                case 118: {
                    return "setBluetoothAudioDeviceCategory";
                }
                case 119: {
                    return "getBluetoothAudioDeviceCategory";
                }
                case 120: {
                    return "isBluetoothAudioDeviceCategoryFixed";
                }
                case 121: {
                    return "setHdmiSystemAudioSupported";
                }
                case 122: {
                    return "isHdmiSystemAudioSupported";
                }
                case 123: {
                    return "registerAudioPolicy";
                }
                case 124: {
                    return "unregisterAudioPolicyAsync";
                }
                case 125: {
                    return "getRegisteredPolicyMixes";
                }
                case 126: {
                    return "unregisterAudioPolicy";
                }
                case 127: {
                    return "addMixForPolicy";
                }
                case 128: {
                    return "removeMixForPolicy";
                }
                case 129: {
                    return "updateMixingRulesForPolicy";
                }
                case 130: {
                    return "setFocusPropertiesForPolicy";
                }
                case 131: {
                    return "setVolumePolicy";
                }
                case 132: {
                    return "getVolumePolicy";
                }
                case 133: {
                    return "hasRegisteredDynamicPolicy";
                }
                case 134: {
                    return "registerRecordingCallback";
                }
                case 135: {
                    return "unregisterRecordingCallback";
                }
                case 136: {
                    return "getActiveRecordingConfigurations";
                }
                case 137: {
                    return "registerPlaybackCallback";
                }
                case 138: {
                    return "unregisterPlaybackCallback";
                }
                case 139: {
                    return "getActivePlaybackConfigurations";
                }
                case 140: {
                    return "getFocusRampTimeMs";
                }
                case 141: {
                    return "dispatchFocusChange";
                }
                case 142: {
                    return "dispatchFocusChangeWithFade";
                }
                case 143: {
                    return "playerHasOpPlayAudio";
                }
                case 144: {
                    return "handleBluetoothActiveDeviceChanged";
                }
                case 145: {
                    return "setFocusRequestResultFromExtPolicy";
                }
                case 146: {
                    return "registerAudioServerStateDispatcher";
                }
                case 147: {
                    return "unregisterAudioServerStateDispatcher";
                }
                case 148: {
                    return "isAudioServerRunning";
                }
                case 149: {
                    return "registerAudioVolumeCallback";
                }
                case 150: {
                    return "unregisterAudioVolumeCallback";
                }
                case 151: {
                    return "setUidDeviceAffinity";
                }
                case 152: {
                    return "removeUidDeviceAffinity";
                }
                case 153: {
                    return "setUserIdDeviceAffinity";
                }
                case 154: {
                    return "removeUserIdDeviceAffinity";
                }
                case 155: {
                    return "hasHapticChannels";
                }
                case 156: {
                    return "isCallScreeningModeSupported";
                }
                case 157: {
                    return "setPreferredDevicesForStrategy";
                }
                case 158: {
                    return "removePreferredDevicesForStrategy";
                }
                case 159: {
                    return "getPreferredDevicesForStrategy";
                }
                case 160: {
                    return "setDeviceAsNonDefaultForStrategy";
                }
                case 161: {
                    return "removeDeviceAsNonDefaultForStrategy";
                }
                case 162: {
                    return "getNonDefaultDevicesForStrategy";
                }
                case 163: {
                    return "getDevicesForAttributes";
                }
                case 164: {
                    return "getDevicesForAttributesUnprotected";
                }
                case 165: {
                    return "addOnDevicesForAttributesChangedListener";
                }
                case 166: {
                    return "removeOnDevicesForAttributesChangedListener";
                }
                case 167: {
                    return "setAllowedCapturePolicy";
                }
                case 168: {
                    return "getAllowedCapturePolicy";
                }
                case 169: {
                    return "registerStrategyPreferredDevicesDispatcher";
                }
                case 170: {
                    return "unregisterStrategyPreferredDevicesDispatcher";
                }
                case 171: {
                    return "registerStrategyNonDefaultDevicesDispatcher";
                }
                case 172: {
                    return "unregisterStrategyNonDefaultDevicesDispatcher";
                }
                case 173: {
                    return "setRttEnabled";
                }
                case 174: {
                    return "setDeviceVolumeBehavior";
                }
                case 175: {
                    return "getDeviceVolumeBehavior";
                }
                case 176: {
                    return "setMultiAudioFocusEnabled";
                }
                case 177: {
                    return "setPreferredDevicesForCapturePreset";
                }
                case 178: {
                    return "clearPreferredDevicesForCapturePreset";
                }
                case 179: {
                    return "getPreferredDevicesForCapturePreset";
                }
                case 180: {
                    return "registerCapturePresetDevicesRoleDispatcher";
                }
                case 181: {
                    return "unregisterCapturePresetDevicesRoleDispatcher";
                }
                case 182: {
                    return "adjustStreamVolumeForUid";
                }
                case 183: {
                    return "adjustSuggestedStreamVolumeForUid";
                }
                case 184: {
                    return "setStreamVolumeForUid";
                }
                case 185: {
                    return "adjustVolume";
                }
                case 186: {
                    return "adjustSuggestedStreamVolume";
                }
                case 187: {
                    return "isMusicActive";
                }
                case 188: {
                    return "getDeviceMaskForStream";
                }
                case 189: {
                    return "getAvailableCommunicationDeviceIds";
                }
                case 190: {
                    return "setCommunicationDevice";
                }
                case 191: {
                    return "getCommunicationDevice";
                }
                case 192: {
                    return "registerCommunicationDeviceDispatcher";
                }
                case 193: {
                    return "unregisterCommunicationDeviceDispatcher";
                }
                case 194: {
                    return "areNavigationRepeatSoundEffectsEnabled";
                }
                case 195: {
                    return "setNavigationRepeatSoundEffectsEnabled";
                }
                case 196: {
                    return "isHomeSoundEffectEnabled";
                }
                case 197: {
                    return "setHomeSoundEffectEnabled";
                }
                case 198: {
                    return "setAdditionalOutputDeviceDelay";
                }
                case 199: {
                    return "getAdditionalOutputDeviceDelay";
                }
                case 200: {
                    return "getMaxAdditionalOutputDeviceDelay";
                }
                case 201: {
                    return "requestAudioFocusForTest";
                }
                case 202: {
                    return "abandonAudioFocusForTest";
                }
                case 203: {
                    return "getFadeOutDurationOnFocusLossMillis";
                }
                case 204: {
                    return "getFocusDuckedUidsForTest";
                }
                case 205: {
                    return "getFocusFadeOutDurationForTest";
                }
                case 206: {
                    return "getFocusUnmuteDelayAfterFadeOutForTest";
                }
                case 207: {
                    return "enterAudioFocusFreezeForTest";
                }
                case 208: {
                    return "exitAudioFocusFreezeForTest";
                }
                case 209: {
                    return "registerModeDispatcher";
                }
                case 210: {
                    return "unregisterModeDispatcher";
                }
                case 211: {
                    return "getSpatializerImmersiveAudioLevel";
                }
                case 212: {
                    return "isSpatializerEnabled";
                }
                case 213: {
                    return "isSpatializerAvailable";
                }
                case 214: {
                    return "isSpatializerAvailableForDevice";
                }
                case 215: {
                    return "hasHeadTracker";
                }
                case 216: {
                    return "setHeadTrackerEnabled";
                }
                case 217: {
                    return "isHeadTrackerEnabled";
                }
                case 218: {
                    return "isHeadTrackerAvailable";
                }
                case 219: {
                    return "registerSpatializerHeadTrackerAvailableCallback";
                }
                case 220: {
                    return "setSpatializerEnabled";
                }
                case 221: {
                    return "canBeSpatialized";
                }
                case 222: {
                    return "getSpatializedChannelMasks";
                }
                case 223: {
                    return "registerSpatializerCallback";
                }
                case 224: {
                    return "unregisterSpatializerCallback";
                }
                case 225: {
                    return "registerSpatializerHeadTrackingCallback";
                }
                case 226: {
                    return "unregisterSpatializerHeadTrackingCallback";
                }
                case 227: {
                    return "registerHeadToSoundstagePoseCallback";
                }
                case 228: {
                    return "unregisterHeadToSoundstagePoseCallback";
                }
                case 229: {
                    return "getSpatializerCompatibleAudioDevices";
                }
                case 230: {
                    return "addSpatializerCompatibleAudioDevice";
                }
                case 231: {
                    return "removeSpatializerCompatibleAudioDevice";
                }
                case 232: {
                    return "setDesiredHeadTrackingMode";
                }
                case 233: {
                    return "getDesiredHeadTrackingMode";
                }
                case 234: {
                    return "getSupportedHeadTrackingModes";
                }
                case 235: {
                    return "getActualHeadTrackingMode";
                }
                case 236: {
                    return "setSpatializerGlobalTransform";
                }
                case 237: {
                    return "recenterHeadTracker";
                }
                case 238: {
                    return "setSpatializerParameter";
                }
                case 239: {
                    return "getSpatializerParameter";
                }
                case 240: {
                    return "getSpatializerOutput";
                }
                case 241: {
                    return "registerSpatializerOutputCallback";
                }
                case 242: {
                    return "unregisterSpatializerOutputCallback";
                }
                case 243: {
                    return "isVolumeFixed";
                }
                case 244: {
                    return "getDefaultVolumeInfo";
                }
                case 245: {
                    return "isPstnCallAudioInterceptable";
                }
                case 246: {
                    return "muteAwaitConnection";
                }
                case 247: {
                    return "cancelMuteAwaitConnection";
                }
                case 248: {
                    return "getMutingExpectedDevice";
                }
                case 249: {
                    return "registerMuteAwaitConnectionDispatcher";
                }
                case 250: {
                    return "setTestDeviceConnectionState";
                }
                case 251: {
                    return "registerDeviceVolumeBehaviorDispatcher";
                }
                case 252: {
                    return "getFocusStack";
                }
                case 253: {
                    return "sendFocusLossAndUpdate";
                }
                case 254: {
                    return "sendFocusLoss";
                }
                case 255: {
                    return "addAssistantServicesUids";
                }
                case 256: {
                    return "removeAssistantServicesUids";
                }
                case 257: {
                    return "setActiveAssistantServiceUids";
                }
                case 258: {
                    return "getAssistantServicesUids";
                }
                case 259: {
                    return "getActiveAssistantServiceUids";
                }
                case 260: {
                    return "registerDeviceVolumeDispatcherForAbsoluteVolume";
                }
                case 261: {
                    return "getHalVersion";
                }
                case 262: {
                    return "setPreferredMixerAttributes";
                }
                case 263: {
                    return "clearPreferredMixerAttributes";
                }
                case 264: {
                    return "registerPreferredMixerAttributesDispatcher";
                }
                case 265: {
                    return "unregisterPreferredMixerAttributesDispatcher";
                }
                case 266: {
                    return "supportsBluetoothVariableLatency";
                }
                case 267: {
                    return "setBluetoothVariableLatencyEnabled";
                }
                case 268: {
                    return "isBluetoothVariableLatencyEnabled";
                }
                case 269: {
                    return "registerLoudnessCodecUpdatesDispatcher";
                }
                case 270: {
                    return "unregisterLoudnessCodecUpdatesDispatcher";
                }
                case 271: {
                    return "startLoudnessCodecUpdates";
                }
                case 272: {
                    return "stopLoudnessCodecUpdates";
                }
                case 273: {
                    return "addLoudnessCodecInfo";
                }
                case 274: {
                    return "removeLoudnessCodecInfo";
                }
                case 275: {
                    return "getLoudnessParams";
                }
                case 276: {
                    return "setFadeManagerConfigurationForFocusLoss";
                }
                case 277: {
                    return "clearFadeManagerConfigurationForFocusLoss";
                }
                case 278: {
                    return "getFadeManagerConfigurationForFocusLoss";
                }
                case 279: {
                    return "shouldNotificationSoundPlay";
                }
                case 280: {
                    return "setEnableHardening";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IAudioManagerNative _result = this.getNativeInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    PlayerBase.PlayerIdCard _arg0 = data.readTypedObject(PlayerBase.PlayerIdCard.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.trackPlayer(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    AudioAttributes _arg1 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.playerAttributes(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.playerEvent(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releasePlayer(_arg0);
                    break;
                }
                case 6: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.trackRecorder(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.recorderEvent(_arg0, _arg1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseRecorder(_arg0);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.playerSessionId(_arg0, _arg1);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.portEvent(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    this.permissionUpdateBarrier();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.adjustStreamVolume(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.adjustStreamVolumeWithAttribution(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setStreamVolume(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setStreamVolumeWithAttribution(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    VolumeInfo _arg0 = data.readTypedObject(VolumeInfo.CREATOR);
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setDeviceVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    VolumeInfo _arg0 = data.readTypedObject(VolumeInfo.CREATOR);
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setVolumeForDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    VolumeInfo _arg0 = data.readTypedObject(VolumeInfo.CREATOR);
                    int _arg1 = data.readInt();
                    AudioDeviceAttributes _arg2 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.adjustVolumeForDevice(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    VolumeInfo _arg0 = data.readTypedObject(VolumeInfo.CREATOR);
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.notifyAbsoluteVolumeChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 20: {
                    VolumeInfo _arg0 = data.readTypedObject(VolumeInfo.CREATOR);
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    VolumeInfo _result = this.getDeviceVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 21: {
                    KeyEvent _arg0 = data.readTypedObject(KeyEvent.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.handleVolumeKey(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStreamMute(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    boolean _arg0 = data.readBoolean();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.forceRemoteSubmixFullVolume(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    boolean _result = this.isMasterMute();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setMasterMute(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamMinVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamMaxVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 29: {
                    List<AudioVolumeGroup> _result = this.getAudioVolumeGroups();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setVolumeGroupVolumeIndex(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getVolumeGroupVolumeIndex(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getVolumeGroupMaxVolumeIndex(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getVolumeGroupMinVolumeIndex(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getLastAudibleVolumeForVolumeGroup(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isVolumeGroupMuted(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.adjustVolumeGroupVolume(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getLastAudibleStreamVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 38: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setSupportedSystemUsages(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    int[] _result = this.getSupportedSystemUsages();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 40: {
                    List<AudioProductStrategy> _result = this.getAudioProductStrategies();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 41: {
                    boolean _result = this.isMicrophoneMuted();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 42: {
                    boolean _result = this.isUltrasoundSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 43: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.isHotwordStreamSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 44: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setMicrophoneMute(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setInputGainIndex(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getInputGainIndex(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 47: {
                    int _result = this.getMaxInputGainIndex();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 48: {
                    int _result = this.getMinInputGainIndex();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 49: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isInputGainFixed(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 50: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setMicrophoneMuteFromSwitch(_arg0);
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setRingerModeExternal(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setRingerModeInternal(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    int _result = this.getRingerModeExternal();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 54: {
                    int _result = this.getRingerModeInternal();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 55: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isValidRingerMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 56: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setVibrateSetting(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getVibrateSetting(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldVibrate(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 59: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    int _result = this.getMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 61: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.playSoundEffect(_arg0, _arg1);
                    break;
                }
                case 62: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.playSoundEffectVolume(_arg0, _arg1);
                    break;
                }
                case 63: {
                    boolean _result = this.loadSoundEffects();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 64: {
                    this.unloadSoundEffects();
                    break;
                }
                case 65: {
                    this.reloadAudioSettings();
                    break;
                }
                case 66: {
                    Map _result = this.getSurroundFormats();
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 67: {
                    List _result = this.getReportedSurroundFormats();
                    reply.writeNoException();
                    reply.writeList(_result);
                    break;
                }
                case 68: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setSurroundFormatEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 69: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSurroundFormatEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 70: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setEncodedSurroundMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 71: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getEncodedSurroundMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 72: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setSpeakerphoneOn(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 73: {
                    boolean _result = this.isSpeakerphoneOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 74: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBluetoothScoOn(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 75: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setA2dpSuspended(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 76: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setLeAudioSuspended(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 77: {
                    boolean _result = this.isBluetoothScoOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 78: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBluetoothA2dpOn(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 79: {
                    boolean _result = this.isBluetoothA2dpOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 80: {
                    return this.onTransact$requestAudioFocus$(data, reply);
                }
                case 81: {
                    IAudioFocusDispatcher _arg0 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    AudioAttributes _arg2 = data.readTypedObject(AudioAttributes.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.abandonAudioFocus(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 82: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterAudioFocusClient(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 83: {
                    int _result = this.getCurrentAudioFocus();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 84: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.startBluetoothSco(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 85: {
                    IBinder _arg0 = data.readStrongBinder();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.startBluetoothScoVirtualCall(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 86: {
                    IBinder _arg0 = data.readStrongBinder();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.stopBluetoothSco(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 87: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.forceVolumeControlStream(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 88: {
                    IRingtonePlayer _arg0 = IRingtonePlayer.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setRingtonePlayer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 89: {
                    IRingtonePlayer _result = this.getRingtonePlayer();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 90: {
                    int _result = this.getUiSoundsStreamType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 91: {
                    List _result = this.getIndependentStreamTypes();
                    reply.writeNoException();
                    reply.writeList(_result);
                    break;
                }
                case 92: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamTypeAlias(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 93: {
                    boolean _result = this.isVolumeControlUsingVolumeGroups();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 94: {
                    IStreamAliasingDispatcher _arg0 = IStreamAliasingDispatcher.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.registerStreamAliasingDispatcher(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 95: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotifAliasRingForTest(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 96: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setWiredDeviceConnectionState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 97: {
                    IAudioRoutesObserver _arg0 = IAudioRoutesObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    AudioRoutesInfo _result = this.startWatchingRoutes(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 98: {
                    boolean _result = this.isCameraSoundForced();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 99: {
                    IVolumeController _arg0 = IVolumeController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setVolumeController(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 100: {
                    IVolumeController _result = this.getVolumeController();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 101: {
                    IVolumeController _arg0 = IVolumeController.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyVolumeControllerVisible(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 102: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setVolumeControllerLongPressTimeoutEnabled(_arg0);
                    break;
                }
                case 103: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStreamAffectedByRingerMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 104: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStreamAffectedByMute(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 105: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStreamMutableByUi(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 106: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.disableSafeMediaVolume(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 107: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.lowerVolumeToRs1(_arg0);
                    break;
                }
                case 108: {
                    float _result = this.getOutputRs2UpperBound();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 109: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setOutputRs2UpperBound(_arg0);
                    break;
                }
                case 110: {
                    float _result = this.getCsd();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 111: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setCsd(_arg0);
                    break;
                }
                case 112: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceUseFrameworkMel(_arg0);
                    break;
                }
                case 113: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceComputeCsdOnAllDevices(_arg0);
                    break;
                }
                case 114: {
                    boolean _result = this.isCsdEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 115: {
                    boolean _result = this.isCsdAsAFeatureAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 116: {
                    boolean _result = this.isCsdAsAFeatureEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 117: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setCsdAsAFeatureEnabled(_arg0);
                    break;
                }
                case 118: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setBluetoothAudioDeviceCategory(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 119: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getBluetoothAudioDeviceCategory(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 120: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isBluetoothAudioDeviceCategoryFixed(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 121: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.setHdmiSystemAudioSupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 122: {
                    boolean _result = this.isHdmiSystemAudioSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 123: {
                    AudioPolicyConfig _arg0 = data.readTypedObject(AudioPolicyConfig.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    IMediaProjection _arg6 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg7 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.registerAudioPolicy(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 124: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAudioPolicyAsync(_arg0);
                    break;
                }
                case 125: {
                    List<AudioMix> _result = this.getRegisteredPolicyMixes();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 126: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAudioPolicy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 127: {
                    AudioPolicyConfig _arg0 = data.readTypedObject(AudioPolicyConfig.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.addMixForPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 128: {
                    AudioPolicyConfig _arg0 = data.readTypedObject(AudioPolicyConfig.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.removeMixForPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 129: {
                    AudioMix[] _arg0 = data.createTypedArray(AudioMix.CREATOR);
                    AudioMixingRule[] _arg1 = data.createTypedArray(AudioMixingRule.CREATOR);
                    IAudioPolicyCallback _arg2 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.updateMixingRulesForPolicy(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 130: {
                    int _arg0 = data.readInt();
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.setFocusPropertiesForPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 131: {
                    VolumePolicy _arg0 = data.readTypedObject(VolumePolicy.CREATOR);
                    data.enforceNoDataAvail();
                    this.setVolumePolicy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 132: {
                    VolumePolicy _result = this.getVolumePolicy();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 133: {
                    boolean _result = this.hasRegisteredDynamicPolicy();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 134: {
                    IRecordingConfigDispatcher _arg0 = IRecordingConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerRecordingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 135: {
                    IRecordingConfigDispatcher _arg0 = IRecordingConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterRecordingCallback(_arg0);
                    break;
                }
                case 136: {
                    List<AudioRecordingConfiguration> _result = this.getActiveRecordingConfigurations();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 137: {
                    IPlaybackConfigDispatcher _arg0 = IPlaybackConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerPlaybackCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 138: {
                    IPlaybackConfigDispatcher _arg0 = IPlaybackConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterPlaybackCallback(_arg0);
                    break;
                }
                case 139: {
                    List<AudioPlaybackConfiguration> _result = this.getActivePlaybackConfigurations();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 140: {
                    int _arg0 = data.readInt();
                    AudioAttributes _arg1 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getFocusRampTimeMs(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 141: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    int _arg1 = data.readInt();
                    IAudioPolicyCallback _arg2 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.dispatchFocusChange(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 142: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    int _arg1 = data.readInt();
                    IAudioPolicyCallback _arg2 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    ArrayList<AudioFocusInfo> _arg3 = data.createTypedArrayList(AudioFocusInfo.CREATOR);
                    FadeManagerConfiguration _arg4 = data.readTypedObject(FadeManagerConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.dispatchFocusChangeWithFade(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 143: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.playerHasOpPlayAudio(_arg0, _arg1);
                    break;
                }
                case 144: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    BluetoothDevice _arg1 = data.readTypedObject(BluetoothDevice.CREATOR);
                    BluetoothProfileConnectionInfo _arg2 = data.readTypedObject(BluetoothProfileConnectionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.handleBluetoothActiveDeviceChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 145: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    int _arg1 = data.readInt();
                    IAudioPolicyCallback _arg2 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setFocusRequestResultFromExtPolicy(_arg0, _arg1, _arg2);
                    break;
                }
                case 146: {
                    IAudioServerStateDispatcher _arg0 = IAudioServerStateDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAudioServerStateDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 147: {
                    IAudioServerStateDispatcher _arg0 = IAudioServerStateDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAudioServerStateDispatcher(_arg0);
                    break;
                }
                case 148: {
                    boolean _result = this.isAudioServerRunning();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 149: {
                    IAudioVolumeChangeDispatcher _arg0 = IAudioVolumeChangeDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAudioVolumeCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 150: {
                    IAudioVolumeChangeDispatcher _arg0 = IAudioVolumeChangeDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAudioVolumeCallback(_arg0);
                    break;
                }
                case 151: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    String[] _arg3 = data.createStringArray();
                    data.enforceNoDataAvail();
                    int _result = this.setUidDeviceAffinity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 152: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.removeUidDeviceAffinity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 153: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    String[] _arg3 = data.createStringArray();
                    data.enforceNoDataAvail();
                    int _result = this.setUserIdDeviceAffinity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 154: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.removeUserIdDeviceAffinity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 155: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasHapticChannels(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 156: {
                    boolean _result = this.isCallScreeningModeSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 157: {
                    int _arg0 = data.readInt();
                    ArrayList<AudioDeviceAttributes> _arg1 = data.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setPreferredDevicesForStrategy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 158: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.removePreferredDevicesForStrategy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 159: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getPreferredDevicesForStrategy(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 160: {
                    int _arg0 = data.readInt();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setDeviceAsNonDefaultForStrategy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 161: {
                    int _arg0 = data.readInt();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.removeDeviceAsNonDefaultForStrategy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 162: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getNonDefaultDevicesForStrategy(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 163: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getDevicesForAttributes(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 164: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getDevicesForAttributesUnprotected(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 165: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    IDevicesForAttributesCallback _arg1 = IDevicesForAttributesCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addOnDevicesForAttributesChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 166: {
                    IDevicesForAttributesCallback _arg0 = IDevicesForAttributesCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeOnDevicesForAttributesChangedListener(_arg0);
                    break;
                }
                case 167: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setAllowedCapturePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 168: {
                    int _result = this.getAllowedCapturePolicy();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 169: {
                    IStrategyPreferredDevicesDispatcher _arg0 = IStrategyPreferredDevicesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerStrategyPreferredDevicesDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 170: {
                    IStrategyPreferredDevicesDispatcher _arg0 = IStrategyPreferredDevicesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterStrategyPreferredDevicesDispatcher(_arg0);
                    break;
                }
                case 171: {
                    IStrategyNonDefaultDevicesDispatcher _arg0 = IStrategyNonDefaultDevicesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerStrategyNonDefaultDevicesDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 172: {
                    IStrategyNonDefaultDevicesDispatcher _arg0 = IStrategyNonDefaultDevicesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterStrategyNonDefaultDevicesDispatcher(_arg0);
                    break;
                }
                case 173: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRttEnabled(_arg0);
                    break;
                }
                case 174: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setDeviceVolumeBehavior(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 175: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getDeviceVolumeBehavior(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 176: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setMultiAudioFocusEnabled(_arg0);
                    break;
                }
                case 177: {
                    int _arg0 = data.readInt();
                    ArrayList<AudioDeviceAttributes> _arg1 = data.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setPreferredDevicesForCapturePreset(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 178: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.clearPreferredDevicesForCapturePreset(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 179: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getPreferredDevicesForCapturePreset(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 180: {
                    ICapturePresetDevicesRoleDispatcher _arg0 = ICapturePresetDevicesRoleDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCapturePresetDevicesRoleDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 181: {
                    ICapturePresetDevicesRoleDispatcher _arg0 = ICapturePresetDevicesRoleDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCapturePresetDevicesRoleDispatcher(_arg0);
                    break;
                }
                case 182: {
                    return this.onTransact$adjustStreamVolumeForUid$(data, reply);
                }
                case 183: {
                    return this.onTransact$adjustSuggestedStreamVolumeForUid$(data, reply);
                }
                case 184: {
                    return this.onTransact$setStreamVolumeForUid$(data, reply);
                }
                case 185: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.adjustVolume(_arg0, _arg1);
                    break;
                }
                case 186: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.adjustSuggestedStreamVolume(_arg0, _arg1, _arg2);
                    break;
                }
                case 187: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.isMusicActive(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 188: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDeviceMaskForStream(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 189: {
                    int[] _result = this.getAvailableCommunicationDeviceIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 190: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setCommunicationDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 191: {
                    int _result = this.getCommunicationDevice();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 192: {
                    ICommunicationDeviceDispatcher _arg0 = ICommunicationDeviceDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCommunicationDeviceDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 193: {
                    ICommunicationDeviceDispatcher _arg0 = ICommunicationDeviceDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCommunicationDeviceDispatcher(_arg0);
                    break;
                }
                case 194: {
                    boolean _result = this.areNavigationRepeatSoundEffectsEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 195: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNavigationRepeatSoundEffectsEnabled(_arg0);
                    break;
                }
                case 196: {
                    boolean _result = this.isHomeSoundEffectEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 197: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setHomeSoundEffectEnabled(_arg0);
                    break;
                }
                case 198: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.setAdditionalOutputDeviceDelay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 199: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getAdditionalOutputDeviceDelay(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 200: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getMaxAdditionalOutputDeviceDelay(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 201: {
                    return this.onTransact$requestAudioFocusForTest$(data, reply);
                }
                case 202: {
                    IAudioFocusDispatcher _arg0 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    AudioAttributes _arg2 = data.readTypedObject(AudioAttributes.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.abandonAudioFocusForTest(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 203: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getFadeOutDurationOnFocusLossMillis(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 204: {
                    List _result = this.getFocusDuckedUidsForTest();
                    reply.writeNoException();
                    reply.writeList(_result);
                    break;
                }
                case 205: {
                    long _result = this.getFocusFadeOutDurationForTest();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 206: {
                    long _result = this.getFocusUnmuteDelayAfterFadeOutForTest();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 207: {
                    IBinder _arg0 = data.readStrongBinder();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    boolean _result = this.enterAudioFocusFreezeForTest(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 208: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.exitAudioFocusFreezeForTest(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 209: {
                    IAudioModeDispatcher _arg0 = IAudioModeDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerModeDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 210: {
                    IAudioModeDispatcher _arg0 = IAudioModeDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterModeDispatcher(_arg0);
                    break;
                }
                case 211: {
                    int _result = this.getSpatializerImmersiveAudioLevel();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 212: {
                    boolean _result = this.isSpatializerEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 213: {
                    boolean _result = this.isSpatializerAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 214: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isSpatializerAvailableForDevice(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 215: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasHeadTracker(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 216: {
                    boolean _arg0 = data.readBoolean();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.setHeadTrackerEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 217: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isHeadTrackerEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 218: {
                    boolean _result = this.isHeadTrackerAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 219: {
                    ISpatializerHeadTrackerAvailableCallback _arg0 = ISpatializerHeadTrackerAvailableCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.registerSpatializerHeadTrackerAvailableCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 220: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSpatializerEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 221: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    AudioFormat _arg1 = data.readTypedObject(AudioFormat.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.canBeSpatialized(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 222: {
                    List _result = this.getSpatializedChannelMasks();
                    reply.writeNoException();
                    reply.writeList(_result);
                    break;
                }
                case 223: {
                    ISpatializerCallback _arg0 = ISpatializerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSpatializerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 224: {
                    ISpatializerCallback _arg0 = ISpatializerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSpatializerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 225: {
                    ISpatializerHeadTrackingModeCallback _arg0 = ISpatializerHeadTrackingModeCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSpatializerHeadTrackingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 226: {
                    ISpatializerHeadTrackingModeCallback _arg0 = ISpatializerHeadTrackingModeCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSpatializerHeadTrackingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 227: {
                    ISpatializerHeadToSoundStagePoseCallback _arg0 = ISpatializerHeadToSoundStagePoseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerHeadToSoundstagePoseCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 228: {
                    ISpatializerHeadToSoundStagePoseCallback _arg0 = ISpatializerHeadToSoundStagePoseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterHeadToSoundstagePoseCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 229: {
                    List<AudioDeviceAttributes> _result = this.getSpatializerCompatibleAudioDevices();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 230: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.addSpatializerCompatibleAudioDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 231: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeSpatializerCompatibleAudioDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 232: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDesiredHeadTrackingMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 233: {
                    int _result = this.getDesiredHeadTrackingMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 234: {
                    int[] _result = this.getSupportedHeadTrackingModes();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 235: {
                    int _result = this.getActualHeadTrackingMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 236: {
                    float[] _arg0 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.setSpatializerGlobalTransform(_arg0);
                    break;
                }
                case 237: {
                    this.recenterHeadTracker();
                    break;
                }
                case 238: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.setSpatializerParameter(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 239: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.getSpatializerParameter(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_arg1);
                    break;
                }
                case 240: {
                    int _result = this.getSpatializerOutput();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 241: {
                    ISpatializerOutputCallback _arg0 = ISpatializerOutputCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSpatializerOutputCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 242: {
                    ISpatializerOutputCallback _arg0 = ISpatializerOutputCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSpatializerOutputCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 243: {
                    boolean _result = this.isVolumeFixed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 244: {
                    VolumeInfo _result = this.getDefaultVolumeInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 245: {
                    boolean _result = this.isPstnCallAudioInterceptable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 246: {
                    int[] _arg0 = data.createIntArray();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.muteAwaitConnection(_arg0, _arg1, _arg2);
                    break;
                }
                case 247: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.cancelMuteAwaitConnection(_arg0);
                    break;
                }
                case 248: {
                    AudioDeviceAttributes _result = this.getMutingExpectedDevice();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 249: {
                    IMuteAwaitConnectionCallback _arg0 = IMuteAwaitConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.registerMuteAwaitConnectionDispatcher(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 250: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTestDeviceConnectionState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 251: {
                    boolean _arg0 = data.readBoolean();
                    IDeviceVolumeBehaviorDispatcher _arg1 = IDeviceVolumeBehaviorDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerDeviceVolumeBehaviorDispatcher(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 252: {
                    List<AudioFocusInfo> _result = this.getFocusStack();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 253: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.sendFocusLossAndUpdate(_arg0, _arg1);
                    break;
                }
                case 254: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.sendFocusLoss(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 255: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.addAssistantServicesUids(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 256: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.removeAssistantServicesUids(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 257: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setActiveAssistantServiceUids(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 258: {
                    int[] _result = this.getAssistantServicesUids();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 259: {
                    int[] _result = this.getActiveAssistantServiceUids();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 260: {
                    boolean _arg0 = data.readBoolean();
                    IAudioDeviceVolumeDispatcher _arg1 = IAudioDeviceVolumeDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    AudioDeviceAttributes _arg3 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    ArrayList<VolumeInfo> _arg4 = data.createTypedArrayList(VolumeInfo.CREATOR);
                    boolean _arg5 = data.readBoolean();
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerDeviceVolumeDispatcherForAbsoluteVolume(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 261: {
                    AudioHalVersionInfo _result = this.getHalVersion();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 262: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    AudioMixerAttributes _arg2 = data.readTypedObject(AudioMixerAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setPreferredMixerAttributes(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 263: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.clearPreferredMixerAttributes(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 264: {
                    IPreferredMixerAttributesDispatcher _arg0 = IPreferredMixerAttributesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerPreferredMixerAttributesDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 265: {
                    IPreferredMixerAttributesDispatcher _arg0 = IPreferredMixerAttributesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterPreferredMixerAttributesDispatcher(_arg0);
                    break;
                }
                case 266: {
                    boolean _result = this.supportsBluetoothVariableLatency();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 267: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBluetoothVariableLatencyEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 268: {
                    boolean _result = this.isBluetoothVariableLatencyEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 269: {
                    ILoudnessCodecUpdatesDispatcher _arg0 = ILoudnessCodecUpdatesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerLoudnessCodecUpdatesDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 270: {
                    ILoudnessCodecUpdatesDispatcher _arg0 = ILoudnessCodecUpdatesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterLoudnessCodecUpdatesDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 271: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startLoudnessCodecUpdates(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 272: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopLoudnessCodecUpdates(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 273: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    LoudnessCodecInfo _arg2 = data.readTypedObject(LoudnessCodecInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.addLoudnessCodecInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 274: {
                    int _arg0 = data.readInt();
                    LoudnessCodecInfo _arg1 = data.readTypedObject(LoudnessCodecInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeLoudnessCodecInfo(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 275: {
                    LoudnessCodecInfo _arg0 = data.readTypedObject(LoudnessCodecInfo.CREATOR);
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.getLoudnessParams(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 276: {
                    FadeManagerConfiguration _arg0 = data.readTypedObject(FadeManagerConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setFadeManagerConfigurationForFocusLoss(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 277: {
                    int _result = this.clearFadeManagerConfigurationForFocusLoss();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 278: {
                    FadeManagerConfiguration _result = this.getFadeManagerConfigurationForFocusLoss();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 279: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldNotificationSoundPlay(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 280: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setEnableHardening(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setDeviceVolume_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_setDeviceVolume, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setVolumeForDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_setVolumeForDevice, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void adjustVolumeForDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_adjustVolumeForDevice, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyAbsoluteVolumeChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_notifyAbsoluteVolumeChanged, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDeviceVolume_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getDeviceVolume, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setMasterMute_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAudioVolumeGroups_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getAudioVolumeGroups, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setVolumeGroupVolumeIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_setVolumeGroupVolumeIndex, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getVolumeGroupVolumeIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getVolumeGroupVolumeIndex, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getVolumeGroupMaxVolumeIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getVolumeGroupMaxVolumeIndex, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getVolumeGroupMinVolumeIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getVolumeGroupMinVolumeIndex, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getLastAudibleVolumeForVolumeGroup_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_AUDIO_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getLastAudibleStreamVolume_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_AUDIO_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setSupportedSystemUsages_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSupportedSystemUsages_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAudioProductStrategies_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isUltrasoundSupported_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_ULTRASOUND", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isHotwordStreamSupported_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CAPTURE_AUDIO_HOTWORD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setInputGainIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getInputGainIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getMaxInputGainIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getMinInputGainIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isInputGainFixed_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setEncodedSurroundMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.WRITE_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setA2dpSuspended_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BLUETOOTH_STACK", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setLeAudioSuspended_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BLUETOOTH_STACK", Stub.getCallingPid(), Stub.getCallingUid());
        }

        private boolean onTransact$requestAudioFocus$(Parcel data, Parcel reply) throws RemoteException {
            AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
            int _arg1 = data.readInt();
            IBinder _arg2 = data.readStrongBinder();
            IAudioFocusDispatcher _arg3 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
            String _arg4 = data.readString();
            String _arg5 = data.readString();
            String _arg6 = data.readString();
            int _arg7 = data.readInt();
            IAudioPolicyCallback _arg8 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
            int _arg9 = data.readInt();
            data.enforceNoDataAvail();
            int _result = this.requestAudioFocus(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
            reply.writeNoException();
            reply.writeInt(_result);
            return true;
        }

        protected void setRingtonePlayer_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.REMOTE_AUDIO_PLAYBACK", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getIndependentStreamTypes_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getStreamTypeAlias_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isVolumeControlUsingVolumeGroups_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerStreamAliasingDispatcher_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setNotifAliasRingForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setWiredDeviceConnectionState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setVolumeControllerLongPressTimeoutEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getOutputRs2UpperBound_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setOutputRs2UpperBound_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getCsd_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setCsd_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void forceUseFrameworkMel_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void forceComputeCsdOnAllDevices_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isCsdEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isCsdAsAFeatureAvailable_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isCsdAsAFeatureEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setCsdAsAFeatureEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setBluetoothAudioDeviceCategory_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getBluetoothAudioDeviceCategory_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isBluetoothAudioDeviceCategoryFixed_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void updateMixingRulesForPolicy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void dispatchFocusChangeWithFade_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void handleBluetoothActiveDeviceChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BLUETOOTH_STACK", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setPreferredDevicesForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removePreferredDevicesForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getPreferredDevicesForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDeviceAsNonDefaultForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeDeviceAsNonDefaultForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getNonDefaultDevicesForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addOnDevicesForAttributesChangedListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_addOnDevicesForAttributesChangedListener, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDeviceVolumeBehavior_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_setDeviceVolumeBehavior, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDeviceVolumeBehavior_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getDeviceVolumeBehavior, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setMultiAudioFocusEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void clearPreferredDevicesForCapturePreset_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getPreferredDevicesForCapturePreset_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        private boolean onTransact$adjustStreamVolumeForUid$(Parcel data, Parcel reply) throws RemoteException {
            int _arg0 = data.readInt();
            int _arg1 = data.readInt();
            int _arg2 = data.readInt();
            String _arg3 = data.readString();
            int _arg4 = data.readInt();
            int _arg5 = data.readInt();
            UserHandle _arg6 = data.readTypedObject(UserHandle.CREATOR);
            int _arg7 = data.readInt();
            data.enforceNoDataAvail();
            this.adjustStreamVolumeForUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
            return true;
        }

        private boolean onTransact$adjustSuggestedStreamVolumeForUid$(Parcel data, Parcel reply) throws RemoteException {
            int _arg0 = data.readInt();
            int _arg1 = data.readInt();
            int _arg2 = data.readInt();
            String _arg3 = data.readString();
            int _arg4 = data.readInt();
            int _arg5 = data.readInt();
            UserHandle _arg6 = data.readTypedObject(UserHandle.CREATOR);
            int _arg7 = data.readInt();
            data.enforceNoDataAvail();
            this.adjustSuggestedStreamVolumeForUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
            return true;
        }

        private boolean onTransact$setStreamVolumeForUid$(Parcel data, Parcel reply) throws RemoteException {
            int _arg0 = data.readInt();
            int _arg1 = data.readInt();
            int _arg2 = data.readInt();
            String _arg3 = data.readString();
            int _arg4 = data.readInt();
            int _arg5 = data.readInt();
            UserHandle _arg6 = data.readTypedObject(UserHandle.CREATOR);
            int _arg7 = data.readInt();
            data.enforceNoDataAvail();
            this.setStreamVolumeForUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
            return true;
        }

        private boolean onTransact$requestAudioFocusForTest$(Parcel data, Parcel reply) throws RemoteException {
            AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
            int _arg1 = data.readInt();
            IBinder _arg2 = data.readStrongBinder();
            IAudioFocusDispatcher _arg3 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
            String _arg4 = data.readString();
            String _arg5 = data.readString();
            int _arg6 = data.readInt();
            int _arg7 = data.readInt();
            int _arg8 = data.readInt();
            data.enforceNoDataAvail();
            int _result = this.requestAudioFocusForTest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
            reply.writeNoException();
            reply.writeInt(_result);
            return true;
        }

        protected void getFocusDuckedUidsForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_AUDIO_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getFocusFadeOutDurationForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_AUDIO_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getFocusUnmuteDelayAfterFadeOutForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_AUDIO_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void enterAudioFocusFreezeForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void exitAudioFocusFreezeForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isSpatializerAvailableForDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void hasHeadTracker_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setHeadTrackerEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isHeadTrackerEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setSpatializerEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerSpatializerHeadTrackingCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterSpatializerHeadTrackingCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerHeadToSoundstagePoseCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterHeadToSoundstagePoseCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSpatializerCompatibleAudioDevices_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addSpatializerCompatibleAudioDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeSpatializerCompatibleAudioDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDesiredHeadTrackingMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDesiredHeadTrackingMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSupportedHeadTrackingModes_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getActualHeadTrackingMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setSpatializerGlobalTransform_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void recenterHeadTracker_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setSpatializerParameter_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSpatializerParameter_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSpatializerOutput_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerSpatializerOutputCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterSpatializerOutputCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isPstnCallAudioInterceptable_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CALL_AUDIO_INTERCEPTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getMutingExpectedDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerMuteAwaitConnectionDispatcher_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getFocusStack_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendFocusLossAndUpdate_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendFocusLoss_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addAssistantServicesUids_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeAssistantServicesUids_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setActiveAssistantServiceUids_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAssistantServicesUids_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getActiveAssistantServiceUids_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void supportsBluetoothVariableLatency_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setBluetoothVariableLatencyEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isBluetoothVariableLatencyEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setFadeManagerConfigurationForFocusLoss_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void clearFadeManagerConfigurationForFocusLoss_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getFadeManagerConfigurationForFocusLoss_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void shouldNotificationSoundPlay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_AUDIO_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setEnableHardening_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 279;
        }

        private static class Proxy
        implements IAudioService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IAudioManagerNative getNativeInterface() throws RemoteException {
                IAudioManagerNative _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = IAudioManagerNative.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int trackPlayer(PlayerBase.PlayerIdCard pic) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(pic, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerAttributes(int piid, AudioAttributes attr2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeTypedObject(attr2, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerEvent(int piid, int event, int[] eventId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeInt(event);
                    _data.writeIntArray(eventId);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releasePlayer(int piid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int trackRecorder(IBinder recorder) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(recorder);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recorderEvent(int riid, int event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(riid);
                    _data.writeInt(event);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseRecorder(int riid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(riid);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerSessionId(int piid, int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void portEvent(int portId, int event, PersistableBundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(portId);
                    _data.writeInt(event);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void permissionUpdateBarrier() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustStreamVolumeWithAttribution(int streamType, int direction, int flags, String callingPackage, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStreamVolume(int streamType, int index, int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(index);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStreamVolumeWithAttribution(int streamType, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(index);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceVolume(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(vi, 0);
                    _data.writeTypedObject(ada, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeForDevice(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(vi, 0);
                    _data.writeTypedObject(ada, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustVolumeForDevice(VolumeInfo vi, int direction, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(vi, 0);
                    _data.writeInt(direction);
                    _data.writeTypedObject(ada, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAbsoluteVolumeChanged(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(vi, 0);
                    _data.writeTypedObject(ada, 0);
                    _data.writeString(callingPackage);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VolumeInfo getDeviceVolume(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
                VolumeInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(vi, 0);
                    _data.writeTypedObject(ada, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VolumeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleVolumeKey(KeyEvent event, boolean isOnTv, String callingPackage, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    _data.writeBoolean(isOnTv);
                    _data.writeString(callingPackage);
                    _data.writeString(caller);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreamMute(int streamType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceRemoteSubmixFullVolume(boolean startForcing, IBinder cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(startForcing);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMasterMute() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMasterMute(boolean mute, int flags, String callingPackage, int userId, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(mute);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamMinVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamMaxVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioVolumeGroup> getAudioVolumeGroups() throws RemoteException {
                ArrayList<AudioVolumeGroup> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioVolumeGroup.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeGroupVolumeIndex(int groupId, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeInt(index);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVolumeGroupVolumeIndex(int groupId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVolumeGroupMaxVolumeIndex(int groupId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVolumeGroupMinVolumeIndex(int groupId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastAudibleVolumeForVolumeGroup(int groupId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVolumeGroupMuted(int groupId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustVolumeGroupVolume(int groupId, int direction, int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastAudibleStreamVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSupportedSystemUsages(int[] systemUsages) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(systemUsages);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSupportedSystemUsages() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioProductStrategy> getAudioProductStrategies() throws RemoteException {
                ArrayList<AudioProductStrategy> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioProductStrategy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMicrophoneMuted() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUltrasoundSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHotwordStreamSupported(boolean lookbackAudio) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(lookbackAudio);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMicrophoneMute(boolean on, String callingPackage, int userId, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInputGainIndex(AudioDeviceAttributes ada, int index) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ada, 0);
                    _data.writeInt(index);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInputGainIndex(AudioDeviceAttributes ada) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ada, 0);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxInputGainIndex() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMinInputGainIndex() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInputGainFixed(AudioDeviceAttributes ada) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ada, 0);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMicrophoneMuteFromSwitch(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean bl = this.mRemote.transact(50, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRingerModeExternal(int ringerMode, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ringerMode);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRingerModeInternal(int ringerMode, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ringerMode);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRingerModeExternal() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRingerModeInternal() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isValidRingerMode(int ringerMode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ringerMode);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVibrateSetting(int vibrateType, int vibrateSetting) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(vibrateType);
                    _data.writeInt(vibrateSetting);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVibrateSetting(int vibrateType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(vibrateType);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldVibrate(int vibrateType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(vibrateType);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMode(int mode, IBinder cb, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeStrongBinder(cb);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playSoundEffect(int effectType, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(effectType);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(61, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playSoundEffectVolume(int effectType, float volume) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(effectType);
                    _data.writeFloat(volume);
                    boolean bl = this.mRemote.transact(62, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean loadSoundEffects() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void unloadSoundEffects() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(64, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void reloadAudioSettings() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(65, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getSurroundFormats() throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List getReportedSurroundFormats() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readArrayList(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSurroundFormatEnabled(int audioFormat, boolean enabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(audioFormat);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSurroundFormatEnabled(int audioFormat) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(audioFormat);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setEncodedSurroundMode(int mode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getEncodedSurroundMode(int targetSdkVersion) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(targetSdkVersion);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpeakerphoneOn(IBinder cb, boolean on, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeBoolean(on);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpeakerphoneOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBluetoothScoOn(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setA2dpSuspended(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLeAudioSuspended(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBluetoothScoOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBluetoothA2dpOn(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBluetoothA2dpOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestAudioFocus(AudioAttributes aa, int focusReqType, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, String attributionTag, int flags, IAudioPolicyCallback pcb, int sdk) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(focusReqType);
                    _data.writeStrongBinder(cb);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeString(callingPackageName);
                    _data.writeString(attributionTag);
                    _data.writeInt(flags);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(sdk);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int abandonAudioFocus(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeTypedObject(aa, 0);
                    _data.writeString(callingPackageName);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioFocusClient(String clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(clientId);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCurrentAudioFocus() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startBluetoothSco(IBinder cb, int targetSdkVersion, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeInt(targetSdkVersion);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startBluetoothScoVirtualCall(IBinder cb, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopBluetoothSco(IBinder cb, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceVolumeControlStream(int streamType, IBinder cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRingtonePlayer(IRingtonePlayer player) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(player);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRingtonePlayer getRingtonePlayer() throws RemoteException {
                IRingtonePlayer _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                    _result = IRingtonePlayer.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getUiSoundsStreamType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List getIndependentStreamTypes() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readArrayList(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamTypeAlias(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVolumeControlUsingVolumeGroups() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerStreamAliasingDispatcher(IStreamAliasingDispatcher isad, boolean register) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(isad);
                    _data.writeBoolean(register);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotifAliasRingForTest(boolean alias) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(alias);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWiredDeviceConnectionState(AudioDeviceAttributes aa, int state, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(state);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) throws RemoteException {
                AudioRoutesInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AudioRoutesInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCameraSoundForced() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeController(IVolumeController controller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVolumeController getVolumeController() throws RemoteException {
                IVolumeController _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    _reply.readException();
                    _result = IVolumeController.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyVolumeControllerVisible(IVolumeController controller, boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    _data.writeBoolean(visible);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeControllerLongPressTimeoutEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean bl = this.mRemote.transact(102, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreamAffectedByRingerMode(int streamType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreamAffectedByMute(int streamType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreamMutableByUi(int streamType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableSafeMediaVolume(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lowerVolumeToRs1(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean bl = this.mRemote.transact(107, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getOutputRs2UpperBound() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOutputRs2UpperBound(float rs2Value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(rs2Value);
                    boolean bl = this.mRemote.transact(109, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getCsd() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCsd(float csd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(csd);
                    boolean bl = this.mRemote.transact(111, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceUseFrameworkMel(boolean useFrameworkMel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(useFrameworkMel);
                    boolean bl = this.mRemote.transact(112, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceComputeCsdOnAllDevices(boolean computeCsdOnAllDevices) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(computeCsdOnAllDevices);
                    boolean bl = this.mRemote.transact(113, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCsdEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(114, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCsdAsAFeatureAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCsdAsAFeatureEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCsdAsAFeatureEnabled(boolean csdToggleValue) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(csdToggleValue);
                    boolean bl = this.mRemote.transact(117, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setBluetoothAudioDeviceCategory(String address, int deviceCategory) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(deviceCategory);
                    boolean _status = this.mRemote.transact(118, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBluetoothAudioDeviceCategory(String address) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBluetoothAudioDeviceCategoryFixed(String address) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setHdmiSystemAudioSupported(boolean on) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHdmiSystemAudioSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String registerAudioPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb, boolean hasFocusListener, boolean isFocusPolicy, boolean isTestFocusPolicy, boolean isVolumeController, IMediaProjection projection, AttributionSource attributionSource) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policyConfig, 0);
                    _data.writeStrongInterface(pcb);
                    _data.writeBoolean(hasFocusListener);
                    _data.writeBoolean(isFocusPolicy);
                    _data.writeBoolean(isTestFocusPolicy);
                    _data.writeBoolean(isVolumeController);
                    _data.writeStrongInterface(projection);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(123, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioPolicyAsync(IAudioPolicyCallback pcb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    boolean bl = this.mRemote.transact(124, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioMix> getRegisteredPolicyMixes() throws RemoteException {
                ArrayList<AudioMix> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(125, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioMix.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioPolicy(IAudioPolicyCallback pcb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(126, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policyConfig, 0);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(127, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policyConfig, 0);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(128, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateMixingRulesForPolicy(AudioMix[] mixesToUpdate, AudioMixingRule[] updatedMixingRules, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(mixesToUpdate, 0);
                    _data.writeTypedArray(updatedMixingRules, 0);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(129, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setFocusPropertiesForPolicy(int duckingBehavior, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(duckingBehavior);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(130, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumePolicy(VolumePolicy policy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policy, 0);
                    boolean _status = this.mRemote.transact(131, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VolumePolicy getVolumePolicy() throws RemoteException {
                VolumePolicy _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(132, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VolumePolicy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasRegisteredDynamicPolicy() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(133, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(rcdb);
                    boolean _status = this.mRemote.transact(134, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(rcdb);
                    boolean bl = this.mRemote.transact(135, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() throws RemoteException {
                ArrayList<AudioRecordingConfiguration> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(136, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioRecordingConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcdb);
                    boolean _status = this.mRemote.transact(137, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcdb);
                    boolean bl = this.mRemote.transact(138, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() throws RemoteException {
                ArrayList<AudioPlaybackConfiguration> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(139, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioPlaybackConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFocusRampTimeMs(int focusGain, AudioAttributes attr2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(focusGain);
                    _data.writeTypedObject(attr2, 0);
                    boolean _status = this.mRemote.transact(140, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int dispatchFocusChange(AudioFocusInfo afi, int focusChange, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(afi, 0);
                    _data.writeInt(focusChange);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(141, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int dispatchFocusChangeWithFade(AudioFocusInfo afi, int focusChange, IAudioPolicyCallback pcb, List<AudioFocusInfo> otherActiveAfis, FadeManagerConfiguration transientFadeMgrConfig) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(afi, 0);
                    _data.writeInt(focusChange);
                    _data.writeStrongInterface(pcb);
                    _data.writeTypedList(otherActiveAfis, 0);
                    _data.writeTypedObject(transientFadeMgrConfig, 0);
                    boolean _status = this.mRemote.transact(142, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerHasOpPlayAudio(int piid, boolean hasOpPlayAudio) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeBoolean(hasOpPlayAudio);
                    boolean bl = this.mRemote.transact(143, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleBluetoothActiveDeviceChanged(BluetoothDevice newDevice, BluetoothDevice previousDevice, BluetoothProfileConnectionInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(newDevice, 0);
                    _data.writeTypedObject(previousDevice, 0);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(144, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFocusRequestResultFromExtPolicy(AudioFocusInfo afi, int requestResult, IAudioPolicyCallback pcb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(afi, 0);
                    _data.writeInt(requestResult);
                    _data.writeStrongInterface(pcb);
                    boolean bl = this.mRemote.transact(145, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(asd);
                    boolean _status = this.mRemote.transact(146, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(asd);
                    boolean bl = this.mRemote.transact(147, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAudioServerRunning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(148, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAudioVolumeCallback(IAudioVolumeChangeDispatcher avc) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(avc);
                    boolean _status = this.mRemote.transact(149, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioVolumeCallback(IAudioVolumeChangeDispatcher avc) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(avc);
                    boolean bl = this.mRemote.transact(150, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setUidDeviceAffinity(IAudioPolicyCallback pcb, int uid, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(uid);
                    _data.writeIntArray(deviceTypes);
                    _data.writeStringArray(deviceAddresses);
                    boolean _status = this.mRemote.transact(151, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeUidDeviceAffinity(IAudioPolicyCallback pcb, int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(152, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(userId);
                    _data.writeIntArray(deviceTypes);
                    _data.writeStringArray(deviceAddresses);
                    boolean _status = this.mRemote.transact(153, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(154, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasHapticChannels(Uri uri) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uri, 0);
                    boolean _status = this.mRemote.transact(155, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCallScreeningModeSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(156, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setPreferredDevicesForStrategy(int strategy, List<AudioDeviceAttributes> devices) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    _data.writeTypedList(devices, 0);
                    boolean _status = this.mRemote.transact(157, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removePreferredDevicesForStrategy(int strategy) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    boolean _status = this.mRemote.transact(158, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getPreferredDevicesForStrategy(int strategy) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    boolean _status = this.mRemote.transact(159, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDeviceAsNonDefaultForStrategy(int strategy, AudioDeviceAttributes device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(160, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeDeviceAsNonDefaultForStrategy(int strategy, AudioDeviceAttributes device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(161, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getNonDefaultDevicesForStrategy(int strategy) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    boolean _status = this.mRemote.transact(162, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getDevicesForAttributes(AudioAttributes attributes) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributes, 0);
                    boolean _status = this.mRemote.transact(163, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getDevicesForAttributesUnprotected(AudioAttributes attributes) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributes, 0);
                    boolean _status = this.mRemote.transact(164, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnDevicesForAttributesChangedListener(AudioAttributes attributes, IDevicesForAttributesCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributes, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(165, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnDevicesForAttributesChangedListener(IDevicesForAttributesCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(166, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setAllowedCapturePolicy(int capturePolicy) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePolicy);
                    boolean _status = this.mRemote.transact(167, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAllowedCapturePolicy() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(168, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(169, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(170, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(171, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(172, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRttEnabled(boolean rttEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(rttEnabled);
                    boolean bl = this.mRemote.transact(173, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceVolumeBehavior(AudioDeviceAttributes device, int deviceVolumeBehavior, String pkgName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(deviceVolumeBehavior);
                    _data.writeString(pkgName);
                    boolean _status = this.mRemote.transact(174, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeviceVolumeBehavior(AudioDeviceAttributes device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(175, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMultiAudioFocusEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(176, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setPreferredDevicesForCapturePreset(int capturePreset, List<AudioDeviceAttributes> devices) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePreset);
                    _data.writeTypedList(devices, 0);
                    boolean _status = this.mRemote.transact(177, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int clearPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePreset);
                    boolean _status = this.mRemote.transact(178, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePreset);
                    boolean _status = this.mRemote.transact(179, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(180, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(181, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(targetSdkVersion);
                    boolean bl = this.mRemote.transact(182, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustSuggestedStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(targetSdkVersion);
                    boolean bl = this.mRemote.transact(183, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(targetSdkVersion);
                    boolean bl = this.mRemote.transact(184, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustVolume(int direction, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    boolean bl = this.mRemote.transact(185, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(direction);
                    _data.writeInt(suggestedStreamType);
                    _data.writeInt(flags);
                    boolean bl = this.mRemote.transact(186, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMusicActive(boolean remotely) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(remotely);
                    boolean _status = this.mRemote.transact(187, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeviceMaskForStream(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(188, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAvailableCommunicationDeviceIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(189, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setCommunicationDevice(IBinder cb, int portId, AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeInt(portId);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(190, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCommunicationDevice() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(191, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(192, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(193, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areNavigationRepeatSoundEffectsEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(194, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavigationRepeatSoundEffectsEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(195, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHomeSoundEffectEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(196, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHomeSoundEffectEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(197, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAdditionalOutputDeviceDelay(AudioDeviceAttributes device, long delayMillis) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeLong(delayMillis);
                    boolean _status = this.mRemote.transact(198, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(199, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getMaxAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(200, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestAudioFocusForTest(AudioAttributes aa, int focusReqType, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, int flags, int uid, int sdk) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(focusReqType);
                    _data.writeStrongBinder(cb);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeString(callingPackageName);
                    _data.writeInt(flags);
                    _data.writeInt(uid);
                    _data.writeInt(sdk);
                    boolean _status = this.mRemote.transact(201, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int abandonAudioFocusForTest(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeTypedObject(aa, 0);
                    _data.writeString(callingPackageName);
                    boolean _status = this.mRemote.transact(202, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getFadeOutDurationOnFocusLossMillis(AudioAttributes aa) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    boolean _status = this.mRemote.transact(203, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List getFocusDuckedUidsForTest() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(204, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readArrayList(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getFocusFadeOutDurationForTest() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(205, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getFocusUnmuteDelayAfterFadeOutForTest() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(206, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enterAudioFocusFreezeForTest(IBinder cb, int[] uids) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeIntArray(uids);
                    boolean _status = this.mRemote.transact(207, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean exitAudioFocusFreezeForTest(IBinder cb) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(208, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(209, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(210, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSpatializerImmersiveAudioLevel() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(211, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpatializerEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(212, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpatializerAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(213, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpatializerAvailableForDevice(AudioDeviceAttributes device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(214, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasHeadTracker(AudioDeviceAttributes device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(215, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHeadTrackerEnabled(boolean enabled, AudioDeviceAttributes device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(216, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHeadTrackerEnabled(AudioDeviceAttributes device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(217, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHeadTrackerAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(218, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerHeadTrackerAvailableCallback(ISpatializerHeadTrackerAvailableCallback cb, boolean register) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    _data.writeBoolean(register);
                    boolean _status = this.mRemote.transact(219, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpatializerEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(220, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canBeSpatialized(AudioAttributes aa, AudioFormat af) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeTypedObject(af, 0);
                    boolean _status = this.mRemote.transact(221, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List getSpatializedChannelMasks() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(222, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readArrayList(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(223, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(224, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(225, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(226, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(227, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(228, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getSpatializerCompatibleAudioDevices() throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(229, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ada, 0);
                    boolean _status = this.mRemote.transact(230, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ada, 0);
                    boolean _status = this.mRemote.transact(231, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDesiredHeadTrackingMode(int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(232, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDesiredHeadTrackingMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(233, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSupportedHeadTrackingModes() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(234, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActualHeadTrackingMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(235, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpatializerGlobalTransform(float[] transform) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloatArray(transform);
                    boolean bl = this.mRemote.transact(236, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void recenterHeadTracker() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(237, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpatializerParameter(int key, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    boolean _status = this.mRemote.transact(238, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getSpatializerParameter(int key, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    boolean _status = this.mRemote.transact(239, _data, _reply, 0);
                    _reply.readException();
                    _reply.readByteArray(value);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSpatializerOutput() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(240, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(241, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(242, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVolumeFixed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(243, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VolumeInfo getDefaultVolumeInfo() throws RemoteException {
                VolumeInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(244, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VolumeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPstnCallAudioInterceptable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(245, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void muteAwaitConnection(int[] usagesToMute, AudioDeviceAttributes dev, long timeOutMs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(usagesToMute);
                    _data.writeTypedObject(dev, 0);
                    _data.writeLong(timeOutMs);
                    boolean bl = this.mRemote.transact(246, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelMuteAwaitConnection(AudioDeviceAttributes dev) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(dev, 0);
                    boolean bl = this.mRemote.transact(247, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AudioDeviceAttributes getMutingExpectedDevice() throws RemoteException {
                AudioDeviceAttributes _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(248, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerMuteAwaitConnectionDispatcher(IMuteAwaitConnectionCallback cb, boolean register) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    _data.writeBoolean(register);
                    boolean _status = this.mRemote.transact(249, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestDeviceConnectionState(AudioDeviceAttributes device, boolean connected) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(connected);
                    boolean _status = this.mRemote.transact(250, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDeviceVolumeBehaviorDispatcher(boolean register, IDeviceVolumeBehaviorDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(register);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(251, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioFocusInfo> getFocusStack() throws RemoteException {
                ArrayList<AudioFocusInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(252, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioFocusInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendFocusLossAndUpdate(AudioFocusInfo focusLoser, IAudioPolicyCallback apcb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(focusLoser, 0);
                    _data.writeStrongInterface(apcb);
                    boolean bl = this.mRemote.transact(253, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendFocusLoss(AudioFocusInfo focusLoser, IAudioPolicyCallback apcb) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(focusLoser, 0);
                    _data.writeStrongInterface(apcb);
                    boolean _status = this.mRemote.transact(254, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAssistantServicesUids(int[] assistantUID) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(assistantUID);
                    boolean _status = this.mRemote.transact(255, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAssistantServicesUids(int[] assistantUID) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(assistantUID);
                    boolean _status = this.mRemote.transact(256, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActiveAssistantServiceUids(int[] activeUids) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(activeUids);
                    boolean _status = this.mRemote.transact(257, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAssistantServicesUids() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(258, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getActiveAssistantServiceUids() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(259, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDeviceVolumeDispatcherForAbsoluteVolume(boolean register, IAudioDeviceVolumeDispatcher cb, String packageName, AudioDeviceAttributes device, List<VolumeInfo> volumes, boolean handlesvolumeAdjustment, int volumeBehavior) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(register);
                    _data.writeStrongInterface(cb);
                    _data.writeString(packageName);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedList(volumes, 0);
                    _data.writeBoolean(handlesvolumeAdjustment);
                    _data.writeInt(volumeBehavior);
                    boolean _status = this.mRemote.transact(260, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AudioHalVersionInfo getHalVersion() throws RemoteException {
                AudioHalVersionInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(261, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AudioHalVersionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setPreferredMixerAttributes(AudioAttributes aa, int portId, AudioMixerAttributes mixerAttributes) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(portId);
                    _data.writeTypedObject(mixerAttributes, 0);
                    boolean _status = this.mRemote.transact(262, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int clearPreferredMixerAttributes(AudioAttributes aa, int portId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(portId);
                    boolean _status = this.mRemote.transact(263, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(264, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(265, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean supportsBluetoothVariableLatency() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(266, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBluetoothVariableLatencyEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(267, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBluetoothVariableLatencyEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(268, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerLoudnessCodecUpdatesDispatcher(ILoudnessCodecUpdatesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(269, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterLoudnessCodecUpdatesDispatcher(ILoudnessCodecUpdatesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(270, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startLoudnessCodecUpdates(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(271, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopLoudnessCodecUpdates(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(272, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addLoudnessCodecInfo(int sessionId, int mediaCodecHash, LoudnessCodecInfo codecInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(mediaCodecHash);
                    _data.writeTypedObject(codecInfo, 0);
                    boolean _status = this.mRemote.transact(273, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeLoudnessCodecInfo(int sessionId, LoudnessCodecInfo codecInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(codecInfo, 0);
                    boolean _status = this.mRemote.transact(274, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getLoudnessParams(LoudnessCodecInfo codecInfo) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(codecInfo, 0);
                    boolean _status = this.mRemote.transact(275, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setFadeManagerConfigurationForFocusLoss(FadeManagerConfiguration fmcForFocusLoss) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(fmcForFocusLoss, 0);
                    boolean _status = this.mRemote.transact(276, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int clearFadeManagerConfigurationForFocusLoss() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(277, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FadeManagerConfiguration getFadeManagerConfigurationForFocusLoss() throws RemoteException {
                FadeManagerConfiguration _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(278, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(FadeManagerConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldNotificationSoundPlay(AudioAttributes aa) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    boolean _status = this.mRemote.transact(279, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEnableHardening(boolean shouldEnable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(shouldEnable);
                    boolean _status = this.mRemote.transact(280, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAudioService {
        @Override
        public IAudioManagerNative getNativeInterface() throws RemoteException {
            return null;
        }

        @Override
        public int trackPlayer(PlayerBase.PlayerIdCard pic) throws RemoteException {
            return 0;
        }

        @Override
        public void playerAttributes(int piid, AudioAttributes attr2) throws RemoteException {
        }

        @Override
        public void playerEvent(int piid, int event, int[] eventId) throws RemoteException {
        }

        @Override
        public void releasePlayer(int piid) throws RemoteException {
        }

        @Override
        public int trackRecorder(IBinder recorder) throws RemoteException {
            return 0;
        }

        @Override
        public void recorderEvent(int riid, int event) throws RemoteException {
        }

        @Override
        public void releaseRecorder(int riid) throws RemoteException {
        }

        @Override
        public void playerSessionId(int piid, int sessionId) throws RemoteException {
        }

        @Override
        public void portEvent(int portId, int event, PersistableBundle extras) throws RemoteException {
        }

        @Override
        public void permissionUpdateBarrier() throws RemoteException {
        }

        @Override
        public void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) throws RemoteException {
        }

        @Override
        public void adjustStreamVolumeWithAttribution(int streamType, int direction, int flags, String callingPackage, String attributionTag) throws RemoteException {
        }

        @Override
        public void setStreamVolume(int streamType, int index, int flags, String callingPackage) throws RemoteException {
        }

        @Override
        public void setStreamVolumeWithAttribution(int streamType, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
        }

        @Override
        public void setDeviceVolume(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
        }

        @Override
        public void setVolumeForDevice(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
        }

        @Override
        public void adjustVolumeForDevice(VolumeInfo vi, int direction, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
        }

        @Override
        public void notifyAbsoluteVolumeChanged(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
        }

        @Override
        public VolumeInfo getDeviceVolume(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void handleVolumeKey(KeyEvent event, boolean isOnTv, String callingPackage, String caller) throws RemoteException {
        }

        @Override
        public boolean isStreamMute(int streamType) throws RemoteException {
            return false;
        }

        @Override
        public void forceRemoteSubmixFullVolume(boolean startForcing, IBinder cb) throws RemoteException {
        }

        @Override
        public boolean isMasterMute() throws RemoteException {
            return false;
        }

        @Override
        public void setMasterMute(boolean mute, int flags, String callingPackage, int userId, String attributionTag) throws RemoteException {
        }

        @Override
        public int getStreamVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public int getStreamMinVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public int getStreamMaxVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioVolumeGroup> getAudioVolumeGroups() throws RemoteException {
            return null;
        }

        @Override
        public void setVolumeGroupVolumeIndex(int groupId, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
        }

        @Override
        public int getVolumeGroupVolumeIndex(int groupId) throws RemoteException {
            return 0;
        }

        @Override
        public int getVolumeGroupMaxVolumeIndex(int groupId) throws RemoteException {
            return 0;
        }

        @Override
        public int getVolumeGroupMinVolumeIndex(int groupId) throws RemoteException {
            return 0;
        }

        @Override
        public int getLastAudibleVolumeForVolumeGroup(int groupId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isVolumeGroupMuted(int groupId) throws RemoteException {
            return false;
        }

        @Override
        public void adjustVolumeGroupVolume(int groupId, int direction, int flags, String callingPackage) throws RemoteException {
        }

        @Override
        public int getLastAudibleStreamVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public void setSupportedSystemUsages(int[] systemUsages) throws RemoteException {
        }

        @Override
        public int[] getSupportedSystemUsages() throws RemoteException {
            return null;
        }

        @Override
        public List<AudioProductStrategy> getAudioProductStrategies() throws RemoteException {
            return null;
        }

        @Override
        public boolean isMicrophoneMuted() throws RemoteException {
            return false;
        }

        @Override
        public boolean isUltrasoundSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isHotwordStreamSupported(boolean lookbackAudio) throws RemoteException {
            return false;
        }

        @Override
        public void setMicrophoneMute(boolean on, String callingPackage, int userId, String attributionTag) throws RemoteException {
        }

        @Override
        public void setInputGainIndex(AudioDeviceAttributes ada, int index) throws RemoteException {
        }

        @Override
        public int getInputGainIndex(AudioDeviceAttributes ada) throws RemoteException {
            return 0;
        }

        @Override
        public int getMaxInputGainIndex() throws RemoteException {
            return 0;
        }

        @Override
        public int getMinInputGainIndex() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isInputGainFixed(AudioDeviceAttributes ada) throws RemoteException {
            return false;
        }

        @Override
        public void setMicrophoneMuteFromSwitch(boolean on) throws RemoteException {
        }

        @Override
        public void setRingerModeExternal(int ringerMode, String caller) throws RemoteException {
        }

        @Override
        public void setRingerModeInternal(int ringerMode, String caller) throws RemoteException {
        }

        @Override
        public int getRingerModeExternal() throws RemoteException {
            return 0;
        }

        @Override
        public int getRingerModeInternal() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isValidRingerMode(int ringerMode) throws RemoteException {
            return false;
        }

        @Override
        public void setVibrateSetting(int vibrateType, int vibrateSetting) throws RemoteException {
        }

        @Override
        public int getVibrateSetting(int vibrateType) throws RemoteException {
            return 0;
        }

        @Override
        public boolean shouldVibrate(int vibrateType) throws RemoteException {
            return false;
        }

        @Override
        public void setMode(int mode, IBinder cb, String callingPackage) throws RemoteException {
        }

        @Override
        public int getMode() throws RemoteException {
            return 0;
        }

        @Override
        public void playSoundEffect(int effectType, int userId) throws RemoteException {
        }

        @Override
        public void playSoundEffectVolume(int effectType, float volume) throws RemoteException {
        }

        @Override
        public boolean loadSoundEffects() throws RemoteException {
            return false;
        }

        @Override
        public void unloadSoundEffects() throws RemoteException {
        }

        @Override
        public void reloadAudioSettings() throws RemoteException {
        }

        @Override
        public Map getSurroundFormats() throws RemoteException {
            return null;
        }

        @Override
        public List getReportedSurroundFormats() throws RemoteException {
            return null;
        }

        @Override
        public boolean setSurroundFormatEnabled(int audioFormat, boolean enabled) throws RemoteException {
            return false;
        }

        @Override
        public boolean isSurroundFormatEnabled(int audioFormat) throws RemoteException {
            return false;
        }

        @Override
        public boolean setEncodedSurroundMode(int mode) throws RemoteException {
            return false;
        }

        @Override
        public int getEncodedSurroundMode(int targetSdkVersion) throws RemoteException {
            return 0;
        }

        @Override
        public void setSpeakerphoneOn(IBinder cb, boolean on, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public boolean isSpeakerphoneOn() throws RemoteException {
            return false;
        }

        @Override
        public void setBluetoothScoOn(boolean on) throws RemoteException {
        }

        @Override
        public void setA2dpSuspended(boolean on) throws RemoteException {
        }

        @Override
        public void setLeAudioSuspended(boolean enable) throws RemoteException {
        }

        @Override
        public boolean isBluetoothScoOn() throws RemoteException {
            return false;
        }

        @Override
        public void setBluetoothA2dpOn(boolean on) throws RemoteException {
        }

        @Override
        public boolean isBluetoothA2dpOn() throws RemoteException {
            return false;
        }

        @Override
        public int requestAudioFocus(AudioAttributes aa, int focusReqType, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, String attributionTag, int flags, IAudioPolicyCallback pcb, int sdk) throws RemoteException {
            return 0;
        }

        @Override
        public int abandonAudioFocus(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
            return 0;
        }

        @Override
        public void unregisterAudioFocusClient(String clientId) throws RemoteException {
        }

        @Override
        public int getCurrentAudioFocus() throws RemoteException {
            return 0;
        }

        @Override
        public void startBluetoothSco(IBinder cb, int targetSdkVersion, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void startBluetoothScoVirtualCall(IBinder cb, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void stopBluetoothSco(IBinder cb, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void forceVolumeControlStream(int streamType, IBinder cb) throws RemoteException {
        }

        @Override
        public void setRingtonePlayer(IRingtonePlayer player) throws RemoteException {
        }

        @Override
        public IRingtonePlayer getRingtonePlayer() throws RemoteException {
            return null;
        }

        @Override
        public int getUiSoundsStreamType() throws RemoteException {
            return 0;
        }

        @Override
        public List getIndependentStreamTypes() throws RemoteException {
            return null;
        }

        @Override
        public int getStreamTypeAlias(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isVolumeControlUsingVolumeGroups() throws RemoteException {
            return false;
        }

        @Override
        public void registerStreamAliasingDispatcher(IStreamAliasingDispatcher isad, boolean register) throws RemoteException {
        }

        @Override
        public void setNotifAliasRingForTest(boolean alias) throws RemoteException {
        }

        @Override
        public void setWiredDeviceConnectionState(AudioDeviceAttributes aa, int state, String caller) throws RemoteException {
        }

        @Override
        public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) throws RemoteException {
            return null;
        }

        @Override
        public boolean isCameraSoundForced() throws RemoteException {
            return false;
        }

        @Override
        public void setVolumeController(IVolumeController controller) throws RemoteException {
        }

        @Override
        public IVolumeController getVolumeController() throws RemoteException {
            return null;
        }

        @Override
        public void notifyVolumeControllerVisible(IVolumeController controller, boolean visible) throws RemoteException {
        }

        @Override
        public void setVolumeControllerLongPressTimeoutEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public boolean isStreamAffectedByRingerMode(int streamType) throws RemoteException {
            return false;
        }

        @Override
        public boolean isStreamAffectedByMute(int streamType) throws RemoteException {
            return false;
        }

        @Override
        public boolean isStreamMutableByUi(int streamType) throws RemoteException {
            return false;
        }

        @Override
        public void disableSafeMediaVolume(String callingPackage) throws RemoteException {
        }

        @Override
        public void lowerVolumeToRs1(String callingPackage) throws RemoteException {
        }

        @Override
        public float getOutputRs2UpperBound() throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setOutputRs2UpperBound(float rs2Value) throws RemoteException {
        }

        @Override
        public float getCsd() throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setCsd(float csd) throws RemoteException {
        }

        @Override
        public void forceUseFrameworkMel(boolean useFrameworkMel) throws RemoteException {
        }

        @Override
        public void forceComputeCsdOnAllDevices(boolean computeCsdOnAllDevices) throws RemoteException {
        }

        @Override
        public boolean isCsdEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isCsdAsAFeatureAvailable() throws RemoteException {
            return false;
        }

        @Override
        public boolean isCsdAsAFeatureEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setCsdAsAFeatureEnabled(boolean csdToggleValue) throws RemoteException {
        }

        @Override
        public boolean setBluetoothAudioDeviceCategory(String address, int deviceCategory) throws RemoteException {
            return false;
        }

        @Override
        public int getBluetoothAudioDeviceCategory(String address) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isBluetoothAudioDeviceCategoryFixed(String address) throws RemoteException {
            return false;
        }

        @Override
        public int setHdmiSystemAudioSupported(boolean on) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isHdmiSystemAudioSupported() throws RemoteException {
            return false;
        }

        @Override
        public String registerAudioPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb, boolean hasFocusListener, boolean isFocusPolicy, boolean isTestFocusPolicy, boolean isVolumeController, IMediaProjection projection, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterAudioPolicyAsync(IAudioPolicyCallback pcb) throws RemoteException {
        }

        @Override
        public List<AudioMix> getRegisteredPolicyMixes() throws RemoteException {
            return null;
        }

        @Override
        public void unregisterAudioPolicy(IAudioPolicyCallback pcb) throws RemoteException {
        }

        @Override
        public int addMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public int removeMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public int updateMixingRulesForPolicy(AudioMix[] mixesToUpdate, AudioMixingRule[] updatedMixingRules, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public int setFocusPropertiesForPolicy(int duckingBehavior, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public void setVolumePolicy(VolumePolicy policy) throws RemoteException {
        }

        @Override
        public VolumePolicy getVolumePolicy() throws RemoteException {
            return null;
        }

        @Override
        public boolean hasRegisteredDynamicPolicy() throws RemoteException {
            return false;
        }

        @Override
        public void registerRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
        }

        @Override
        public void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
        }

        @Override
        public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() throws RemoteException {
            return null;
        }

        @Override
        public void registerPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
        }

        @Override
        public void unregisterPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
        }

        @Override
        public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() throws RemoteException {
            return null;
        }

        @Override
        public int getFocusRampTimeMs(int focusGain, AudioAttributes attr2) throws RemoteException {
            return 0;
        }

        @Override
        public int dispatchFocusChange(AudioFocusInfo afi, int focusChange, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public int dispatchFocusChangeWithFade(AudioFocusInfo afi, int focusChange, IAudioPolicyCallback pcb, List<AudioFocusInfo> otherActiveAfis, FadeManagerConfiguration transientFadeMgrConfig) throws RemoteException {
            return 0;
        }

        @Override
        public void playerHasOpPlayAudio(int piid, boolean hasOpPlayAudio) throws RemoteException {
        }

        @Override
        public void handleBluetoothActiveDeviceChanged(BluetoothDevice newDevice, BluetoothDevice previousDevice, BluetoothProfileConnectionInfo info) throws RemoteException {
        }

        @Override
        public void setFocusRequestResultFromExtPolicy(AudioFocusInfo afi, int requestResult, IAudioPolicyCallback pcb) throws RemoteException {
        }

        @Override
        public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
        }

        @Override
        public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
        }

        @Override
        public boolean isAudioServerRunning() throws RemoteException {
            return false;
        }

        @Override
        public void registerAudioVolumeCallback(IAudioVolumeChangeDispatcher avc) throws RemoteException {
        }

        @Override
        public void unregisterAudioVolumeCallback(IAudioVolumeChangeDispatcher avc) throws RemoteException {
        }

        @Override
        public int setUidDeviceAffinity(IAudioPolicyCallback pcb, int uid, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
            return 0;
        }

        @Override
        public int removeUidDeviceAffinity(IAudioPolicyCallback pcb, int uid) throws RemoteException {
            return 0;
        }

        @Override
        public int setUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
            return 0;
        }

        @Override
        public int removeUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean hasHapticChannels(Uri uri) throws RemoteException {
            return false;
        }

        @Override
        public boolean isCallScreeningModeSupported() throws RemoteException {
            return false;
        }

        @Override
        public int setPreferredDevicesForStrategy(int strategy, List<AudioDeviceAttributes> devices) throws RemoteException {
            return 0;
        }

        @Override
        public int removePreferredDevicesForStrategy(int strategy) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioDeviceAttributes> getPreferredDevicesForStrategy(int strategy) throws RemoteException {
            return null;
        }

        @Override
        public int setDeviceAsNonDefaultForStrategy(int strategy, AudioDeviceAttributes device) throws RemoteException {
            return 0;
        }

        @Override
        public int removeDeviceAsNonDefaultForStrategy(int strategy, AudioDeviceAttributes device) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioDeviceAttributes> getNonDefaultDevicesForStrategy(int strategy) throws RemoteException {
            return null;
        }

        @Override
        public List<AudioDeviceAttributes> getDevicesForAttributes(AudioAttributes attributes) throws RemoteException {
            return null;
        }

        @Override
        public List<AudioDeviceAttributes> getDevicesForAttributesUnprotected(AudioAttributes attributes) throws RemoteException {
            return null;
        }

        @Override
        public void addOnDevicesForAttributesChangedListener(AudioAttributes attributes, IDevicesForAttributesCallback callback) throws RemoteException {
        }

        @Override
        public void removeOnDevicesForAttributesChangedListener(IDevicesForAttributesCallback callback) throws RemoteException {
        }

        @Override
        public int setAllowedCapturePolicy(int capturePolicy) throws RemoteException {
            return 0;
        }

        @Override
        public int getAllowedCapturePolicy() throws RemoteException {
            return 0;
        }

        @Override
        public void registerStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void registerStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void setRttEnabled(boolean rttEnabled) throws RemoteException {
        }

        @Override
        public void setDeviceVolumeBehavior(AudioDeviceAttributes device, int deviceVolumeBehavior, String pkgName) throws RemoteException {
        }

        @Override
        public int getDeviceVolumeBehavior(AudioDeviceAttributes device) throws RemoteException {
            return 0;
        }

        @Override
        public void setMultiAudioFocusEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public int setPreferredDevicesForCapturePreset(int capturePreset, List<AudioDeviceAttributes> devices) throws RemoteException {
            return 0;
        }

        @Override
        public int clearPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioDeviceAttributes> getPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
            return null;
        }

        @Override
        public void registerCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void adjustStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public void adjustSuggestedStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public void setStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public void adjustVolume(int direction, int flags) throws RemoteException {
        }

        @Override
        public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags) throws RemoteException {
        }

        @Override
        public boolean isMusicActive(boolean remotely) throws RemoteException {
            return false;
        }

        @Override
        public int getDeviceMaskForStream(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public int[] getAvailableCommunicationDeviceIds() throws RemoteException {
            return null;
        }

        @Override
        public boolean setCommunicationDevice(IBinder cb, int portId, AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public int getCommunicationDevice() throws RemoteException {
            return 0;
        }

        @Override
        public void registerCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public boolean areNavigationRepeatSoundEffectsEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setNavigationRepeatSoundEffectsEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isHomeSoundEffectEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setHomeSoundEffectEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean setAdditionalOutputDeviceDelay(AudioDeviceAttributes device, long delayMillis) throws RemoteException {
            return false;
        }

        @Override
        public long getAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
            return 0L;
        }

        @Override
        public long getMaxAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
            return 0L;
        }

        @Override
        public int requestAudioFocusForTest(AudioAttributes aa, int focusReqType, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, int flags, int uid, int sdk) throws RemoteException {
            return 0;
        }

        @Override
        public int abandonAudioFocusForTest(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
            return 0;
        }

        @Override
        public long getFadeOutDurationOnFocusLossMillis(AudioAttributes aa) throws RemoteException {
            return 0L;
        }

        @Override
        public List getFocusDuckedUidsForTest() throws RemoteException {
            return null;
        }

        @Override
        public long getFocusFadeOutDurationForTest() throws RemoteException {
            return 0L;
        }

        @Override
        public long getFocusUnmuteDelayAfterFadeOutForTest() throws RemoteException {
            return 0L;
        }

        @Override
        public boolean enterAudioFocusFreezeForTest(IBinder cb, int[] uids) throws RemoteException {
            return false;
        }

        @Override
        public boolean exitAudioFocusFreezeForTest(IBinder cb) throws RemoteException {
            return false;
        }

        @Override
        public void registerModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public int getSpatializerImmersiveAudioLevel() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isSpatializerEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isSpatializerAvailable() throws RemoteException {
            return false;
        }

        @Override
        public boolean isSpatializerAvailableForDevice(AudioDeviceAttributes device) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasHeadTracker(AudioDeviceAttributes device) throws RemoteException {
            return false;
        }

        @Override
        public void setHeadTrackerEnabled(boolean enabled, AudioDeviceAttributes device) throws RemoteException {
        }

        @Override
        public boolean isHeadTrackerEnabled(AudioDeviceAttributes device) throws RemoteException {
            return false;
        }

        @Override
        public boolean isHeadTrackerAvailable() throws RemoteException {
            return false;
        }

        @Override
        public void registerSpatializerHeadTrackerAvailableCallback(ISpatializerHeadTrackerAvailableCallback cb, boolean register) throws RemoteException {
        }

        @Override
        public void setSpatializerEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean canBeSpatialized(AudioAttributes aa, AudioFormat af) throws RemoteException {
            return false;
        }

        @Override
        public List getSpatializedChannelMasks() throws RemoteException {
            return null;
        }

        @Override
        public void registerSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
        }

        @Override
        public void registerSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
        }

        @Override
        public void registerHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
        }

        @Override
        public List<AudioDeviceAttributes> getSpatializerCompatibleAudioDevices() throws RemoteException {
            return null;
        }

        @Override
        public void addSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
        }

        @Override
        public void removeSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
        }

        @Override
        public void setDesiredHeadTrackingMode(int mode) throws RemoteException {
        }

        @Override
        public int getDesiredHeadTrackingMode() throws RemoteException {
            return 0;
        }

        @Override
        public int[] getSupportedHeadTrackingModes() throws RemoteException {
            return null;
        }

        @Override
        public int getActualHeadTrackingMode() throws RemoteException {
            return 0;
        }

        @Override
        public void setSpatializerGlobalTransform(float[] transform) throws RemoteException {
        }

        @Override
        public void recenterHeadTracker() throws RemoteException {
        }

        @Override
        public void setSpatializerParameter(int key, byte[] value) throws RemoteException {
        }

        @Override
        public void getSpatializerParameter(int key, byte[] value) throws RemoteException {
        }

        @Override
        public int getSpatializerOutput() throws RemoteException {
            return 0;
        }

        @Override
        public void registerSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
        }

        @Override
        public boolean isVolumeFixed() throws RemoteException {
            return false;
        }

        @Override
        public VolumeInfo getDefaultVolumeInfo() throws RemoteException {
            return null;
        }

        @Override
        public boolean isPstnCallAudioInterceptable() throws RemoteException {
            return false;
        }

        @Override
        public void muteAwaitConnection(int[] usagesToMute, AudioDeviceAttributes dev, long timeOutMs) throws RemoteException {
        }

        @Override
        public void cancelMuteAwaitConnection(AudioDeviceAttributes dev) throws RemoteException {
        }

        @Override
        public AudioDeviceAttributes getMutingExpectedDevice() throws RemoteException {
            return null;
        }

        @Override
        public void registerMuteAwaitConnectionDispatcher(IMuteAwaitConnectionCallback cb, boolean register) throws RemoteException {
        }

        @Override
        public void setTestDeviceConnectionState(AudioDeviceAttributes device, boolean connected) throws RemoteException {
        }

        @Override
        public void registerDeviceVolumeBehaviorDispatcher(boolean register, IDeviceVolumeBehaviorDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public List<AudioFocusInfo> getFocusStack() throws RemoteException {
            return null;
        }

        @Override
        public void sendFocusLossAndUpdate(AudioFocusInfo focusLoser, IAudioPolicyCallback apcb) throws RemoteException {
        }

        @Override
        public boolean sendFocusLoss(AudioFocusInfo focusLoser, IAudioPolicyCallback apcb) throws RemoteException {
            return false;
        }

        @Override
        public void addAssistantServicesUids(int[] assistantUID) throws RemoteException {
        }

        @Override
        public void removeAssistantServicesUids(int[] assistantUID) throws RemoteException {
        }

        @Override
        public void setActiveAssistantServiceUids(int[] activeUids) throws RemoteException {
        }

        @Override
        public int[] getAssistantServicesUids() throws RemoteException {
            return null;
        }

        @Override
        public int[] getActiveAssistantServiceUids() throws RemoteException {
            return null;
        }

        @Override
        public void registerDeviceVolumeDispatcherForAbsoluteVolume(boolean register, IAudioDeviceVolumeDispatcher cb, String packageName, AudioDeviceAttributes device, List<VolumeInfo> volumes, boolean handlesvolumeAdjustment, int volumeBehavior) throws RemoteException {
        }

        @Override
        public AudioHalVersionInfo getHalVersion() throws RemoteException {
            return null;
        }

        @Override
        public int setPreferredMixerAttributes(AudioAttributes aa, int portId, AudioMixerAttributes mixerAttributes) throws RemoteException {
            return 0;
        }

        @Override
        public int clearPreferredMixerAttributes(AudioAttributes aa, int portId) throws RemoteException {
            return 0;
        }

        @Override
        public void registerPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public boolean supportsBluetoothVariableLatency() throws RemoteException {
            return false;
        }

        @Override
        public void setBluetoothVariableLatencyEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isBluetoothVariableLatencyEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void registerLoudnessCodecUpdatesDispatcher(ILoudnessCodecUpdatesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterLoudnessCodecUpdatesDispatcher(ILoudnessCodecUpdatesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void startLoudnessCodecUpdates(int sessionId) throws RemoteException {
        }

        @Override
        public void stopLoudnessCodecUpdates(int sessionId) throws RemoteException {
        }

        @Override
        public void addLoudnessCodecInfo(int sessionId, int mediaCodecHash, LoudnessCodecInfo codecInfo) throws RemoteException {
        }

        @Override
        public void removeLoudnessCodecInfo(int sessionId, LoudnessCodecInfo codecInfo) throws RemoteException {
        }

        @Override
        public PersistableBundle getLoudnessParams(LoudnessCodecInfo codecInfo) throws RemoteException {
            return null;
        }

        @Override
        public int setFadeManagerConfigurationForFocusLoss(FadeManagerConfiguration fmcForFocusLoss) throws RemoteException {
            return 0;
        }

        @Override
        public int clearFadeManagerConfigurationForFocusLoss() throws RemoteException {
            return 0;
        }

        @Override
        public FadeManagerConfiguration getFadeManagerConfigurationForFocusLoss() throws RemoteException {
            return null;
        }

        @Override
        public boolean shouldNotificationSoundPlay(AudioAttributes aa) throws RemoteException {
            return false;
        }

        @Override
        public void setEnableHardening(boolean shouldEnable) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

