/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.system.ErrnoException;
import android.system.Os;
import android.util.Log;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ExifInterfaceUtils {
    private static final String TAG = "ExifInterface";

    ExifInterfaceUtils() {
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int c;
        int total = 0;
        byte[] buffer = new byte[8192];
        while ((c = in.read(buffer)) != -1) {
            total += c;
            out.write(buffer, 0, c);
        }
        return total;
    }

    public static void copy(InputStream in, OutputStream out, int numBytes) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        for (int remainder = numBytes; remainder > 0; remainder -= bytesRead) {
            int bytesToRead = Math.min(remainder, 8192);
            bytesRead = in.read(buffer, 0, bytesToRead);
            if (bytesRead != bytesToRead) {
                throw new IOException("Failed to copy the given amount of bytes from the inputstream to the output stream.");
            }
            out.write(buffer, 0, bytesRead);
        }
    }

    public static long[] convertToLongArray(Object inputObj) {
        if (inputObj instanceof int[]) {
            int[] input = (int[])inputObj;
            long[] result = new long[input.length];
            for (int i = 0; i < input.length; ++i) {
                result[i] = input[i];
            }
            return result;
        }
        if (inputObj instanceof long[]) {
            return (long[])inputObj;
        }
        return null;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(String.format("%02x", bytes[i]));
        }
        return sb.toString();
    }

    public static boolean startsWith(byte[] cur, byte[] val) {
        if (cur == null || val == null) {
            return false;
        }
        if (cur.length < val.length) {
            return false;
        }
        if (cur.length == 0 || val.length == 0) {
            return false;
        }
        for (int i = 0; i < val.length; ++i) {
            if (cur[i] == val[i]) continue;
            return false;
        }
        return true;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeFileDescriptor(FileDescriptor fd) {
        try {
            Os.close(fd);
        }
        catch (ErrnoException ex) {
            Log.e(TAG, "Error closing fd.", ex);
        }
    }
}

