/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.SubtitleTrack;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.CaptioningManager;

abstract class ClosedCaptionWidget
extends ViewGroup
implements SubtitleTrack.RenderingWidget {
    private static final CaptioningManager.CaptionStyle DEFAULT_CAPTION_STYLE = CaptioningManager.CaptionStyle.DEFAULT;
    private final CaptioningManager mManager;
    protected CaptioningManager.CaptionStyle mCaptionStyle;
    protected SubtitleTrack.RenderingWidget.OnChangedListener mListener;
    protected ClosedCaptionLayout mClosedCaptionLayout;
    private boolean mHasChangeListener;
    private final CaptioningManager.CaptioningChangeListener mCaptioningListener = new CaptioningManager.CaptioningChangeListener(){

        @Override
        public void onUserStyleChanged(CaptioningManager.CaptionStyle userStyle) {
            ClosedCaptionWidget.this.mCaptionStyle = DEFAULT_CAPTION_STYLE.applyStyle(userStyle);
            ClosedCaptionWidget.this.mClosedCaptionLayout.setCaptionStyle(ClosedCaptionWidget.this.mCaptionStyle);
        }

        @Override
        public void onFontScaleChanged(float fontScale) {
            ClosedCaptionWidget.this.mClosedCaptionLayout.setFontScale(fontScale);
        }
    };

    public ClosedCaptionWidget(Context context) {
        this(context, null);
    }

    public ClosedCaptionWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClosedCaptionWidget(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public ClosedCaptionWidget(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setLayerType(1, null);
        this.mManager = (CaptioningManager)context.getSystemService("captioning");
        this.mCaptionStyle = DEFAULT_CAPTION_STYLE.applyStyle(this.mManager.getUserStyle());
        this.mClosedCaptionLayout = this.createCaptionLayout(context);
        this.mClosedCaptionLayout.setCaptionStyle(this.mCaptionStyle);
        this.mClosedCaptionLayout.setFontScale(this.mManager.getFontScale());
        this.addView((View)((ViewGroup)((Object)this.mClosedCaptionLayout)), -1, -1);
        this.requestLayout();
    }

    public abstract ClosedCaptionLayout createCaptionLayout(Context var1);

    @Override
    public void setOnChangedListener(SubtitleTrack.RenderingWidget.OnChangedListener listener) {
        this.mListener = listener;
    }

    @Override
    public void setSize(int width, int height) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
        this.measure(widthSpec, heightSpec);
        this.layout(0, 0, width, height);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
        this.manageChangeListener();
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.manageChangeListener();
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.manageChangeListener();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ((ViewGroup)((Object)this.mClosedCaptionLayout)).measure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        ((ViewGroup)((Object)this.mClosedCaptionLayout)).layout(l, t, r, b);
    }

    private void manageChangeListener() {
        boolean needsListener;
        boolean bl = needsListener = this.isAttachedToWindow() && this.getVisibility() == 0;
        if (this.mHasChangeListener != needsListener) {
            this.mHasChangeListener = needsListener;
            if (needsListener) {
                this.mManager.addCaptioningChangeListener(this.mCaptioningListener);
            } else {
                this.mManager.removeCaptioningChangeListener(this.mCaptioningListener);
            }
        }
    }

    static interface ClosedCaptionLayout {
        public void setCaptionStyle(CaptioningManager.CaptionStyle var1);

        public void setFontScale(float var1);
    }
}

