/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.location.Country;
import android.location.CountryListener;
import android.location.ICountryDetector;
import android.location.ICountryListener;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
public class CountryDetector {
    private static final String TAG = "CountryDetector";
    private final ICountryDetector mService;
    private final HashMap<Consumer<Country>, ListenerTransport> mListeners;

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public CountryDetector(ICountryDetector service) {
        this.mService = service;
        this.mListeners = new HashMap();
    }

    @UnsupportedAppUsage
    public Country detectCountry() {
        try {
            return this.mService.detectCountry();
        }
        catch (RemoteException e) {
            Log.e(TAG, "detectCountry: RemoteException", e);
            return null;
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public void addCountryListener(@NonNull CountryListener listener, @Nullable Looper looper) {
        Handler handler = looper != null ? new Handler(looper) : new Handler();
        this.registerCountryDetectorCallback(new HandlerExecutor(handler), listener);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void removeCountryListener(CountryListener listener) {
        this.unregisterCountryDetectorCallback(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCountryDetectorCallback(@NonNull Executor executor, @NonNull Consumer<Country> consumer) {
        HashMap<Consumer<Country>, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            this.unregisterCountryDetectorCallback(consumer);
            ListenerTransport transport = new ListenerTransport(consumer, executor);
            try {
                this.mService.addCountryListener(transport);
                this.mListeners.put(consumer, transport);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCountryDetectorCallback(@NonNull Consumer<Country> consumer) {
        HashMap<Consumer<Country>, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            ListenerTransport transport = this.mListeners.remove(consumer);
            if (transport != null) {
                try {
                    this.mService.removeCountryListener(transport);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    private static class ListenerTransport
    extends ICountryListener.Stub {
        private final Consumer<Country> mListener;
        private final Executor mExecutor;

        ListenerTransport(Consumer<Country> consumer, Executor executor) {
            this.mListener = consumer;
            this.mExecutor = executor;
        }

        @Override
        public void onCountryDetected(Country country) {
            this.mExecutor.execute(() -> this.mListener.accept(country));
        }
    }
}

