/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class CorrelationVector
implements Parcelable {
    private final double mSamplingWidthMeters;
    private final double mSamplingStartMeters;
    private final double mFrequencyOffsetMetersPerSecond;
    @NonNull
    private final int[] mMagnitude;
    @NonNull
    public static final Parcelable.Creator<CorrelationVector> CREATOR = new Parcelable.Creator<CorrelationVector>(){

        @Override
        public CorrelationVector createFromParcel(Parcel parcel) {
            return new CorrelationVector(parcel);
        }

        public CorrelationVector[] newArray(int size) {
            return new CorrelationVector[size];
        }
    };

    public double getSamplingWidthMeters() {
        return this.mSamplingWidthMeters;
    }

    public double getSamplingStartMeters() {
        return this.mSamplingStartMeters;
    }

    public double getFrequencyOffsetMetersPerSecond() {
        return this.mFrequencyOffsetMetersPerSecond;
    }

    @NonNull
    public int[] getMagnitude() {
        return (int[])this.mMagnitude.clone();
    }

    private CorrelationVector(Builder builder) {
        Preconditions.checkNotNull(builder.mMagnitude, "Magnitude array must not be null");
        Preconditions.checkArgumentPositive(builder.mMagnitude.length, "Magnitude array must have non-zero length");
        Preconditions.checkArgument(builder.mFrequencyOffsetMetersPerSecond >= 0.0, "FrequencyOffsetMetersPerSecond must be non-negative (greater than or equal to 0)");
        Preconditions.checkArgument(builder.mSamplingWidthMeters > 0.0, "SamplingWidthMeters must be positive (greater than 0)");
        this.mMagnitude = builder.mMagnitude;
        this.mFrequencyOffsetMetersPerSecond = builder.mFrequencyOffsetMetersPerSecond;
        this.mSamplingWidthMeters = builder.mSamplingWidthMeters;
        this.mSamplingStartMeters = builder.mSamplingStartMeters;
    }

    private CorrelationVector(Parcel in) {
        this.mSamplingWidthMeters = in.readDouble();
        this.mSamplingStartMeters = in.readDouble();
        this.mFrequencyOffsetMetersPerSecond = in.readDouble();
        this.mMagnitude = new int[in.readInt()];
        in.readIntArray(this.mMagnitude);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String toString() {
        return "CorrelationVector{FrequencyOffsetMetersPerSecond=" + this.mFrequencyOffsetMetersPerSecond + ", SamplingWidthMeters=" + this.mSamplingWidthMeters + ", SamplingStartMeters=" + this.mSamplingStartMeters + ", Magnitude=" + Arrays.toString(this.mMagnitude) + '}';
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeDouble(this.mSamplingWidthMeters);
        dest.writeDouble(this.mSamplingStartMeters);
        dest.writeDouble(this.mFrequencyOffsetMetersPerSecond);
        dest.writeInt(this.mMagnitude.length);
        dest.writeIntArray(this.mMagnitude);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CorrelationVector)) {
            return false;
        }
        CorrelationVector c = (CorrelationVector)object;
        return Arrays.equals(this.mMagnitude, c.getMagnitude()) && Double.compare(this.mSamplingWidthMeters, c.getSamplingWidthMeters()) == 0 && Double.compare(this.mSamplingStartMeters, c.getSamplingStartMeters()) == 0 && Double.compare(this.mFrequencyOffsetMetersPerSecond, c.getFrequencyOffsetMetersPerSecond()) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.mSamplingWidthMeters, this.mSamplingStartMeters, this.mFrequencyOffsetMetersPerSecond, Arrays.hashCode(this.mMagnitude));
    }

    public static class Builder {
        private double mSamplingWidthMeters;
        private double mSamplingStartMeters;
        private double mFrequencyOffsetMetersPerSecond;
        @NonNull
        private int[] mMagnitude;

        @NonNull
        public Builder setSamplingWidthMeters(double samplingWidthMeters) {
            this.mSamplingWidthMeters = samplingWidthMeters;
            return this;
        }

        @NonNull
        public Builder setSamplingStartMeters(double samplingStartMeters) {
            this.mSamplingStartMeters = samplingStartMeters;
            return this;
        }

        @NonNull
        public Builder setFrequencyOffsetMetersPerSecond(double frequencyOffsetMetersPerSecond) {
            this.mFrequencyOffsetMetersPerSecond = frequencyOffsetMetersPerSecond;
            return this;
        }

        @NonNull
        public Builder setMagnitude(@NonNull int[] magnitude) {
            this.mMagnitude = magnitude;
            return this;
        }

        @NonNull
        public CorrelationVector build() {
            return new CorrelationVector(this);
        }
    }
}

