/*
 * Decompiled with CFR 0.152.
 */
package android.internal.aconfig.storage;

import android.internal.aconfig.storage.AconfigStorageException;
import android.internal.aconfig.storage.FlagTable;
import android.internal.aconfig.storage.FlagValueList;
import android.internal.aconfig.storage.PackageTable;
import android.internal.aconfig.storage.SipHasher13;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;

@RavenwoodKeepWholeClass
public class TableUtils {
    private static final int[] HASH_PRIMES = new int[]{7, 17, 29, 53, 97, 193, 389, 769, 1543, 3079, 6151, 12289, 24593, 49157, 98317, 196613, 393241, 786433, 1572869, 0x30000B, 0x60000D, 0xC00005, 25165843, 0x3000005, 100663319, 201326611, 402653189, 805306457, 0x60000005};

    public static int getTableSize(int numEntries) {
        for (int i : HASH_PRIMES) {
            if (i < 2 * numEntries) continue;
            return i;
        }
        throw new AconfigStorageException("Number of items in a hash table exceeds limit");
    }

    public static int getBucketIndex(byte[] val, int numBuckets) {
        long hashVal = SipHasher13.hash(val);
        return (int)Long.remainderUnsigned(hashVal, numBuckets);
    }

    public static class StorageFilesBundle {
        public final PackageTable packageTable;
        public final FlagTable flagTable;
        public final FlagValueList flagValueList;

        public StorageFilesBundle(PackageTable pTable, FlagTable fTable, FlagValueList fValueList) {
            this.packageTable = pTable;
            this.flagTable = fTable;
            this.flagValueList = fValueList;
        }
    }
}

