/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice.navigationbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RecordingCanvas;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Trace;
import android.view.RenderNodeAnimator;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import com.android.internal.hidden_from_bootclasspath.android.companion.virtualdevice.flags.Flags;
import java.util.ArrayList;
import java.util.HashSet;

class KeyButtonRipple
extends Drawable {
    private static final float GLOW_MAX_SCALE_FACTOR = 1.35f;
    private static final float GLOW_MAX_ALPHA = 0.2f;
    private static final float GLOW_MAX_ALPHA_DARK = 0.1f;
    private static final int ANIMATION_DURATION_SCALE = 350;
    private static final int ANIMATION_DURATION_FADE = 450;
    private static final Interpolator ALPHA_OUT_INTERPOLATOR = new PathInterpolator(0.0f, 0.0f, 0.8f, 1.0f);
    private final int mMaxWidthResource;
    private Paint mRipplePaint;
    private CanvasProperty<Float> mLeftProp;
    private CanvasProperty<Float> mTopProp;
    private CanvasProperty<Float> mRightProp;
    private CanvasProperty<Float> mBottomProp;
    private CanvasProperty<Float> mRxProp;
    private CanvasProperty<Float> mRyProp;
    private CanvasProperty<Paint> mPaintProp;
    private float mGlowAlpha = 0.0f;
    private float mGlowScale = 1.0f;
    private boolean mPressed;
    private boolean mVisible;
    private boolean mDrawingHardwareGlow;
    private int mMaxWidth;
    private boolean mLastDark;
    private boolean mDark;
    private boolean mDelayTouchFeedback;
    private final Interpolator mInterpolator = new LogInterpolator();
    private boolean mSupportHardware;
    private final View mTargetView;
    private final int mTapTimeoutMillis;
    private final Handler mHandler = new Handler();
    private final HashSet<Animator> mRunningAnimations = new HashSet();
    private final ArrayList<Animator> mTmpArray = new ArrayList();
    private final TraceAnimatorListener mExitHwTraceAnimator = new TraceAnimatorListener("exitHardware");
    private final TraceAnimatorListener mEnterHwTraceAnimator = new TraceAnimatorListener("enterHardware");
    private Type mType = Type.ROUNDED_RECT;
    private final AnimatorListenerAdapter mAnimatorListener = new AnimatorListenerAdapter(){

        @Override
        public void onAnimationEnd(Animator animation) {
            KeyButtonRipple.this.mRunningAnimations.remove(animation);
            if (KeyButtonRipple.this.mRunningAnimations.isEmpty() && !KeyButtonRipple.this.mPressed) {
                KeyButtonRipple.this.mVisible = false;
                KeyButtonRipple.this.mDrawingHardwareGlow = false;
                KeyButtonRipple.this.invalidateSelf();
            }
        }
    };

    KeyButtonRipple(Context ctx, View targetView, int maxWidthResource) {
        this.mMaxWidthResource = maxWidthResource;
        this.mMaxWidth = ctx.getResources().getDimensionPixelSize(maxWidthResource);
        this.mTargetView = targetView;
        this.mTapTimeoutMillis = Flags.viewconfigurationApis() ? ViewConfiguration.get(this.mTargetView.getContext()).getTapTimeoutMillis() : ViewConfiguration.getTapTimeout();
    }

    public void updateResources() {
        this.mMaxWidth = this.mTargetView.getContext().getResources().getDimensionPixelSize(this.mMaxWidthResource);
        this.invalidateSelf();
    }

    public void setDarkIntensity(float darkIntensity) {
        this.mDark = darkIntensity >= 0.5f;
    }

    public void setDelayTouchFeedback(boolean delay) {
        this.mDelayTouchFeedback = delay;
    }

    public void setType(Type type) {
        this.mType = type;
    }

    private Paint getRipplePaint() {
        if (this.mRipplePaint == null) {
            this.mRipplePaint = new Paint();
            this.mRipplePaint.setAntiAlias(true);
            this.mRipplePaint.setColor(this.mLastDark ? -16777216 : -1);
        }
        return this.mRipplePaint;
    }

    private void drawSoftware(Canvas canvas) {
        if (this.mGlowAlpha > 0.0f) {
            float corner;
            Paint p = this.getRipplePaint();
            p.setAlpha((int)(this.mGlowAlpha * 255.0f));
            float w = this.getBounds().width();
            float h = this.getBounds().height();
            boolean horizontal = w > h;
            float diameter = (float)this.getRippleSize() * this.mGlowScale;
            float radius = diameter * 0.5f;
            float cx = w * 0.5f;
            float cy = h * 0.5f;
            float rx = horizontal ? radius : cx;
            float ry = horizontal ? cy : radius;
            float f = corner = horizontal ? cy : cx;
            if (this.mType == Type.ROUNDED_RECT) {
                canvas.drawRoundRect(cx - rx, cy - ry, cx + rx, cy + ry, corner, corner, p);
            } else {
                canvas.save();
                canvas.translate(cx, cy);
                float r = Math.min(rx, ry);
                canvas.drawOval(-r, -r, r, r, p);
                canvas.restore();
            }
        }
    }

    @Override
    public void draw(Canvas canvas) {
        this.mSupportHardware = canvas.isHardwareAccelerated();
        if (this.mSupportHardware) {
            this.drawHardware((RecordingCanvas)canvas);
        } else {
            this.drawSoftware(canvas);
        }
    }

    @Override
    public void setAlpha(int alpha) {
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    private boolean isHorizontal() {
        return this.getBounds().width() > this.getBounds().height();
    }

    private void drawHardware(RecordingCanvas c) {
        if (this.mDrawingHardwareGlow) {
            if (this.mType == Type.ROUNDED_RECT) {
                c.drawRoundRect(this.mLeftProp, this.mTopProp, this.mRightProp, this.mBottomProp, this.mRxProp, this.mRyProp, this.mPaintProp);
            } else {
                CanvasProperty<Float> cx = CanvasProperty.createFloat(this.getBounds().width() / 2);
                CanvasProperty<Float> cy = CanvasProperty.createFloat(this.getBounds().height() / 2);
                int d = Math.min(this.getBounds().width(), this.getBounds().height());
                CanvasProperty<Float> r = CanvasProperty.createFloat(1.0f * (float)d / 2.0f);
                c.drawCircle(cx, cy, r, this.mPaintProp);
            }
        }
    }

    public float getGlowAlpha() {
        return this.mGlowAlpha;
    }

    public void setGlowAlpha(float x) {
        this.mGlowAlpha = x;
        this.invalidateSelf();
    }

    public float getGlowScale() {
        return this.mGlowScale;
    }

    public void setGlowScale(float x) {
        this.mGlowScale = x;
        this.invalidateSelf();
    }

    private float getMaxGlowAlpha() {
        return this.mLastDark ? 0.1f : 0.2f;
    }

    @Override
    protected boolean onStateChange(int[] state) {
        boolean pressed = false;
        for (int i = 0; i < state.length; ++i) {
            if (state[i] != 16842919) continue;
            pressed = true;
            break;
        }
        if (pressed != this.mPressed) {
            this.setPressed(pressed);
            this.mPressed = pressed;
            return true;
        }
        return false;
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (changed) {
            this.jumpToCurrentState();
        }
        return changed;
    }

    @Override
    public void jumpToCurrentState() {
        this.endAnimations("jumpToCurrentState", false);
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return true;
    }

    public void setPressed(boolean pressed) {
        if (this.mDark != this.mLastDark && pressed) {
            this.mRipplePaint = null;
            this.mLastDark = this.mDark;
        }
        if (this.mSupportHardware) {
            this.setPressedHardware(pressed);
        } else {
            this.setPressedSoftware(pressed);
        }
    }

    public void abortDelayedRipple() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private void endAnimations(String reason, boolean cancel) {
        Trace.beginSection("KeyButtonRipple.endAnim: reason=" + reason + " cancel=" + cancel);
        Trace.endSection();
        this.mVisible = false;
        this.mTmpArray.addAll(this.mRunningAnimations);
        int size = this.mTmpArray.size();
        for (int i = 0; i < size; ++i) {
            Animator a = this.mTmpArray.get(i);
            if (cancel) {
                a.cancel();
                continue;
            }
            a.end();
        }
        this.mTmpArray.clear();
        this.mRunningAnimations.clear();
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private void setPressedSoftware(boolean pressed) {
        if (pressed) {
            if (this.mDelayTouchFeedback) {
                if (this.mRunningAnimations.isEmpty()) {
                    this.mHandler.removeCallbacksAndMessages(null);
                    this.mHandler.postDelayed(this::enterSoftware, this.mTapTimeoutMillis);
                } else if (this.mVisible) {
                    this.enterSoftware();
                }
            } else {
                this.enterSoftware();
            }
        } else {
            this.exitSoftware();
        }
    }

    private void enterSoftware() {
        this.endAnimations("enterSoftware", true);
        this.mVisible = true;
        this.mGlowAlpha = this.getMaxGlowAlpha();
        ObjectAnimator scaleAnimator = ObjectAnimator.ofFloat((Object)this, "glowScale", 0.0f, 1.35f);
        scaleAnimator.setInterpolator(this.mInterpolator);
        scaleAnimator.setDuration(350L);
        scaleAnimator.addListener(this.mAnimatorListener);
        scaleAnimator.start();
        this.mRunningAnimations.add(scaleAnimator);
        if (this.mDelayTouchFeedback && !this.mPressed) {
            this.exitSoftware();
        }
    }

    private void exitSoftware() {
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)this, "glowAlpha", this.mGlowAlpha, 0.0f);
        alphaAnimator.setInterpolator(ALPHA_OUT_INTERPOLATOR);
        alphaAnimator.setDuration(450L);
        alphaAnimator.addListener(this.mAnimatorListener);
        alphaAnimator.start();
        this.mRunningAnimations.add(alphaAnimator);
    }

    private void setPressedHardware(boolean pressed) {
        if (pressed) {
            if (this.mDelayTouchFeedback) {
                if (this.mRunningAnimations.isEmpty()) {
                    this.mHandler.removeCallbacksAndMessages(null);
                    this.mHandler.postDelayed(this::enterHardware, this.mTapTimeoutMillis);
                } else if (this.mVisible) {
                    this.enterHardware();
                }
            } else {
                this.enterHardware();
            }
        } else {
            this.exitHardware();
        }
    }

    private void setExtendStart(CanvasProperty<Float> prop) {
        if (this.isHorizontal()) {
            this.mLeftProp = prop;
        } else {
            this.mTopProp = prop;
        }
    }

    private CanvasProperty<Float> getExtendStart() {
        return this.isHorizontal() ? this.mLeftProp : this.mTopProp;
    }

    private void setExtendEnd(CanvasProperty<Float> prop) {
        if (this.isHorizontal()) {
            this.mRightProp = prop;
        } else {
            this.mBottomProp = prop;
        }
    }

    private CanvasProperty<Float> getExtendEnd() {
        return this.isHorizontal() ? this.mRightProp : this.mBottomProp;
    }

    private int getExtendSize() {
        return this.isHorizontal() ? this.getBounds().width() : this.getBounds().height();
    }

    private int getRippleSize() {
        int size = this.isHorizontal() ? this.getBounds().width() : this.getBounds().height();
        return Math.min(size, this.mMaxWidth);
    }

    private void enterHardware() {
        this.endAnimations("enterHardware", true);
        this.mVisible = true;
        this.mDrawingHardwareGlow = true;
        this.setExtendStart(CanvasProperty.createFloat(this.getExtendSize() / 2));
        RenderNodeAnimator startAnim = new RenderNodeAnimator(this.getExtendStart(), (float)(this.getExtendSize() / 2) - 1.35f * (float)this.getRippleSize() / 2.0f);
        startAnim.setDuration(350L);
        startAnim.setInterpolator(this.mInterpolator);
        startAnim.addListener(this.mAnimatorListener);
        startAnim.setTarget(this.mTargetView);
        this.setExtendEnd(CanvasProperty.createFloat(this.getExtendSize() / 2));
        RenderNodeAnimator endAnim = new RenderNodeAnimator(this.getExtendEnd(), (float)(this.getExtendSize() / 2) + 1.35f * (float)this.getRippleSize() / 2.0f);
        endAnim.setDuration(350L);
        endAnim.setInterpolator(this.mInterpolator);
        endAnim.addListener(this.mAnimatorListener);
        endAnim.addListener(this.mEnterHwTraceAnimator);
        endAnim.setTarget(this.mTargetView);
        if (this.isHorizontal()) {
            this.mTopProp = CanvasProperty.createFloat(0.0f);
            this.mBottomProp = CanvasProperty.createFloat(this.getBounds().height());
            this.mRxProp = CanvasProperty.createFloat(this.getBounds().height() / 2);
            this.mRyProp = CanvasProperty.createFloat(this.getBounds().height() / 2);
        } else {
            this.mLeftProp = CanvasProperty.createFloat(0.0f);
            this.mRightProp = CanvasProperty.createFloat(this.getBounds().width());
            this.mRxProp = CanvasProperty.createFloat(this.getBounds().width() / 2);
            this.mRyProp = CanvasProperty.createFloat(this.getBounds().width() / 2);
        }
        this.mGlowScale = 1.35f;
        this.mGlowAlpha = this.getMaxGlowAlpha();
        this.mRipplePaint = this.getRipplePaint();
        this.mRipplePaint.setAlpha((int)(this.mGlowAlpha * 255.0f));
        this.mPaintProp = CanvasProperty.createPaint(this.mRipplePaint);
        startAnim.start();
        endAnim.start();
        this.mRunningAnimations.add(startAnim);
        this.mRunningAnimations.add(endAnim);
        this.invalidateSelf();
        if (this.mDelayTouchFeedback && !this.mPressed) {
            this.exitHardware();
        }
    }

    private void exitHardware() {
        this.mPaintProp = CanvasProperty.createPaint(this.getRipplePaint());
        RenderNodeAnimator opacityAnim = new RenderNodeAnimator(this.mPaintProp, 1, 0.0f);
        opacityAnim.setDuration(450L);
        opacityAnim.setInterpolator(ALPHA_OUT_INTERPOLATOR);
        opacityAnim.addListener(this.mAnimatorListener);
        opacityAnim.addListener(this.mExitHwTraceAnimator);
        opacityAnim.setTarget(this.mTargetView);
        opacityAnim.start();
        this.mRunningAnimations.add(opacityAnim);
        this.invalidateSelf();
    }

    private static class LogInterpolator
    implements Interpolator {
        private LogInterpolator() {
        }

        @Override
        public float getInterpolation(float input) {
            return 1.0f - (float)Math.pow(400.0, (double)(-input) * 1.4);
        }
    }

    private static class TraceAnimatorListener
    extends AnimatorListenerAdapter {
        private final String mName;

        TraceAnimatorListener(String name) {
            this.mName = name;
        }

        @Override
        public void onAnimationStart(Animator animation) {
            Trace.beginSection("KeyButtonRipple.start." + this.mName);
            Trace.endSection();
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            Trace.beginSection("KeyButtonRipple.cancel." + this.mName);
            Trace.endSection();
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            Trace.beginSection("KeyButtonRipple.end." + this.mName);
            Trace.endSection();
        }
    }

    public static enum Type {
        OVAL,
        ROUNDED_RECT;

    }
}

