/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.res.Configuration;
import android.content.res.Resources;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.content.res.Flags;
import com.android.internal.util.Preconditions;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class ImsConfigurationTracker {
    private static final int CONFIG_CHANGED = -1;
    @Nullable
    private Configuration mLastKnownConfig = null;
    private int mHandledConfigChanges = 0;
    private boolean mInitialized = false;

    public void onInitialize(int handledConfigChanges) {
        Preconditions.checkState(!this.mInitialized, "onInitialize can be called only once.");
        this.mInitialized = true;
        this.mHandledConfigChanges = handledConfigChanges;
    }

    public void onBindInput(@Nullable Resources resources) {
        if (!this.mInitialized) {
            return;
        }
        if (this.mLastKnownConfig == null && resources != null) {
            this.mLastKnownConfig = new Configuration(resources.getConfiguration());
        }
    }

    public void setHandledConfigChanges(int configChanges) {
        this.mHandledConfigChanges = configChanges;
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig, @NonNull Runnable resetStateForNewConfigurationRunner) {
        if (!this.mInitialized) {
            return;
        }
        boolean neverReset = Flags.handleAllConfigChanges() && (this.mHandledConfigChanges & 0x8000000) != 0;
        int diff = this.mLastKnownConfig != null ? this.mLastKnownConfig.diffPublicOnly(newConfig) : -1;
        int unhandledDiff = diff & ~this.mHandledConfigChanges;
        if (unhandledDiff != 0 && !neverReset) {
            resetStateForNewConfigurationRunner.run();
        }
        if (diff != 0) {
            this.mLastKnownConfig = new Configuration(newConfig);
        }
    }
}

