/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.CancellationSignalBeamer;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.HandwritingGesture;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.ParcelableHandwritingGesture;
import android.view.inputmethod.SurroundingText;
import android.view.inputmethod.TextAttribute;
import android.view.inputmethod.TextBoundsInfo;
import android.view.inputmethod.TextBoundsInfoResult;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.inputmethod.IRemoteInputConnection;
import com.android.internal.inputmethod.InputConnectionCommandHeader;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

class IRemoteInputConnectionInvoker {
    @NonNull
    private final IRemoteInputConnection mConnection;
    private final int mSessionId;
    private CancellationSignalBeamer.Sender mBeamer;

    private IRemoteInputConnectionInvoker(@NonNull IRemoteInputConnection inputConnection, int sessionId) {
        this.mConnection = inputConnection;
        this.mSessionId = sessionId;
    }

    public static IRemoteInputConnectionInvoker create(@NonNull IRemoteInputConnection connection) {
        Objects.requireNonNull(connection);
        return new IRemoteInputConnectionInvoker(connection, 0);
    }

    @NonNull
    public IRemoteInputConnectionInvoker cloneWithSessionId(int sessionId) {
        return new IRemoteInputConnectionInvoker(this.mConnection, sessionId);
    }

    public boolean isSameConnection(@NonNull IRemoteInputConnection connection) {
        if (connection == null) {
            return false;
        }
        return this.mConnection.asBinder() == connection.asBinder();
    }

    @NonNull
    InputConnectionCommandHeader createHeader() {
        return new InputConnectionCommandHeader(this.mSessionId);
    }

    @NonNull
    public AndroidFuture<CharSequence> getTextAfterCursor(int length, int flags) {
        AndroidFuture<CharSequence> future = new AndroidFuture<CharSequence>();
        try {
            this.mConnection.getTextAfterCursor(this.createHeader(), length, flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @NonNull
    public AndroidFuture<CharSequence> getTextBeforeCursor(int length, int flags) {
        AndroidFuture<CharSequence> future = new AndroidFuture<CharSequence>();
        try {
            this.mConnection.getTextBeforeCursor(this.createHeader(), length, flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @NonNull
    public AndroidFuture<CharSequence> getSelectedText(int flags) {
        AndroidFuture<CharSequence> future = new AndroidFuture<CharSequence>();
        try {
            this.mConnection.getSelectedText(this.createHeader(), flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @NonNull
    public AndroidFuture<SurroundingText> getSurroundingText(int beforeLength, int afterLength, int flags) {
        AndroidFuture<SurroundingText> future = new AndroidFuture<SurroundingText>();
        try {
            this.mConnection.getSurroundingText(this.createHeader(), beforeLength, afterLength, flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @NonNull
    public AndroidFuture<Integer> getCursorCapsMode(int reqModes) {
        AndroidFuture<Integer> future = new AndroidFuture<Integer>();
        try {
            this.mConnection.getCursorCapsMode(this.createHeader(), reqModes, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @NonNull
    public AndroidFuture<ExtractedText> getExtractedText(ExtractedTextRequest request, int flags) {
        AndroidFuture<ExtractedText> future = new AndroidFuture<ExtractedText>();
        try {
            this.mConnection.getExtractedText(this.createHeader(), request, flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        try {
            this.mConnection.commitText(this.createHeader(), text, newCursorPosition);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean commitText(CharSequence text, int newCursorPosition, @Nullable TextAttribute textAttribute) {
        try {
            this.mConnection.commitTextWithTextAttribute(this.createHeader(), text, newCursorPosition, textAttribute);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean commitCompletion(CompletionInfo text) {
        try {
            this.mConnection.commitCompletion(this.createHeader(), text);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        try {
            this.mConnection.commitCorrection(this.createHeader(), correctionInfo);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setSelection(int start, int end) {
        try {
            this.mConnection.setSelection(this.createHeader(), start, end);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean performEditorAction(int actionCode) {
        try {
            this.mConnection.performEditorAction(this.createHeader(), actionCode);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean performContextMenuAction(int id2) {
        try {
            this.mConnection.performContextMenuAction(this.createHeader(), id2);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setComposingRegion(int start, int end) {
        try {
            this.mConnection.setComposingRegion(this.createHeader(), start, end);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setComposingRegion(int start, int end, @Nullable TextAttribute textAttribute) {
        try {
            this.mConnection.setComposingRegionWithTextAttribute(this.createHeader(), start, end, textAttribute);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        try {
            this.mConnection.setComposingText(this.createHeader(), text, newCursorPosition);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition, @Nullable TextAttribute textAttribute) {
        try {
            this.mConnection.setComposingTextWithTextAttribute(this.createHeader(), text, newCursorPosition, textAttribute);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean finishComposingText() {
        try {
            this.mConnection.finishComposingText(this.createHeader());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean beginBatchEdit() {
        try {
            this.mConnection.beginBatchEdit(this.createHeader());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean endBatchEdit() {
        try {
            this.mConnection.endBatchEdit(this.createHeader());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean sendKeyEvent(KeyEvent event) {
        try {
            this.mConnection.sendKeyEvent(this.createHeader(), event);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean clearMetaKeyStates(int states) {
        try {
            this.mConnection.clearMetaKeyStates(this.createHeader(), states);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        try {
            this.mConnection.deleteSurroundingText(this.createHeader(), beforeLength, afterLength);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        try {
            this.mConnection.deleteSurroundingTextInCodePoints(this.createHeader(), beforeLength, afterLength);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean performSpellCheck() {
        try {
            this.mConnection.performSpellCheck(this.createHeader());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean performPrivateCommand(String action, Bundle data) {
        try {
            this.mConnection.performPrivateCommand(this.createHeader(), action, data);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void performHandwritingGesture(@NonNull HandwritingGesture gesture, @Nullable Executor executor, @Nullable IntConsumer consumer) {
        block9: {
            IntResultReceiver resultReceiver = null;
            if (consumer != null) {
                Objects.requireNonNull(executor);
                resultReceiver = new IntResultReceiver(executor, consumer);
            }
            try (CancellationSignalBeamer.Sender.MustClose ignored = this.getCancellationSignalBeamer().beamScopeIfNeeded(gesture);){
                this.mConnection.performHandwritingGesture(this.createHeader(), ParcelableHandwritingGesture.of(gesture), resultReceiver);
            }
            catch (RemoteException e) {
                if (consumer == null || executor == null) break block9;
                executor.execute(() -> consumer.accept(4));
            }
        }
    }

    public boolean previewHandwritingGesture(@NonNull HandwritingGesture gesture, @Nullable CancellationSignal cancellationSignal) {
        try {
            try (CancellationSignalBeamer.Sender.CloseableToken csToken = this.beam(cancellationSignal);){
                this.mConnection.previewHandwritingGesture(this.createHeader(), ParcelableHandwritingGesture.of(gesture), csToken);
            }
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Nullable
    CancellationSignalBeamer.Sender.CloseableToken beam(CancellationSignal cs) {
        if (cs == null) {
            return null;
        }
        return this.getCancellationSignalBeamer().beam(cs);
    }

    private CancellationSignalBeamer.Sender getCancellationSignalBeamer() {
        if (this.mBeamer != null) {
            return this.mBeamer;
        }
        this.mBeamer = new CancellationSignalBeamer.Sender(){

            @Override
            public void onCancel(IBinder token) {
                try {
                    IRemoteInputConnectionInvoker.this.mConnection.cancelCancellationSignal(token);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }

            @Override
            public void onForget(IBinder token) {
                try {
                    IRemoteInputConnectionInvoker.this.mConnection.forgetCancellationSignal(token);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        };
        return this.mBeamer;
    }

    @NonNull
    public AndroidFuture<Boolean> requestCursorUpdates(int cursorUpdateMode, int imeDisplayId) {
        AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
        try {
            this.mConnection.requestCursorUpdates(this.createHeader(), cursorUpdateMode, imeDisplayId, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @NonNull
    public AndroidFuture<Boolean> requestCursorUpdates(int cursorUpdateMode, int cursorUpdateFilter, int imeDisplayId) {
        AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
        try {
            this.mConnection.requestCursorUpdatesWithFilter(this.createHeader(), cursorUpdateMode, cursorUpdateFilter, imeDisplayId, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void requestTextBoundsInfo(@NonNull RectF bounds, @NonNull Executor executor, @NonNull Consumer<TextBoundsInfoResult> consumer) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(consumer);
        TextBoundsInfoResultReceiver resultReceiver = new TextBoundsInfoResultReceiver(executor, consumer);
        try {
            this.mConnection.requestTextBoundsInfo(this.createHeader(), bounds, resultReceiver);
        }
        catch (RemoteException e) {
            executor.execute(() -> consumer.accept(new TextBoundsInfoResult(3)));
        }
    }

    @NonNull
    public AndroidFuture<Boolean> commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts) {
        AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
        try {
            this.mConnection.commitContent(this.createHeader(), inputContentInfo, flags, opts, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public boolean setImeConsumesInput(boolean imeConsumesInput) {
        try {
            this.mConnection.setImeConsumesInput(this.createHeader(), imeConsumesInput);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean replaceText(int start, int end, @NonNull CharSequence text, int newCursorPosition, @Nullable TextAttribute textAttribute) {
        try {
            this.mConnection.replaceText(this.createHeader(), start, end, text, newCursorPosition, textAttribute);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private static class IntResultReceiver
    extends OnceResultReceiver<IntConsumer> {
        IntResultReceiver(@NonNull Executor executor, @NonNull IntConsumer consumer) {
            super(executor, consumer);
        }

        @Override
        protected void dispatch(@NonNull Executor executor, @NonNull IntConsumer consumer, int code, Bundle data) {
            executor.execute(() -> consumer.accept(code));
        }
    }

    private static class TextBoundsInfoResultReceiver
    extends OnceResultReceiver<Consumer<TextBoundsInfoResult>> {
        TextBoundsInfoResultReceiver(@NonNull Executor executor, @NonNull Consumer<TextBoundsInfoResult> consumer) {
            super(executor, consumer);
        }

        @Override
        protected void dispatch(@NonNull Executor executor, @NonNull Consumer<TextBoundsInfoResult> consumer, int code, Bundle data) {
            TextBoundsInfoResult textBoundsInfoResult = new TextBoundsInfoResult(code, TextBoundsInfo.createFromBundle(data));
            executor.execute(() -> consumer.accept(textBoundsInfoResult));
        }
    }

    private static abstract class OnceResultReceiver<C>
    extends ResultReceiver {
        @Nullable
        private C mConsumer;
        @Nullable
        private Executor mExecutor;

        protected OnceResultReceiver(@NonNull Executor executor, @NonNull C consumer) {
            super((Handler)null);
            Objects.requireNonNull(executor);
            Objects.requireNonNull(consumer);
            this.mExecutor = executor;
            this.mConsumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onReceiveResult(int resultCode, Bundle resultData) {
            C consumer;
            Executor executor;
            OnceResultReceiver onceResultReceiver = this;
            synchronized (onceResultReceiver) {
                executor = this.mExecutor;
                consumer = this.mConsumer;
                this.mExecutor = null;
                this.mConsumer = null;
            }
            if (executor != null && consumer != null) {
                this.dispatch(executor, consumer, resultCode, resultData);
            }
        }

        protected abstract void dispatch(@NonNull Executor var1, @NonNull C var2, int var3, Bundle var4);
    }
}

