/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes.utils;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.RecordInternal;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import android.os.Parcel;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InternalExternalRecordConverter {
    @Nullable
    private static volatile InternalExternalRecordConverter sInternalExternalRecordConverter;
    private final Map<Integer, Class<? extends RecordInternal<?>>> mRecordIdToInternalRecordClassMap = HealthConnectMappings.getInstance().getRecordIdToInternalRecordClassMap();

    private InternalExternalRecordConverter() {
    }

    @NonNull
    public static synchronized InternalExternalRecordConverter getInstance() {
        if (sInternalExternalRecordConverter == null) {
            sInternalExternalRecordConverter = new InternalExternalRecordConverter();
        }
        return sInternalExternalRecordConverter;
    }

    @NonNull
    public RecordInternal<?> newInternalRecord(Parcel in) {
        int type = in.readInt();
        Class<RecordInternal<?>> recordClass = this.mRecordIdToInternalRecordClassMap.get(type);
        Objects.requireNonNull(recordClass);
        try {
            return recordClass.getConstructor(Parcel.class).newInstance(in);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public List<Record> getExternalRecords(@NonNull List<RecordInternal<?>> recordInternals) {
        ArrayList<Record> externalRecordList = new ArrayList<Record>(recordInternals.size());
        for (RecordInternal<?> recordInternal : recordInternals) {
            try {
                externalRecordList.add((Record)recordInternal.toExternalRecord());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String message = illegalArgumentException.getMessage();
                if (message != null && message.contains("Unknown Intdef value")) continue;
                throw illegalArgumentException;
            }
        }
        return externalRecordList;
    }
}

