/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.SkinTemperatureRecord;
import android.health.connect.datatypes.units.Temperature;
import android.health.connect.datatypes.units.TemperatureDelta;
import android.health.connect.internal.datatypes.SeriesRecordInternal;
import android.os.Parcel;
import com.android.healthfitness.flags.Flags;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=39)
public class SkinTemperatureRecordInternal
extends SeriesRecordInternal<SkinTemperatureRecord, SkinTemperatureRecord.Delta> {
    private Temperature mBaseline = Temperature.fromCelsius(Double.MIN_VALUE);
    private Set<SkinTemperatureDeltaSample> mDeltaSamples;
    private int mMeasurementLocation;

    public SkinTemperatureRecordInternal(Set<SkinTemperatureDeltaSample> deltaSamples) {
        this.mDeltaSamples = deltaSamples;
    }

    public SkinTemperatureRecordInternal(Parcel parcel) {
        super(parcel);
        this.mMeasurementLocation = parcel.readInt();
        this.mBaseline = Temperature.fromCelsius(parcel.readDouble());
        int size = parcel.readInt();
        this.mDeltaSamples = new HashSet<SkinTemperatureDeltaSample>(size);
        for (int idx = 0; idx < size; ++idx) {
            this.mDeltaSamples.add(new SkinTemperatureDeltaSample(parcel.readDouble(), parcel.readLong()));
        }
    }

    @Override
    void populateIntervalRecordTo(@NonNull Parcel parcel) {
        parcel.writeInt(this.mMeasurementLocation);
        parcel.writeDouble(this.mBaseline.getInCelsius());
        parcel.writeInt(this.mDeltaSamples.size());
        for (SkinTemperatureDeltaSample skinTemperatureDeltaSample : this.mDeltaSamples) {
            parcel.writeDouble(skinTemperatureDeltaSample.mTemperatureDeltaInCelsius());
            parcel.writeLong(skinTemperatureDeltaSample.mEpochMillis());
        }
    }

    @Override
    public SkinTemperatureRecord toExternalRecord() {
        SkinTemperatureRecord.Builder builder = new SkinTemperatureRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime()).setDeltas(this.getExternalDeltas()).setMeasurementLocation(this.getMeasurementLocation()).setEndZoneOffset(this.getEndZoneOffset()).setStartZoneOffset(this.getStartZoneOffset());
        if (this.mBaseline.getInCelsius() != Double.MIN_VALUE) {
            builder.setBaseline(this.mBaseline);
        }
        return builder.buildWithoutValidation();
    }

    @Override
    @NonNull
    public Set<SkinTemperatureDeltaSample> getSamples() {
        return this.mDeltaSamples;
    }

    public Temperature getBaseline() {
        return this.mBaseline;
    }

    @NonNull
    public SkinTemperatureRecordInternal setBaseline(Temperature baseline) {
        Objects.requireNonNull(baseline);
        this.mBaseline = baseline;
        return this;
    }

    public int getMeasurementLocation() {
        return this.mMeasurementLocation;
    }

    @NonNull
    public SkinTemperatureRecordInternal setMeasurementLocation(int measurementLocation) {
        this.mMeasurementLocation = measurementLocation;
        return this;
    }

    private List<SkinTemperatureRecord.Delta> getExternalDeltas() {
        ArrayList<SkinTemperatureRecord.Delta> skinTemperatureDeltas = new ArrayList<SkinTemperatureRecord.Delta>(this.mDeltaSamples.size());
        for (SkinTemperatureDeltaSample skinTemperatureDeltaSample : this.mDeltaSamples) {
            skinTemperatureDeltas.add(new SkinTemperatureRecord.Delta(TemperatureDelta.fromCelsius(skinTemperatureDeltaSample.mTemperatureDeltaInCelsius()), Instant.ofEpochMilli(skinTemperatureDeltaSample.mEpochMillis()), true));
        }
        return skinTemperatureDeltas;
    }

    public static class SkinTemperatureDeltaSample
    implements SeriesRecordInternal.Sample {
        private final double mTemperatureDeltaInCelsius;
        private final long mEpochMillis;

        public SkinTemperatureDeltaSample(double temperatureDeltaInCelsius, long epochMillis) {
            this.mTemperatureDeltaInCelsius = temperatureDeltaInCelsius;
            this.mEpochMillis = epochMillis;
        }

        public double mTemperatureDeltaInCelsius() {
            return this.mTemperatureDeltaInCelsius;
        }

        public long mEpochMillis() {
            return this.mEpochMillis;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof SkinTemperatureDeltaSample) {
                SkinTemperatureDeltaSample other = (SkinTemperatureDeltaSample)object;
                if (Flags.sampleTimeOrdering()) {
                    return this.mEpochMillis == other.mEpochMillis && this.mTemperatureDeltaInCelsius == other.mTemperatureDeltaInCelsius;
                }
                return super.equals(other) && this.mEpochMillis() == other.mEpochMillis();
            }
            return false;
        }

        public int hashCode() {
            if (Flags.sampleTimeOrdering()) {
                return Objects.hash(this.mEpochMillis, this.mTemperatureDeltaInCelsius);
            }
            return Objects.hash(this.mEpochMillis);
        }
    }
}

