/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Device;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.Record;
import android.os.Parcel;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;

public abstract class RecordInternal<T extends Record> {
    private final int mRecordIdentifier = this.constructRecordIdentifier();
    @Nullable
    private UUID mUuid;
    @Nullable
    private String mPackageName;
    @Nullable
    private String mAppName;
    private long mLastModifiedTime = -1L;
    @Nullable
    private String mClientRecordId;
    private long mClientRecordVersion = -1L;
    @Nullable
    private String mManufacturer;
    @Nullable
    private String mModel;
    private int mDeviceType;
    private long mDeviceInfoId = -1L;
    private long mAppInfoId = -1L;
    private int mRowId = -1;
    private int mRecordingMethod;

    RecordInternal() {
    }

    RecordInternal(Parcel parcel) {
        String uuidString = parcel.readString();
        if (uuidString != null && !uuidString.isEmpty()) {
            this.mUuid = UUID.fromString(uuidString);
        }
        this.mPackageName = parcel.readString();
        this.mAppName = parcel.readString();
        this.mLastModifiedTime = parcel.readLong();
        this.mClientRecordId = parcel.readString();
        this.mClientRecordVersion = parcel.readLong();
        this.mManufacturer = parcel.readString();
        this.mModel = parcel.readString();
        this.mDeviceType = parcel.readInt();
        this.mRecordingMethod = parcel.readInt();
    }

    private int constructRecordIdentifier() {
        Identifier annotation = this.getClass().getAnnotation(Identifier.class);
        return Objects.requireNonNull(annotation).recordIdentifier();
    }

    public int getRecordType() {
        return this.mRecordIdentifier;
    }

    @NonNull
    public void writeToParcel(@NonNull Parcel parcel) {
        parcel.writeString(this.mUuid == null ? "" : ((Object)this.mUuid).toString());
        parcel.writeString(this.mPackageName);
        parcel.writeString(this.mAppName);
        parcel.writeLong(this.mLastModifiedTime);
        parcel.writeString(this.mClientRecordId);
        parcel.writeLong(this.mClientRecordVersion);
        parcel.writeString(this.mManufacturer);
        parcel.writeString(this.mModel);
        parcel.writeInt(this.mDeviceType);
        parcel.writeInt(this.mRecordingMethod);
        this.populateRecordTo(parcel);
    }

    @Nullable
    public UUID getUuid() {
        return this.mUuid;
    }

    @NonNull
    public RecordInternal<T> setUuid(@Nullable UUID uuid) {
        this.mUuid = uuid;
        return this;
    }

    @NonNull
    public RecordInternal<T> setUuid(@Nullable String uuid) {
        if (uuid == null || uuid.isEmpty()) {
            this.mUuid = null;
            return this;
        }
        this.mUuid = UUID.fromString(uuid);
        return this;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public RecordInternal<T> setPackageName(String packageName) {
        this.mPackageName = packageName;
        return this;
    }

    public int getRowId() {
        return this.mRowId;
    }

    public RecordInternal<T> setRowId(int rowId) {
        this.mRowId = rowId;
        return this;
    }

    @Nullable
    public String getAppName() {
        return this.mAppName;
    }

    @NonNull
    public RecordInternal<T> setAppName(@Nullable String appName) {
        this.mAppName = appName;
        return this;
    }

    public long getLastModifiedTime() {
        return this.mLastModifiedTime;
    }

    @NonNull
    public RecordInternal<T> setLastModifiedTime(long lastModifiedTime) {
        this.mLastModifiedTime = lastModifiedTime;
        return this;
    }

    @Nullable
    public String getClientRecordId() {
        return this.mClientRecordId;
    }

    @NonNull
    public RecordInternal<T> setClientRecordId(@Nullable String clientRecordId) {
        this.mClientRecordId = clientRecordId;
        return this;
    }

    public long getClientRecordVersion() {
        return this.mClientRecordVersion;
    }

    @NonNull
    public RecordInternal<T> setClientRecordVersion(long clientRecordVersion) {
        this.mClientRecordVersion = clientRecordVersion;
        return this;
    }

    @Nullable
    public String getManufacturer() {
        return this.mManufacturer;
    }

    @NonNull
    public RecordInternal<T> setManufacturer(@Nullable String manufacturer) {
        this.mManufacturer = manufacturer;
        return this;
    }

    @Nullable
    public String getModel() {
        return this.mModel;
    }

    @NonNull
    public RecordInternal<T> setModel(@Nullable String model) {
        this.mModel = model;
        return this;
    }

    public int getDeviceType() {
        return this.mDeviceType;
    }

    @NonNull
    public RecordInternal<T> setDeviceType(int deviceType) {
        this.mDeviceType = deviceType;
        return this;
    }

    public long getDeviceInfoId() {
        return this.mDeviceInfoId;
    }

    @NonNull
    public RecordInternal<T> setDeviceInfoId(long deviceInfoId) {
        this.mDeviceInfoId = deviceInfoId;
        return this;
    }

    public long getAppInfoId() {
        return this.mAppInfoId;
    }

    @NonNull
    public RecordInternal<T> setAppInfoId(long appInfoId) {
        this.mAppInfoId = appInfoId;
        return this;
    }

    public int getRecordingMethod() {
        return this.mRecordingMethod;
    }

    @NonNull
    public RecordInternal<T> setRecordingMethod(int recordingMethod) {
        this.mRecordingMethod = recordingMethod;
        return this;
    }

    public abstract T toExternalRecord();

    @NonNull
    Metadata buildMetaData() {
        DataOrigin dataOrigin = new DataOrigin.Builder().setPackageName(this.getPackageName()).build();
        Metadata.Builder builder = new Metadata.Builder().setClientRecordId(this.getClientRecordId()).setClientRecordVersion(this.getClientRecordVersion()).setDataOrigin(dataOrigin).setLastModifiedTime(Instant.ofEpochMilli(this.getLastModifiedTime())).setRecordingMethod(this.getRecordingMethod()).setDevice(new Device.Builder().setManufacturer(this.getManufacturer()).setType(this.getDeviceType()).setModel(this.getModel()).build());
        UUID id2 = this.getUuid();
        if (id2 != null) {
            builder.setId(((Object)id2).toString());
        }
        return builder.build();
    }

    @NonNull
    public RecordInternal<T> setMetaData(Metadata metaData) {
        return this.setUuid(metaData.getId()).setPackageName(metaData.getDataOrigin().getPackageName()).setLastModifiedTime(metaData.getLastModifiedTime().toEpochMilli()).setClientRecordId(metaData.getClientRecordId()).setClientRecordVersion(metaData.getClientRecordVersion()).setManufacturer(metaData.getDevice().getManufacturer()).setModel(metaData.getDevice().getModel()).setDeviceType(metaData.getDevice().getType()).setRecordingMethod(metaData.getRecordingMethod());
    }

    public abstract LocalDate getLocalDate();

    public abstract long getRecordTime();

    abstract void populateRecordTo(@NonNull Parcel var1);
}

