/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.internal.datatypes.RecordInternal;
import android.os.Parcel;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;

public abstract class InstantRecordInternal<T extends InstantRecord>
extends RecordInternal<T> {
    private long mTime;
    private int mZoneOffset;

    public long getTimeInMillis() {
        return this.mTime;
    }

    public int getZoneOffsetInSeconds() {
        return this.mZoneOffset;
    }

    InstantRecordInternal() {
    }

    InstantRecordInternal(Parcel parcel) {
        super(parcel);
        this.mTime = parcel.readLong();
        this.mZoneOffset = parcel.readInt();
    }

    @Override
    @NonNull
    public LocalDate getLocalDate() {
        return LocalDate.ofInstant(this.getTime(), this.getZoneOffset());
    }

    @Override
    void populateRecordTo(@NonNull Parcel parcel) {
        parcel.writeLong(this.mTime);
        parcel.writeInt(this.mZoneOffset);
        this.populateInstantRecordTo(parcel);
    }

    @Override
    public long getRecordTime() {
        return this.getTimeInMillis();
    }

    Instant getTime() {
        return Instant.ofEpochMilli(this.mTime);
    }

    @NonNull
    public InstantRecordInternal<T> setTime(long time) {
        this.mTime = time;
        return this;
    }

    ZoneOffset getZoneOffset() {
        return ZoneOffset.ofTotalSeconds(this.mZoneOffset);
    }

    @NonNull
    public InstantRecordInternal<T> setZoneOffset(int zoneOffset) {
        this.mZoneOffset = zoneOffset;
        return this;
    }

    abstract void populateInstantRecordTo(@NonNull Parcel var1);
}

