/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.exportimport;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class ScheduledExportSettings
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<ScheduledExportSettings> CREATOR = new Parcelable.Creator<ScheduledExportSettings>(){

        @Override
        public ScheduledExportSettings createFromParcel(Parcel in) {
            return new ScheduledExportSettings(in);
        }

        public ScheduledExportSettings[] newArray(int size) {
            return new ScheduledExportSettings[size];
        }
    };
    @Nullable
    private final Uri mUri;
    private final int mPeriodInDays;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledExportSettings)) {
            return false;
        }
        ScheduledExportSettings that = (ScheduledExportSettings)o;
        return this.mPeriodInDays == that.mPeriodInDays && Objects.equals(this.mUri, that.mUri);
    }

    public int hashCode() {
        return Objects.hash(this.mUri, this.mPeriodInDays);
    }

    private ScheduledExportSettings(@NonNull Parcel in) {
        boolean hasUri = in.readBoolean();
        this.mUri = hasUri ? Uri.parse(in.readString()) : null;
        this.mPeriodInDays = in.readInt();
    }

    private ScheduledExportSettings(@Nullable Uri uri, int periodInDays) {
        this.mUri = uri;
        this.mPeriodInDays = periodInDays;
    }

    @Nullable
    public Uri getUri() {
        return this.mUri;
    }

    public int getPeriodInDays() {
        return this.mPeriodInDays;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBoolean(this.mUri != null);
        if (this.mUri != null) {
            dest.writeString(this.mUri.toString());
        }
        dest.writeInt(this.mPeriodInDays);
    }

    public static class Builder {
        @Nullable
        private Uri mUri;
        private int mPeriodInDays = -1;

        @NonNull
        public Builder setUri(@NonNull Uri uri) {
            Objects.requireNonNull(uri);
            this.mUri = uri;
            return this;
        }

        @NonNull
        public Builder setPeriodInDays(int periodInDays) {
            if (periodInDays < 0 || periodInDays > 30) {
                throw new IllegalArgumentException("periodInDays should be between 0 and 30");
            }
            this.mPeriodInDays = periodInDays;
            return this;
        }

        @NonNull
        public ScheduledExportSettings build() {
            return new ScheduledExportSettings(this.mUri, this.mPeriodInDays);
        }
    }
}

