/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes.validation;

import android.health.connect.datatypes.ExerciseRoute;
import android.health.connect.datatypes.ExerciseSegment;
import android.health.connect.datatypes.ExerciseSegmentType;
import android.health.connect.datatypes.ExerciseSessionType;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExerciseSessionTypesValidation {
    private static final String TAG = "ExerciseSessionsValidations";
    private static final Set<Integer> UNIVERSAL_SEGMENTS = Set.of(Integer.valueOf(64), Integer.valueOf(67), Integer.valueOf(66), Integer.valueOf(20), Integer.valueOf(0));
    private static final Set<Integer> UNIVERSAL_SESSIONS = Set.of(Integer.valueOf(6), Integer.valueOf(20), Integer.valueOf(58), Integer.valueOf(0));
    private static final Set<Integer> EXERCISES = Set.of(26, 27, 28, 1, 29, 2, 30, 31, 32, 33, 5, 6, 7, 8, 34, 9, 10, 11, 13, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 23, 63);
    private static final Set<Integer> SWIMMING = Set.of(Integer.valueOf(57), Integer.valueOf(58), Integer.valueOf(56), Integer.valueOf(59), Integer.valueOf(60), Integer.valueOf(61));
    private static final Map<Integer, Set<Integer>> SESSION_TO_SEGMENT_MAPPING = new ArrayMap<Integer, Set<Integer>>();

    public static void validateSessionAndSegmentsTypes(int sessionType, List<ExerciseSegment> segments) {
        if (!ExerciseSessionType.isKnownSessionType(sessionType)) {
            Slog.w(TAG, "Unknown exercise session type: " + sessionType);
            return;
        }
        for (ExerciseSegment segment : segments) {
            int segmentType = segment.getSegmentType();
            if (!ExerciseSegmentType.isKnownSegmentType(segmentType)) {
                Slog.w(TAG, "Unknown exercise segment type: " + segmentType);
                continue;
            }
            if (UNIVERSAL_SESSIONS.contains(sessionType) || UNIVERSAL_SEGMENTS.contains(segmentType) || SESSION_TO_SEGMENT_MAPPING.containsKey(sessionType) && SESSION_TO_SEGMENT_MAPPING.get(sessionType).contains(segmentType)) continue;
            throw new IllegalArgumentException("Invalid exercise segment type for given exercise session type");
        }
    }

    public static void validateExerciseRouteTimestamps(Instant sessionStartTime, Instant sessionEndTime, ExerciseRoute route) {
        if (route == null) {
            return;
        }
        for (ExerciseRoute.Location location : route.getRouteLocations()) {
            if (!location.getTime().isAfter(sessionEndTime) && !location.getTime().isBefore(sessionStartTime)) continue;
            throw new IllegalArgumentException("Exercise route timestamp must be within session interval, got start time: " + sessionStartTime + ", session end time: " + sessionEndTime + ", route location time: " + location.getTime());
        }
    }

    static {
        SESSION_TO_SEGMENT_MAPPING.put(4, Set.of(Integer.valueOf(3)));
        SESSION_TO_SEGMENT_MAPPING.put(5, Set.of(Integer.valueOf(4)));
        SESSION_TO_SEGMENT_MAPPING.put(8, EXERCISES);
        SESSION_TO_SEGMENT_MAPPING.put(60, Set.of(Integer.valueOf(12)));
        SESSION_TO_SEGMENT_MAPPING.put(11, Set.of(Integer.valueOf(65), Integer.valueOf(4), Integer.valueOf(14), Integer.valueOf(62)));
        SESSION_TO_SEGMENT_MAPPING.put(18, EXERCISES);
        SESSION_TO_SEGMENT_MAPPING.put(21, Set.of(Integer.valueOf(24), Integer.valueOf(25)));
        SESSION_TO_SEGMENT_MAPPING.put(27, Set.of(Integer.valueOf(14)));
        SESSION_TO_SEGMENT_MAPPING.put(61, Set.of(Integer.valueOf(15)));
        SESSION_TO_SEGMENT_MAPPING.put(33, Set.of(Integer.valueOf(16), Integer.valueOf(24)));
        SESSION_TO_SEGMENT_MAPPING.put(34, Set.of(Integer.valueOf(17)));
        SESSION_TO_SEGMENT_MAPPING.put(44, Set.of(Integer.valueOf(18)));
        SESSION_TO_SEGMENT_MAPPING.put(59, Set.of(Integer.valueOf(19)));
        SESSION_TO_SEGMENT_MAPPING.put(45, EXERCISES);
        ArraySet<Integer> openSwimming = new ArraySet<Integer>(SWIMMING);
        openSwimming.add(21);
        SESSION_TO_SEGMENT_MAPPING.put(48, openSwimming);
        ArraySet<Integer> poolSwimming = new ArraySet<Integer>(SWIMMING);
        poolSwimming.add(22);
        SESSION_TO_SEGMENT_MAPPING.put(49, poolSwimming);
        SESSION_TO_SEGMENT_MAPPING.put(53, Set.of(Integer.valueOf(24)));
        SESSION_TO_SEGMENT_MAPPING.put(55, EXERCISES);
        SESSION_TO_SEGMENT_MAPPING.put(56, Set.of(Integer.valueOf(25)));
        SESSION_TO_SEGMENT_MAPPING.put(57, Set.of(Integer.valueOf(65)));
    }
}

