/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.TimeInterval;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.SleepSessionRecordInternal;
import android.health.connect.internal.datatypes.SleepStageInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Identifier(recordIdentifier=38)
public class SleepSessionRecord
extends IntervalRecord {
    @NonNull
    public static final AggregationType<Long> SLEEP_DURATION_TOTAL = new AggregationType<Long>(66, 3, 38, Long.class);
    private final List<Stage> mStages;
    private final CharSequence mNotes;
    private final CharSequence mTitle;

    private SleepSessionRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @NonNull List<Stage> stages, @Nullable CharSequence notes, @Nullable CharSequence title, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        Objects.requireNonNull(stages);
        this.mStages = Collections.unmodifiableList(ValidationUtils.sortAndValidateTimeIntervalHolders(startTime, endTime, stages));
        this.mNotes = notes;
        this.mTitle = title;
    }

    @Nullable
    public CharSequence getNotes() {
        return this.mNotes;
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @NonNull
    public List<Stage> getStages() {
        return this.mStages;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SleepSessionRecord)) {
            return false;
        }
        SleepSessionRecord that = (SleepSessionRecord)o;
        if (!super.equals(o)) {
            return false;
        }
        return RecordUtils.isEqualNullableCharSequences(this.getNotes(), that.getNotes()) && RecordUtils.isEqualNullableCharSequences(this.getTitle(), that.getTitle()) && Objects.equals(this.getStages(), that.getStages());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNotes(), this.getTitle(), this.getStages());
    }

    public SleepSessionRecordInternal toRecordInternal() {
        CharSequence title;
        SleepSessionRecordInternal recordInternal = (SleepSessionRecordInternal)new SleepSessionRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTimeInterval(this);
        recordInternal.setSleepStages(this.getStages().stream().map(Stage::toInternalStage).collect(Collectors.toList()));
        CharSequence notes = this.getNotes();
        if (notes != null) {
            recordInternal.setNotes(notes.toString());
        }
        if ((title = this.getTitle()) != null) {
            recordInternal.setTitle(title.toString());
        }
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<Stage> mStages;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        @Nullable
        private CharSequence mNotes;
        @Nullable
        private CharSequence mTitle;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mStages = new ArrayList<Stage>();
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder setNotes(@Nullable CharSequence notes) {
            this.mNotes = notes;
            return this;
        }

        @NonNull
        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        @NonNull
        public Builder setStages(@NonNull List<Stage> stages) {
            Objects.requireNonNull(stages);
            this.mStages.clear();
            this.mStages.addAll(stages);
            return this;
        }

        @NonNull
        public SleepSessionRecord buildWithoutValidation() {
            return new SleepSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mStages, this.mNotes, this.mTitle, true);
        }

        @NonNull
        public SleepSessionRecord build() {
            return new SleepSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mStages, this.mNotes, this.mTitle, false);
        }
    }

    public static class StageType {
        public static final int STAGE_TYPE_UNKNOWN = 0;
        public static final int STAGE_TYPE_AWAKE = 1;
        public static final int STAGE_TYPE_SLEEPING = 2;
        public static final int STAGE_TYPE_AWAKE_OUT_OF_BED = 3;
        public static final int STAGE_TYPE_SLEEPING_LIGHT = 4;
        public static final int STAGE_TYPE_SLEEPING_DEEP = 5;
        public static final int STAGE_TYPE_SLEEPING_REM = 6;
        public static final int STAGE_TYPE_AWAKE_IN_BED = 7;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7));
        public static final List<Integer> DURATION_EXCLUDE_TYPES = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(7));

        private StageType() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StageTypes {
        }
    }

    public static class Stage
    implements TimeInterval.TimeIntervalHolder {
        @NonNull
        private final TimeInterval mInterval;
        private final int mStageType;

        public Stage(@NonNull Instant startTime, @NonNull Instant endTime, int stageType) {
            ValidationUtils.validateIntDefValue(stageType, StageType.VALID_TYPES, StageType.class.getSimpleName());
            this.mInterval = new TimeInterval(startTime, endTime);
            this.mStageType = stageType;
        }

        @NonNull
        public Instant getStartTime() {
            return this.mInterval.getStartTime();
        }

        @NonNull
        public Instant getEndTime() {
            return this.mInterval.getEndTime();
        }

        public int getType() {
            return this.mStageType;
        }

        @Override
        public TimeInterval getInterval() {
            return this.mInterval;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Stage)) {
                return false;
            }
            Stage that = (Stage)o;
            return this.getType() == that.getType() && this.getStartTime().toEpochMilli() == that.getStartTime().toEpochMilli() && this.getEndTime().toEpochMilli() == that.getEndTime().toEpochMilli();
        }

        public int hashCode() {
            return Objects.hash(this.getStartTime(), this.getEndTime(), this.mStageType);
        }

        public SleepStageInternal toInternalStage() {
            return new SleepStageInternal().setStartTime(this.getStartTime().toEpochMilli()).setEndTime(this.getEndTime().toEpochMilli()).setStageType(this.getType());
        }
    }
}

