/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.RespiratoryRateRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=31)
public class RespiratoryRateRecord
extends InstantRecord {
    private final double mRate;

    private RespiratoryRateRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, @NonNull double rate, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        if (!skipValidation) {
            ValidationUtils.requireInRange(rate, 0.0, 1000.0, "rate");
        }
        this.mRate = rate;
    }

    public double getRate() {
        return this.mRate;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof RespiratoryRateRecord)) {
            return false;
        }
        RespiratoryRateRecord that = (RespiratoryRateRecord)o;
        return Double.compare(that.getRate(), this.getRate()) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRate());
    }

    public RespiratoryRateRecordInternal toRecordInternal() {
        RespiratoryRateRecordInternal recordInternal = (RespiratoryRateRecordInternal)new RespiratoryRateRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setRate(this.mRate);
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final double mRate;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, double rate) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mRate = rate;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public RespiratoryRateRecord buildWithoutValidation() {
            return new RespiratoryRateRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mRate, true);
        }

        @NonNull
        public RespiratoryRateRecord build() {
            return new RespiratoryRateRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mRate, false);
        }
    }
}

