/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordTypeIdentifier;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.RecordInternal;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import java.util.Objects;

public abstract class Record {
    private final Metadata mMetadata;
    private final int mRecordIdentifier;

    Record(@NonNull Metadata metadata) {
        Objects.requireNonNull(metadata);
        Identifier annotation = this.getClass().getAnnotation(Identifier.class);
        Objects.requireNonNull(annotation);
        ValidationUtils.validateIntDefValue(annotation.recordIdentifier(), HealthConnectMappings.getInstance().getAllRecordTypeIdentifiers(), RecordTypeIdentifier.class.getSimpleName());
        this.mRecordIdentifier = annotation.recordIdentifier();
        this.mMetadata = metadata;
    }

    @NonNull
    public Metadata getMetadata() {
        return this.mMetadata;
    }

    @SystemApi
    public int getRecordType() {
        return this.mRecordIdentifier;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (Objects.isNull(object)) {
            return false;
        }
        if (this.getClass().isAssignableFrom(object.getClass())) {
            Record other = (Record)object;
            return this.getMetadata().equals(other.getMetadata()) && this.getRecordType() == other.getRecordType();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getMetadata(), this.getRecordType());
    }

    public abstract RecordInternal<?> toRecordInternal();
}

