/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.MedicalResourceId;
import android.health.connect.datatypes.FhirResource;
import android.health.connect.datatypes.FhirVersion;
import android.health.connect.datatypes.MedicalDataSource;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.healthfitness.flags.Flags;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class MedicalResource
implements Parcelable {
    public static final int MEDICAL_RESOURCE_TYPE_VACCINES = 1;
    public static final int MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES = 2;
    public static final int MEDICAL_RESOURCE_TYPE_PREGNANCY = 3;
    public static final int MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY = 4;
    public static final int MEDICAL_RESOURCE_TYPE_VITAL_SIGNS = 5;
    public static final int MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS = 6;
    public static final int MEDICAL_RESOURCE_TYPE_CONDITIONS = 7;
    public static final int MEDICAL_RESOURCE_TYPE_PROCEDURES = 8;
    public static final int MEDICAL_RESOURCE_TYPE_MEDICATIONS = 9;
    public static final int MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS = 10;
    public static final int MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS = 11;
    public static final int MEDICAL_RESOURCE_TYPE_VISITS = 12;
    public static final int MEDICAL_RESOURCE_TYPE_DEVICES = 13;
    private final int mType;
    @NonNull
    private final MedicalResourceId mId;
    @NonNull
    private final String mDataSourceId;
    @NonNull
    private final FhirVersion mFhirVersion;
    @NonNull
    private final FhirResource mFhirResource;
    private long mLastModifiedTimestamp;
    @NonNull
    public static final Parcelable.Creator<MedicalResource> CREATOR = new Parcelable.Creator<MedicalResource>(){

        @Override
        public MedicalResource createFromParcel(Parcel in) {
            return new MedicalResource(in);
        }

        public MedicalResource[] newArray(int size) {
            return new MedicalResource[size];
        }
    };
    public static final Set<Integer> VALID_TYPES = Stream.of(Stream.of(2, 7, 6, 9, 10, 11, 3, 8, 4, 1, 12, 5), Flags.deviceResource() ? Stream.of(Integer.valueOf(13)) : Stream.of(new Integer[0])).flatMap(t -> t).collect(Collectors.toSet());

    public MedicalResource(int type, @NonNull String dataSourceId, @NonNull FhirVersion fhirVersion, @NonNull FhirResource fhirResource, long lastModifiedTimestamp) {
        this(type, dataSourceId, fhirVersion, fhirResource);
        this.mLastModifiedTimestamp = lastModifiedTimestamp;
    }

    private MedicalResource(int type, @NonNull String dataSourceId, @NonNull FhirVersion fhirVersion, @NonNull FhirResource fhirResource) {
        Objects.requireNonNull(dataSourceId);
        Objects.requireNonNull(fhirVersion);
        Objects.requireNonNull(fhirResource);
        MedicalResource.validateMedicalResourceType(type);
        MedicalDataSource.validateMedicalDataSourceIds(Set.of(dataSourceId));
        this.mType = type;
        this.mDataSourceId = dataSourceId;
        this.mFhirVersion = fhirVersion;
        this.mFhirResource = fhirResource;
        this.mId = new MedicalResourceId(dataSourceId, fhirResource.getType(), fhirResource.getId());
    }

    private MedicalResource(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mType = in.readInt();
        MedicalResource.validateMedicalResourceType(this.mType);
        this.mDataSourceId = Objects.requireNonNull(in.readString());
        MedicalDataSource.validateMedicalDataSourceIds(Set.of(this.mDataSourceId));
        this.mFhirVersion = Objects.requireNonNull(in.readParcelable(FhirVersion.class.getClassLoader(), FhirVersion.class));
        this.mFhirResource = Objects.requireNonNull(in.readParcelable(FhirResource.class.getClassLoader(), FhirResource.class));
        this.mId = new MedicalResourceId(this.mDataSourceId, this.mFhirResource.getType(), this.mFhirResource.getId());
    }

    public int getType() {
        return this.mType;
    }

    @NonNull
    public MedicalResourceId getId() {
        return this.mId;
    }

    @NonNull
    public String getDataSourceId() {
        return this.mDataSourceId;
    }

    @NonNull
    public FhirVersion getFhirVersion() {
        return this.mFhirVersion;
    }

    @NonNull
    public FhirResource getFhirResource() {
        return this.mFhirResource;
    }

    public long getLastModifiedTimestamp() {
        return this.mLastModifiedTimestamp;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.getType());
        dest.writeString(this.getDataSourceId());
        dest.writeParcelable(this.getFhirVersion(), 0);
        dest.writeParcelable(this.getFhirResource(), 0);
    }

    public static void validateMedicalResourceType(int medicalResourceType) {
        ValidationUtils.validateIntDefValue(medicalResourceType, VALID_TYPES, MedicalResourceType.class.getSimpleName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MedicalResource)) {
            return false;
        }
        MedicalResource that = (MedicalResource)o;
        return this.getType() == that.getType() && this.getDataSourceId().equals(that.getDataSourceId()) && this.getFhirVersion().equals(that.getFhirVersion()) && this.getFhirResource().equals(that.getFhirResource());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getDataSourceId(), this.getFhirVersion(), this.getFhirResource());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("type=").append(this.getType());
        sb.append(",dataSourceId=").append(this.getDataSourceId());
        sb.append(",fhirVersion=").append(this.getFhirVersion());
        sb.append(",fhirResource=").append(this.getFhirResource());
        sb.append("}");
        return sb.toString();
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MedicalResourceType {
    }

    public static class Builder {
        private int mType;
        @NonNull
        private String mDataSourceId;
        @NonNull
        private FhirVersion mFhirVersion;
        @NonNull
        private FhirResource mFhirResource;

        public Builder(int type, @NonNull String dataSourceId, @NonNull FhirVersion fhirVersion, @NonNull FhirResource fhirResource) {
            Objects.requireNonNull(dataSourceId);
            Objects.requireNonNull(fhirVersion);
            Objects.requireNonNull(fhirResource);
            MedicalResource.validateMedicalResourceType(type);
            MedicalDataSource.validateMedicalDataSourceIds(Set.of(dataSourceId));
            this.mType = type;
            this.mDataSourceId = dataSourceId;
            this.mFhirVersion = fhirVersion;
            this.mFhirResource = fhirResource;
        }

        public Builder(@NonNull Builder other) {
            Objects.requireNonNull(other);
            this.mType = other.mType;
            this.mDataSourceId = other.mDataSourceId;
            this.mFhirVersion = other.mFhirVersion;
            this.mFhirResource = other.mFhirResource;
        }

        public Builder(@NonNull MedicalResource other) {
            Objects.requireNonNull(other);
            this.mType = other.getType();
            this.mDataSourceId = other.getDataSourceId();
            this.mFhirVersion = other.getFhirVersion();
            this.mFhirResource = other.getFhirResource();
        }

        @NonNull
        public Builder setType(int type) {
            MedicalResource.validateMedicalResourceType(type);
            this.mType = type;
            return this;
        }

        @NonNull
        public Builder setDataSourceId(@NonNull String dataSourceId) {
            Objects.requireNonNull(dataSourceId);
            MedicalDataSource.validateMedicalDataSourceIds(Set.of(dataSourceId));
            this.mDataSourceId = dataSourceId;
            return this;
        }

        @NonNull
        public Builder setFhirVersion(@NonNull FhirVersion fhirVersion) {
            Objects.requireNonNull(fhirVersion);
            this.mFhirVersion = fhirVersion;
            return this;
        }

        @NonNull
        public Builder setFhirResource(@NonNull FhirResource fhirResource) {
            Objects.requireNonNull(fhirResource);
            this.mFhirResource = fhirResource;
            return this;
        }

        @NonNull
        public MedicalResource build() {
            return new MedicalResource(this.mType, this.mDataSourceId, this.mFhirVersion, this.mFhirResource);
        }
    }
}

