/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.LeanBodyMassRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=27)
public class LeanBodyMassRecord
extends InstantRecord {
    private final Mass mMass;

    private LeanBodyMassRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, @NonNull Mass mass, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(mass);
        if (!skipValidation) {
            ValidationUtils.requireInRange(mass.getInGrams(), 0.0, 1000000.0, "mass");
        }
        this.mMass = mass;
    }

    @NonNull
    public Mass getMass() {
        return this.mMass;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LeanBodyMassRecord)) {
            return false;
        }
        LeanBodyMassRecord that = (LeanBodyMassRecord)o;
        return this.getMass().equals(that.getMass());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMass());
    }

    public LeanBodyMassRecordInternal toRecordInternal() {
        LeanBodyMassRecordInternal recordInternal = (LeanBodyMassRecordInternal)new LeanBodyMassRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setMass(this.mMass.getInGrams());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final Mass mMass;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, @NonNull Mass mass) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(mass);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mMass = mass;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public LeanBodyMassRecord buildWithoutValidation() {
            return new LeanBodyMassRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMass, true);
        }

        @NonNull
        public LeanBodyMassRecord build() {
            return new LeanBodyMassRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMass, false);
        }
    }
}

