/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.internal.datatypes.IntermenstrualBleedingRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=36)
public class IntermenstrualBleedingRecord
extends InstantRecord {
    private IntermenstrualBleedingRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public IntermenstrualBleedingRecordInternal toRecordInternal() {
        IntermenstrualBleedingRecordInternal recordInternal = (IntermenstrualBleedingRecordInternal)new IntermenstrualBleedingRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public IntermenstrualBleedingRecord buildWithoutValidation() {
            return new IntermenstrualBleedingRecord(this.mMetadata, this.mTime, this.mZoneOffset, true);
        }

        @NonNull
        public IntermenstrualBleedingRecord build() {
            return new IntermenstrualBleedingRecord(this.mMetadata, this.mTime, this.mZoneOffset, false);
        }
    }
}

