/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Volume;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.HydrationRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=3)
public class HydrationRecord
extends IntervalRecord {
    @NonNull
    public static final AggregationType<Volume> VOLUME_TOTAL = new AggregationType<Volume>(11, 3, 3, Volume.class);
    private final Volume mVolume;

    private HydrationRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @NonNull Volume volume, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        Objects.requireNonNull(volume);
        if (!skipValidation) {
            ValidationUtils.requireInRange(volume.getInLiters(), 0.0, 100.0, "volume");
        }
        this.mVolume = volume;
    }

    @NonNull
    public Volume getVolume() {
        return this.mVolume;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof HydrationRecord)) {
            return false;
        }
        HydrationRecord that = (HydrationRecord)o;
        return Objects.equals(this.getVolume(), that.getVolume());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getVolume());
    }

    public HydrationRecordInternal toRecordInternal() {
        HydrationRecordInternal recordInternal = (HydrationRecordInternal)new HydrationRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTimeInterval(this);
        recordInternal.setVolume(this.mVolume.getInLiters());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        private final Volume mVolume;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, @NonNull Volume volume) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(volume);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mVolume = volume;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public HydrationRecord buildWithoutValidation() {
            return new HydrationRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mVolume, true);
        }

        @NonNull
        public HydrationRecord build() {
            return new HydrationRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mVolume, false);
        }
    }
}

