/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.HeartRateVariabilityRmssdRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=35)
public class HeartRateVariabilityRmssdRecord
extends InstantRecord {
    private final double mHeartRateVariabilityMillis;

    private HeartRateVariabilityRmssdRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, double heartRateVariabilityMillis, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        if (!skipValidation) {
            ValidationUtils.requireInRange(heartRateVariabilityMillis, 1.0, 200.0, "heartRateVariabilityMillis");
        }
        this.mHeartRateVariabilityMillis = heartRateVariabilityMillis;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof HeartRateVariabilityRmssdRecord)) {
            return false;
        }
        HeartRateVariabilityRmssdRecord that = (HeartRateVariabilityRmssdRecord)o;
        return this.getHeartRateVariabilityMillis() == that.getHeartRateVariabilityMillis();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getHeartRateVariabilityMillis());
    }

    public double getHeartRateVariabilityMillis() {
        return this.mHeartRateVariabilityMillis;
    }

    public HeartRateVariabilityRmssdRecordInternal toRecordInternal() {
        HeartRateVariabilityRmssdRecordInternal recordInternal = (HeartRateVariabilityRmssdRecordInternal)new HeartRateVariabilityRmssdRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setHeartRateVariabilityMillis(this.mHeartRateVariabilityMillis);
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private final double mHeartRateVariabilityMillis;
        private ZoneOffset mZoneOffset;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, double heartRateVariabilityMillis) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mHeartRateVariabilityMillis = heartRateVariabilityMillis;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(this.mTime);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public HeartRateVariabilityRmssdRecord buildWithoutValidation() {
            return new HeartRateVariabilityRmssdRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mHeartRateVariabilityMillis, true);
        }

        @NonNull
        public HeartRateVariabilityRmssdRecord build() {
            return new HeartRateVariabilityRmssdRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mHeartRateVariabilityMillis, false);
        }
    }
}

