/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.units.Energy;
import android.health.connect.datatypes.units.Length;
import java.time.Duration;
import java.util.Objects;

@FlaggedApi(value="com.android.healthconnect.flags.training_plans")
public abstract class ExerciseCompletionGoal {
    private ExerciseCompletionGoal() {
    }

    public static class UnspecifiedGoal
    extends ExerciseCompletionGoal {
        @NonNull
        public static final UnspecifiedGoal INSTANCE = new UnspecifiedGoal();

        private UnspecifiedGoal() {
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class UnknownGoal
    extends ExerciseCompletionGoal {
        @NonNull
        public static final UnknownGoal INSTANCE = new UnknownGoal();

        private UnknownGoal() {
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class ActiveCaloriesBurnedGoal
    extends ExerciseCompletionGoal {
        private final Energy mActiveCalories;

        public ActiveCaloriesBurnedGoal(@NonNull Energy activeCalories) {
            Objects.requireNonNull(activeCalories);
            this.mActiveCalories = activeCalories;
        }

        @NonNull
        public Energy getActiveCalories() {
            return this.mActiveCalories;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ActiveCaloriesBurnedGoal)) {
                return false;
            }
            ActiveCaloriesBurnedGoal that = (ActiveCaloriesBurnedGoal)o;
            return this.getActiveCalories().equals(that.getActiveCalories());
        }

        public int hashCode() {
            return Objects.hash(this.mActiveCalories);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class TotalCaloriesBurnedGoal
    extends ExerciseCompletionGoal {
        private final Energy mTotalCalories;

        public TotalCaloriesBurnedGoal(@NonNull Energy totalCalories) {
            Objects.requireNonNull(totalCalories);
            this.mTotalCalories = totalCalories;
        }

        @NonNull
        public Energy getTotalCalories() {
            return this.mTotalCalories;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TotalCaloriesBurnedGoal)) {
                return false;
            }
            TotalCaloriesBurnedGoal that = (TotalCaloriesBurnedGoal)o;
            return this.getTotalCalories().equals(that.getTotalCalories());
        }

        public int hashCode() {
            return Objects.hash(this.mTotalCalories);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class RepetitionsGoal
    extends ExerciseCompletionGoal {
        private final int mRepetitions;

        public RepetitionsGoal(int repetitions) {
            this.mRepetitions = repetitions;
        }

        public int getRepetitions() {
            return this.mRepetitions;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RepetitionsGoal)) {
                return false;
            }
            RepetitionsGoal that = (RepetitionsGoal)o;
            return this.getRepetitions() == that.getRepetitions();
        }

        public int hashCode() {
            return Objects.hash(this.mRepetitions);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class DurationGoal
    extends ExerciseCompletionGoal {
        private final Duration mDuration;

        public DurationGoal(@NonNull Duration duration) {
            Objects.requireNonNull(duration);
            this.mDuration = duration;
        }

        @NonNull
        public Duration getDuration() {
            return this.mDuration;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DurationGoal)) {
                return false;
            }
            DurationGoal that = (DurationGoal)o;
            return ((Object)this.getDuration()).equals(that.getDuration());
        }

        public int hashCode() {
            return Objects.hash(this.mDuration);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class StepsGoal
    extends ExerciseCompletionGoal {
        private final int mSteps;

        public StepsGoal(int steps) {
            this.mSteps = steps;
        }

        public int getSteps() {
            return this.mSteps;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StepsGoal)) {
                return false;
            }
            StepsGoal that = (StepsGoal)o;
            return this.getSteps() == that.getSteps();
        }

        public int hashCode() {
            return Objects.hash(this.mSteps);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class DistanceWithVariableRestGoal
    extends ExerciseCompletionGoal {
        private final Length mDistance;
        private final Duration mDuration;

        public DistanceWithVariableRestGoal(@NonNull Length distance, @NonNull Duration duration) {
            Objects.requireNonNull(distance);
            Objects.requireNonNull(duration);
            this.mDistance = distance;
            this.mDuration = duration;
        }

        @NonNull
        public Length getDistance() {
            return this.mDistance;
        }

        @NonNull
        public Duration getDuration() {
            return this.mDuration;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DistanceWithVariableRestGoal)) {
                return false;
            }
            DistanceWithVariableRestGoal that = (DistanceWithVariableRestGoal)o;
            return this.getDistance().equals(that.getDistance()) && ((Object)this.getDuration()).equals(that.getDuration());
        }

        public int hashCode() {
            return Objects.hash(this.mDistance, this.mDuration);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class DistanceGoal
    extends ExerciseCompletionGoal {
        private final Length mDistance;

        public DistanceGoal(@NonNull Length distance) {
            Objects.requireNonNull(distance);
            this.mDistance = distance;
        }

        @NonNull
        public Length getDistance() {
            return this.mDistance;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DistanceGoal)) {
                return false;
            }
            DistanceGoal that = (DistanceGoal)o;
            return this.getDistance().equals(that.getDistance());
        }

        public int hashCode() {
            return Objects.hash(this.mDistance);
        }
    }
}

