/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.backuprestore;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.health.connect.backuprestore.BackupChange;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.healthfitness.flags.cloud_backup_and_restore")
public class GetChangesForBackupResponse
implements Parcelable {
    private final int mCurrentVersion;
    @NonNull
    private final List<BackupChange> mChanges;
    @NonNull
    private final String mNextChangeToken;
    @NonNull
    public static final Parcelable.Creator<GetChangesForBackupResponse> CREATOR = new Parcelable.Creator<GetChangesForBackupResponse>(){

        @Override
        public GetChangesForBackupResponse createFromParcel(Parcel in) {
            return new GetChangesForBackupResponse(in);
        }

        public GetChangesForBackupResponse[] newArray(int size) {
            return new GetChangesForBackupResponse[size];
        }
    };

    public GetChangesForBackupResponse(int currentVersion, @NonNull List<BackupChange> changes, @NonNull String nextChangeToken) {
        this.mCurrentVersion = currentVersion;
        this.mChanges = changes;
        this.mNextChangeToken = nextChangeToken;
    }

    private GetChangesForBackupResponse(Parcel in) {
        this.mCurrentVersion = in.readInt();
        this.mChanges = in.createTypedArrayList(BackupChange.CREATOR);
        this.mNextChangeToken = in.readString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetChangesForBackupResponse)) {
            return false;
        }
        GetChangesForBackupResponse that = (GetChangesForBackupResponse)o;
        return this.mCurrentVersion == that.mCurrentVersion && this.mChanges.equals(that.mChanges) && this.mNextChangeToken.equals(that.mNextChangeToken);
    }

    public int hashCode() {
        return Objects.hash(this.mCurrentVersion, this.mChanges, this.mNextChangeToken);
    }

    public int getCurrentVersion() {
        return this.mCurrentVersion;
    }

    @NonNull
    public List<BackupChange> getChanges() {
        return this.mChanges;
    }

    @NonNull
    public String getNextChangeToken() {
        return this.mNextChangeToken;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mCurrentVersion);
        dest.writeTypedList(this.mChanges);
        dest.writeString(this.mNextChangeToken);
    }
}

