/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.backuprestore;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.healthfitness.flags.cloud_backup_and_restore")
public class BackupChange
implements Parcelable {
    @NonNull
    private final String mChangeId;
    private final boolean mIsDeletion;
    @Nullable
    private final byte[] mData;
    @NonNull
    public static final Parcelable.Creator<BackupChange> CREATOR = new Parcelable.Creator<BackupChange>(){

        @Override
        public BackupChange createFromParcel(Parcel in) {
            return new BackupChange(in);
        }

        public BackupChange[] newArray(int size) {
            return new BackupChange[size];
        }
    };

    @NonNull
    public static BackupChange ofDeletion(@NonNull String changeId) {
        return new BackupChange(changeId, true, null);
    }

    @NonNull
    public static BackupChange ofUpsertion(@NonNull String changeId, @NonNull byte[] data) {
        return new BackupChange(changeId, false, data);
    }

    private BackupChange(@NonNull String changeId, boolean isDeletion, @Nullable byte[] data) {
        this.mChangeId = changeId;
        this.mIsDeletion = isDeletion;
        this.mData = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupChange)) {
            return false;
        }
        BackupChange that = (BackupChange)o;
        return this.mIsDeletion == that.mIsDeletion && this.mChangeId.equals(that.mChangeId) && Arrays.equals(this.mData, that.mData);
    }

    public int hashCode() {
        int result = Objects.hash(this.mChangeId, this.mIsDeletion);
        result = 31 * result + Arrays.hashCode(this.mData);
        return result;
    }

    private BackupChange(Parcel in) {
        this.mChangeId = in.readString();
        this.mIsDeletion = in.readByte() != 0;
        this.mData = in.readBlob();
    }

    @NonNull
    public String getChangeId() {
        return this.mChangeId;
    }

    public boolean isDeletion() {
        return this.mIsDeletion;
    }

    @Nullable
    public byte[] getData() {
        return this.mData;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mChangeId);
        dest.writeByte((byte)(this.mIsDeletion ? 1 : 0));
        dest.writeBlob(this.mData);
    }
}

