/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.annotation.NonNull;
import android.health.connect.RecordTypeInfoResponse;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RecordTypeInfoResponseParcel
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<RecordTypeInfoResponseParcel> CREATOR = new Parcelable.Creator<RecordTypeInfoResponseParcel>(){

        @Override
        public RecordTypeInfoResponseParcel createFromParcel(Parcel in) {
            return new RecordTypeInfoResponseParcel(in);
        }

        public RecordTypeInfoResponseParcel[] newArray(int size) {
            return new RecordTypeInfoResponseParcel[size];
        }
    };
    private Map<Integer, List<String>> mRecordTypeInfoResponses;

    public RecordTypeInfoResponseParcel(Parcel in) {
        int numberOfResponses = in.readInt();
        this.mRecordTypeInfoResponses = new HashMap<Integer, List<String>>(numberOfResponses);
        for (int i = 0; i < numberOfResponses; ++i) {
            Integer recordType = in.readInt();
            ArrayList<String> contributingPackages = in.createStringArrayList();
            this.mRecordTypeInfoResponses.put(recordType, contributingPackages);
        }
    }

    public RecordTypeInfoResponseParcel(@NonNull Map<Integer, List<DataOrigin>> recordTypeInfoResponses) {
        Objects.requireNonNull(recordTypeInfoResponses);
        this.mRecordTypeInfoResponses = new HashMap<Integer, List<String>>(recordTypeInfoResponses.size());
        recordTypeInfoResponses.forEach((recordType, contributingPackages) -> this.mRecordTypeInfoResponses.put((Integer)recordType, RecordTypeInfoResponseParcel.getContributingPackagesAsListOfString(contributingPackages)));
    }

    @NonNull
    public static List<String> getContributingPackagesAsListOfString(@NonNull List<DataOrigin> contributingPackagesAsDataOrigin) {
        return contributingPackagesAsDataOrigin.stream().map(DataOrigin::getPackageName).filter(packageName -> packageName != null && !packageName.isEmpty()).collect(Collectors.toList());
    }

    @NonNull
    public static List<DataOrigin> getContributingPackagesAsDataOrigin(@NonNull List<String> packagesAsListOfString) {
        return packagesAsListOfString.stream().map(packageName -> new DataOrigin.Builder().setPackageName((String)packageName).build()).collect(Collectors.toList());
    }

    public Map<Class<? extends Record>, RecordTypeInfoResponse> getRecordTypeInfoResponses() {
        HashMap<Class<? extends Record>, RecordTypeInfoResponse> responses = new HashMap<Class<? extends Record>, RecordTypeInfoResponse>(this.mRecordTypeInfoResponses.size());
        HealthConnectMappings healthConnectMappings = HealthConnectMappings.getInstance();
        this.mRecordTypeInfoResponses.forEach((recordType, contributingPackages) -> {
            RecordTypeInfoResponse res = new RecordTypeInfoResponse(healthConnectMappings.getHealthPermissionCategoryForRecordType((int)recordType), healthConnectMappings.getRecordCategoryForRecordType((int)recordType), RecordTypeInfoResponseParcel.getContributingPackagesAsDataOrigin(contributingPackages));
            Class<? extends Record> recordTypeClass = healthConnectMappings.getRecordIdToExternalRecordClassMap().get(recordType);
            responses.put(recordTypeClass, res);
        });
        return responses;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mRecordTypeInfoResponses.size());
        this.mRecordTypeInfoResponses.forEach((recordType, contributingPackages) -> {
            dest.writeInt((int)recordType);
            dest.writeStringList((List<String>)contributingPackages);
        });
    }
}

