/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.health.connect.aidl.HealthConnectExceptionParcel;
import android.health.connect.datatypes.MedicalDataSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMedicalDataSourceResponseCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.health.connect.aidl.IMedicalDataSourceResponseCallback";

    public void onResult(MedicalDataSource var1) throws RemoteException;

    public void onError(HealthConnectExceptionParcel var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMedicalDataSourceResponseCallback {
        static final int TRANSACTION_onResult = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, IMedicalDataSourceResponseCallback.DESCRIPTOR);
        }

        public static IMedicalDataSourceResponseCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMedicalDataSourceResponseCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IMedicalDataSourceResponseCallback) {
                return (IMedicalDataSourceResponseCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onResult";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMedicalDataSourceResponseCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    MedicalDataSource _arg0 = data.readTypedObject(MedicalDataSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResult(_arg0);
                    break;
                }
                case 2: {
                    HealthConnectExceptionParcel _arg0 = data.readTypedObject(HealthConnectExceptionParcel.CREATOR);
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IMedicalDataSourceResponseCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMedicalDataSourceResponseCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(MedicalDataSource parcel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMedicalDataSourceResponseCallback.DESCRIPTOR);
                    _data.writeTypedObject(parcel, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(HealthConnectExceptionParcel exception) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMedicalDataSourceResponseCallback.DESCRIPTOR);
                    _data.writeTypedObject(exception, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMedicalDataSourceResponseCallback {
        @Override
        public void onResult(MedicalDataSource parcel) throws RemoteException {
        }

        @Override
        public void onError(HealthConnectExceptionParcel exception) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

