/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.annotation.NonNull;
import android.health.connect.DeleteUsingFiltersRequest;
import android.health.connect.TimeRangeFilterHelper;
import android.health.connect.aidl.RecordIdFiltersParcel;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DeleteUsingFiltersRequestParcel
implements Parcelable {
    public static final Parcelable.Creator<DeleteUsingFiltersRequestParcel> CREATOR = new Parcelable.Creator<DeleteUsingFiltersRequestParcel>(){

        @Override
        public DeleteUsingFiltersRequestParcel createFromParcel(Parcel in) {
            return new DeleteUsingFiltersRequestParcel(in);
        }

        public DeleteUsingFiltersRequestParcel[] newArray(int size) {
            return new DeleteUsingFiltersRequestParcel[size];
        }
    };
    private List<String> mPackageNameFilters;
    private final int[] mRecordTypeFilters;
    private final long mStartTime;
    private final long mEndTime;
    private final RecordIdFiltersParcel mRecordIdFiltersParcel;
    private final boolean mLocalTimeFilter;

    protected DeleteUsingFiltersRequestParcel(Parcel in) {
        this.mPackageNameFilters = in.createStringArrayList();
        this.mRecordTypeFilters = in.createIntArray();
        this.mStartTime = in.readLong();
        this.mEndTime = in.readLong();
        this.mLocalTimeFilter = in.readBoolean();
        this.mRecordIdFiltersParcel = in.readParcelable(RecordIdFiltersParcel.class.getClassLoader(), RecordIdFiltersParcel.class);
    }

    public DeleteUsingFiltersRequestParcel(DeleteUsingFiltersRequest request) {
        this.mPackageNameFilters = request.getDataOrigins().stream().map(DataOrigin::getPackageName).collect(Collectors.toList());
        this.mRecordTypeFilters = request.getRecordTypes().stream().mapToInt(recordType -> HealthConnectMappings.getInstance().getRecordType((Class<? extends Record>)recordType)).toArray();
        if (request.getTimeRangeFilter() == null) {
            this.mStartTime = -1L;
            this.mEndTime = -1L;
            this.mLocalTimeFilter = false;
        } else {
            this.mStartTime = TimeRangeFilterHelper.getFilterStartTimeMillis(request.getTimeRangeFilter());
            this.mEndTime = TimeRangeFilterHelper.getFilterEndTimeMillis(request.getTimeRangeFilter());
            this.mLocalTimeFilter = TimeRangeFilterHelper.isLocalTimeFilter(request.getTimeRangeFilter());
        }
        this.mRecordIdFiltersParcel = new RecordIdFiltersParcel(Collections.emptyList());
    }

    public DeleteUsingFiltersRequestParcel(RecordIdFiltersParcel recordIdFiltersParcel, String packageName) {
        this.mPackageNameFilters = Collections.singletonList(packageName);
        this.mRecordTypeFilters = new int[0];
        this.mStartTime = -1L;
        this.mEndTime = -1L;
        this.mLocalTimeFilter = false;
        this.mRecordIdFiltersParcel = recordIdFiltersParcel;
    }

    public RecordIdFiltersParcel getRecordIdFiltersParcel() {
        return this.mRecordIdFiltersParcel;
    }

    public List<String> getPackageNameFilters() {
        return this.mPackageNameFilters;
    }

    public void setPackageNameFilters(@NonNull List<String> packages) {
        Objects.requireNonNull(packages);
        this.mPackageNameFilters = packages;
    }

    public List<Integer> getRecordTypeFilters() {
        if (this.mRecordIdFiltersParcel != null && !this.mRecordIdFiltersParcel.getRecordIdFilters().isEmpty()) {
            return this.mRecordIdFiltersParcel.getRecordIdFilters().stream().map(recordIdFilter -> HealthConnectMappings.getInstance().getRecordType(recordIdFilter.getRecordType())).toList().stream().distinct().toList();
        }
        return Arrays.stream(this.mRecordTypeFilters).boxed().toList();
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public boolean usesIdFilters() {
        return this.mRecordIdFiltersParcel.getRecordIdFilters() != null && !this.mRecordIdFiltersParcel.getRecordIdFilters().isEmpty();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeStringList(this.mPackageNameFilters);
        dest.writeIntArray(this.mRecordTypeFilters);
        dest.writeLong(this.mStartTime);
        dest.writeLong(this.mEndTime);
        dest.writeBoolean(this.mLocalTimeFilter);
        dest.writeParcelable(this.mRecordIdFiltersParcel, 0);
    }

    public boolean isLocalTimeFilter() {
        return this.mLocalTimeFilter;
    }

    public boolean usesNonIdFilters() {
        return this.mRecordTypeFilters.length != 0 || this.mStartTime != -1L || this.mEndTime != -1L;
    }
}

